#ifndef HARDWARE_DP32G030_PWMPLUS_H
#define HARDWARE_DP32G030_PWMPLUS_H

#define PWM_PLUS0_BASE_ADDR 0x400B4000U

//---------------

#define PWMPLUS_CFG                             0x00U

#define PWMPLUS_CFG_COUNTER_EN_SHIFT            0U
#define PWMPLUS_CFG_COUNTER_EN_WIDTH            1U
#define PWMPLUS_CFG_COUNTER_EN_MASK             (((1U << PWMPLUS_CFG_COUNTER_EN_WIDTH) - 1U) << PWMPLUS_CFG_COUNTER_EN_SHIFT)
#define PWMPLUS_CFG_COUNTER_EN_VALUE_ENABLE     1U
#define PWMPLUS_CFG_COUNTER_EN_BITS_ENABLE      (PWMPLUS_CFG_COUNTER_EN_VALUE_ENABLE << PWMPLUS_CFG_COUNTER_EN_SHIFT)

#define PWMPLUS_CFG_CNT_TYPE_SHIFT              1U

#define PWMPLUS_CFG_CNT_REP_SHIFT               2U
#define PWMPLUS_CFG_CNT_REP_WIDTH               1U
#define PWMPLUS_CFG_CNT_REP_VALUE_ENABLE        1U
#define PWMPLUS_CFG_CNT_REP_BITS_ENABLE         (PWMPLUS_CFG_CNT_REP_VALUE_ENABLE << PWMPLUS_CFG_CNT_REP_SHIFT)

#define PWMPLUS_CFG_OUT_MODE_SHIFT              3U
#define PWMPLUS_CFG_OUT_MODE_VALUE_ENABLE       1U
#define PWMPLUS_CFG_OUT_MODE_BITS_ENABLE        (PWMPLUS_CFG_OUT_MODE_VALUE_ENABLE << PWMPLUS_CFG_OUT_MODE_SHIFT)

#define PWMPLUS_CFG_AUTO_RELOAD_SHIFT           8U

//---------------

#define PWMPLUS_GEN                             0x04U

#define PWMPLUS_GEN_CH0_OE_SHIFT                24U
#define PWMPLUS_GEN_CH0_OE_WIDTH                1U
#define PWMPLUS_GEN_CH0_OE_VALUE_ENABLE         1U
#define PWMPLUS_GEN_CH0_OE_BITS_ENABLE          (PWMPLUS_GEN_CH0_OE_VALUE_ENABLE << PWMPLUS_GEN_CH0_OE_SHIFT)

#define PWMPLUS_GEN_CH0_OUTINV_SHIFT            16U
#define PWMPLUS_GEN_CH0_OUTINV_WIDTH            1U
#define PWMPLUS_GEN_CH0_OUTINV_VALUE_ENABLE     1U
#define PWMPLUS_GEN_CH0_OUTINV_BITS_ENABLE      (PWMPLUS_GEN_CH0_OUTINV_VALUE_ENABLE << PWMPLUS_GEN_CH0_OUTINV_SHIFT)

#define PWMPLUS_GEN_CH0_START_SHIFT             8U
#define PWMPLUS_GEN_CH0_START_WIDTH             1U
#define PWMPLUS_GEN_CH0_START_VALUE_ENABLE      1U
#define PWMPLUS_GEN_CH0_START_BITS_ENABLE       (PWMPLUS_GEN_CH0_START_VALUE_ENABLE << PWMPLUS_GEN_CH0_START_SHIFT)

#define PWMPLUS_GEN_CH0_IDLE_SHIFT              0U
#define PWMPLUS_GEN_CH0_IDLE_WIDTH              1U
#define PWMPLUS_GEN_CH0_IDLE_VALUE_ENABLE       1U
#define PWMPLUS_GEN_CH0_IDLE_BITS_ENABLE        (PWMPLUS_GEN_CH0_IDLE_VALUE_ENABLE << PWMPLUS_GEN_CH0_IDLE_SHIFT)

//---------------

#define PWMPLUS_CLKSRC      0x08U
#define PWMPLUS_BRAKE_CFG   0x0CU
#define PWMPLUS_MASK_LEV    0x10U
#define PWMPLUS_PERIOD      0x1CU
#define PWMPLUS_CH0_COMP    0x20U
#define PWMPLUS_CH1_COMP    0x24U
#define PWMPLUS_CH2_COMP    0x28U
#define PWMPLUS_CH0_DT      0x30U
#define PWMPLUS_CH1_DT      0x34U
#define PWMPLUS_CH2_DT      0x38U
#define PWMPLUS_TRIG_COMP   0x40U
#define PWMPLUS_TRIG_CFG    0x44U
#define PWMPLUS_IE          0x60U
#define PWMPLUS_IF          0x64U
#define PWMPLUS_SWLOAD      0x84U
#define PWMPLUS_MASK_EN     0x88
#define PWMPLUS_CNT_ST      0xE0
#define PWMPLUS_BRAKE_ST    0xE4













#define PWM_PLUS0_CFG_ADDR          (PWM_PLUS0_BASE_ADDR + PWMPLUS_CFG)
#define PWM_PLUS0_CFG               (*(volatile uint32_t *)PWM_PLUS0_CFG_ADDR)

#define PWM_PLUS0_GEN_ADDR          (PWM_PLUS0_BASE_ADDR + PWMPLUS_GEN)
#define PWM_PLUS0_GEN               (*(volatile uint32_t *)PWM_PLUS0_GEN_ADDR)

#define PWM_PLUS0_CLKSRC_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_CLKSRC)
#define PWM_PLUS0_CLKSRC            (*(volatile uint32_t *)PWM_PLUS0_CLKSRC_ADDR)

#define PWM_PLUS0_BRAKE_CFG_ADDR    (PWM_PLUS0_BASE_ADDR + PWMPLUS_BRAKE_CFG)
#define PWM_PLUS0_BRAKE_CFG         (*(volatile uint32_t *)PWM_PLUS0_BRAKE_CFG_ADDR)

#define PWM_PLUS0_MASK_LEV_ADDR     (PWM_PLUS0_BASE_ADDR + PWMPLUS_MASK_LEV)
#define PWM_PLUS0_MASK_LEV          (*(volatile uint32_t *)PWM_PLUS0_MASK_LEV_ADDR)

#define PWM_PLUS0_PERIOD_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_PERIOD)
#define PWM_PLUS0_PERIOD            (*(volatile uint32_t *)PWM_PLUS0_PERIOD_ADDR)

#define PWM_PLUS0_CH0_COMP_ADDR     (PWM_PLUS0_BASE_ADDR + PWMPLUS_CH0_COMP)
#define PWM_PLUS0_CH0_COMP          (*(volatile uint32_t *)PWM_PLUS0_CH0_COMP_ADDR)

#define PWM_PLUS0_CH1_COMP_ADDR     (PWM_PLUS0_BASE_ADDR + PWMPLUS_CH1_COMP)
#define PWM_PLUS0_CH1_COMP          (*(volatile uint32_t *)PWM_PLUS0_CH1_COMP_ADDR)

#define PWM_PLUS0_CH2_COMP_ADDR     (PWM_PLUS0_BASE_ADDR + PWMPLUS_CH2_COMP)
#define PWM_PLUS0_CH2_COMP          (*(volatile uint32_t *)PWM_PLUS0_CH2_COMP_ADDR)

#define PWM_PLUS0_CH0_DT_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_CH0_DT)
#define PWM_PLUS0_CH0_DT            (*(volatile uint32_t *)PWM_PLUS0_CH0_DT_ADDR)

#define PWM_PLUS0_CH1_DT_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_CH1_DT)
#define PWM_PLUS0_CH1_DT            (*(volatile uint32_t *)PWM_PLUS0_CH1_DT_ADDR)

#define PWM_PLUS0_CH2_DT_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_CH2_DT)
#define PWM_PLUS0_CH2_DT            (*(volatile uint32_t *)PWM_PLUS0_CH2_DT_ADDR)

#define PWM_PLUS0_TRIG_COMP_ADDR    (PWM_PLUS0_BASE_ADDR + PWMPLUS_TRIG_COMP)
#define PWM_PLUS0_TRIG_COMP         (*(volatile uint32_t *)PWM_PLUS0_TRIG_COMP_ADDR)

#define PWM_PLUS0_TRIG_CFG_ADDR     (PWM_PLUS0_BASE_ADDR + PWMPLUS_TRIG_CFG)
#define PWM_PLUS0_TRIG_CFG          (*(volatile uint32_t *)PWM_PLUS0_TRIG_CFG_ADDR)

#define PWM_PLUS0_IE_ADDR           (PWM_PLUS0_BASE_ADDR + PWMPLUS_IE)
#define PWM_PLUS0_IE                (*(volatile uint32_t *)PWM_PLUS0_IE_ADDR)

#define PWM_PLUS0_IF_ADDR           (PWM_PLUS0_BASE_ADDR + PWMPLUS_IF)
#define PWM_PLUS0_IF                (*(volatile uint32_t *)PWM_PLUS0_IF_ADDR)

#define PWM_PLUS0_SWLOAD_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_SWLOAD)
#define PWM_PLUS0_SWLOAD            (*(volatile uint32_t *)PWM_PLUS0_SWLOAD_ADDR)

#define PWM_PLUS0_MASK_EN_ADDR      (PWM_PLUS0_BASE_ADDR + PWMPLUS_MASK_EN)
#define PWM_PLUS0_MASK_EN           (*(volatile uint32_t *)PWM_PLUS0_MASK_EN_ADDR)

#define PWM_PLUS0_CNT_ST_ADDR       (PWM_PLUS0_BASE_ADDR + PWMPLUS_CNT_ST)
#define PWM_PLUS0_CNT_ST            (*(volatile uint32_t *)PWM_PLUS0_CNT_ST_ADDR)

#define PWM_PLUS0_BRAKE_ST_ADDR     (PWM_PLUS0_BASE_ADDR + PWMPLUS_BRAKE_ST)
#define PWM_PLUS0_BRAKE_ST          (*(volatile uint32_t *)PWM_PLUS0_BRAKE_ST_ADDR)

#endif