/* Copyright 2023 Dual Tachyon
 * https://github.com/DualTachyon
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef HARDWARE_DP32G030_SYSCON_H
#define HARDWARE_DP32G030_SYSCON_H

#if !defined(__ASSEMBLY__)
#include <stdint.h>
#endif

/* -------- SYSCON -------- */
#define SYSCON_BASE_ADDR                                0x40000000U
#define SYSCON_BASE_SIZE                                0x00000800U

#define SYSCON_CLK_SEL_ADDR                             (SYSCON_BASE_ADDR + 0x0000U)
#define SYSCON_CLK_SEL                                  (*(volatile uint32_t *)SYSCON_CLK_SEL_ADDR)
#define SYSCON_CLK_SEL_SYS_SHIFT                        0
#define SYSCON_CLK_SEL_SYS_WIDTH                        1
#define SYSCON_CLK_SEL_SYS_MASK                         (((1U << SYSCON_CLK_SEL_SYS_WIDTH) - 1U) << SYSCON_CLK_SEL_SYS_SHIFT)
#define SYSCON_CLK_SEL_SYS_VALUE_RCHF                   0U
#define SYSCON_CLK_SEL_SYS_BITS_RCHF                    (SYSCON_CLK_SEL_SYS_VALUE_RCHF << SYSCON_CLK_SEL_SYS_SHIFT)
#define SYSCON_CLK_SEL_SYS_VALUE_DIV_CLK                1U
#define SYSCON_CLK_SEL_SYS_BITS_DIV_CLK                 (SYSCON_CLK_SEL_SYS_VALUE_DIV_CLK << SYSCON_CLK_SEL_SYS_SHIFT)

#define SYSCON_CLK_SEL_DIV_SHIFT                        1
#define SYSCON_CLK_SEL_DIV_WIDTH                        3
#define SYSCON_CLK_SEL_DIV_MASK                         (((1U << SYSCON_CLK_SEL_DIV_WIDTH) - 1U) << SYSCON_CLK_SEL_DIV_SHIFT)
#define SYSCON_CLK_SEL_DIV_VALUE_1                      0U
#define SYSCON_CLK_SEL_DIV_BITS_1                       (SYSCON_CLK_SEL_DIV_VALUE_1 << SYSCON_CLK_SEL_DIV_SHIFT)
#define SYSCON_CLK_SEL_DIV_VALUE_2                      1U
#define SYSCON_CLK_SEL_DIV_BITS_2                       (SYSCON_CLK_SEL_DIV_VALUE_2 << SYSCON_CLK_SEL_DIV_SHIFT)
#define SYSCON_CLK_SEL_DIV_VALUE_4                      2U
#define SYSCON_CLK_SEL_DIV_BITS_4                       (SYSCON_CLK_SEL_DIV_VALUE_4 << SYSCON_CLK_SEL_DIV_SHIFT)
#define SYSCON_CLK_SEL_DIV_VALUE_8                      3U
#define SYSCON_CLK_SEL_DIV_BITS_8                       (SYSCON_CLK_SEL_DIV_VALUE_8 << SYSCON_CLK_SEL_DIV_SHIFT)
#define SYSCON_CLK_SEL_DIV_VALUE_16                     4U
#define SYSCON_CLK_SEL_DIV_BITS_16                      (SYSCON_CLK_SEL_DIV_VALUE_16 << SYSCON_CLK_SEL_DIV_SHIFT)
#define SYSCON_CLK_SEL_DIV_VALUE_32                     5U
#define SYSCON_CLK_SEL_DIV_BITS_32                      (SYSCON_CLK_SEL_DIV_VALUE_32 << SYSCON_CLK_SEL_DIV_SHIFT)

#define SYSCON_CLK_SEL_SRC_SHIFT                        4
#define SYSCON_CLK_SEL_SRC_WIDTH                        3
#define SYSCON_CLK_SEL_SRC_MASK                         (((1U << SYSCON_CLK_SEL_SRC_WIDTH) - 1U) << SYSCON_CLK_SEL_SRC_SHIFT)
#define SYSCON_CLK_SEL_SRC_VALUE_RCHF                   0U
#define SYSCON_CLK_SEL_SRC_BITS_RCHF                    (SYSCON_CLK_SEL_SRC_VALUE_RCHF << SYSCON_CLK_SEL_SRC_SHIFT)
#define SYSCON_CLK_SEL_SRC_VALUE_RCLF                   1U
#define SYSCON_CLK_SEL_SRC_BITS_RCLF                    (SYSCON_CLK_SEL_SRC_VALUE_RCLF << SYSCON_CLK_SEL_SRC_SHIFT)
#define SYSCON_CLK_SEL_SRC_VALUE_XTAH                   2U
#define SYSCON_CLK_SEL_SRC_BITS_XTAH                    (SYSCON_CLK_SEL_SRC_VALUE_XTAH << SYSCON_CLK_SEL_SRC_SHIFT)
#define SYSCON_CLK_SEL_SRC_VALUE_XTAL                   3U
#define SYSCON_CLK_SEL_SRC_BITS_XTAL                    (SYSCON_CLK_SEL_SRC_VALUE_XTAL << SYSCON_CLK_SEL_SRC_SHIFT)
#define SYSCON_CLK_SEL_SRC_VALUE_PLL                    4U
#define SYSCON_CLK_SEL_SRC_BITS_PLL                     (SYSCON_CLK_SEL_SRC_VALUE_PLL << SYSCON_CLK_SEL_SRC_SHIFT)

#define SYSCON_CLK_SEL_W_PLL_SHIFT                      7
#define SYSCON_CLK_SEL_W_PLL_WIDTH                      1
#define SYSCON_CLK_SEL_W_PLL_MASK                       (((1U << SYSCON_CLK_SEL_W_PLL_WIDTH) - 1U) << SYSCON_CLK_SEL_W_PLL_SHIFT)
#define SYSCON_CLK_SEL_W_PLL_VALUE_RCHF                 0U
#define SYSCON_CLK_SEL_W_PLL_BITS_RCHF                  (SYSCON_CLK_SEL_W_PLL_VALUE_RCHF << SYSCON_CLK_SEL_W_PLL_SHIFT)
#define SYSCON_CLK_SEL_W_PLL_VALUE_XTAH                 1U
#define SYSCON_CLK_SEL_W_PLL_BITS_XTAH                  (SYSCON_CLK_SEL_W_PLL_VALUE_XTAH << SYSCON_CLK_SEL_W_PLL_SHIFT)

#define SYSCON_CLK_SEL_R_SARADC_SMPL_SHIFT              9
#define SYSCON_CLK_SEL_R_SARADC_SMPL_WIDTH              2
#define SYSCON_CLK_SEL_R_SARADC_SMPL_MASK               (((1U << SYSCON_CLK_SEL_R_SARADC_SMPL_WIDTH) - 1U) << SYSCON_CLK_SEL_R_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV1         0U
#define SYSCON_CLK_SEL_R_SARADC_SMPL_BITS_DIV1          (SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV1 << SYSCON_CLK_SEL_R_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV2         1U
#define SYSCON_CLK_SEL_R_SARADC_SMPL_BITS_DIV2          (SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV2 << SYSCON_CLK_SEL_R_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV4         2U
#define SYSCON_CLK_SEL_R_SARADC_SMPL_BITS_DIV4          (SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV4 << SYSCON_CLK_SEL_R_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV8         3U
#define SYSCON_CLK_SEL_R_SARADC_SMPL_BITS_DIV8          (SYSCON_CLK_SEL_R_SARADC_SMPL_VALUE_DIV8 << SYSCON_CLK_SEL_R_SARADC_SMPL_SHIFT)

#define SYSCON_CLK_SEL_W_SARADC_SMPL_SHIFT              10
#define SYSCON_CLK_SEL_W_SARADC_SMPL_WIDTH              2
#define SYSCON_CLK_SEL_W_SARADC_SMPL_MASK               (((1U << SYSCON_CLK_SEL_W_SARADC_SMPL_WIDTH) - 1U) << SYSCON_CLK_SEL_W_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV1         0U
#define SYSCON_CLK_SEL_W_SARADC_SMPL_BITS_DIV1          (SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV1 << SYSCON_CLK_SEL_W_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV2         1U
#define SYSCON_CLK_SEL_W_SARADC_SMPL_BITS_DIV2          (SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV2 << SYSCON_CLK_SEL_W_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV4         2U
#define SYSCON_CLK_SEL_W_SARADC_SMPL_BITS_DIV4          (SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV4 << SYSCON_CLK_SEL_W_SARADC_SMPL_SHIFT)
#define SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV8         3U
#define SYSCON_CLK_SEL_W_SARADC_SMPL_BITS_DIV8          (SYSCON_CLK_SEL_W_SARADC_SMPL_VALUE_DIV8 << SYSCON_CLK_SEL_W_SARADC_SMPL_SHIFT)

#define SYSCON_CLK_SEL_R_PLL_SHIFT                      11
#define SYSCON_CLK_SEL_R_PLL_WIDTH                      1
#define SYSCON_CLK_SEL_R_PLL_MASK                       (((1U << SYSCON_CLK_SEL_R_PLL_WIDTH) - 1U) << SYSCON_CLK_SEL_R_PLL_SHIFT)
#define SYSCON_CLK_SEL_R_PLL_VALUE_RCHF                 0U
#define SYSCON_CLK_SEL_R_PLL_BITS_RCHF                  (SYSCON_CLK_SEL_R_PLL_VALUE_RCHF << SYSCON_CLK_SEL_R_PLL_SHIFT)
#define SYSCON_CLK_SEL_R_PLL_VALUE_XTAH                 1U
#define SYSCON_CLK_SEL_R_PLL_BITS_XTAH                  (SYSCON_CLK_SEL_R_PLL_VALUE_XTAH << SYSCON_CLK_SEL_R_PLL_SHIFT)

#define SYSCON_DIV_CLK_GATE_ADDR                        (SYSCON_BASE_ADDR + 0x0004U)
#define SYSCON_DIV_CLK_GATE                             (*(volatile uint32_t *)SYSCON_DIV_CLK_GATE_ADDR)
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_SHIFT          0
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_WIDTH          1
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_MASK           (((1U << SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_WIDTH) - 1U) << SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_SHIFT)
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_VALUE_DISABLE  0U
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_BITS_DISABLE   (SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_VALUE_DISABLE << SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_SHIFT)
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_VALUE_ENABLE   1U
#define SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_BITS_ENABLE    (SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_VALUE_ENABLE << SYSCON_DIV_CLK_GATE_DIV_CLK_GATE_SHIFT)

#define SYSCON_DEV_CLK_GATE_ADDR                        (SYSCON_BASE_ADDR + 0x0008U)
#define SYSCON_DEV_CLK_GATE                             (*(volatile uint32_t *)SYSCON_DEV_CLK_GATE_ADDR)
#define SYSCON_DEV_CLK_GATE_GPIOA_SHIFT                 0
#define SYSCON_DEV_CLK_GATE_GPIOA_WIDTH                 1
#define SYSCON_DEV_CLK_GATE_GPIOA_MASK                  (((1U << SYSCON_DEV_CLK_GATE_GPIOA_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_GPIOA_SHIFT)
#define SYSCON_DEV_CLK_GATE_GPIOA_VALUE_DISABLE         0U
#define SYSCON_DEV_CLK_GATE_GPIOA_BITS_DISABLE          (SYSCON_DEV_CLK_GATE_GPIOA_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_GPIOA_SHIFT)
#define SYSCON_DEV_CLK_GATE_GPIOA_VALUE_ENABLE          1U
#define SYSCON_DEV_CLK_GATE_GPIOA_BITS_ENABLE           (SYSCON_DEV_CLK_GATE_GPIOA_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_GPIOA_SHIFT)

#define SYSCON_DEV_CLK_GATE_GPIOB_SHIFT                 1
#define SYSCON_DEV_CLK_GATE_GPIOB_WIDTH                 1
#define SYSCON_DEV_CLK_GATE_GPIOB_MASK                  (((1U << SYSCON_DEV_CLK_GATE_GPIOB_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_GPIOB_SHIFT)
#define SYSCON_DEV_CLK_GATE_GPIOB_VALUE_DISABLE         0U
#define SYSCON_DEV_CLK_GATE_GPIOB_BITS_DISABLE          (SYSCON_DEV_CLK_GATE_GPIOB_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_GPIOB_SHIFT)
#define SYSCON_DEV_CLK_GATE_GPIOB_VALUE_ENABLE          1U
#define SYSCON_DEV_CLK_GATE_GPIOB_BITS_ENABLE           (SYSCON_DEV_CLK_GATE_GPIOB_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_GPIOB_SHIFT)

#define SYSCON_DEV_CLK_GATE_GPIOC_SHIFT                 2
#define SYSCON_DEV_CLK_GATE_GPIOC_WIDTH                 1
#define SYSCON_DEV_CLK_GATE_GPIOC_MASK                  (((1U << SYSCON_DEV_CLK_GATE_GPIOC_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_GPIOC_SHIFT)
#define SYSCON_DEV_CLK_GATE_GPIOC_VALUE_DISABLE         0U
#define SYSCON_DEV_CLK_GATE_GPIOC_BITS_DISABLE          (SYSCON_DEV_CLK_GATE_GPIOC_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_GPIOC_SHIFT)
#define SYSCON_DEV_CLK_GATE_GPIOC_VALUE_ENABLE          1U
#define SYSCON_DEV_CLK_GATE_GPIOC_BITS_ENABLE           (SYSCON_DEV_CLK_GATE_GPIOC_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_GPIOC_SHIFT)

#define SYSCON_DEV_CLK_GATE_IIC0_SHIFT                  4
#define SYSCON_DEV_CLK_GATE_IIC0_WIDTH                  1
#define SYSCON_DEV_CLK_GATE_IIC0_MASK                   (((1U << SYSCON_DEV_CLK_GATE_IIC0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_IIC0_SHIFT)
#define SYSCON_DEV_CLK_GATE_IIC0_VALUE_DISABLE          0U
#define SYSCON_DEV_CLK_GATE_IIC0_BITS_DISABLE           (SYSCON_DEV_CLK_GATE_IIC0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_IIC0_SHIFT)
#define SYSCON_DEV_CLK_GATE_IIC0_VALUE_ENABLE           1U
#define SYSCON_DEV_CLK_GATE_IIC0_BITS_ENABLE            (SYSCON_DEV_CLK_GATE_IIC0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_IIC0_SHIFT)

#define SYSCON_DEV_CLK_GATE_IIC1_SHIFT                  5
#define SYSCON_DEV_CLK_GATE_IIC1_WIDTH                  1
#define SYSCON_DEV_CLK_GATE_IIC1_MASK                   (((1U << SYSCON_DEV_CLK_GATE_IIC1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_IIC1_SHIFT)
#define SYSCON_DEV_CLK_GATE_IIC1_VALUE_DISABLE          0U
#define SYSCON_DEV_CLK_GATE_IIC1_BITS_DISABLE           (SYSCON_DEV_CLK_GATE_IIC1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_IIC1_SHIFT)
#define SYSCON_DEV_CLK_GATE_IIC1_VALUE_ENABLE           1U
#define SYSCON_DEV_CLK_GATE_IIC1_BITS_ENABLE            (SYSCON_DEV_CLK_GATE_IIC1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_IIC1_SHIFT)

#define SYSCON_DEV_CLK_GATE_UART0_SHIFT                 6
#define SYSCON_DEV_CLK_GATE_UART0_WIDTH                 1
#define SYSCON_DEV_CLK_GATE_UART0_MASK                  (((1U << SYSCON_DEV_CLK_GATE_UART0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_UART0_SHIFT)
#define SYSCON_DEV_CLK_GATE_UART0_VALUE_DISABLE         0U
#define SYSCON_DEV_CLK_GATE_UART0_BITS_DISABLE          (SYSCON_DEV_CLK_GATE_UART0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_UART0_SHIFT)
#define SYSCON_DEV_CLK_GATE_UART0_VALUE_ENABLE          1U
#define SYSCON_DEV_CLK_GATE_UART0_BITS_ENABLE           (SYSCON_DEV_CLK_GATE_UART0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_UART0_SHIFT)

#define SYSCON_DEV_CLK_GATE_UART1_SHIFT                 7
#define SYSCON_DEV_CLK_GATE_UART1_WIDTH                 1
#define SYSCON_DEV_CLK_GATE_UART1_MASK                  (((1U << SYSCON_DEV_CLK_GATE_UART1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_UART1_SHIFT)
#define SYSCON_DEV_CLK_GATE_UART1_VALUE_DISABLE         0U
#define SYSCON_DEV_CLK_GATE_UART1_BITS_DISABLE          (SYSCON_DEV_CLK_GATE_UART1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_UART1_SHIFT)
#define SYSCON_DEV_CLK_GATE_UART1_VALUE_ENABLE          1U
#define SYSCON_DEV_CLK_GATE_UART1_BITS_ENABLE           (SYSCON_DEV_CLK_GATE_UART1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_UART1_SHIFT)

#define SYSCON_DEV_CLK_GATE_UART2_SHIFT                 8
#define SYSCON_DEV_CLK_GATE_UART2_WIDTH                 1
#define SYSCON_DEV_CLK_GATE_UART2_MASK                  (((1U << SYSCON_DEV_CLK_GATE_UART2_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_UART2_SHIFT)
#define SYSCON_DEV_CLK_GATE_UART2_VALUE_DISABLE         0U
#define SYSCON_DEV_CLK_GATE_UART2_BITS_DISABLE          (SYSCON_DEV_CLK_GATE_UART2_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_UART2_SHIFT)
#define SYSCON_DEV_CLK_GATE_UART2_VALUE_ENABLE          1U
#define SYSCON_DEV_CLK_GATE_UART2_BITS_ENABLE           (SYSCON_DEV_CLK_GATE_UART2_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_UART2_SHIFT)

#define SYSCON_DEV_CLK_GATE_SPI0_SHIFT                  10
#define SYSCON_DEV_CLK_GATE_SPI0_WIDTH                  1
#define SYSCON_DEV_CLK_GATE_SPI0_MASK                   (((1U << SYSCON_DEV_CLK_GATE_SPI0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_SPI0_SHIFT)
#define SYSCON_DEV_CLK_GATE_SPI0_VALUE_DISABLE          0U
#define SYSCON_DEV_CLK_GATE_SPI0_BITS_DISABLE           (SYSCON_DEV_CLK_GATE_SPI0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_SPI0_SHIFT)
#define SYSCON_DEV_CLK_GATE_SPI0_VALUE_ENABLE           1U
#define SYSCON_DEV_CLK_GATE_SPI0_BITS_ENABLE            (SYSCON_DEV_CLK_GATE_SPI0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_SPI0_SHIFT)

#define SYSCON_DEV_CLK_GATE_SPI1_SHIFT                  11
#define SYSCON_DEV_CLK_GATE_SPI1_WIDTH                  1
#define SYSCON_DEV_CLK_GATE_SPI1_MASK                   (((1U << SYSCON_DEV_CLK_GATE_SPI1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_SPI1_SHIFT)
#define SYSCON_DEV_CLK_GATE_SPI1_VALUE_DISABLE          0U
#define SYSCON_DEV_CLK_GATE_SPI1_BITS_DISABLE           (SYSCON_DEV_CLK_GATE_SPI1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_SPI1_SHIFT)
#define SYSCON_DEV_CLK_GATE_SPI1_VALUE_ENABLE           1U
#define SYSCON_DEV_CLK_GATE_SPI1_BITS_ENABLE            (SYSCON_DEV_CLK_GATE_SPI1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_SPI1_SHIFT)

#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_SHIFT           12
#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_WIDTH           1
#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_MASK            (((1U << SYSCON_DEV_CLK_GATE_TIMER_BASE0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_TIMER_BASE0_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_VALUE_DISABLE   0U
#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_BITS_DISABLE    (SYSCON_DEV_CLK_GATE_TIMER_BASE0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_TIMER_BASE0_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_VALUE_ENABLE    1U
#define SYSCON_DEV_CLK_GATE_TIMER_BASE0_BITS_ENABLE     (SYSCON_DEV_CLK_GATE_TIMER_BASE0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_TIMER_BASE0_SHIFT)

#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_SHIFT           13
#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_WIDTH           1
#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_MASK            (((1U << SYSCON_DEV_CLK_GATE_TIMER_BASE1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_TIMER_BASE1_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_VALUE_DISABLE   0U
#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_BITS_DISABLE    (SYSCON_DEV_CLK_GATE_TIMER_BASE1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_TIMER_BASE1_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_VALUE_ENABLE    1U
#define SYSCON_DEV_CLK_GATE_TIMER_BASE1_BITS_ENABLE     (SYSCON_DEV_CLK_GATE_TIMER_BASE1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_TIMER_BASE1_SHIFT)

#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_SHIFT           14
#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_WIDTH           1
#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_MASK            (((1U << SYSCON_DEV_CLK_GATE_TIMER_BASE2_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_TIMER_BASE2_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_VALUE_DISABLE   0U
#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_BITS_DISABLE    (SYSCON_DEV_CLK_GATE_TIMER_BASE2_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_TIMER_BASE2_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_VALUE_ENABLE    1U
#define SYSCON_DEV_CLK_GATE_TIMER_BASE2_BITS_ENABLE     (SYSCON_DEV_CLK_GATE_TIMER_BASE2_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_TIMER_BASE2_SHIFT)

#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_SHIFT           15
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_WIDTH           1
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_MASK            (((1U << SYSCON_DEV_CLK_GATE_TIMER_PLUS0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_TIMER_PLUS0_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_VALUE_DISABLE   0U
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_BITS_DISABLE    (SYSCON_DEV_CLK_GATE_TIMER_PLUS0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_TIMER_PLUS0_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_VALUE_ENABLE    1U
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS0_BITS_ENABLE     (SYSCON_DEV_CLK_GATE_TIMER_PLUS0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_TIMER_PLUS0_SHIFT)

#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_SHIFT           16
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_WIDTH           1
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_MASK            (((1U << SYSCON_DEV_CLK_GATE_TIMER_PLUS1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_TIMER_PLUS1_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_VALUE_DISABLE   0U
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_BITS_DISABLE    (SYSCON_DEV_CLK_GATE_TIMER_PLUS1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_TIMER_PLUS1_SHIFT)
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_VALUE_ENABLE    1U
#define SYSCON_DEV_CLK_GATE_TIMER_PLUS1_BITS_ENABLE     (SYSCON_DEV_CLK_GATE_TIMER_PLUS1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_TIMER_PLUS1_SHIFT)

#define SYSCON_DEV_CLK_GATE_PWM_BASE0_SHIFT             17
#define SYSCON_DEV_CLK_GATE_PWM_BASE0_WIDTH             1
#define SYSCON_DEV_CLK_GATE_PWM_BASE0_MASK              (((1U << SYSCON_DEV_CLK_GATE_PWM_BASE0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_PWM_BASE0_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_BASE0_VALUE_DISABLE     0U
#define SYSCON_DEV_CLK_GATE_PWM_BASE0_BITS_DISABLE      (SYSCON_DEV_CLK_GATE_PWM_BASE0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_PWM_BASE0_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_BASE0_VALUE_ENABLE      1U
#define SYSCON_DEV_CLK_GATE_PWM_BASE0_BITS_ENABLE       (SYSCON_DEV_CLK_GATE_PWM_BASE0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_PWM_BASE0_SHIFT)

#define SYSCON_DEV_CLK_GATE_PWM_BASE1_SHIFT             18
#define SYSCON_DEV_CLK_GATE_PWM_BASE1_WIDTH             1
#define SYSCON_DEV_CLK_GATE_PWM_BASE1_MASK              (((1U << SYSCON_DEV_CLK_GATE_PWM_BASE1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_PWM_BASE1_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_BASE1_VALUE_DISABLE     0U
#define SYSCON_DEV_CLK_GATE_PWM_BASE1_BITS_DISABLE      (SYSCON_DEV_CLK_GATE_PWM_BASE1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_PWM_BASE1_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_BASE1_VALUE_ENABLE      1U
#define SYSCON_DEV_CLK_GATE_PWM_BASE1_BITS_ENABLE       (SYSCON_DEV_CLK_GATE_PWM_BASE1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_PWM_BASE1_SHIFT)

#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_SHIFT             20
#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_WIDTH             1
#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_MASK              (((1U << SYSCON_DEV_CLK_GATE_PWM_PLUS0_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_PWM_PLUS0_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_VALUE_DISABLE     0U
#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_BITS_DISABLE      (SYSCON_DEV_CLK_GATE_PWM_PLUS0_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_PWM_PLUS0_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_VALUE_ENABLE      1U
#define SYSCON_DEV_CLK_GATE_PWM_PLUS0_BITS_ENABLE       (SYSCON_DEV_CLK_GATE_PWM_PLUS0_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_PWM_PLUS0_SHIFT)

#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_SHIFT             21
#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_WIDTH             1
#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_MASK              (((1U << SYSCON_DEV_CLK_GATE_PWM_PLUS1_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_PWM_PLUS1_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_VALUE_DISABLE     0U
#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_BITS_DISABLE      (SYSCON_DEV_CLK_GATE_PWM_PLUS1_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_PWM_PLUS1_SHIFT)
#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_VALUE_ENABLE      1U
#define SYSCON_DEV_CLK_GATE_PWM_PLUS1_BITS_ENABLE       (SYSCON_DEV_CLK_GATE_PWM_PLUS1_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_PWM_PLUS1_SHIFT)

#define SYSCON_DEV_CLK_GATE_RTC_SHIFT                   22
#define SYSCON_DEV_CLK_GATE_RTC_WIDTH                   1
#define SYSCON_DEV_CLK_GATE_RTC_MASK                    (((1U << SYSCON_DEV_CLK_GATE_RTC_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_RTC_SHIFT)
#define SYSCON_DEV_CLK_GATE_RTC_VALUE_DISABLE           0U
#define SYSCON_DEV_CLK_GATE_RTC_BITS_DISABLE            (SYSCON_DEV_CLK_GATE_RTC_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_RTC_SHIFT)
#define SYSCON_DEV_CLK_GATE_RTC_VALUE_ENABLE            1U
#define SYSCON_DEV_CLK_GATE_RTC_BITS_ENABLE             (SYSCON_DEV_CLK_GATE_RTC_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_RTC_SHIFT)

#define SYSCON_DEV_CLK_GATE_IWDT_SHIFT                  23
#define SYSCON_DEV_CLK_GATE_IWDT_WIDTH                  1
#define SYSCON_DEV_CLK_GATE_IWDT_MASK                   (((1U << SYSCON_DEV_CLK_GATE_IWDT_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_IWDT_SHIFT)
#define SYSCON_DEV_CLK_GATE_IWDT_VALUE_DISABLE          0U
#define SYSCON_DEV_CLK_GATE_IWDT_BITS_DISABLE           (SYSCON_DEV_CLK_GATE_IWDT_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_IWDT_SHIFT)
#define SYSCON_DEV_CLK_GATE_IWDT_VALUE_ENABLE           1U
#define SYSCON_DEV_CLK_GATE_IWDT_BITS_ENABLE            (SYSCON_DEV_CLK_GATE_IWDT_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_IWDT_SHIFT)

#define SYSCON_DEV_CLK_GATE_WWDT_SHIFT                  24
#define SYSCON_DEV_CLK_GATE_WWDT_WIDTH                  1
#define SYSCON_DEV_CLK_GATE_WWDT_MASK                   (((1U << SYSCON_DEV_CLK_GATE_WWDT_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_WWDT_SHIFT)
#define SYSCON_DEV_CLK_GATE_WWDT_VALUE_DISABLE          0U
#define SYSCON_DEV_CLK_GATE_WWDT_BITS_DISABLE           (SYSCON_DEV_CLK_GATE_WWDT_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_WWDT_SHIFT)
#define SYSCON_DEV_CLK_GATE_WWDT_VALUE_ENABLE           1U
#define SYSCON_DEV_CLK_GATE_WWDT_BITS_ENABLE            (SYSCON_DEV_CLK_GATE_WWDT_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_WWDT_SHIFT)

#define SYSCON_DEV_CLK_GATE_SARADC_SHIFT                25
#define SYSCON_DEV_CLK_GATE_SARADC_WIDTH                1
#define SYSCON_DEV_CLK_GATE_SARADC_MASK                 (((1U << SYSCON_DEV_CLK_GATE_SARADC_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_SARADC_SHIFT)
#define SYSCON_DEV_CLK_GATE_SARADC_VALUE_DISABLE        0U
#define SYSCON_DEV_CLK_GATE_SARADC_BITS_DISABLE         (SYSCON_DEV_CLK_GATE_SARADC_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_SARADC_SHIFT)
#define SYSCON_DEV_CLK_GATE_SARADC_VALUE_ENABLE         1U
#define SYSCON_DEV_CLK_GATE_SARADC_BITS_ENABLE          (SYSCON_DEV_CLK_GATE_SARADC_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_SARADC_SHIFT)

#define SYSCON_DEV_CLK_GATE_CRC_SHIFT                   27
#define SYSCON_DEV_CLK_GATE_CRC_WIDTH                   1
#define SYSCON_DEV_CLK_GATE_CRC_MASK                    (((1U << SYSCON_DEV_CLK_GATE_CRC_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_CRC_SHIFT)
#define SYSCON_DEV_CLK_GATE_CRC_VALUE_DISABLE           0U
#define SYSCON_DEV_CLK_GATE_CRC_BITS_DISABLE            (SYSCON_DEV_CLK_GATE_CRC_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_CRC_SHIFT)
#define SYSCON_DEV_CLK_GATE_CRC_VALUE_ENABLE            1U
#define SYSCON_DEV_CLK_GATE_CRC_BITS_ENABLE             (SYSCON_DEV_CLK_GATE_CRC_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_CRC_SHIFT)

#define SYSCON_DEV_CLK_GATE_AES_SHIFT                   28
#define SYSCON_DEV_CLK_GATE_AES_WIDTH                   1
#define SYSCON_DEV_CLK_GATE_AES_MASK                    (((1U << SYSCON_DEV_CLK_GATE_AES_WIDTH) - 1U) << SYSCON_DEV_CLK_GATE_AES_SHIFT)
#define SYSCON_DEV_CLK_GATE_AES_VALUE_DISABLE           0U
#define SYSCON_DEV_CLK_GATE_AES_BITS_DISABLE            (SYSCON_DEV_CLK_GATE_AES_VALUE_DISABLE << SYSCON_DEV_CLK_GATE_AES_SHIFT)
#define SYSCON_DEV_CLK_GATE_AES_VALUE_ENABLE            1U
#define SYSCON_DEV_CLK_GATE_AES_BITS_ENABLE             (SYSCON_DEV_CLK_GATE_AES_VALUE_ENABLE << SYSCON_DEV_CLK_GATE_AES_SHIFT)

#define SYSCON_RC_FREQ_DELTA_ADDR                       (SYSCON_BASE_ADDR + 0x0078U)
#define SYSCON_RC_FREQ_DELTA                            (*(volatile uint32_t *)SYSCON_RC_FREQ_DELTA_ADDR)
#define SYSCON_RC_FREQ_DELTA_RCLF_DELTA_SHIFT           0
#define SYSCON_RC_FREQ_DELTA_RCLF_DELTA_WIDTH           10
#define SYSCON_RC_FREQ_DELTA_RCLF_DELTA_MASK            (((1U << SYSCON_RC_FREQ_DELTA_RCLF_DELTA_WIDTH) - 1U) << SYSCON_RC_FREQ_DELTA_RCLF_DELTA_SHIFT)
#define SYSCON_RC_FREQ_DELTA_RCLF_SIG_SHIFT             10
#define SYSCON_RC_FREQ_DELTA_RCLF_SIG_WIDTH             1
#define SYSCON_RC_FREQ_DELTA_RCLF_SIG_MASK              (((1U << SYSCON_RC_FREQ_DELTA_RCLF_SIG_WIDTH) - 1U) << SYSCON_RC_FREQ_DELTA_RCLF_SIG_SHIFT)
#define SYSCON_RC_FREQ_DELTA_RCHF_DELTA_SHIFT           11
#define SYSCON_RC_FREQ_DELTA_RCHF_DELTA_WIDTH           20
#define SYSCON_RC_FREQ_DELTA_RCHF_DELTA_MASK            (((1U << SYSCON_RC_FREQ_DELTA_RCHF_DELTA_WIDTH) - 1U) << SYSCON_RC_FREQ_DELTA_RCHF_DELTA_SHIFT)
#define SYSCON_RC_FREQ_DELTA_RCHF_SIG_SHIFT             31
#define SYSCON_RC_FREQ_DELTA_RCHF_SIG_WIDTH             1
#define SYSCON_RC_FREQ_DELTA_RCHF_SIG_MASK              (((1U << SYSCON_RC_FREQ_DELTA_RCHF_SIG_WIDTH) - 1U) << SYSCON_RC_FREQ_DELTA_RCHF_SIG_SHIFT)

#define SYSCON_VREF_VOLT_DELTA_ADDR                     (SYSCON_BASE_ADDR + 0x007CU)
#define SYSCON_VREF_VOLT_DELTA                          (*(volatile uint32_t *)SYSCON_VREF_VOLT_DELTA_ADDR)
#define SYSCON_CHIP_ID0_ADDR                            (SYSCON_BASE_ADDR + 0x0080U)
#define SYSCON_CHIP_ID0                                 (*(volatile uint32_t *)SYSCON_CHIP_ID0_ADDR)
#define SYSCON_CHIP_ID1_ADDR                            (SYSCON_BASE_ADDR + 0x0084U)
#define SYSCON_CHIP_ID1                                 (*(volatile uint32_t *)SYSCON_CHIP_ID1_ADDR)
#define SYSCON_CHIP_ID2_ADDR                            (SYSCON_BASE_ADDR + 0x0088U)
#define SYSCON_CHIP_ID2                                 (*(volatile uint32_t *)SYSCON_CHIP_ID2_ADDR)
#define SYSCON_CHIP_ID3_ADDR                            (SYSCON_BASE_ADDR + 0x008CU)
#define SYSCON_CHIP_ID3                                 (*(volatile uint32_t *)SYSCON_CHIP_ID3_ADDR)


#endif

