/* Copyright 2023 Dual Tachyon
 * https://github.com/DualTachyon
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef HARDWARE_DP32G030_UART_H
#define HARDWARE_DP32G030_UART_H

#if !defined(__ASSEMBLY__)
#include <stdint.h>
#endif

/* -------- UART0 -------- */
#define UART0_BASE_ADDR                     0x4006B000U
#define UART0_BASE_SIZE                     0x00000800U
#define UART0                               ((volatile UART_Port_t *)UART0_BASE_ADDR)

/* -------- UART1 -------- */
#define UART1_BASE_ADDR                     0x4006B800U
#define UART1_BASE_SIZE                     0x00000800U
#define UART1                               ((volatile UART_Port_t *)UART1_BASE_ADDR)

/* -------- UART2 -------- */
#define UART2_BASE_ADDR                     0x4006C000U
#define UART2_BASE_SIZE                     0x00000800U
#define UART2                               ((volatile UART_Port_t *)UART2_BASE_ADDR)

/* -------- UART -------- */

typedef struct {
	uint32_t CTRL;
	uint32_t BAUD;
	uint32_t TDR;
	uint32_t RDR;
	uint32_t IE;
	uint32_t IF;
	uint32_t FIFO;
	uint32_t FC;
	uint32_t RXTO;
} UART_Port_t;

#define UART_CTRL_UARTEN_SHIFT              0
#define UART_CTRL_UARTEN_WIDTH              1
#define UART_CTRL_UARTEN_MASK               (((1U << UART_CTRL_UARTEN_WIDTH) - 1U) << UART_CTRL_UARTEN_SHIFT)
#define UART_CTRL_UARTEN_VALUE_DISABLE      0U
#define UART_CTRL_UARTEN_BITS_DISABLE       (UART_CTRL_UARTEN_VALUE_DISABLE << UART_CTRL_UARTEN_SHIFT)
#define UART_CTRL_UARTEN_VALUE_ENABLE       1U
#define UART_CTRL_UARTEN_BITS_ENABLE        (UART_CTRL_UARTEN_VALUE_ENABLE << UART_CTRL_UARTEN_SHIFT)

#define UART_CTRL_RXEN_SHIFT                1
#define UART_CTRL_RXEN_WIDTH                1
#define UART_CTRL_RXEN_MASK                 (((1U << UART_CTRL_RXEN_WIDTH) - 1U) << UART_CTRL_RXEN_SHIFT)
#define UART_CTRL_RXEN_VALUE_DISABLE        0U
#define UART_CTRL_RXEN_BITS_DISABLE         (UART_CTRL_RXEN_VALUE_DISABLE << UART_CTRL_RXEN_SHIFT)
#define UART_CTRL_RXEN_VALUE_ENABLE         1U
#define UART_CTRL_RXEN_BITS_ENABLE          (UART_CTRL_RXEN_VALUE_ENABLE << UART_CTRL_RXEN_SHIFT)

#define UART_CTRL_TXEN_SHIFT                2
#define UART_CTRL_TXEN_WIDTH                1
#define UART_CTRL_TXEN_MASK                 (((1U << UART_CTRL_TXEN_WIDTH) - 1U) << UART_CTRL_TXEN_SHIFT)
#define UART_CTRL_TXEN_VALUE_DISABLE        0U
#define UART_CTRL_TXEN_BITS_DISABLE         (UART_CTRL_TXEN_VALUE_DISABLE << UART_CTRL_TXEN_SHIFT)
#define UART_CTRL_TXEN_VALUE_ENABLE         1U
#define UART_CTRL_TXEN_BITS_ENABLE          (UART_CTRL_TXEN_VALUE_ENABLE << UART_CTRL_TXEN_SHIFT)

#define UART_CTRL_RXDMAEN_SHIFT             3
#define UART_CTRL_RXDMAEN_WIDTH             1
#define UART_CTRL_RXDMAEN_MASK              (((1U << UART_CTRL_RXDMAEN_WIDTH) - 1U) << UART_CTRL_RXDMAEN_SHIFT)
#define UART_CTRL_RXDMAEN_VALUE_DISABLE     0U
#define UART_CTRL_RXDMAEN_BITS_DISABLE      (UART_CTRL_RXDMAEN_VALUE_DISABLE << UART_CTRL_RXDMAEN_SHIFT)
#define UART_CTRL_RXDMAEN_VALUE_ENABLE      1U
#define UART_CTRL_RXDMAEN_BITS_ENABLE       (UART_CTRL_RXDMAEN_VALUE_ENABLE << UART_CTRL_RXDMAEN_SHIFT)

#define UART_CTRL_TXDMAEN_SHIFT             4
#define UART_CTRL_TXDMAEN_WIDTH             1
#define UART_CTRL_TXDMAEN_MASK              (((1U << UART_CTRL_TXDMAEN_WIDTH) - 1U) << UART_CTRL_TXDMAEN_SHIFT)
#define UART_CTRL_TXDMAEN_VALUE_DISABLE     0U
#define UART_CTRL_TXDMAEN_BITS_DISABLE      (UART_CTRL_TXDMAEN_VALUE_DISABLE << UART_CTRL_TXDMAEN_SHIFT)
#define UART_CTRL_TXDMAEN_VALUE_ENABLE      1U
#define UART_CTRL_TXDMAEN_BITS_ENABLE       (UART_CTRL_TXDMAEN_VALUE_ENABLE << UART_CTRL_TXDMAEN_SHIFT)

#define UART_CTRL_NINEBIT_SHIFT             5
#define UART_CTRL_NINEBIT_WIDTH             1
#define UART_CTRL_NINEBIT_MASK              (((1U << UART_CTRL_NINEBIT_WIDTH) - 1U) << UART_CTRL_NINEBIT_SHIFT)
#define UART_CTRL_NINEBIT_VALUE_DISABLE     0U
#define UART_CTRL_NINEBIT_BITS_DISABLE      (UART_CTRL_NINEBIT_VALUE_DISABLE << UART_CTRL_NINEBIT_SHIFT)
#define UART_CTRL_NINEBIT_VALUE_ENABLE      1U
#define UART_CTRL_NINEBIT_BITS_ENABLE       (UART_CTRL_NINEBIT_VALUE_ENABLE << UART_CTRL_NINEBIT_SHIFT)

#define UART_CTRL_PAREN_SHIFT               6
#define UART_CTRL_PAREN_WIDTH               1
#define UART_CTRL_PAREN_MASK                (((1U << UART_CTRL_PAREN_WIDTH) - 1U) << UART_CTRL_PAREN_SHIFT)
#define UART_CTRL_PAREN_VALUE_DISABLE       0U
#define UART_CTRL_PAREN_BITS_DISABLE        (UART_CTRL_PAREN_VALUE_DISABLE << UART_CTRL_PAREN_SHIFT)
#define UART_CTRL_PAREN_VALUE_ENABLE        1U
#define UART_CTRL_PAREN_BITS_ENABLE         (UART_CTRL_PAREN_VALUE_ENABLE << UART_CTRL_PAREN_SHIFT)

#define UART_IE_TXDONE_SHIFT                2
#define UART_IE_TXDONE_WIDTH                1
#define UART_IE_TXDONE_MASK                 (((1U << UART_IE_TXDONE_WIDTH) - 1U) << UART_IE_TXDONE_SHIFT)
#define UART_IE_TXDONE_VALUE_DISABLE        0U
#define UART_IE_TXDONE_BITS_DISABLE         (UART_IE_TXDONE_VALUE_DISABLE << UART_IE_TXDONE_SHIFT)
#define UART_IE_TXDONE_VALUE_ENABLE         1U
#define UART_IE_TXDONE_BITS_ENABLE          (UART_IE_TXDONE_VALUE_ENABLE << UART_IE_TXDONE_SHIFT)

#define UART_IE_PARITYE_SHIFT               3
#define UART_IE_PARITYE_WIDTH               1
#define UART_IE_PARITYE_MASK                (((1U << UART_IE_PARITYE_WIDTH) - 1U) << UART_IE_PARITYE_SHIFT)
#define UART_IE_PARITYE_VALUE_DISABLE       0U
#define UART_IE_PARITYE_BITS_DISABLE        (UART_IE_PARITYE_VALUE_DISABLE << UART_IE_PARITYE_SHIFT)
#define UART_IE_PARITYE_VALUE_ENABLE        1U
#define UART_IE_PARITYE_BITS_ENABLE         (UART_IE_PARITYE_VALUE_ENABLE << UART_IE_PARITYE_SHIFT)

#define UART_IE_STOPE_SHIFT                 4
#define UART_IE_STOPE_WIDTH                 1
#define UART_IE_STOPE_MASK                  (((1U << UART_IE_STOPE_WIDTH) - 1U) << UART_IE_STOPE_SHIFT)
#define UART_IE_STOPE_VALUE_DISABLE         0U
#define UART_IE_STOPE_BITS_DISABLE          (UART_IE_STOPE_VALUE_DISABLE << UART_IE_STOPE_SHIFT)
#define UART_IE_STOPE_VALUE_ENABLE          1U
#define UART_IE_STOPE_BITS_ENABLE           (UART_IE_STOPE_VALUE_ENABLE << UART_IE_STOPE_SHIFT)

#define UART_IE_RXTO_SHIFT                  5
#define UART_IE_RXTO_WIDTH                  1
#define UART_IE_RXTO_MASK                   (((1U << UART_IE_RXTO_WIDTH) - 1U) << UART_IE_RXTO_SHIFT)
#define UART_IE_RXTO_VALUE_DISABLE          0U
#define UART_IE_RXTO_BITS_DISABLE           (UART_IE_RXTO_VALUE_DISABLE << UART_IE_RXTO_SHIFT)
#define UART_IE_RXTO_VALUE_ENABLE           1U
#define UART_IE_RXTO_BITS_ENABLE            (UART_IE_RXTO_VALUE_ENABLE << UART_IE_RXTO_SHIFT)

#define UART_IE_RXFIFO_SHIFT                6
#define UART_IE_RXFIFO_WIDTH                1
#define UART_IE_RXFIFO_MASK                 (((1U << UART_IE_RXFIFO_WIDTH) - 1U) << UART_IE_RXFIFO_SHIFT)
#define UART_IE_RXFIFO_VALUE_DISABLE        0U
#define UART_IE_RXFIFO_BITS_DISABLE         (UART_IE_RXFIFO_VALUE_DISABLE << UART_IE_RXFIFO_SHIFT)
#define UART_IE_RXFIFO_VALUE_ENABLE         1U
#define UART_IE_RXFIFO_BITS_ENABLE          (UART_IE_RXFIFO_VALUE_ENABLE << UART_IE_RXFIFO_SHIFT)

#define UART_IE_TXFIFO_SHIFT                7
#define UART_IE_TXFIFO_WIDTH                1
#define UART_IE_TXFIFO_MASK                 (((1U << UART_IE_TXFIFO_WIDTH) - 1U) << UART_IE_TXFIFO_SHIFT)
#define UART_IE_TXFIFO_VALUE_DISABLE        0U
#define UART_IE_TXFIFO_BITS_DISABLE         (UART_IE_TXFIFO_VALUE_DISABLE << UART_IE_TXFIFO_SHIFT)
#define UART_IE_TXFIFO_VALUE_ENABLE         1U
#define UART_IE_TXFIFO_BITS_ENABLE          (UART_IE_TXFIFO_VALUE_ENABLE << UART_IE_TXFIFO_SHIFT)

#define UART_IE_RXFIFO_OVF_SHIFT            8
#define UART_IE_RXFIFO_OVF_WIDTH            1
#define UART_IE_RXFIFO_OVF_MASK             (((1U << UART_IE_RXFIFO_OVF_WIDTH) - 1U) << UART_IE_RXFIFO_OVF_SHIFT)
#define UART_IE_RXFIFO_OVF_VALUE_DISABLE    0U
#define UART_IE_RXFIFO_OVF_BITS_DISABLE     (UART_IE_RXFIFO_OVF_VALUE_DISABLE << UART_IE_RXFIFO_OVF_SHIFT)
#define UART_IE_RXFIFO_OVF_VALUE_ENABLE     1U
#define UART_IE_RXFIFO_OVF_BITS_ENABLE      (UART_IE_RXFIFO_OVF_VALUE_ENABLE << UART_IE_RXFIFO_OVF_SHIFT)

#define UART_IE_ABRD_OVF_SHIFT              9
#define UART_IE_ABRD_OVF_WIDTH              1
#define UART_IE_ABRD_OVF_MASK               (((1U << UART_IE_ABRD_OVF_WIDTH) - 1U) << UART_IE_ABRD_OVF_SHIFT)
#define UART_IE_ABRD_OVF_VALUE_DISABLE      0U
#define UART_IE_ABRD_OVF_BITS_DISABLE       (UART_IE_ABRD_OVF_VALUE_DISABLE << UART_IE_ABRD_OVF_SHIFT)
#define UART_IE_ABRD_OVF_VALUE_ENABLE       1U
#define UART_IE_ABRD_OVF_BITS_ENABLE        (UART_IE_ABRD_OVF_VALUE_ENABLE << UART_IE_ABRD_OVF_SHIFT)

#define UART_IF_TXDONE_SHIFT                2
#define UART_IF_TXDONE_WIDTH                1
#define UART_IF_TXDONE_MASK                 (((1U << UART_IF_TXDONE_WIDTH) - 1U) << UART_IF_TXDONE_SHIFT)
#define UART_IF_TXDONE_VALUE_NOT_SET        0U
#define UART_IF_TXDONE_BITS_NOT_SET         (UART_IF_TXDONE_VALUE_NOT_SET << UART_IF_TXDONE_SHIFT)
#define UART_IF_TXDONE_VALUE_SET            1U
#define UART_IF_TXDONE_BITS_SET             (UART_IF_TXDONE_VALUE_SET << UART_IF_TXDONE_SHIFT)

#define UART_IF_PARITYE_SHIFT               3
#define UART_IF_PARITYE_WIDTH               1
#define UART_IF_PARITYE_MASK                (((1U << UART_IF_PARITYE_WIDTH) - 1U) << UART_IF_PARITYE_SHIFT)
#define UART_IF_PARITYE_VALUE_NOT_SET       0U
#define UART_IF_PARITYE_BITS_NOT_SET        (UART_IF_PARITYE_VALUE_NOT_SET << UART_IF_PARITYE_SHIFT)
#define UART_IF_PARITYE_VALUE_SET           1U
#define UART_IF_PARITYE_BITS_SET            (UART_IF_PARITYE_VALUE_SET << UART_IF_PARITYE_SHIFT)

#define UART_IF_STOPE_SHIFT                 4
#define UART_IF_STOPE_WIDTH                 1
#define UART_IF_STOPE_MASK                  (((1U << UART_IF_STOPE_WIDTH) - 1U) << UART_IF_STOPE_SHIFT)
#define UART_IF_STOPE_VALUE_NOT_SET         0U
#define UART_IF_STOPE_BITS_NOT_SET          (UART_IF_STOPE_VALUE_NOT_SET << UART_IF_STOPE_SHIFT)
#define UART_IF_STOPE_VALUE_SET             1U
#define UART_IF_STOPE_BITS_SET              (UART_IF_STOPE_VALUE_SET << UART_IF_STOPE_SHIFT)

#define UART_IF_RXTO_SHIFT                  5
#define UART_IF_RXTO_WIDTH                  1
#define UART_IF_RXTO_MASK                   (((1U << UART_IF_RXTO_WIDTH) - 1U) << UART_IF_RXTO_SHIFT)
#define UART_IF_RXTO_VALUE_NOT_SET          0U
#define UART_IF_RXTO_BITS_NOT_SET           (UART_IF_RXTO_VALUE_NOT_SET << UART_IF_RXTO_SHIFT)
#define UART_IF_RXTO_VALUE_SET              1U
#define UART_IF_RXTO_BITS_SET               (UART_IF_RXTO_VALUE_SET << UART_IF_RXTO_SHIFT)

#define UART_IF_RXFIFO_SHIFT                6
#define UART_IF_RXFIFO_WIDTH                1
#define UART_IF_RXFIFO_MASK                 (((1U << UART_IF_RXFIFO_WIDTH) - 1U) << UART_IF_RXFIFO_SHIFT)
#define UART_IF_RXFIFO_VALUE_NOT_SET        0U
#define UART_IF_RXFIFO_BITS_NOT_SET         (UART_IF_RXFIFO_VALUE_NOT_SET << UART_IF_RXFIFO_SHIFT)
#define UART_IF_RXFIFO_VALUE_SET            1U
#define UART_IF_RXFIFO_BITS_SET             (UART_IF_RXFIFO_VALUE_SET << UART_IF_RXFIFO_SHIFT)

#define UART_IF_TXFIFO_SHIFT                7
#define UART_IF_TXFIFO_WIDTH                1
#define UART_IF_TXFIFO_MASK                 (((1U << UART_IF_TXFIFO_WIDTH) - 1U) << UART_IF_TXFIFO_SHIFT)
#define UART_IF_TXFIFO_VALUE_NOT_SET        0U
#define UART_IF_TXFIFO_BITS_NOT_SET         (UART_IF_TXFIFO_VALUE_NOT_SET << UART_IF_TXFIFO_SHIFT)
#define UART_IF_TXFIFO_VALUE_SET            1U
#define UART_IF_TXFIFO_BITS_SET             (UART_IF_TXFIFO_VALUE_SET << UART_IF_TXFIFO_SHIFT)

#define UART_IF_RXFIFO_OVF_SHIFT            8
#define UART_IF_RXFIFO_OVF_WIDTH            1
#define UART_IF_RXFIFO_OVF_MASK             (((1U << UART_IF_RXFIFO_OVF_WIDTH) - 1U) << UART_IF_RXFIFO_OVF_SHIFT)
#define UART_IF_RXFIFO_OVF_VALUE_NOT_SET    0U
#define UART_IF_RXFIFO_OVF_BITS_NOT_SET     (UART_IF_RXFIFO_OVF_VALUE_NOT_SET << UART_IF_RXFIFO_OVF_SHIFT)
#define UART_IF_RXFIFO_OVF_VALUE_SET        1U
#define UART_IF_RXFIFO_OVF_BITS_SET         (UART_IF_RXFIFO_OVF_VALUE_SET << UART_IF_RXFIFO_OVF_SHIFT)

#define UART_IF_ABRD_OVF_SHIFT              9
#define UART_IF_ABRD_OVF_WIDTH              1
#define UART_IF_ABRD_OVF_MASK               (((1U << UART_IF_ABRD_OVF_WIDTH) - 1U) << UART_IF_ABRD_OVF_SHIFT)
#define UART_IF_ABRD_OVF_VALUE_NOT_SET      0U
#define UART_IF_ABRD_OVF_BITS_NOT_SET       (UART_IF_ABRD_OVF_VALUE_NOT_SET << UART_IF_ABRD_OVF_SHIFT)
#define UART_IF_ABRD_OVF_VALUE_SET          1U
#define UART_IF_ABRD_OVF_BITS_SET           (UART_IF_ABRD_OVF_VALUE_SET << UART_IF_ABRD_OVF_SHIFT)

#define UART_IF_RXFIFO_EMPTY_SHIFT          10
#define UART_IF_RXFIFO_EMPTY_WIDTH          1
#define UART_IF_RXFIFO_EMPTY_MASK           (((1U << UART_IF_RXFIFO_EMPTY_WIDTH) - 1U) << UART_IF_RXFIFO_EMPTY_SHIFT)
#define UART_IF_RXFIFO_EMPTY_VALUE_NOT_SET  0U
#define UART_IF_RXFIFO_EMPTY_BITS_NOT_SET   (UART_IF_RXFIFO_EMPTY_VALUE_NOT_SET << UART_IF_RXFIFO_EMPTY_SHIFT)
#define UART_IF_RXFIFO_EMPTY_VALUE_SET      1U
#define UART_IF_RXFIFO_EMPTY_BITS_SET       (UART_IF_RXFIFO_EMPTY_VALUE_SET << UART_IF_RXFIFO_EMPTY_SHIFT)

#define UART_IF_RXFIFO_FULL_SHIFT           11
#define UART_IF_RXFIFO_FULL_WIDTH           1
#define UART_IF_RXFIFO_FULL_MASK            (((1U << UART_IF_RXFIFO_FULL_WIDTH) - 1U) << UART_IF_RXFIFO_FULL_SHIFT)
#define UART_IF_RXFIFO_FULL_VALUE_NOT_SET   0U
#define UART_IF_RXFIFO_FULL_BITS_NOT_SET    (UART_IF_RXFIFO_FULL_VALUE_NOT_SET << UART_IF_RXFIFO_FULL_SHIFT)
#define UART_IF_RXFIFO_FULL_VALUE_SET       1U
#define UART_IF_RXFIFO_FULL_BITS_SET        (UART_IF_RXFIFO_FULL_VALUE_SET << UART_IF_RXFIFO_FULL_SHIFT)

#define UART_IF_RXFIFO_HFULL_SHIFT          12
#define UART_IF_RXFIFO_HFULL_WIDTH          1
#define UART_IF_RXFIFO_HFULL_MASK           (((1U << UART_IF_RXFIFO_HFULL_WIDTH) - 1U) << UART_IF_RXFIFO_HFULL_SHIFT)
#define UART_IF_RXFIFO_HFULL_VALUE_NOT_SET  0U
#define UART_IF_RXFIFO_HFULL_BITS_NOT_SET   (UART_IF_RXFIFO_HFULL_VALUE_NOT_SET << UART_IF_RXFIFO_HFULL_SHIFT)
#define UART_IF_RXFIFO_HFULL_VALUE_SET      1U
#define UART_IF_RXFIFO_HFULL_BITS_SET       (UART_IF_RXFIFO_HFULL_VALUE_SET << UART_IF_RXFIFO_HFULL_SHIFT)

#define UART_IF_TXFIFO_EMPTY_SHIFT          13
#define UART_IF_TXFIFO_EMPTY_WIDTH          1
#define UART_IF_TXFIFO_EMPTY_MASK           (((1U << UART_IF_TXFIFO_EMPTY_WIDTH) - 1U) << UART_IF_TXFIFO_EMPTY_SHIFT)
#define UART_IF_TXFIFO_EMPTY_VALUE_NOT_SET  0U
#define UART_IF_TXFIFO_EMPTY_BITS_NOT_SET   (UART_IF_TXFIFO_EMPTY_VALUE_NOT_SET << UART_IF_TXFIFO_EMPTY_SHIFT)
#define UART_IF_TXFIFO_EMPTY_VALUE_SET      1U
#define UART_IF_TXFIFO_EMPTY_BITS_SET       (UART_IF_TXFIFO_EMPTY_VALUE_SET << UART_IF_TXFIFO_EMPTY_SHIFT)

#define UART_IF_TXFIFO_FULL_SHIFT           14
#define UART_IF_TXFIFO_FULL_WIDTH           1
#define UART_IF_TXFIFO_FULL_MASK            (((1U << UART_IF_TXFIFO_FULL_WIDTH) - 1U) << UART_IF_TXFIFO_FULL_SHIFT)
#define UART_IF_TXFIFO_FULL_VALUE_NOT_SET   0U
#define UART_IF_TXFIFO_FULL_BITS_NOT_SET    (UART_IF_TXFIFO_FULL_VALUE_NOT_SET << UART_IF_TXFIFO_FULL_SHIFT)
#define UART_IF_TXFIFO_FULL_VALUE_SET       1U
#define UART_IF_TXFIFO_FULL_BITS_SET        (UART_IF_TXFIFO_FULL_VALUE_SET << UART_IF_TXFIFO_FULL_SHIFT)

#define UART_IF_TXFIFO_HFULL_SHIFT          15
#define UART_IF_TXFIFO_HFULL_WIDTH          1
#define UART_IF_TXFIFO_HFULL_MASK           (((1U << UART_IF_TXFIFO_HFULL_WIDTH) - 1U) << UART_IF_TXFIFO_HFULL_SHIFT)
#define UART_IF_TXFIFO_HFULL_VALUE_NOT_SET  0U
#define UART_IF_TXFIFO_HFULL_BITS_NOT_SET   (UART_IF_TXFIFO_HFULL_VALUE_NOT_SET << UART_IF_TXFIFO_HFULL_SHIFT)
#define UART_IF_TXFIFO_HFULL_VALUE_SET      1U
#define UART_IF_TXFIFO_HFULL_BITS_SET       (UART_IF_TXFIFO_HFULL_VALUE_SET << UART_IF_TXFIFO_HFULL_SHIFT)

#define UART_IF_TXBUSY_SHIFT                16
#define UART_IF_TXBUSY_WIDTH                1
#define UART_IF_TXBUSY_MASK                 (((1U << UART_IF_TXBUSY_WIDTH) - 1U) << UART_IF_TXBUSY_SHIFT)
#define UART_IF_TXBUSY_VALUE_NOT_SET        0U
#define UART_IF_TXBUSY_BITS_NOT_SET         (UART_IF_TXBUSY_VALUE_NOT_SET << UART_IF_TXBUSY_SHIFT)
#define UART_IF_TXBUSY_VALUE_SET            1U
#define UART_IF_TXBUSY_BITS_SET             (UART_IF_TXBUSY_VALUE_SET << UART_IF_TXBUSY_SHIFT)

#define UART_IF_RF_LEVEL_SHIFT              17
#define UART_IF_RF_LEVEL_WIDTH              3
#define UART_IF_RF_LEVEL_MASK               (((1U << UART_IF_RF_LEVEL_WIDTH) - 1U) << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_0_8_BYTE     0U
#define UART_IF_RF_LEVEL_BITS_0_8_BYTE      (UART_IF_RF_LEVEL_VALUE_0_8_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_1_BYTE       1U
#define UART_IF_RF_LEVEL_BITS_1_BYTE        (UART_IF_RF_LEVEL_VALUE_1_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_2_BYTE       2U
#define UART_IF_RF_LEVEL_BITS_2_BYTE        (UART_IF_RF_LEVEL_VALUE_2_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_3_BYTE       3U
#define UART_IF_RF_LEVEL_BITS_3_BYTE        (UART_IF_RF_LEVEL_VALUE_3_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_4_BYTE       4U
#define UART_IF_RF_LEVEL_BITS_4_BYTE        (UART_IF_RF_LEVEL_VALUE_4_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_5_BYTE       5U
#define UART_IF_RF_LEVEL_BITS_5_BYTE        (UART_IF_RF_LEVEL_VALUE_5_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_6_BYTE       6U
#define UART_IF_RF_LEVEL_BITS_6_BYTE        (UART_IF_RF_LEVEL_VALUE_6_BYTE << UART_IF_RF_LEVEL_SHIFT)
#define UART_IF_RF_LEVEL_VALUE_7_BYTE       7U
#define UART_IF_RF_LEVEL_BITS_7_BYTE        (UART_IF_RF_LEVEL_VALUE_7_BYTE << UART_IF_RF_LEVEL_SHIFT)

#define UART_IF_TF_LEVEL_SHIFT              20
#define UART_IF_TF_LEVEL_WIDTH              3
#define UART_IF_TF_LEVEL_MASK               (((1U << UART_IF_TF_LEVEL_WIDTH) - 1U) << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_0_8_BYTE     0U
#define UART_IF_TF_LEVEL_BITS_0_8_BYTE      (UART_IF_TF_LEVEL_VALUE_0_8_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_1_BYTE       1U
#define UART_IF_TF_LEVEL_BITS_1_BYTE        (UART_IF_TF_LEVEL_VALUE_1_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_2_BYTE       2U
#define UART_IF_TF_LEVEL_BITS_2_BYTE        (UART_IF_TF_LEVEL_VALUE_2_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_3_BYTE       3U
#define UART_IF_TF_LEVEL_BITS_3_BYTE        (UART_IF_TF_LEVEL_VALUE_3_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_4_BYTE       4U
#define UART_IF_TF_LEVEL_BITS_4_BYTE        (UART_IF_TF_LEVEL_VALUE_4_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_5_BYTE       5U
#define UART_IF_TF_LEVEL_BITS_5_BYTE        (UART_IF_TF_LEVEL_VALUE_5_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_6_BYTE       6U
#define UART_IF_TF_LEVEL_BITS_6_BYTE        (UART_IF_TF_LEVEL_VALUE_6_BYTE << UART_IF_TF_LEVEL_SHIFT)
#define UART_IF_TF_LEVEL_VALUE_7_BYTE       7U
#define UART_IF_TF_LEVEL_BITS_7_BYTE        (UART_IF_TF_LEVEL_VALUE_7_BYTE << UART_IF_TF_LEVEL_SHIFT)

#define UART_FIFO_RF_LEVEL_SHIFT            0
#define UART_FIFO_RF_LEVEL_WIDTH            3
#define UART_FIFO_RF_LEVEL_MASK             (((1U << UART_FIFO_RF_LEVEL_WIDTH) - 1U) << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_1_BYTE     0U
#define UART_FIFO_RF_LEVEL_BITS_1_BYTE      (UART_FIFO_RF_LEVEL_VALUE_1_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_2_BYTE     1U
#define UART_FIFO_RF_LEVEL_BITS_2_BYTE      (UART_FIFO_RF_LEVEL_VALUE_2_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_3_BYTE     2U
#define UART_FIFO_RF_LEVEL_BITS_3_BYTE      (UART_FIFO_RF_LEVEL_VALUE_3_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_4_BYTE     3U
#define UART_FIFO_RF_LEVEL_BITS_4_BYTE      (UART_FIFO_RF_LEVEL_VALUE_4_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_5_BYTE     4U
#define UART_FIFO_RF_LEVEL_BITS_5_BYTE      (UART_FIFO_RF_LEVEL_VALUE_5_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_6_BYTE     5U
#define UART_FIFO_RF_LEVEL_BITS_6_BYTE      (UART_FIFO_RF_LEVEL_VALUE_6_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_7_BYTE     6U
#define UART_FIFO_RF_LEVEL_BITS_7_BYTE      (UART_FIFO_RF_LEVEL_VALUE_7_BYTE << UART_FIFO_RF_LEVEL_SHIFT)
#define UART_FIFO_RF_LEVEL_VALUE_8_BYTE     7U
#define UART_FIFO_RF_LEVEL_BITS_8_BYTE      (UART_FIFO_RF_LEVEL_VALUE_8_BYTE << UART_FIFO_RF_LEVEL_SHIFT)

#define UART_FIFO_TF_LEVEL_SHIFT            3
#define UART_FIFO_TF_LEVEL_WIDTH            3
#define UART_FIFO_TF_LEVEL_MASK             (((1U << UART_FIFO_TF_LEVEL_WIDTH) - 1U) << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_0_BYTE     0U
#define UART_FIFO_TF_LEVEL_BITS_0_BYTE      (UART_FIFO_TF_LEVEL_VALUE_0_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_1_BYTE     1U
#define UART_FIFO_TF_LEVEL_BITS_1_BYTE      (UART_FIFO_TF_LEVEL_VALUE_1_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_2_BYTE     2U
#define UART_FIFO_TF_LEVEL_BITS_2_BYTE      (UART_FIFO_TF_LEVEL_VALUE_2_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_3_BYTE     3U
#define UART_FIFO_TF_LEVEL_BITS_3_BYTE      (UART_FIFO_TF_LEVEL_VALUE_3_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_4_BYTE     4U
#define UART_FIFO_TF_LEVEL_BITS_4_BYTE      (UART_FIFO_TF_LEVEL_VALUE_4_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_5_BYTE     5U
#define UART_FIFO_TF_LEVEL_BITS_5_BYTE      (UART_FIFO_TF_LEVEL_VALUE_5_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_6_BYTE     6U
#define UART_FIFO_TF_LEVEL_BITS_6_BYTE      (UART_FIFO_TF_LEVEL_VALUE_6_BYTE << UART_FIFO_TF_LEVEL_SHIFT)
#define UART_FIFO_TF_LEVEL_VALUE_7_BYTE     7U
#define UART_FIFO_TF_LEVEL_BITS_7_BYTE      (UART_FIFO_TF_LEVEL_VALUE_7_BYTE << UART_FIFO_TF_LEVEL_SHIFT)

#define UART_FIFO_RF_CLR_SHIFT              6
#define UART_FIFO_RF_CLR_WIDTH              1
#define UART_FIFO_RF_CLR_MASK               (((1U << UART_FIFO_RF_CLR_WIDTH) - 1U) << UART_FIFO_RF_CLR_SHIFT)
#define UART_FIFO_RF_CLR_VALUE_DISABLE      0U
#define UART_FIFO_RF_CLR_BITS_DISABLE       (UART_FIFO_RF_CLR_VALUE_DISABLE << UART_FIFO_RF_CLR_SHIFT)
#define UART_FIFO_RF_CLR_VALUE_ENABLE       1U
#define UART_FIFO_RF_CLR_BITS_ENABLE        (UART_FIFO_RF_CLR_VALUE_ENABLE << UART_FIFO_RF_CLR_SHIFT)

#define UART_FIFO_TF_CLR_SHIFT              7
#define UART_FIFO_TF_CLR_WIDTH              1
#define UART_FIFO_TF_CLR_MASK               (((1U << UART_FIFO_TF_CLR_WIDTH) - 1U) << UART_FIFO_TF_CLR_SHIFT)
#define UART_FIFO_TF_CLR_VALUE_DISABLE      0U
#define UART_FIFO_TF_CLR_BITS_DISABLE       (UART_FIFO_TF_CLR_VALUE_DISABLE << UART_FIFO_TF_CLR_SHIFT)
#define UART_FIFO_TF_CLR_VALUE_ENABLE       1U
#define UART_FIFO_TF_CLR_BITS_ENABLE        (UART_FIFO_TF_CLR_VALUE_ENABLE << UART_FIFO_TF_CLR_SHIFT)

#define UART_FC_CTSEN_SHIFT                 0
#define UART_FC_CTSEN_WIDTH                 1
#define UART_FC_CTSEN_MASK                  (((1U << UART_FC_CTSEN_WIDTH) - 1U) << UART_FC_CTSEN_SHIFT)
#define UART_FC_CTSEN_VALUE_DISABLE         0U
#define UART_FC_CTSEN_BITS_DISABLE          (UART_FC_CTSEN_VALUE_DISABLE << UART_FC_CTSEN_SHIFT)
#define UART_FC_CTSEN_VALUE_ENABLE          1U
#define UART_FC_CTSEN_BITS_ENABLE           (UART_FC_CTSEN_VALUE_ENABLE << UART_FC_CTSEN_SHIFT)

#define UART_FC_RTSEN_SHIFT                 1
#define UART_FC_RTSEN_WIDTH                 1
#define UART_FC_RTSEN_MASK                  (((1U << UART_FC_RTSEN_WIDTH) - 1U) << UART_FC_RTSEN_SHIFT)
#define UART_FC_RTSEN_VALUE_DISABLE         0U
#define UART_FC_RTSEN_BITS_DISABLE          (UART_FC_RTSEN_VALUE_DISABLE << UART_FC_RTSEN_SHIFT)
#define UART_FC_RTSEN_VALUE_ENABLE          1U
#define UART_FC_RTSEN_BITS_ENABLE           (UART_FC_RTSEN_VALUE_ENABLE << UART_FC_RTSEN_SHIFT)

#define UART_FC_CTSPOL_SHIFT                2
#define UART_FC_CTSPOL_WIDTH                1
#define UART_FC_CTSPOL_MASK                 (((1U << UART_FC_CTSPOL_WIDTH) - 1U) << UART_FC_CTSPOL_SHIFT)
#define UART_FC_CTSPOL_VALUE_LOW            0U
#define UART_FC_CTSPOL_BITS_LOW             (UART_FC_CTSPOL_VALUE_LOW << UART_FC_CTSPOL_SHIFT)
#define UART_FC_CTSPOL_VALUE_HIGH           1U
#define UART_FC_CTSPOL_BITS_HIGH            (UART_FC_CTSPOL_VALUE_HIGH << UART_FC_CTSPOL_SHIFT)

#define UART_FC_RTSPOL_SHIFT                3
#define UART_FC_RTSPOL_WIDTH                1
#define UART_FC_RTSPOL_MASK                 (((1U << UART_FC_RTSPOL_WIDTH) - 1U) << UART_FC_RTSPOL_SHIFT)
#define UART_FC_RTSPOL_VALUE_LOW            0U
#define UART_FC_RTSPOL_BITS_LOW             (UART_FC_RTSPOL_VALUE_LOW << UART_FC_RTSPOL_SHIFT)
#define UART_FC_RTSPOL_VALUE_HIGH           1U
#define UART_FC_RTSPOL_BITS_HIGH            (UART_FC_RTSPOL_VALUE_HIGH << UART_FC_RTSPOL_SHIFT)

#define UART_FC_CTS_SIGNAL_SHIFT            4
#define UART_FC_CTS_SIGNAL_WIDTH            1
#define UART_FC_CTS_SIGNAL_MASK             (((1U << UART_FC_CTS_SIGNAL_WIDTH) - 1U) << UART_FC_CTS_SIGNAL_SHIFT)
#define UART_FC_CTS_SIGNAL_VALUE_LOW        0U
#define UART_FC_CTS_SIGNAL_BITS_LOW         (UART_FC_CTS_SIGNAL_VALUE_LOW << UART_FC_CTS_SIGNAL_SHIFT)
#define UART_FC_CTS_SIGNAL_VALUE_HIGH       1U
#define UART_FC_CTS_SIGNAL_BITS_HIGH        (UART_FC_CTS_SIGNAL_VALUE_HIGH << UART_FC_CTS_SIGNAL_SHIFT)

#define UART_FC_RTS_SIGNAL_SHIFT            5
#define UART_FC_RTS_SIGNAL_WIDTH            1
#define UART_FC_RTS_SIGNAL_MASK             (((1U << UART_FC_RTS_SIGNAL_WIDTH) - 1U) << UART_FC_RTS_SIGNAL_SHIFT)
#define UART_FC_RTS_SIGNAL_VALUE_LOW        0U
#define UART_FC_RTS_SIGNAL_BITS_LOW         (UART_FC_RTS_SIGNAL_VALUE_LOW << UART_FC_RTS_SIGNAL_SHIFT)
#define UART_FC_RTS_SIGNAL_VALUE_HIGH       1U
#define UART_FC_RTS_SIGNAL_BITS_HIGH        (UART_FC_RTS_SIGNAL_VALUE_HIGH << UART_FC_RTS_SIGNAL_SHIFT)


#endif

