'''
/** Original work Copyright 2024 damiano IU3QGD
 * https://to-be-defined
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.

 * Addition to the licence: NO company with more than 50employees can use this SW and you are NOT entitled to store this software 
 * on ANY storage that in some way attempts to monetize it (eg: github)
 * corporations and banks are too rich and too powerful, they MUST be split and ALL the money given back to the state

'''

from __future__ import annotations

from tkinter import ttk
import tkinter
import webbrowser

from glob_fun import getResourcesPhotoimage, open_pdf_file
from glob_gui import JtkButtonImage
from glob_mlang import PrepperMlang, ResourcesLoadedListener
import qpystat


class Intro_gui(ttk.Frame,ResourcesLoadedListener):
    
    # -----------------------------------------------------------------------------
    # Constructor, note that this component layout is done by the caller
    # NOTE that THIS CLASS is a new panel !!!
    def __init__(self, stat : qpystat.Qpystat, parent_panel ):
        ttk.Frame.__init__(self, parent_panel ) #, borderwidth=3, relief='ridge')     
        
        self._stat=stat
        
        self._newWorkPanel(self).pack()#fill='both',expand=True)
        
        stat.glob_mlang.addToLoadedListeners(self)

    # ---------------------------------------------------------------------------------
    def _println(self, msg : str ):
        self._stat.app_println(msg)

    # ---------------------------------------------------------------------------------
    # called on swing thread when resources are loaded
    def onResourcesLoaded(self, mlabel_res : PrepperMlang):
        self._println("on resources loaded")
        
        #img = mlabel_res.getLanguagePhotoimage('Flag.png')
        #self._buttonPrepperdockmanual.setImage(img)
         
        #img = mlabel_res.getLanguagePhotoimage('Flag.png')
        #self._buttonPrepperradiomanual.setImage(img)

        #img = mlabel_res.getLanguagePhotoimage('Flag.png')
        #self._buttonEmergenzalocale.setImage(img)

    # ---------------------------------------------------------------------------------
    def _mouseMove(self,event):
        widget = event.widget
        xc = int(widget.canvasx(event.x)) 
        yc = int(widget.canvasy(event.y))
        a_text=str(xc)+'.'+str(yc)
        self._canvas.itemconfigure(self._mouse_pos_id, text=a_text)

    # ---------------------------------------------------------------------------------
    # 
    def _newWorkPanel(self, parent_panel) -> ttk.Frame:

        a_img = getResourcesPhotoimage('intro-background.png')
        i_w=a_img.width()
        i_h=a_img.height()
        
        self._println("intro img i_w="+str(i_w)+" i_h="+str(i_h))
        
        apanel = ttk.Frame(parent_panel, height=i_h, width=i_w)

        self._canvas = tkinter.Canvas(apanel,height = i_h,width = i_w ) #, bg = 'yellow')
        self._canvas.place(x = 0, y = 0)


        # for reference only, some image zooming
        self.b_img=a_img.zoom(1, 1)
        # now, CENTER the image at i_w and i_h, note that it is NOT the corner, but the image center        
        self._canvas.create_image(i_w/2,i_h/2,image=self.b_img)

        #canvas.create_oval(110, 100, 14, 12.5, outline='red' ,width='3m', tags=('item', ))
        
        self._mouse_pos_id = self._canvas.create_text(i_w-40, 7)
        
        self._canvas.bind("<Motion>", self._mouseMove)
        
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-qconnect.png'), command=self._clickQconnect).place(x=19,y=1)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-eeprom.png'), command=self._clickEeprom).place(x=174,y=1)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-messagy.png'), command=self._clickMessagy).place(x=302,y=1)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-lang.png'), command=self._clickLanguage).place(x=568,y=1)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-manual-prepperdock.png'), command=self._clicPrepperdockManual).place(x=28,y=135) 
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-manual-prepperradio.png'), command=self._clicPrepperradioManual).place(x=28,y=176)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-web-prepperradio.png'), command=self._clickPrepperradioCloud).place(x=28,y=220)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-tchan-prepperradio.png'), command=self._clicTchanPrepperradio).place(x=28,y=264)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-tgroup-prepper.png'), command=self._clicTgroupPrepper).place(x=28,y=305)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-manual-organizzarsi.png'),command=self._clicReteEmergenzaLocale).place(x=28,y=350)
        
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-contact-list.png'),command=self._clicContactList).place(x=28,y=464)
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-btn-memo.png'),command=self._clicMemo).place(x=258,y=464)
        
        JtkButtonImage(apanel,getResourcesPhotoimage('intro-abc-radio-sirio.png'), command=self._clicSirio).place(x=260,y=515)

        return apanel
    

    def _clickQconnect(self):
        self._stat.qconnect.GUI_show_window()
        
    def _clickEeprom(self):
        self._stat.eeprom_gui.GUI_show_window()

    def _clickMessagy(self):
        self._stat.qsmsg_gui.GUI_show_window()

    def _clickLanguage(self):
        self._stat.glob_mlang.GUI_show_window()

    def _clicContactList(self):
        fname=self._stat.glob_mlang.getLanguageFname('contact-list-PrepperRadio.pdf')
        open_pdf_file(fname)

    def _clicMemo(self):
        fname=self._stat.glob_mlang.getLanguageFname('memo-PrepperRadio.pdf')
        open_pdf_file(fname)

    def _clicPrepperradioManual(self):
        fname=self._stat.glob_mlang.getLanguageFname('user-manual-PrepperRadio.pdf')
        open_pdf_file(fname)

    def _clicPrepperdockManual(self):
        fname=self._stat.glob_mlang.getLanguageFname('user-manual-PrepperDOCK.pdf')
        open_pdf_file(fname)

    def _clicReteEmergenzaLocale(self):
        fname=self._stat.glob_mlang.getLanguageFname('user-manual-Come_organizzarsi.pdf')
        open_pdf_file(fname)

    def _clickPrepperradioCloud(self):
        webbrowser.open_new('https://www.universirius.com/prepperradio/')
        
    def _clicTchanPrepperradio(self):
        webbrowser.open_new('https://t.me/prepperradio')
        
    def _clicTgroupPrepper(self):
        webbrowser.open_new('https://t.me/c/2988026209/65507')

    def _clicSirio(self):
        webbrowser.open_new('https://www.universirius.com/preppers/labc-della-radio')




