'''
/** Original work Copyright 2024 damiano IU3QGD
 * https://to-be-defined
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.

 * Addition to the licence: NO company with more than 50employees can use this SW and you are NOT entitled to store this software 
 * on ANY storage that in some way attempts to monetize it (eg: github)
 * corporations and banks are too rich and too powerful, they MUST be split and ALL the money given back to the state
 
quansheng channel on X https://x.com/QuanshengRadios

https://www.datacamp.com/tutorial/python-circular-import

For internationalization 
https://docs.python.org/3/library/gettext.html#module-gettext
https://docs.python.org/3/library/locale.html

The requirements are
- it MUST be possible to have a core application and ADDIDTIONAL resources
  meaning that they DO NOT go into the exe that is built for runtime use
- There is the LANGUAGE and there is the RADIO_REGION
- Additional LANGUAGE resources LANG_RES should go in one directory
- Additional RADIO resources RADIO_RES should go into another directory
- For language, the standard is the international standard
- for RADIO_RES the identification is.... ?????
- It should be possible to select the LANG_RES and RADIO_RES (as in file browse)
- Extra distribution should just wirte their own extra directory

HOW-TO

declare a dictionary that holds anything
  adict : dict[str,typing.Any] = {}

this just allocate the main container that will be filled while the system starts
NOTE: classes in this file will see this var directly BUT this is NOT true for other files..

WIN NOTE: pyaudio requires compiled binaries, so, you may have to install a "oldish" python version to have that working

-------------- on Windows, you should install the following
pip install pyperclip
pip install pyserial
pip install pycryptodomex
pip install pyaudio
pip install bleak


------------- on linux debian derivative
apt-get install python3-serial
apt-get install python3-pyperclip
apt-get install python3-pycryptodome
apt-get install python3-pyaudio
apt-get install python3-bleak


https://tigertronics.com/slusbmain.htm

'''


from __future__ import annotations

import argparse

from app_config import AppConfig
import qpystat
from qsk5_gui import QskradioMainGui


# see https://www.pythonguis.com/tutorials/packaging-tkinter-applications-windows-pyinstaller/
try:
    # Only exists on Windows.
    from ctypes import windll   # type: ignore
    # arbitrary string     
    myappid = 'prepperdock.release.v0' 
    windll.shell32.SetCurrentProcessExplicitAppUserModelID(myappid)
except Exception as _exc:
    pass


stat = qpystat.Qpystat()

parser = argparse.ArgumentParser(description='Prepperdock parameters')
parser.add_argument('--cfgfname', help='Name of config file', default="qpyapp_config.json")
stat.appargs = parser.parse_args()

# configuration is the first one
stat.appconfig = AppConfig(getattr(stat.appargs,'cfgfname'))

# The GUI is first, since it is normally used to work
stat.qsk5_gui = QskradioMainGui(stat)

stat.qsk5_gui.runThread()

print ("END Main Thread")

