'''
/** Original work Copyright 2024 damiano IU3QGD
 * https://to-be-defined
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.

 * Addition to the licence: NO company with more than 50employees can use this SW and you are NOT entitled to store this software 
 * on ANY storage that in some way attempts to monetize it (eg: github)
 * corporations and banks are too rich and too powerful, they MUST be split and ALL the money given back to the state

'''
# -------------------------------------------------------------------------
# the idea is that the state of the app is shared between various threads
# since vars are somewhat local to a source file, you need to allocate it here and then share the "pointer"
# To avoid circular dependencies you need to avoid including in external modules this one
# It is kind of simple since you do not need to declare the type of a var...

# well, crap python has quite an issue with circular imports, the "solutions" are like ramming pine cones .... 
# One is using annotations and make types annotated, meaning that type checking quite often fails
# another one seems to be to include the module name in the type, like
# qpystat.Qpystat  
# clearly, it is a HUGE issue on renaming anything, you just keep finger crossed and hope to have anything working
# idiots, reinventing the wheel as an hexagon
# Addition, since there is not a real "clean" and rebuild, you discover crap, later
# apparently, you STILL need
# from __future__ import annotations
# EVEN if you do the above (to avoid circular import issues)

# another idiocracy, since null is harmful, so, let's reinvent null as a square
# enter Optional[something] that just say that something MAY be null, but.... so you have to handle the case in some weird way
# the end result is let's allocate an empty object since.... null is harmful
# then, how an empty object behaves.... who cares we have SOLVED the null problem (by creating a BIGGER problem)
# idiots, reinventing the wheel as a triangle

from __future__ import annotations

import argparse

from app_config import AppConfig
from app_csv import AppCsv
from app_gui import  InputParserThread, AppMainGui
from glob_eeprom import GlobEeprom
from glob_mlang import PrepperMlang
from intro_gui import Intro_gui
from qconnect_gui import QconnectThread
from qscalibrate_gui import Qscalibrate_gui
from qsdtmf_gui import QsdtmfGui
from qseeprom_gui import Qseeprom_gui
from qsk5_gui import QskradioMainGui
from qsmsg_gui import QsmsgGui
from racommand_gui import Racommand_gui
from spectrum_gui import SpectrumGui
from wiradio_gui import Wiradio_gui
from wiremote_gui import Wiremote_gui


# ---------------------------------------------------
# hold the global application objects here
class Qpystat:
    
    # ---------------------------------------------------
    # Hammering types into python is hard..... but needed
    def __init__(self):
        self.appargs : argparse.Namespace
        self.appconfig : AppConfig
        self.glob_mlang : PrepperMlang
        self.qsk5_gui : QskradioMainGui
        self.appcsv : AppCsv
        self.appmain_gui : AppMainGui
        self.inputParser : InputParserThread    
        self.qconnect : QconnectThread
        self.qsmsg_gui : QsmsgGui
        self.qsdtmf_gui : QsdtmfGui
        self.spectrum_gui : SpectrumGui
        self.globeeprom : GlobEeprom
        self.eeprom_gui  : Qseeprom_gui
        self.intro_gui : Intro_gui 
        self.racommand_gui : Racommand_gui
        self.qscalibrate_gui : Qscalibrate_gui
        self.wiremote_gui : Wiremote_gui
        self.wiradio_gui : Wiradio_gui

    # ---------------------------------------------------
    # print something in the application log window
    def app_println(self, msg):
        self.appmain_gui._println(msg)
    
    # --------------------------------------------------
    def showMessageBox(self, a_message : str ):
        self.qsk5_gui.showMessageBox(a_message)

    # --------------------------------------------------
    # this is the equivalent of toString()
    def __str__(self) -> str:
        return 'Qpystat'
