using System;
using System.Configuration;
using System.Globalization;
using System.Reflection;
using System.Resources;
using System.Threading;
using System.Windows.Forms;

internal static class Class1
{
	[STAThread]
	private static void Main()
	{
		Application.EnableVisualStyles();
		Application.SetCompatibleTextRenderingDefault(false);
		if (!string.IsNullOrEmpty(ConfigurationManager.AppSettings["Language"]))
		{
			GClass0.ilang = int.Parse(ConfigurationManager.AppSettings["Language"].ToString());
		}
		else
		{
			GClass0.ilang = 1;
		}
		GClass0.resourceManager_0 = new ResourceManager("Class0", Assembly.GetExecutingAssembly());
		if (GClass0.ilang == 1)
		{
			Thread.CurrentThread.CurrentUICulture = new CultureInfo("en");
		}
		else
		{
			Thread.CurrentThread.CurrentUICulture = new CultureInfo("zh-CHS");
		}
		bool createdNew = false;
		using (new Mutex(true, Application.ProductName, out createdNew))
		{
			if (createdNew)
			{
				Application.Run(new FrmMain());
				return;
			}
			MessageBox.Show(GClass0.resourceManager_0.GetString("Program_Tip"));
			Thread.Sleep(1000);
			Environment.Exit(1);
		}
	}
}
