using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;

public class FrmRadioFreq : Form
{
	private IContainer icontainer_0;

	private GroupBox groupBox1;

	private DataGridView dgvChannels;

	private DataGridViewTextBoxColumn clnNo;

	private DataGridViewTextBoxColumn clnFreq;

	private bool bool_0;

	private GStruct4 gstruct4_0;

	private static FrmRadioFreq frmRadioFreq_0;

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
		System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmRadioFreq));
		System.Windows.Forms.DataGridViewCellStyle dataGridViewCellStyle = new System.Windows.Forms.DataGridViewCellStyle();
		this.groupBox1 = new System.Windows.Forms.GroupBox();
		this.dgvChannels = new System.Windows.Forms.DataGridView();
		this.clnNo = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnFreq = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.groupBox1.SuspendLayout();
		((System.ComponentModel.ISupportInitialize)this.dgvChannels).BeginInit();
		base.SuspendLayout();
		resources.ApplyResources(this.groupBox1, "groupBox1");
		this.groupBox1.Controls.Add(this.dgvChannels);
		this.groupBox1.Name = "groupBox1";
		this.groupBox1.TabStop = false;
		resources.ApplyResources(this.dgvChannels, "dgvChannels");
		this.dgvChannels.AllowUserToAddRows = false;
		this.dgvChannels.AllowUserToDeleteRows = false;
		this.dgvChannels.AllowUserToResizeColumns = false;
		this.dgvChannels.AllowUserToResizeRows = false;
		dataGridViewCellStyle.BackColor = System.Drawing.Color.Bisque;
		this.dgvChannels.AlternatingRowsDefaultCellStyle = dataGridViewCellStyle;
		this.dgvChannels.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
		this.dgvChannels.Columns.AddRange(this.clnNo, this.clnFreq);
		this.dgvChannels.MultiSelect = false;
		this.dgvChannels.Name = "dgvChannels";
		this.dgvChannels.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.DisableResizing;
		this.dgvChannels.RowTemplate.Height = 23;
		this.dgvChannels.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
		this.dgvChannels.CellBeginEdit += new System.Windows.Forms.DataGridViewCellCancelEventHandler(dgvChannels_CellBeginEdit);
		this.dgvChannels.CellEndEdit += new System.Windows.Forms.DataGridViewCellEventHandler(dgvChannels_CellEndEdit);
		this.dgvChannels.Leave += new System.EventHandler(dgvChannels_Leave);
		resources.ApplyResources(this.clnNo, "clnNo");
		this.clnNo.Name = "clnNo";
		this.clnNo.ReadOnly = true;
		this.clnNo.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnFreq, "clnFreq");
		this.clnFreq.Name = "clnFreq";
		this.clnFreq.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this, "$this");
		base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		base.Controls.Add(this.groupBox1);
		base.Name = "FrmRadioFreq";
		base.ShowIcon = false;
		base.FormClosed += new System.Windows.Forms.FormClosedEventHandler(FrmRadioFreq_FormClosed);
		base.Load += new System.EventHandler(FrmRadioFreq_Load);
		this.groupBox1.ResumeLayout(false);
		((System.ComponentModel.ISupportInitialize)this.dgvChannels).EndInit();
		base.ResumeLayout(false);
	}

	[SpecialName]
	public GStruct4 method_0()
	{
		return gstruct4_0;
	}

	[SpecialName]
	public void method_1(GStruct4 gstruct4_1)
	{
		gstruct4_0 = gstruct4_1;
	}

	[SpecialName]
	public static FrmRadioFreq smethod_0()
	{
		if (frmRadioFreq_0 == null || frmRadioFreq_0.IsDisposed)
		{
			frmRadioFreq_0 = new FrmRadioFreq();
			frmRadioFreq_0.WindowState = FormWindowState.Normal;
		}
		return frmRadioFreq_0;
	}

	public static bool smethod_1()
	{
		if (frmRadioFreq_0 != null && !frmRadioFreq_0.IsDisposed)
		{
			return true;
		}
		return false;
	}

	private FrmRadioFreq()
	{
		InitializeComponent();
	}

	private void FrmRadioFreq_Load(object sender, EventArgs e)
	{
		gstruct4_0 = default(GStruct4);
		dgvChannels.Rows.Clear();
		dgvChannels.Rows.Add(20);
		int num = 0;
		foreach (DataGridViewRow item in (IEnumerable)dgvChannels.Rows)
		{
			item.Cells[0].Value = num + 1;
			num++;
		}
	}

	public void method_2(GStruct4 gstruct4_1)
	{
		gstruct4_0 = gstruct4_1;
		dgvChannels.Rows.Clear();
		dgvChannels.Rows.Add(20);
		try
		{
			int num2 = 0;
			foreach (DataGridViewRow item in (IEnumerable)dgvChannels.Rows)
			{
				item.Cells[0].Value = num2 + 1;
				if (gstruct4_1.bool_0[num2])
				{
					item.Cells[1].Value = gstruct4_1.double_0[num2].ToString("F1");
				}
				num2++;
			}
		}
		catch (Exception)
		{
		}
	}

	private void FrmRadioFreq_FormClosed(object sender, FormClosedEventArgs e)
	{
		GStruct4 gStruct = default(GStruct4);
		gStruct.bool_0 = new bool[20];
		gStruct.double_0 = new double[20];
		for (int i = 0; i < dgvChannels.Rows.Count; i++)
		{
			if (dgvChannels.Rows[i].Cells[1].Value != null && method_4(dgvChannels.Rows[i].Cells[1].Value.ToString()))
			{
				gStruct.bool_0[i] = true;
				gStruct.double_0[i] = double.Parse(dgvChannels.Rows[i].Cells[1].Value.ToString());
			}
			else
			{
				gStruct.bool_0[i] = false;
			}
		}
		FrmMain frmMain = (FrmMain)base.MdiParent;
		if (frmMain != null)
		{
			frmMain.setRadioFreq(gStruct);
		}
	}

	private void dgvChannels_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e)
	{
		if (e.ColumnIndex == 1)
		{
			bool_0 = true;
		}
	}

	private void dgvChannels_CellEndEdit(object sender, DataGridViewCellEventArgs e)
	{
		if (e.ColumnIndex != 1)
		{
			return;
		}
		bool_0 = false;
		if (dgvChannels.Rows[e.RowIndex].Cells[1].Value != null)
		{
			string text = dgvChannels.Rows[e.RowIndex].Cells[1].Value.ToString();
			double result = 0.0;
			uint num2 = 0u;
			if (string.IsNullOrEmpty(text))
			{
				method_3();
				return;
			}
			if (!double.TryParse(text, out result))
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmRadioFreq_FreqIsNumber"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				if (GClass0.bool_3)
				{
					GClass0.bool_4 = true;
				}
				return;
			}
			num2 = GClass4.dfreqToUint(result);
			if ((num2 < 65000000 || num2 > 75000000) && (num2 < 76000000 || num2 > 108000000))
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmRadioFreq_FreqRange"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				if (GClass0.bool_3)
				{
					GClass0.bool_4 = true;
				}
				return;
			}
		}
		method_3();
	}

	private void dgvChannels_Leave(object sender, EventArgs e)
	{
		if (bool_0)
		{
			dgvChannels.EndEdit();
		}
		else
		{
			method_3();
		}
	}

	private void method_3()
	{
		for (int i = 0; i < dgvChannels.Rows.Count; i++)
		{
			if (dgvChannels.Rows[i].Cells[1].Value != null && method_4(dgvChannels.Rows[i].Cells[1].Value.ToString()))
			{
				gstruct4_0.bool_0[i] = true;
				gstruct4_0.double_0[i] = double.Parse(dgvChannels.Rows[i].Cells[1].Value.ToString());
			}
			else
			{
				gstruct4_0.bool_0[i] = false;
			}
		}
	}

	private bool method_4(string string_0)
	{
		double result = 0.0;
		uint num = 0u;
		if (string.IsNullOrEmpty(string_0))
		{
			return false;
		}
		if (!double.TryParse(string_0, out result))
		{
			return false;
		}
		num = GClass4.dfreqToUint(result);
		if ((num >= 65000000 && num <= 75000000) || (num >= 76000000 && num <= 108000000))
		{
			return true;
		}
		return false;
	}

	public GStruct4 method_5()
	{
		GStruct4 result = default(GStruct4);
		result.bool_0 = new bool[20];
		result.double_0 = new double[20];
		for (int i = 0; i < dgvChannels.Rows.Count; i++)
		{
			if (dgvChannels.Rows[i].Cells[1].Value != null && method_4(dgvChannels.Rows[i].Cells[1].Value.ToString()))
			{
				result.bool_0[i] = true;
				result.double_0[i] = double.Parse(dgvChannels.Rows[i].Cells[1].Value.ToString());
			}
			else
			{
				result.bool_0[i] = false;
			}
		}
		return result;
	}
}
