using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Windows.Forms;

public class FrmScanList : Form
{
	private IContainer icontainer_0;

	private Label label1;

	private Label label2;

	private ListBox lstUsed;

	private ListBox lstMember;

	private Button btnAdd;

	private Button btnRemove;

	private CheckBox chkPriScanChanEnable;

	private Button btnCancel;

	private Button btnOK;

	private ComboBox cmbPriChannel1;

	private Label label3;

	private ComboBox cmbPriChannel2;

	private Label label4;

	private int int_0;

	private GStructScan gstruct7_0;

	private string string_0 = string.Empty;

	private Dictionary<int, string> dictionary_0;

	private DataTable dataTable_0;

	private DataTable dataTable_1;

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
		System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmScanList));
		this.label1 = new System.Windows.Forms.Label();
		this.label2 = new System.Windows.Forms.Label();
		this.lstUsed = new System.Windows.Forms.ListBox();
		this.lstMember = new System.Windows.Forms.ListBox();
		this.btnAdd = new System.Windows.Forms.Button();
		this.btnRemove = new System.Windows.Forms.Button();
		this.chkPriScanChanEnable = new System.Windows.Forms.CheckBox();
		this.btnCancel = new System.Windows.Forms.Button();
		this.btnOK = new System.Windows.Forms.Button();
		this.cmbPriChannel1 = new System.Windows.Forms.ComboBox();
		this.label3 = new System.Windows.Forms.Label();
		this.cmbPriChannel2 = new System.Windows.Forms.ComboBox();
		this.label4 = new System.Windows.Forms.Label();
		base.SuspendLayout();
		resources.ApplyResources(this.label1, "label1");
		this.label1.Name = "label1";
		resources.ApplyResources(this.label2, "label2");
		this.label2.Name = "label2";
		resources.ApplyResources(this.lstUsed, "lstUsed");
		this.lstUsed.FormattingEnabled = true;
		this.lstUsed.Name = "lstUsed";
		resources.ApplyResources(this.lstMember, "lstMember");
		this.lstMember.FormattingEnabled = true;
		this.lstMember.Name = "lstMember";
		resources.ApplyResources(this.btnAdd, "btnAdd");
		this.btnAdd.Name = "btnAdd";
		this.btnAdd.UseVisualStyleBackColor = true;
		this.btnAdd.Click += new System.EventHandler(btnAdd_Click);
		resources.ApplyResources(this.btnRemove, "btnRemove");
		this.btnRemove.Name = "btnRemove";
		this.btnRemove.UseVisualStyleBackColor = true;
		this.btnRemove.Click += new System.EventHandler(btnRemove_Click);
		resources.ApplyResources(this.chkPriScanChanEnable, "chkPriScanChanEnable");
		this.chkPriScanChanEnable.Name = "chkPriScanChanEnable";
		this.chkPriScanChanEnable.UseVisualStyleBackColor = true;
		this.chkPriScanChanEnable.CheckedChanged += new System.EventHandler(chkPriScanChanEnable_CheckedChanged);
		resources.ApplyResources(this.btnCancel, "btnCancel");
		this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
		this.btnCancel.Name = "btnCancel";
		this.btnCancel.UseVisualStyleBackColor = true;
		this.btnCancel.Click += new System.EventHandler(btnCancel_Click);
		resources.ApplyResources(this.btnOK, "btnOK");
		this.btnOK.Name = "btnOK";
		this.btnOK.UseVisualStyleBackColor = true;
		this.btnOK.Click += new System.EventHandler(btnOK_Click);
		resources.ApplyResources(this.cmbPriChannel1, "cmbPriChannel1");
		this.cmbPriChannel1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbPriChannel1.FormattingEnabled = true;
		this.cmbPriChannel1.Name = "cmbPriChannel1";
		resources.ApplyResources(this.label3, "label3");
		this.label3.Name = "label3";
		resources.ApplyResources(this.cmbPriChannel2, "cmbPriChannel2");
		this.cmbPriChannel2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbPriChannel2.FormattingEnabled = true;
		this.cmbPriChannel2.Name = "cmbPriChannel2";
		resources.ApplyResources(this.label4, "label4");
		this.label4.Name = "label4";
		base.AcceptButton = this.btnOK;
		resources.ApplyResources(this, "$this");
		base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		base.CancelButton = this.btnCancel;
		base.Controls.Add(this.cmbPriChannel2);
		base.Controls.Add(this.label4);
		base.Controls.Add(this.cmbPriChannel1);
		base.Controls.Add(this.label3);
		base.Controls.Add(this.chkPriScanChanEnable);
		base.Controls.Add(this.btnCancel);
		base.Controls.Add(this.btnOK);
		base.Controls.Add(this.btnRemove);
		base.Controls.Add(this.btnAdd);
		base.Controls.Add(this.lstMember);
		base.Controls.Add(this.lstUsed);
		base.Controls.Add(this.label2);
		base.Controls.Add(this.label1);
		base.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
		base.MaximizeBox = false;
		base.MinimizeBox = false;
		base.Name = "FrmScanList";
		base.ShowIcon = false;
		base.Load += new System.EventHandler(FrmScanList_Load);
		base.ResumeLayout(false);
		base.PerformLayout();
	}

	[SpecialName]
	public GStructScan method_0()
	{
		return gstruct7_0;
	}

	public FrmScanList(int int_1, GStructScan gstruct7_1, string string_1, Dictionary<int, string> dictionary_1)
	{
		InitializeComponent();
		int_0 = int_1;
		gstruct7_0 = gstruct7_1;
		string_0 = string_1;
		dictionary_0 = dictionary_1;
	}

	private void FrmScanList_Load(object sender, EventArgs e)
	{
		dataTable_0 = new DataTable();
		dataTable_0.Columns.Add("ChanNo", typeof(int));
		dataTable_0.Columns.Add("ChanName", typeof(string));
		dataTable_1 = new DataTable();
		dataTable_1.Columns.Add("ChanNo", typeof(int));
		dataTable_1.Columns.Add("ChanName", typeof(string));
		foreach (int key in dictionary_0.Keys)
		{
			if (gstruct7_0.list_0.Contains(key))
			{
				if (string.IsNullOrEmpty(dictionary_0[key]))
				{
					dataTable_1.Rows.Add(key, "CH-" + (key + 1).ToString("000"));
				}
				else
				{
					dataTable_1.Rows.Add(key, dictionary_0[key]);
				}
			}
			else if (string.IsNullOrEmpty(dictionary_0[key]))
			{
				dataTable_0.Rows.Add(key, "CH-" + (key + 1).ToString("000"));
			}
			else
			{
				dataTable_0.Rows.Add(key, dictionary_0[key]);
			}
		}
		foreach (int key2 in dictionary_0.Keys)
		{
			if (string.IsNullOrEmpty(dictionary_0[key2]))
			{
				cmbPriChannel1.Items.Add("CH-" + (key2 + 1).ToString("000"));
			}
			else
			{
				cmbPriChannel1.Items.Add(dictionary_0[key2]);
			}
			if (string.IsNullOrEmpty(dictionary_0[key2]))
			{
				cmbPriChannel2.Items.Add("CH-" + (key2 + 1).ToString("000"));
			}
			else
			{
				cmbPriChannel2.Items.Add(dictionary_0[key2]);
			}
		}
		lstUsed.DataSource = dataTable_0;
		lstUsed.DisplayMember = "ChanName";
		lstUsed.ValueMember = "ChanNo";
		lstMember.DataSource = dataTable_1;
		lstMember.DisplayMember = "ChanName";
		lstMember.ValueMember = "ChanNo";
		chkPriScanChanEnable.Checked = gstruct7_0.bool_0;
		cmbPriChannel1.SelectedIndex = method_3(gstruct7_0.int_0);
		cmbPriChannel2.SelectedIndex = method_3(gstruct7_0.int_1);
	}

	private void btnAdd_Click(object sender, EventArgs e)
	{
		int result;
		if (lstUsed.SelectedIndex >= 0 && lstUsed.SelectedIndex < dataTable_0.Rows.Count && int.TryParse(dataTable_0.Rows[lstUsed.SelectedIndex]["ChanNo"].ToString(), out result))
		{
			string text = dataTable_0.Rows[lstUsed.SelectedIndex]["ChanName"].ToString();
			dataTable_0.Rows.RemoveAt(lstUsed.SelectedIndex);
			dataTable_1.Rows.Add(result, text);
		}
	}

	private void btnRemove_Click(object sender, EventArgs e)
	{
		int result;
		if (lstMember.SelectedIndex >= 0 && lstMember.SelectedIndex < dataTable_1.Rows.Count && int.TryParse(dataTable_1.Rows[lstMember.SelectedIndex]["ChanNo"].ToString(), out result))
		{
			string text = dataTable_1.Rows[lstMember.SelectedIndex]["ChanName"].ToString();
			dataTable_1.Rows.RemoveAt(lstMember.SelectedIndex);
			dataTable_0.Rows.Add(result, text);
		}
	}

	private void chkPriScanChanEnable_CheckedChanged(object sender, EventArgs e)
	{
		label3.Enabled = chkPriScanChanEnable.Checked;
		cmbPriChannel1.Enabled = chkPriScanChanEnable.Checked;
		label4.Enabled = chkPriScanChanEnable.Checked;
		cmbPriChannel2.Enabled = chkPriScanChanEnable.Checked;
		if (!chkPriScanChanEnable.Checked)
		{
			cmbPriChannel1.SelectedIndex = -1;
			cmbPriChannel2.SelectedIndex = -1;
		}
	}

	public bool method_1()
	{
		if (lstMember.Items.Count == 0)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmScanList_MustSelect"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			lstMember.Focus();
			return false;
		}
		if (cmbPriChannel1.SelectedIndex != -1 && cmbPriChannel2.SelectedIndex != -1 && cmbPriChannel1.SelectedIndex == cmbPriChannel2.SelectedIndex)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmScanList_TwiceChan"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbPriChannel1.Focus();
			return false;
		}
		return true;
	}

	private void btnOK_Click(object sender, EventArgs e)
	{
		if (!method_1())
		{
			return;
		}
		gstruct7_0.string_0 = string_0;
		gstruct7_0.list_0.Clear();
		foreach (DataRow row in dataTable_1.Rows)
		{
			gstruct7_0.list_0.Add(int.Parse(row["ChanNo"].ToString()));
		}
		gstruct7_0.bool_0 = chkPriScanChanEnable.Checked;
		gstruct7_0.int_0 = method_2(cmbPriChannel1.SelectedIndex);
		gstruct7_0.int_1 = method_2(cmbPriChannel2.SelectedIndex);
		base.DialogResult = DialogResult.OK;
	}

	private void btnCancel_Click(object sender, EventArgs e)
	{
		Close();
	}

	private int method_2(int int_1)
	{
		try
		{
			return dictionary_0.ElementAt(int_1).Key;
		}
		catch (Exception)
		{
			return -1;
		}
	}

	private int method_3(int int_1)
	{
		int num = 0;
		foreach (int key in dictionary_0.Keys)
		{
			if (key != int_1)
			{
				num++;
				continue;
			}
			return num;
		}
		return -1;
	}
}
