using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

public static class GClass4
{
	public static void logWrite(string string_0, string string_1)
	{
		if (GClass0.streamWriter_0 == null)
		{
			return;
		}
		try
		{
			GClass0.streamWriter_0.WriteLine(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff") + "\t" + string_0 + "\t" + string_1);
			GClass0.streamWriter_0.Flush();
		}
		catch (Exception)
		{
		}
	}

	public static uint dfreqToUint(double double_0)
	{
		ulong num = 0uL;
		double_0 *= Math.Pow(10.0, 6.0);
		num = (ulong)(double_0 * 10.0 + 5.0) / 10uL;
		return (uint)num;
	}

	public static uint smethod_2(float float_0)
	{
		ulong num = 0uL;
		float_0 *= 1000f;
		num = (ulong)(float_0 * 10f + 5f) / 10uL;
		return (uint)num;
	}

	public static int freqToNum(uint uint_0)
	{
		if (uint_0 >= 50000000 && uint_0 <= 76000000)
		{
			return 0;
		}
		if (uint_0 >= 108000000 && uint_0 <= 135999900)
		{
			return 1;
		}
		if (uint_0 >= 136000000 && uint_0 <= 173999900)
		{
			return 2;
		}
		if (uint_0 >= 174000000 && uint_0 <= 349999900)
		{
			return 3;
		}
		if (uint_0 >= 350000000 && uint_0 <= 399999900)
		{
			return 4;
		}
		if (uint_0 >= 400000000 && uint_0 <= 469999900)
		{
			return 5;
		}
		if (uint_0 >= 470000000 && uint_0 <= 600000000)
		{
			return 6;
		}
		return 5;
	}

	public static int freqToRangeBegin(uint uint_0)
	{
		if (uint_0 >= 50000000 && uint_0 <= 76000000)
		{
			return 50000000;
		}
		if (uint_0 >= 108000000 && uint_0 <= 135999900)
		{
			return 108000000;
		}
		if (uint_0 >= 136000000 && uint_0 <= 173999900)
		{
			return 136000000;
		}
		if (uint_0 >= 174000000 && uint_0 <= 349999900)
		{
			return 174000000;
		}
		if (uint_0 >= 350000000 && uint_0 <= 399999900)
		{
			return 350000000;
		}
		if (uint_0 >= 400000000 && uint_0 <= 469999900)
		{
			return 400000000;
		}
		if (uint_0 >= 470000000 && uint_0 <= 600000000)
		{
			return 470000000;
		}
		return 400000000;
	}

	public static int dfreqToNum(double double_0)
	{
		return freqToNum(dfreqToUint(double_0));
	}

	public static int smethod_6(uint uint_0)
	{
		if (uint_0 >= 65000000 && uint_0 <= 75000000)
		{
			return 0;
		}
		if (uint_0 >= 76000000 && uint_0 <= 108000000)
		{
			return 1;
		}
		return 0;
	}

	public static int dfreqHiToNum(double double_0)
	{
		return smethod_6(dfreqToUint(double_0));
	}

	public static int dfreqCompare(double double_0, double double_1)
	{
		uint num = 0u;
		uint num2 = 0u;
		num = dfreqToUint(double_0);
		num2 = dfreqToUint(double_1);
		if (num2 > num)
		{
			return 1;
		}
		if (num2 < num)
		{
			return 2;
		}
		return 0;
	}

	public static bool isfreqAllow(uint ufreq, int idefaultRange, int freqNum)
	{
        // FIX: AnyRange add/edit
        return true;
        /*
		bool result = false;
		if (idefaultRange != 0)
		{
			result = (((ufreq >= 50000000 && ufreq <= 76000000) || (ufreq >= 108000000 && ufreq <= 135999900) || (ufreq >= 136000000 && ufreq <= 173999900) || (ufreq >= 174000000 && ufreq <= 349999900) || (ufreq >= 350000000 && ufreq <= 399999900) || (ufreq >= 400000000 && ufreq <= 469999900) || (ufreq >= 470000000 && ufreq <= 600000000)) ? true : false);
		}
		else
		{
			switch (freqNum)
			{
			case 0:
			case 1:
				result = ((ufreq >= 50000000 && ufreq <= 76000000) ? true : false);
				break;
			case 2:
			case 3:
				result = ((ufreq >= 108000000 && ufreq <= 135999900) ? true : false);
				break;
			case 4:
			case 5:
				result = ((ufreq >= 136000000 && ufreq <= 173999900) ? true : false);
				break;
			case 6:
			case 7:
				result = ((ufreq >= 174000000 && ufreq <= 349999900) ? true : false);
				break;
			case 8:
			case 9:
				result = ((ufreq >= 350000000 && ufreq <= 399999900) ? true : false);
				break;
			case 10:
			case 11:
				result = ((ufreq >= 400000000 && ufreq <= 469999900) ? true : false);
				break;
			case 12:
			case 13:
				result = ((ufreq >= 470000000 && ufreq <= 600000000) ? true : false);
				break;
			}
		}
		return result;
        // */ 
	}

	public static uint divideByTenAndConvertToUInt32(uint uint_0)
	{
		char[] array = (uint_0 / 10u).ToString().PadLeft(8, '0').ToArray();
		return BitConverter.ToUInt32(new byte[4]
		{
			(byte)(((uint)array[0] << 4) | (array[1] & 0xFu)),
			(byte)(((uint)array[2] << 4) | (array[3] & 0xFu)),
			(byte)(((uint)array[4] << 4) | (array[5] & 0xFu)),
			(byte)(((uint)array[6] << 4) | (array[7] & 0xFu))
		}, 0);
	}

	public static uint dfreqToUint32(double double_0)
	{
		return divideByTenAndConvertToUInt32(dfreqToUint(double_0));
	}

	public static uint smethod_12(uint uint_0)
	{
		int num = 0;
		byte[] bytes = BitConverter.GetBytes(uint_0);
		for (int i = 0; i < 4; i++)
		{
			num += ((bytes[i] >> 4) & 0xF) * (int)Math.Pow(10.0, (3 - i) * 2 + 1);
			num += (bytes[i] & 0xF) * (int)Math.Pow(10.0, (3 - i) * 2);
		}
		return (uint)(num * 10);
	}

	public static double smethod_13(uint uint_0)
	{
		return (double)smethod_12(uint_0) * 1E-06;
	}

	public static GStructChannel fillChanl(int iChanValid, int iRxNum)
	{
		GStructChannel result = default(GStructChannel);
		result.sChanName = string.Empty;
		result.iBandWidth = 0;
		if (iChanValid == 0)
		{
			switch (iRxNum)
			{
			default:
				result.dRxFreq = 50.0;
				break;
			case 0:
			case 1:
				result.dRxFreq = 50.0;
				break;
			case 2:
			case 3:
				result.dRxFreq = 108.0;
				break;
			case 4:
			case 5:
				result.dRxFreq = 136.0;
				break;
			case 6:
			case 7:
				result.dRxFreq = 174.0;
				break;
			case 8:
			case 9:
				result.dRxFreq = 350.0;
				break;
			case 10:
			case 11:
				result.dRxFreq = 400.0;
				break;
			case 12:
			case 13:
				result.dRxFreq = 470.0;
				break;
			}
		}
		else
		{
			result.dRxFreq = 400.025;
		}
		result.dTxFreq = result.dRxFreq;
		result.iTxPower = 2;
		result.iTxToneType = 0;
		result.iRxToneType = 0;
		result.iTxTone = 0;
		result.iRxTone = 0;
		result.iFreqStep = 5;
		result.iFreqReverse = 0;
		result.iEncyptFlag = 0;
		result.iBusyNoTx = 0;
		result.iPTTId = 0;
		result.iDtmfDecode = 0;
		result.AMChanFlag = 0;
		result.isChanlValid = ((iChanValid == 0) ? true : false);
		return result;
	}

	public static GStructScan smethod_15(int int_0)
	{
		GStructScan result = default(GStructScan);
		result.string_0 = string.Empty;
		result.list_0 = new List<int>();
		result.bool_0 = false;
		result.int_0 = -1;
		result.int_1 = -1;
		return result;
	}

	public static GStructChannel decodeChannelsMR(byte[] byte_0)
	{
		GStructChannel result = default(GStructChannel);
		GClass7.GStruct9 gStruct = (GClass7.GStruct9)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct9));
		if (GClass0.dictListScan[GClass0.ichanlIndex] >= 0 && GClass0.dictListScan[GClass0.ichanlIndex] <= 6)
		{
			if (gStruct.uint_0 < 5000000)
			{
				//gStruct.uint_0 = 5000000u;
			}
			else if (gStruct.uint_0 > 60000000)
			{
				gStruct.uint_0 = 60000000u;
			}
			result.dRxFreq = (double)gStruct.uint_0 * 1E-05;
			if ((gStruct.byte_3 & 0xF) == 1)
			{
				int num = (int)(gStruct.uint_0 + gStruct.uint_1);
				if (num < 5000000)
				{
					//num = 5000000;
				}
				else if (num > 60000000)
				{
					num = 60000000;
				}
				result.dTxFreq = (double)num * 1E-05;
			}
			else if ((gStruct.byte_3 & 0xF) == 2)
			{
				int num2 = (int)(gStruct.uint_0 - gStruct.uint_1);
				if (num2 < 5000000)
				{
					//num2 = 5000000;
				}
				else if (num2 > 60000000)
				{
					num2 = 60000000;
				}
				result.dTxFreq = (double)num2 * 1E-05;
			}
			else
			{
				result.dTxFreq = result.dRxFreq;
			}
			result.iTxPower = (gStruct.byte_4 >> 2) & 3;
			result.iBandWidth = (gStruct.byte_4 >> 1) & 1;
			result.iRxToneType = gStruct.byte_2 & 0xF;
			result.iRxTone = gStruct.byte_0;
			result.iTxToneType = (gStruct.byte_2 >> 4) & 0xF;
			result.iTxTone = gStruct.byte_1;
			result.iEncyptFlag = gStruct.byte_7;
			result.iFreqStep = gStruct.byte_6;
			result.iFreqReverse = gStruct.byte_4 & 1;
			result.iBusyNoTx = (gStruct.byte_4 >> 4) & 1;
			result.iPTTId = (gStruct.byte_5 >> 1) & 3;
			result.iDtmfDecode = gStruct.byte_5 & 1;
			result.AMChanFlag = (gStruct.byte_3 >> 4) & 1;
			result.sChanName = GClass0.dictChannels[GClass0.ichanlIndex];
			result.isChanlValid = true;
		}
		else
		{
			result.isChanlValid = false;
		}
		return result;
	}

	public static GStructChannel decodeChannelsVFO(byte[] byte_0)
	{
		GStructChannel result = default(GStructChannel);
		int num = 0;
		num = ((GClass0.ichanlIndex % 2 != 0) ? ((GClass0.ichanlIndex - 1) / 2) : (GClass0.ichanlIndex / 2));
		GClass7.GStruct9 gStruct = (GClass7.GStruct9)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct9));
		if (GClass0.dictListScan[num + 200] >= 0 && GClass0.dictListScan[num + 200] <= 6)
		{
			if (gStruct.uint_0 < 5000000)
			{
			    //gStruct.uint_0 = 5000000u;
			}
			else if (gStruct.uint_0 > 60000000)
			{
				//gStruct.uint_0 = 60000000u;
			}
			result.dRxFreq = (double)gStruct.uint_0 * 1E-05;
			if ((gStruct.byte_3 & 0xF) == 1)
			{
				int num2 = (int)(gStruct.uint_0 + gStruct.uint_1);
				if (num2 < 5000000)
				{
					//num2 = 5000000;
				}
				else if (num2 > 60000000)
				{
					num2 = 60000000;
				}
				result.dTxFreq = (double)num2 * 1E-05;
			}
			else if ((gStruct.byte_3 & 0xF) == 2)
			{
				int num3 = (int)(gStruct.uint_0 - gStruct.uint_1);
				if (num3 < 5000000)
				{
					//num3 = 5000000;
				}
				else if (num3 > 60000000)
				{
					num3 = 60000000;
				}
				result.dTxFreq = (double)num3 * 1E-05;
			}
			else
			{
				result.dTxFreq = result.dRxFreq;
			}
			result.iTxPower = (gStruct.byte_4 >> 2) & 3;
			result.iBandWidth = (gStruct.byte_4 >> 1) & 1;
			result.iRxToneType = gStruct.byte_2 & 0xF;
			result.iRxTone = gStruct.byte_0;
			result.iTxToneType = (gStruct.byte_2 >> 4) & 0xF;
			result.iTxTone = gStruct.byte_1;
			result.iEncyptFlag = gStruct.byte_7;
			result.iFreqStep = gStruct.byte_6;
			result.iFreqReverse = gStruct.byte_4 & 1;
			result.iBusyNoTx = (gStruct.byte_4 >> 4) & 1;
			result.iPTTId = (gStruct.byte_5 >> 1) & 3;
			result.iDtmfDecode = gStruct.byte_5 & 1;
			result.AMChanFlag = (gStruct.byte_3 >> 4) & 1;
			result.sChanName = fmChannelNameByIndex(GClass0.ichanlIndex);
			result.isChanlValid = true;
			return result;
		}
		return fillChanl(0, GClass0.ichanlIndex);
	}

	public static void decodeCommSettingAndKeyswitch(byte[] byte_0, out GStruct1 gstruct1_0, out GStruct2 gstruct2_0)
	{
		gstruct1_0 = default(GStruct1);
		gstruct2_0 = default(GStruct2);
		GClass7.GStruct10 gStruct = (GClass7.GStruct10)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct10));
		gstruct1_0.int_0 = gStruct.byte_2;
		gstruct1_0.int_1 = gStruct.byte_11;
		gstruct1_0.int_14 = gStruct.byte_13;
		gstruct1_0.int_2 = gStruct.byte_9;
		gstruct1_0.int_3 = gStruct.byte_14;
		gstruct1_0.int_4 = gStruct.byte_15;
		gstruct1_0.int_5 = gStruct.byte_6;
		gstruct1_0.int_6 = gStruct.byte_0;
		gstruct1_0.int_7 = gStruct.byte_7;
		gstruct1_0.int_8 = gStruct.byte_12;
		gstruct1_0.int_9 = gStruct.byte_1;
		gstruct1_0.int_10 = gStruct.byte_10;
		gstruct1_0.int_11 = gStruct.byte_36;
		gstruct1_0.int_12 = gStruct.byte_37;
		gstruct1_0.int_15 = gStruct.byte_27;
		gstruct1_0.int_13 = gStruct.byte_33;
		gstruct1_0.int_16 = gStruct.byte_32;
		gstruct1_0.int_17 = gStruct.byte_34;
		gstruct1_0.int_18 = gStruct.byte_39;
		gstruct1_0.int_19 = gStruct.byte_40;
		gstruct1_0.int_20 = gStruct.byte_41;
		if (gStruct.byte_44[0] == byte.MaxValue)
		{
			gstruct1_0.string_0 = string.Empty;
		}
		else
		{
			string @string = Encoding.Default.GetString(gStruct.byte_44);
			char[] trimChars = new char[1];
			gstruct1_0.string_0 = @string.Trim(trimChars);
		}
		if (gStruct.byte_45[0] == byte.MaxValue)
		{
			gstruct1_0.string_1 = string.Empty;
		}
		else
		{
			string string2 = Encoding.Default.GetString(gStruct.byte_45);
			char[] trimChars2 = new char[1];
			gstruct1_0.string_1 = string2.Trim(trimChars2);
		}
		gstruct1_0.int_21 = gStruct.byte_3;
		if (gStruct.uint_0 == uint.MaxValue)
		{
			gstruct1_0.string_2 = string.Empty;
		}
		else
		{
			gstruct1_0.string_2 = gStruct.uint_0.ToString().PadLeft(6, '0');
		}
		gstruct2_0.int_0 = gStruct.byte_28;
		gstruct2_0.int_1 = gStruct.byte_29;
		gstruct2_0.int_2 = gStruct.byte_30;
		gstruct2_0.int_3 = gStruct.byte_31;
	}

	public static void decodeListScan(byte[] byte_0, ref Dictionary<int, int> dictionary_0, ref List<GStructScan> list_0)
	{
		for (int i = 0; i < byte_0.Length; i++)
		{
			if (byte_0[i] != byte.MaxValue)
			{
				dictionary_0.Add(GClass0.ichanlIndex + i, byte_0[i] & 0xF);
				if (((byte_0[i] >> 7) & 1) == 1)
				{
					list_0[0].list_0.Add(GClass0.ichanlIndex + i);
				}
				if (((byte_0[i] >> 6) & 1) == 1)
				{
					list_0[1].list_0.Add(GClass0.ichanlIndex + i);
				}
			}
			else
			{
				dictionary_0.Add(GClass0.ichanlIndex + i, 255);
			}
		}
	}

	public static void decodeChannels(byte[] byte_0, ref Dictionary<int, string> dictionary_0)
	{
		for (int i = 0; i < 8; i++)
		{
			if (GClass0.dictListScan[GClass0.ichanlIndex + i] >= 0 && GClass0.dictListScan[GClass0.ichanlIndex + i] <= 6)
			{
				if (byte_0[16 * i] == byte.MaxValue)
				{
					dictionary_0.Add(GClass0.ichanlIndex + i, string.Empty);
					continue;
				}
				Dictionary<int, string> obj = dictionary_0;
				int key = GClass0.ichanlIndex + i;
				string @string = Encoding.Default.GetString(byte_0, 16 * i, 16);
				char[] trimChars = new char[1];
				obj.Add(key, @string.Trim(trimChars));
			}
			else
			{
				dictionary_0.Add(GClass0.ichanlIndex + i, null);
			}
		}
	}

	public static void decodeDTMFSettingAndCommSetting(byte[] byte_0, out GStruct5 gstruct5_0, ref GStruct1 gstruct1_0)
	{
		gstruct5_0 = default(GStruct5);
		GClass7.GStruct12 gStruct = (GClass7.GStruct12)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct12));
		if (gStruct.byte_12[0] == byte.MaxValue)
		{
			gstruct5_0.string_0 = string.Empty;
		}
		else
		{
			string @string = Encoding.Default.GetString(gStruct.byte_12);
			char[] trimChars = new char[1];
			gstruct5_0.string_0 = @string.Trim(trimChars);
		}
		if (gStruct.byte_13[0] == byte.MaxValue)
		{
			gstruct5_0.string_1 = string.Empty;
		}
		else
		{
			string string2 = Encoding.Default.GetString(gStruct.byte_13);
			char[] trimChars2 = new char[1];
			gstruct5_0.string_1 = string2.Trim(trimChars2);
		}
		if (gStruct.byte_14[0] == byte.MaxValue)
		{
			gstruct5_0.string_2 = string.Empty;
		}
		else
		{
			string string3 = Encoding.Default.GetString(gStruct.byte_14);
			char[] trimChars3 = new char[1];
			gstruct5_0.string_2 = string3.Trim(trimChars3);
		}
		if (gStruct.byte_1 == byte.MaxValue)
		{
			gstruct5_0.string_3 = "*";
		}
		else
		{
			char byte_ = (char)gStruct.byte_1;
			gstruct5_0.string_3 = byte_.ToString();
		}
		if (gStruct.byte_2 == byte.MaxValue)
		{
			gstruct5_0.string_4 = "#";
		}
		else
		{
			char byte_2 = (char)gStruct.byte_2;
			gstruct5_0.string_4 = byte_2.ToString();
		}
		gstruct5_0.int_0 = gStruct.byte_4;
		gstruct5_0.int_1 = gStruct.byte_3;
		if (gStruct.byte_15[0] == byte.MaxValue)
		{
			gstruct5_0.string_5 = string.Empty;
		}
		else
		{
			string string4 = Encoding.Default.GetString(gStruct.byte_15);
			char[] trimChars4 = new char[1];
			gstruct5_0.string_5 = string4.Trim(trimChars4);
		}
		if (gStruct.byte_16[0] == byte.MaxValue)
		{
			gstruct5_0.string_6 = string.Empty;
		}
		else
		{
			string string5 = Encoding.Default.GetString(gStruct.byte_16);
			char[] trimChars5 = new char[1];
			gstruct5_0.string_6 = string5.Trim(trimChars5);
		}
		gstruct5_0.int_2 = gStruct.byte_0;
		gstruct5_0.int_3 = gStruct.byte_5 * 10;
		gstruct5_0.int_4 = gStruct.byte_6 * 10;
		gstruct5_0.int_5 = gStruct.byte_7 * 10;
		gstruct5_0.int_6 = gStruct.byte_8 * 10;
		gstruct5_0.int_7 = gStruct.byte_9 * 10;
		if (gStruct.byte_10 == byte.MaxValue)
		{
			gstruct1_0.bool_0 = false;
		}
		else
		{
			gstruct1_0.bool_0 = gStruct.byte_10 == 1;
		}
	}

	public static void decodeContactDTMF(byte[] byte_0, ref List<GStructContactDTMF> list_0)
	{
		int num = byte_0.Length / 16;
		for (int i = 0; i < num; i++)
		{
			GClass7.GStruct13 gStruct = (GClass7.GStruct13)GClass6.byteToObject(byte_0.Skip(16 * i).Take(16).ToArray(), typeof(GClass7.GStruct13));
			if (gStruct.byte_0[0] == byte.MaxValue || gStruct.byte_1[0] == byte.MaxValue)
			{
				break;
			}
			List<GStructContactDTMF> obj = list_0;
			GStructContactDTMF item = default(GStructContactDTMF);
			string @string = Encoding.Default.GetString(gStruct.byte_0);
			char[] trimChars = new char[1];
			item.string_0 = @string.Trim(trimChars);
			string string2 = Encoding.Default.GetString(gStruct.byte_1);
			char[] trimChars2 = new char[1];
			item.string_1 = string2.Trim(trimChars2);
			obj.Add(item);
		}
	}

	public static void decodeRadioFreq(byte[] byte_0, out GStruct4 gstruct4_0)
	{
		gstruct4_0.bool_0 = new bool[20];
		gstruct4_0.double_0 = new double[20];
		for (int i = 0; i < 20; i++)
		{
			ushort num = BitConverter.ToUInt16(byte_0, i * 2);
			if (num != ushort.MaxValue)
			{
				gstruct4_0.bool_0[i] = true;
				gstruct4_0.double_0[i] = (double)(int)num / 10.0;
			}
			else
			{
				gstruct4_0.bool_0[i] = false;
			}
		}
	}

	public static void decodeListScan2(byte[] byte_0, List<GStructScan> list_0, out List<GStructScan> list_1, out int int_0)
	{
		int_0 = 0;
		list_1 = new List<GStructScan>();
		GClass7.GStruct15 gStruct = (GClass7.GStruct15)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct15));
		int_0 = gStruct.byte_0;
		if (list_0.Count >= 2)
		{
			list_1.Add(new GStructScan
			{
				list_0 = list_0[0].list_0,
				bool_0 = (gStruct.byte_1 == 1),
				int_0 = gStruct.byte_2,
				int_1 = gStruct.byte_3
			});
			list_1.Add(new GStructScan
			{
				list_0 = list_0[1].list_0,
				bool_0 = (gStruct.byte_4 == 1),
				int_0 = gStruct.byte_5,
				int_1 = gStruct.byte_6
			});
		}
	}

	public static void smethod_25(byte[] byte_0, ref GStruct8 gstruct8_0)
	{
		GClass7.GStruct16 gStruct = (GClass7.GStruct16)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct16));
		if (gStruct.byte_0[0] == byte.MaxValue)
		{
			gstruct8_0.string_0 = string.Empty;
		}
		else
		{
			string @string = Encoding.Default.GetString(gStruct.byte_0);
			char[] trimChars = new char[1];
			gstruct8_0.string_0 = @string.Trim(trimChars);
		}
		if (gStruct.byte_1[0] == byte.MaxValue)
		{
			gstruct8_0.string_1 = string.Empty;
			return;
		}
		string string2 = Encoding.Default.GetString(gStruct.byte_1);
		char[] trimChars2 = new char[1];
		gstruct8_0.string_1 = string2.Trim(trimChars2);
	}

	public static void smethod_26(byte[] byte_0, ref GStruct8 gstruct8_0)
	{
		uint num = 0u;
		num = BitConverter.ToUInt32(byte_0, 0);
		if (num == uint.MaxValue)
		{
			gstruct8_0.string_2 = string.Empty;
		}
		else
		{
			gstruct8_0.string_2 = num.ToString().PadLeft(6, '0');
		}
	}

	public static void decodeAdvance(byte[] byte_0, ref GStruct8 gstruct8_0)
	{
		GClass7.GStruct17 gStruct = (GClass7.GStruct17)GClass6.byteToObject(byte_0, typeof(GClass7.GStruct17));
		if (gStruct.byte_0 >= 0 && gStruct.byte_0 <= 5)
		{
			gstruct8_0.int_3 = gStruct.byte_0;
		}
		else
		{
			gstruct8_0.int_3 = 0;
		}
		if (gStruct.byte_1 >= 0 && gStruct.byte_1 <= 1)
		{
			gstruct8_0.int_1 = gStruct.byte_1;
		}
		else
		{
			gstruct8_0.int_1 = 1;
		}
		if (gStruct.byte_2 >= 0 && gStruct.byte_2 <= 1)
		{
			gstruct8_0.bool_0 = gStruct.byte_2 == 1;
		}
		else
		{
			gstruct8_0.bool_0 = false;
		}
		if (gStruct.byte_3 >= 0 && gStruct.byte_3 <= 1)
		{
			gstruct8_0.int_0 = gStruct.byte_3;
		}
		else
		{
			gstruct8_0.int_0 = 0;
		}
		if (gStruct.byte_4 >= 0 && gStruct.byte_4 <= 1)
		{
			gstruct8_0.int_2 = gStruct.byte_4;
		}
		else
		{
			gstruct8_0.int_2 = 0;
		}
		if (gStruct.byte_5 >= 0 && gStruct.byte_5 <= 1)
		{
			gstruct8_0.bool_1 = gStruct.byte_5 == 0;
		}
		else
		{
			gstruct8_0.bool_1 = false;
		}
		if (gStruct.byte_6 >= 0 && gStruct.byte_6 <= 1)
		{
			gstruct8_0.bool_2 = gStruct.byte_6 == 0;
		}
		else
		{
			gstruct8_0.bool_2 = false;
		}
	}

	public static int smethod_28(string string_0)
	{
		int num = 0;
		for (num = 0; num < GClass0.string_0.Length && !GClass0.string_0[num].Equals(string_0); num++)
		{
		}
		if (num >= GClass0.string_0.Length)
		{
			num = 0;
		}
		return num;
	}

	public static int smethod_29(string string_0)
	{
		int num = 0;
		for (num = 0; num < GClass0.string_1.Length && !GClass0.string_1[num].Equals(string_0); num++)
		{
		}
		if (num >= GClass0.string_1.Length)
		{
			num = 0;
		}
		return num;
	}

	public static int smethod_30(string string_0)
	{
		int num = 0;
		for (num = 0; num < GClass0.string_2.Length && !GClass0.string_2[num].Equals(string_0); num++)
		{
		}
		if (num >= GClass0.string_2.Length)
		{
			num = 0;
		}
		return num;
	}

	public static int smethod_31(string string_0)
	{
		int num = 0;
		for (num = 0; num < GClass0.string_3.Length && !GClass0.string_3[num].Equals(string_0); num++)
		{
		}
		if (num >= GClass0.string_3.Length)
		{
			num = 0;
		}
		return num;
	}

	public static int smethod_32(string string_0)
	{
		int num = 0;
		for (num = 0; num < GClass0.string_4.Length && !GClass0.string_4[num].Equals(string_0); num++)
		{
		}
		if (num >= GClass0.string_4.Length)
		{
			num = 0;
		}
		return num;
	}

	public static string fmChannelNameByIndex(int int_0)
	{
		string result = string.Empty;
		switch (int_0)
		{
		case 0:
			result = "F1(50M-76M)A";
			break;
		case 1:
			result = "F1(50M-76M)B";
			break;
		case 2:
			result = "F2(108M-136M)A";
			break;
		case 3:
			result = "F2(108M-136M)B";
			break;
		case 4:
			result = "F3(136M-174M)A";
			break;
		case 5:
			result = "F3(136M-174M)B";
			break;
		case 6:
			result = "F4(174M-350M)A";
			break;
		case 7:
			result = "F4(174M-350M)B";
			break;
		case 8:
			result = "F5(350M-400M)A";
			break;
		case 9:
			result = "F5(350M-400M)B";
			break;
		case 10:
			result = "F6(400M-470M)A";
			break;
		case 11:
			result = "F6(400M-470M)B";
			break;
		case 12:
			result = "F7(470M-600M)A";
			break;
		case 13:
			result = "F7(470M-600M)B";
			break;
		}
		return result;
	}

	public static bool smethod_34(uint uint_0)
	{
		GClass8.GStruct21 gStruct = default(GClass8.GStruct21);
		gStruct.gstruct20_0.ushort_0 = 1300;
		gStruct.gstruct20_0.ushort_1 = 4;
		gStruct.uint_0 = uint_0;
		GClass8.GStruct18 gStruct2 = default(GClass8.GStruct18);
		gStruct2.byte_0 = 171;
		gStruct2.byte_1 = 205;
		gStruct2.ushort_0 = 8;
		GClass8.GStruct19 gStruct3 = default(GClass8.GStruct19);
		gStruct3.byte_0 = 220;
		gStruct3.byte_1 = 186;
		byte[] array = GClass6.smethod_0(gStruct);
		gStruct3.ushort_0 = GClass9.smethod_14(array);
		byte[] array2 = new byte[4 + gStruct2.ushort_0 + 4];
		GClass6.smethod_0(gStruct2).CopyTo(array2, 0);
		array.CopyTo(array2, 4);
		GClass6.smethod_0(gStruct3).CopyTo(array2, 4 + gStruct2.ushort_0);
		array2 = smethod_40(array2, 4, gStruct2.ushort_0 + 2);
		return GClass10.smethod_0().method_15(array2, true, 3000);
	}

	public static bool smethod_35(uint[] uint_0)
	{
		GClass8.GStruct47 gStruct = default(GClass8.GStruct47);
		gStruct.gstruct20_0.ushort_0 = 1325;
		gStruct.gstruct20_0.ushort_1 = 16;
		gStruct.uint_0 = new uint[4];
		uint_0.CopyTo(gStruct.uint_0, 0);
		GClass8.GStruct18 gStruct2 = default(GClass8.GStruct18);
		gStruct2.byte_0 = 171;
		gStruct2.byte_1 = 205;
		gStruct2.ushort_0 = 20;
		GClass8.GStruct19 gStruct3 = default(GClass8.GStruct19);
		gStruct3.byte_0 = 220;
		gStruct3.byte_1 = 186;
		byte[] array = GClass6.smethod_0(gStruct);
		gStruct3.ushort_0 = GClass9.smethod_14(array);
		byte[] array2 = new byte[4 + gStruct2.ushort_0 + 4];
		GClass6.smethod_0(gStruct2).CopyTo(array2, 0);
		array.CopyTo(array2, 4);
		GClass6.smethod_0(gStruct3).CopyTo(array2, 4 + gStruct2.ushort_0);
		array2 = smethod_40(array2, 4, gStruct2.ushort_0 + 2);
		return GClass10.smethod_0().method_15(array2, true, 3000);
	}

	public static bool smethod_36(ushort ushort_0, int int_0, uint uint_0)
	{
		GClass8.GStruct29 gStruct = default(GClass8.GStruct29);
		gStruct.gstruct20_0.ushort_0 = 1307;
		gStruct.gstruct20_0.ushort_1 = 8;
		gStruct.ushort_0 = ushort_0;
		gStruct.byte_0 = (byte)int_0;
		gStruct.uint_0 = uint_0;
		GClass8.GStruct18 gStruct2 = default(GClass8.GStruct18);
		gStruct2.byte_0 = 171;
		gStruct2.byte_1 = 205;
		gStruct2.ushort_0 = 12;
		GClass8.GStruct19 gStruct3 = default(GClass8.GStruct19);
		gStruct3.byte_0 = 220;
		gStruct3.byte_1 = 186;
		byte[] array = GClass6.smethod_0(gStruct);
		gStruct3.ushort_0 = GClass9.smethod_14(array);
		byte[] array2 = new byte[4 + gStruct2.ushort_0 + 4];
		GClass6.smethod_0(gStruct2).CopyTo(array2, 0);
		array.CopyTo(array2, 4);
		GClass6.smethod_0(gStruct3).CopyTo(array2, 4 + gStruct2.ushort_0);
		array2 = smethod_40(array2, 4, gStruct2.ushort_0 + 2);
		return GClass10.smethod_0().method_15(array2, true, 3000);
	}

	public static bool smethod_37(ushort ushort_0, byte[] byte_0, int int_0, uint uint_0, bool bool_0)
	{
		if (int_0 % 8 == 0 && int_0 <= 128)
		{
			GClass8.GStruct31 gStruct = default(GClass8.GStruct31);
			gStruct.gstruct20_0.ushort_0 = 1309;
			gStruct.gstruct20_0.ushort_1 = (ushort)(8 + int_0);
			gStruct.ushort_0 = ushort_0;
			gStruct.byte_0 = (byte)int_0;
			gStruct.byte_1 = (byte)(bool_0 ? 1u : 0u);
			gStruct.uint_0 = uint_0;
			GClass8.GStruct18 gStruct2 = default(GClass8.GStruct18);
			gStruct2.byte_0 = 171;
			gStruct2.byte_1 = 205;
			gStruct2.ushort_0 = (ushort)(4 + gStruct.gstruct20_0.ushort_1);
			GClass8.GStruct19 gStruct3 = default(GClass8.GStruct19);
			gStruct3.byte_0 = 220;
			gStruct3.byte_1 = 186;
			byte[] array = new byte[4 + gStruct.gstruct20_0.ushort_1];
			GClass6.smethod_0(gStruct).CopyTo(array, 0);
			byte_0.CopyTo(array, 12);
			gStruct3.ushort_0 = GClass9.smethod_14(array);
			byte[] array2 = new byte[4 + gStruct2.ushort_0 + 4];
			GClass6.smethod_0(gStruct2).CopyTo(array2, 0);
			array.CopyTo(array2, 4);
			GClass6.smethod_0(gStruct3).CopyTo(array2, 4 + gStruct2.ushort_0);
			array2 = smethod_40(array2, 4, gStruct2.ushort_0 + 2);
			return GClass10.smethod_0().method_15(array2, true, 3000);
		}
		return false;
	}

	public static bool smethod_38()
	{
		GClass8.GStruct52 gStruct = default(GClass8.GStruct52);
		gStruct.gstruct20_0.ushort_0 = 1501;
		gStruct.gstruct20_0.ushort_1 = 0;
		GClass8.GStruct18 gStruct2 = default(GClass8.GStruct18);
		gStruct2.byte_0 = 171;
		gStruct2.byte_1 = 205;
		gStruct2.ushort_0 = 4;
		GClass8.GStruct19 gStruct3 = default(GClass8.GStruct19);
		gStruct3.byte_0 = 220;
		gStruct3.byte_1 = 186;
		byte[] array = GClass6.smethod_0(gStruct);
		gStruct3.ushort_0 = GClass9.smethod_14(array);
		byte[] array2 = new byte[4 + gStruct2.ushort_0 + 4];
		GClass6.smethod_0(gStruct2).CopyTo(array2, 0);
		array.CopyTo(array2, 4);
		GClass6.smethod_0(gStruct3).CopyTo(array2, 4 + gStruct2.ushort_0);
		array2 = smethod_40(array2, 4, gStruct2.ushort_0 + 2);
		return GClass10.smethod_0().method_15(array2, false, 0);
	}

	public static byte[] smethod_39(byte[] byte_0, int int_0, int int_1)
	{
		byte[] byte_ = new byte[int_0];
		Array.Copy(byte_0, int_1, byte_, 0, int_0);
		GClass9.smethod_11(ref byte_);
		byte[] array = new byte[int_1 + int_0];
		Array.Copy(byte_0, 0, array, 0, int_1);
		Array.Copy(byte_, 0, array, int_1, int_0);
		return array;
	}

	public static byte[] smethod_40(byte[] byte_0, int int_0, int int_1)
	{
		byte[] byte_ = new byte[int_1];
		Array.Copy(byte_0, int_0, byte_, 0, int_1);
		GClass9.smethod_11(ref byte_);
		byte[] array = new byte[byte_0.Length];
		Array.Copy(byte_0, 0, array, 0, int_0);
		Array.Copy(byte_, 0, array, int_0, int_1);
		Array.Copy(byte_0, int_0 + int_1, array, int_0 + int_1, byte_0.Length - (int_0 + int_1));
		return array;
	}

	public static string smethod_41(List<int> list_0)
	{
		StringBuilder stringBuilder = new StringBuilder();
		if (list_0.Count > 0)
		{
			for (int i = 0; i < list_0.Count; i++)
			{
				stringBuilder.Append(list_0[i].ToString()).Append("|");
			}
			return stringBuilder.ToString().Substring(0, stringBuilder.ToString().Length - 1);
		}
		return string.Empty;
	}

	public static List<int> smethod_42(string string_0)
	{
		List<int> list = new List<int>();
		string[] array = string_0.Split('|');
		for (int i = 0; i < array.Length; i++)
		{
			list.Add(int.Parse(array[i]));
		}
		return list;
	}
}
