using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Windows.Forms;

public class FrmChannelVFOs : Form
{
	private bool bool_0;

	private bool bool_1;

	private static FrmChannelVFOs frmChannelVFOs_0;

	private IContainer icontainer_0;

	private DataGridView dgvChannels;

	private ToolStripButton tbnDelete;

	private ToolStripButton tbnEdit;

	private ToolStripButton tbnAdd;

	private ToolStrip tolOperation;

	private ToolStripSeparator toolStripSeparator3;

	private ToolStripButton tbnUp;

	private ToolStripButton tbnDown;

	private DataGridViewTextBoxColumn clnNo;

	private DataGridViewTextBoxColumn clnChanName;

	private DataGridViewTextBoxColumn clnBandWidth;

	private DataGridViewTextBoxColumn clnRxFreq;

	private DataGridViewTextBoxColumn clnTxFreq;

	private DataGridViewTextBoxColumn clnTxPower;

	private DataGridViewTextBoxColumn clnRxToneType;

	private DataGridViewTextBoxColumn clnRxTone;

	private DataGridViewTextBoxColumn clnRxToneDigit;

	private DataGridViewTextBoxColumn clnTxToneType;

	private DataGridViewTextBoxColumn clnTxTone;

	private DataGridViewTextBoxColumn clnTxToneDigit;

	private DataGridViewTextBoxColumn clnFreqStep;

	private DataGridViewTextBoxColumn clnFreqReverse;

	private DataGridViewTextBoxColumn clnEncryptFlag;

	private DataGridViewTextBoxColumn clnBusyNoTx;

	private DataGridViewTextBoxColumn clnPTTID;

	private DataGridViewTextBoxColumn clnDtmfDecode;

	private DataGridViewTextBoxColumn clnAMFlag;

	private DataGridViewTextBoxColumn clnChanlKey;

	private DataGridViewTextBoxColumn clnChanlValid;

	[SpecialName]
	public static FrmChannelVFOs smethod_0()
	{
		if (frmChannelVFOs_0 == null || frmChannelVFOs_0.IsDisposed)
		{
			frmChannelVFOs_0 = new FrmChannelVFOs();
			frmChannelVFOs_0.WindowState = FormWindowState.Normal;
		}
		return frmChannelVFOs_0;
	}

	public static bool smethod_1()
	{
		if (frmChannelVFOs_0 != null && !frmChannelVFOs_0.IsDisposed)
		{
			return true;
		}
		return false;
	}

	private FrmChannelVFOs()
	{
		InitializeComponent();
	}

	private void FrmChannelVFOs_Load(object sender, EventArgs e)
	{
		int num2 = 0;
		dgvChannels.Rows.Add(14);
		foreach (DataGridViewRow item in (IEnumerable)dgvChannels.Rows)
		{
			item.Cells[0].Value = num2 + 1;
			item.Cells[1].Value = GClass4.fmChannelNameByIndex(num2);
			item.Cells[2].Value = null;
			item.Cells[3].Value = null;
			item.Cells[4].Value = null;
			item.Cells[5].Value = null;
			item.Cells[6].Value = null;
			item.Cells[7].Value = null;
			item.Cells[8].Value = null;
			item.Cells[9].Value = null;
			item.Cells[10].Value = null;
			item.Cells[11].Value = null;
			item.Cells[12].Value = null;
			item.Cells[13].Value = null;
			item.Cells[14].Value = null;
			item.Cells[15].Value = null;
			item.Cells[16].Value = null;
			item.Cells[17].Value = null;
			item.Cells[18].Value = null;
			item.Cells["clnChanlValid"].Value = false;
			item.Cells["clnChanlKey"].Value = num2;
			num2++;
		}
	}

	public void method_0(List<GStructChannel> list_0)
	{
		dgvChannels.Rows.Clear();
		dgvChannels.Rows.Add(14);
		try
		{
			int num = 0;
			foreach (GStructChannel item in list_0)
			{
				method_3(num, item);
				num++;
			}
		}
		catch (Exception)
		{
		}
	}

	private void FrmChannelVFOs_FormClosed(object sender, FormClosedEventArgs e)
	{
		List<GStructChannel> list = new List<GStructChannel>();
		for (int i = 0; i < 14; i++)
		{
			list.Add(method_2(i));
		}
		FrmMain frmMain = (FrmMain)base.MdiParent;
		if (frmMain != null)
		{
			frmMain.setVFO(list);
		}
	}

	private void FrmChannelVFOs_Activated(object sender, EventArgs e)
	{
	}

	private void tbnAdd_Click(object sender, EventArgs e)
	{
	}

	private void tbnEdit_Click(object sender, EventArgs e)
	{
		method_1();
	}

	private void tbnDelete_Click(object sender, EventArgs e)
	{
		int index = dgvChannels.CurrentRow.Index;
		if (index >= 0 && index < dgvChannels.RowCount && MessageBox.Show(GClass0.resourceManager_0.GetString("FrmChannelMRs_DeleteChanConfirm"), GClass0.resourceManager_0.GetString("DialogTitle_Ask"), MessageBoxButtons.OKCancel, MessageBoxIcon.Question) != DialogResult.Cancel)
		{
			method_3(index, default(GStructChannel));
		}
	}

	private void tbnUp_Click(object sender, EventArgs e)
	{
		int index = dgvChannels.CurrentRow.Index;
		if (index > 0 && index < dgvChannels.RowCount)
		{
			DataGridViewRow dataGridViewRow = dgvChannels.Rows[index];
			dataGridViewRow.Cells["clnChanlKey"].Value.ToString();
			DataGridViewRow dataGridViewRow2 = dataGridViewRow;
			dgvChannels.Rows.Remove(dataGridViewRow);
			dgvChannels.Rows.Insert(index - 1, dataGridViewRow2);
			dgvChannels.ClearSelection();
			dgvChannels.Rows[index - 1].Selected = true;
			dgvChannels.CurrentCell = dgvChannels.Rows[index - 1].Cells[0];
			for (int i = 0; i < dgvChannels.Rows.Count; i++)
			{
				dgvChannels.Rows[i].Cells[0].Value = i + 1;
			}
		}
	}

	private void tbnDown_Click(object sender, EventArgs e)
	{
		int index = dgvChannels.CurrentRow.Index;
		if (index >= 0 && index < dgvChannels.RowCount - 1)
		{
			DataGridViewRow dataGridViewRow = dgvChannels.Rows[index];
			dataGridViewRow.Cells["clnChanlKey"].Value.ToString();
			DataGridViewRow dataGridViewRow2 = dataGridViewRow;
			dgvChannels.Rows.Remove(dataGridViewRow);
			dgvChannels.Rows.Insert(index + 1, dataGridViewRow2);
			dgvChannels.ClearSelection();
			dgvChannels.Rows[index + 1].Selected = true;
			dgvChannels.CurrentCell = dgvChannels.Rows[index + 1].Cells[0];
			for (int i = 0; i < dgvChannels.Rows.Count; i++)
			{
				dgvChannels.Rows[i].Cells[0].Value = i + 1;
			}
		}
	}

	private void dgvChannels_CellMouseDoubleClick(object sender, DataGridViewCellMouseEventArgs e)
	{
		method_1();
	}

	private void method_1()
	{
		int index = dgvChannels.CurrentRow.Index;
		if (index >= 0 && index < dgvChannels.RowCount)
		{
			GStructChannel gstruct3_ = method_2(index);
			int num2 = int.Parse(dgvChannels.Rows[index].Cells["clnChanlKey"].Value.ToString());
			if (!gstruct3_.isChanlValid)
			{
				gstruct3_ = GClass4.fillChanl(0, num2);
			}
			FrmChannelAnalog frmChannelAnalog = new FrmChannelAnalog(num2, gstruct3_, 0, GClass4.fmChannelNameByIndex(index), bool_0, bool_1);
			if (frmChannelAnalog.ShowDialog() == DialogResult.OK)
			{
				method_3(index, frmChannelAnalog.getStructChannel());
			}
		}
	}

	public GStructChannel method_2(int int_0)
	{
		DataGridViewRow dataGridViewRow = dgvChannels.Rows[int_0];
		bool flag = bool.Parse(dataGridViewRow.Cells["clnChanlValid"].Value.ToString());
		GStructChannel result = default(GStructChannel);
		if (flag)
		{
			result.isChanlValid = flag;
			result.sChanName = dataGridViewRow.Cells[1].Value.ToString();
			result.iBandWidth = ((!dataGridViewRow.Cells[2].Value.ToString().Equals("25KHz")) ? 1 : 0);
			result.dRxFreq = double.Parse(dataGridViewRow.Cells[3].Value.ToString());
			result.dTxFreq = double.Parse(dataGridViewRow.Cells[4].Value.ToString());
			result.iTxPower = ((!dataGridViewRow.Cells[5].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerLow"))) ? (dataGridViewRow.Cells[5].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerMid")) ? 1 : 2) : 0);
			result.iRxToneType = ((!dataGridViewRow.Cells[6].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeNone"))) ? (dataGridViewRow.Cells[6].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudio")) ? 1 : (dataGridViewRow.Cells[6].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigit")) ? 2 : 3)) : 0);
			if (result.iRxToneType == 1)
			{
				result.iRxTone = GClass4.smethod_28(dataGridViewRow.Cells[7].Value.ToString());
			}
			else if (result.iRxToneType != 2 && result.iRxToneType != 3)
			{
				result.iRxTone = 0;
			}
			else
			{
				result.iRxTone = GClass4.smethod_29(dataGridViewRow.Cells[8].Value.ToString());
			}
			result.iTxToneType = ((!dataGridViewRow.Cells[9].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeNone"))) ? (dataGridViewRow.Cells[9].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudio")) ? 1 : (dataGridViewRow.Cells[9].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigit")) ? 2 : 3)) : 0);
			if (result.iTxToneType == 1)
			{
				result.iTxTone = GClass4.smethod_28(dataGridViewRow.Cells[10].Value.ToString());
			}
			else if (result.iTxToneType != 2 && result.iTxToneType != 3)
			{
				result.iTxTone = 0;
			}
			else
			{
				result.iTxTone = GClass4.smethod_29(dataGridViewRow.Cells[11].Value.ToString());
			}
			result.iFreqStep = GClass4.smethod_30(dataGridViewRow.Cells[12].Value.ToString());
			result.iFreqReverse = ((!dataGridViewRow.Cells[13].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"))) ? 1 : 0);
			result.iEncyptFlag = ((!dataGridViewRow.Cells[14].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"))) ? int.Parse(dataGridViewRow.Cells[14].Value.ToString()) : 0);
			result.iBusyNoTx = ((!dataGridViewRow.Cells[15].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"))) ? 1 : 0);
			result.iPTTId = GClass4.smethod_32(dataGridViewRow.Cells[16].Value.ToString());
			result.iDtmfDecode = ((!dataGridViewRow.Cells[17].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_No"))) ? 1 : 0);
			result.AMChanFlag = ((!dataGridViewRow.Cells[18].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"))) ? 1 : 0);
		}
		return result;
	}

	public bool method_3(int int_0, GStructChannel gstruct3_0)
	{
		DataGridViewRow dataGridViewRow = dgvChannels.Rows[int_0];
		dataGridViewRow.Cells[0].Value = int_0 + 1;
		if (gstruct3_0.isChanlValid)
		{
			dataGridViewRow.Cells[1].Value = gstruct3_0.sChanName;
			dataGridViewRow.Cells[2].Value = ((gstruct3_0.iBandWidth == 0) ? "25KHz" : "12.5KHz");
			dataGridViewRow.Cells[3].Value = gstruct3_0.dRxFreq.ToString("F5");
			dataGridViewRow.Cells[4].Value = gstruct3_0.dTxFreq.ToString("F5");
			dataGridViewRow.Cells[5].Value = ((gstruct3_0.iTxPower == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerLow") : ((gstruct3_0.iTxPower == 1) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerMid") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerHigh")));
			dataGridViewRow.Cells[6].Value = ((gstruct3_0.iRxToneType == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeNone") : ((gstruct3_0.iRxToneType == 1) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudio") : ((gstruct3_0.iRxToneType == 2) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigit") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigitR"))));
			if (gstruct3_0.iRxToneType == 1)
			{
				dataGridViewRow.Cells[7].Value = GClass0.string_0[gstruct3_0.iRxTone];
				dataGridViewRow.Cells[8].Value = null;
			}
			else if (gstruct3_0.iRxToneType == 2 || gstruct3_0.iRxToneType == 3)
			{
				dataGridViewRow.Cells[7].Value = null;
				dataGridViewRow.Cells[8].Value = GClass0.string_1[gstruct3_0.iRxTone];
			}
			dataGridViewRow.Cells[9].Value = ((gstruct3_0.iTxToneType == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeNone") : ((gstruct3_0.iTxToneType == 1) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudio") : ((gstruct3_0.iTxToneType == 2) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigit") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigitR"))));
			if (gstruct3_0.iTxToneType == 1)
			{
				dataGridViewRow.Cells[10].Value = GClass0.string_0[gstruct3_0.iTxTone];
				dataGridViewRow.Cells[11].Value = null;
			}
			else if (gstruct3_0.iTxToneType == 2 || gstruct3_0.iTxToneType == 3)
			{
				dataGridViewRow.Cells[10].Value = null;
				dataGridViewRow.Cells[11].Value = GClass0.string_1[gstruct3_0.iTxTone];
			}
			dataGridViewRow.Cells[12].Value = GClass0.string_2[gstruct3_0.iFreqStep];
			dataGridViewRow.Cells[13].Value = ((gstruct3_0.iFreqReverse == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_On"));
			dataGridViewRow.Cells[14].Value = ((gstruct3_0.iEncyptFlag == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off") : gstruct3_0.iEncyptFlag.ToString());
			dataGridViewRow.Cells[15].Value = ((gstruct3_0.iBusyNoTx == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_On"));
			dataGridViewRow.Cells[16].Value = GClass0.string_4[gstruct3_0.iPTTId];
			dataGridViewRow.Cells[17].Value = ((gstruct3_0.iDtmfDecode == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_No") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_Yes"));
			dataGridViewRow.Cells[18].Value = ((gstruct3_0.AMChanFlag == 0) ? GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off") : GClass0.resourceManager_0.GetString("FrmChannelAnalog_On"));
			dataGridViewRow.Cells["clnChanlValid"].Value = true;
		}
		else
		{
			dataGridViewRow.Cells[1].Value = GClass4.fmChannelNameByIndex(int_0);
			dataGridViewRow.Cells[2].Value = null;
			dataGridViewRow.Cells[3].Value = null;
			dataGridViewRow.Cells[4].Value = null;
			dataGridViewRow.Cells[5].Value = null;
			dataGridViewRow.Cells[6].Value = null;
			dataGridViewRow.Cells[7].Value = null;
			dataGridViewRow.Cells[8].Value = null;
			dataGridViewRow.Cells[9].Value = null;
			dataGridViewRow.Cells[10].Value = null;
			dataGridViewRow.Cells[11].Value = null;
			dataGridViewRow.Cells[12].Value = null;
			dataGridViewRow.Cells[13].Value = null;
			dataGridViewRow.Cells[14].Value = null;
			dataGridViewRow.Cells[15].Value = null;
			dataGridViewRow.Cells[16].Value = null;
			dataGridViewRow.Cells[17].Value = null;
			dataGridViewRow.Cells[18].Value = null;
			dataGridViewRow.Cells["clnChanlValid"].Value = false;
		}
		dataGridViewRow.Cells["clnChanlKey"].Value = int_0;
		return true;
	}

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmChannelVFOs));
            System.Windows.Forms.DataGridViewCellStyle dataGridViewCellStyle1 = new System.Windows.Forms.DataGridViewCellStyle();
            this.dgvChannels = new System.Windows.Forms.DataGridView();
            this.clnNo = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnChanName = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnBandWidth = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnRxFreq = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnTxFreq = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnTxPower = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnRxToneType = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnRxTone = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnRxToneDigit = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnTxToneType = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnTxTone = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnTxToneDigit = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnFreqStep = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnFreqReverse = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnEncryptFlag = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnBusyNoTx = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnPTTID = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnDtmfDecode = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnAMFlag = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnChanlKey = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.clnChanlValid = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.tbnDelete = new System.Windows.Forms.ToolStripButton();
            this.tbnEdit = new System.Windows.Forms.ToolStripButton();
            this.tbnAdd = new System.Windows.Forms.ToolStripButton();
            this.tolOperation = new System.Windows.Forms.ToolStrip();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this.tbnUp = new System.Windows.Forms.ToolStripButton();
            this.tbnDown = new System.Windows.Forms.ToolStripButton();
            ((System.ComponentModel.ISupportInitialize)(this.dgvChannels)).BeginInit();
            this.tolOperation.SuspendLayout();
            this.SuspendLayout();
            // 
            // dgvChannels
            // 
            resources.ApplyResources(this.dgvChannels, "dgvChannels");
            this.dgvChannels.AllowUserToAddRows = false;
            this.dgvChannels.AllowUserToDeleteRows = false;
            this.dgvChannels.AllowUserToResizeColumns = false;
            this.dgvChannels.AllowUserToResizeRows = false;
            dataGridViewCellStyle1.BackColor = System.Drawing.Color.Bisque;
            this.dgvChannels.AlternatingRowsDefaultCellStyle = dataGridViewCellStyle1;
            this.dgvChannels.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.dgvChannels.Columns.AddRange(new System.Windows.Forms.DataGridViewColumn[] {
            this.clnNo,
            this.clnChanName,
            this.clnBandWidth,
            this.clnRxFreq,
            this.clnTxFreq,
            this.clnTxPower,
            this.clnRxToneType,
            this.clnRxTone,
            this.clnRxToneDigit,
            this.clnTxToneType,
            this.clnTxTone,
            this.clnTxToneDigit,
            this.clnFreqStep,
            this.clnFreqReverse,
            this.clnEncryptFlag,
            this.clnBusyNoTx,
            this.clnPTTID,
            this.clnDtmfDecode,
            this.clnAMFlag,
            this.clnChanlKey,
            this.clnChanlValid});
            this.dgvChannels.MultiSelect = false;
            this.dgvChannels.Name = "dgvChannels";
            this.dgvChannels.ReadOnly = true;
            this.dgvChannels.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.DisableResizing;
            this.dgvChannels.RowTemplate.Height = 23;
            this.dgvChannels.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
            this.dgvChannels.CellMouseDoubleClick += new System.Windows.Forms.DataGridViewCellMouseEventHandler(this.dgvChannels_CellMouseDoubleClick);
            // 
            // clnNo
            // 
            resources.ApplyResources(this.clnNo, "clnNo");
            this.clnNo.Name = "clnNo";
            this.clnNo.ReadOnly = true;
            this.clnNo.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnChanName
            // 
            resources.ApplyResources(this.clnChanName, "clnChanName");
            this.clnChanName.Name = "clnChanName";
            this.clnChanName.ReadOnly = true;
            this.clnChanName.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnBandWidth
            // 
            resources.ApplyResources(this.clnBandWidth, "clnBandWidth");
            this.clnBandWidth.Name = "clnBandWidth";
            this.clnBandWidth.ReadOnly = true;
            this.clnBandWidth.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnRxFreq
            // 
            resources.ApplyResources(this.clnRxFreq, "clnRxFreq");
            this.clnRxFreq.Name = "clnRxFreq";
            this.clnRxFreq.ReadOnly = true;
            this.clnRxFreq.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnTxFreq
            // 
            resources.ApplyResources(this.clnTxFreq, "clnTxFreq");
            this.clnTxFreq.Name = "clnTxFreq";
            this.clnTxFreq.ReadOnly = true;
            this.clnTxFreq.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnTxPower
            // 
            resources.ApplyResources(this.clnTxPower, "clnTxPower");
            this.clnTxPower.Name = "clnTxPower";
            this.clnTxPower.ReadOnly = true;
            this.clnTxPower.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnRxToneType
            // 
            resources.ApplyResources(this.clnRxToneType, "clnRxToneType");
            this.clnRxToneType.Name = "clnRxToneType";
            this.clnRxToneType.ReadOnly = true;
            this.clnRxToneType.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnRxTone
            // 
            resources.ApplyResources(this.clnRxTone, "clnRxTone");
            this.clnRxTone.Name = "clnRxTone";
            this.clnRxTone.ReadOnly = true;
            this.clnRxTone.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnRxToneDigit
            // 
            resources.ApplyResources(this.clnRxToneDigit, "clnRxToneDigit");
            this.clnRxToneDigit.Name = "clnRxToneDigit";
            this.clnRxToneDigit.ReadOnly = true;
            this.clnRxToneDigit.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnTxToneType
            // 
            resources.ApplyResources(this.clnTxToneType, "clnTxToneType");
            this.clnTxToneType.Name = "clnTxToneType";
            this.clnTxToneType.ReadOnly = true;
            this.clnTxToneType.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnTxTone
            // 
            resources.ApplyResources(this.clnTxTone, "clnTxTone");
            this.clnTxTone.Name = "clnTxTone";
            this.clnTxTone.ReadOnly = true;
            this.clnTxTone.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnTxToneDigit
            // 
            resources.ApplyResources(this.clnTxToneDigit, "clnTxToneDigit");
            this.clnTxToneDigit.Name = "clnTxToneDigit";
            this.clnTxToneDigit.ReadOnly = true;
            this.clnTxToneDigit.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnFreqStep
            // 
            resources.ApplyResources(this.clnFreqStep, "clnFreqStep");
            this.clnFreqStep.Name = "clnFreqStep";
            this.clnFreqStep.ReadOnly = true;
            this.clnFreqStep.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnFreqReverse
            // 
            resources.ApplyResources(this.clnFreqReverse, "clnFreqReverse");
            this.clnFreqReverse.Name = "clnFreqReverse";
            this.clnFreqReverse.ReadOnly = true;
            this.clnFreqReverse.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnEncryptFlag
            // 
            resources.ApplyResources(this.clnEncryptFlag, "clnEncryptFlag");
            this.clnEncryptFlag.Name = "clnEncryptFlag";
            this.clnEncryptFlag.ReadOnly = true;
            this.clnEncryptFlag.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnBusyNoTx
            // 
            resources.ApplyResources(this.clnBusyNoTx, "clnBusyNoTx");
            this.clnBusyNoTx.Name = "clnBusyNoTx";
            this.clnBusyNoTx.ReadOnly = true;
            this.clnBusyNoTx.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnPTTID
            // 
            resources.ApplyResources(this.clnPTTID, "clnPTTID");
            this.clnPTTID.Name = "clnPTTID";
            this.clnPTTID.ReadOnly = true;
            this.clnPTTID.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnDtmfDecode
            // 
            resources.ApplyResources(this.clnDtmfDecode, "clnDtmfDecode");
            this.clnDtmfDecode.Name = "clnDtmfDecode";
            this.clnDtmfDecode.ReadOnly = true;
            this.clnDtmfDecode.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnAMFlag
            // 
            resources.ApplyResources(this.clnAMFlag, "clnAMFlag");
            this.clnAMFlag.Name = "clnAMFlag";
            this.clnAMFlag.ReadOnly = true;
            this.clnAMFlag.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
            // 
            // clnChanlKey
            // 
            resources.ApplyResources(this.clnChanlKey, "clnChanlKey");
            this.clnChanlKey.Name = "clnChanlKey";
            this.clnChanlKey.ReadOnly = true;
            // 
            // clnChanlValid
            // 
            resources.ApplyResources(this.clnChanlValid, "clnChanlValid");
            this.clnChanlValid.Name = "clnChanlValid";
            this.clnChanlValid.ReadOnly = true;
            // 
            // tbnDelete
            // 
            resources.ApplyResources(this.tbnDelete, "tbnDelete");
            this.tbnDelete.Name = "tbnDelete";
            this.tbnDelete.Click += new System.EventHandler(this.tbnDelete_Click);
            // 
            // tbnEdit
            // 
            resources.ApplyResources(this.tbnEdit, "tbnEdit");
            this.tbnEdit.Name = "tbnEdit";
            this.tbnEdit.Click += new System.EventHandler(this.tbnEdit_Click);
            // 
            // tbnAdd
            // 
            resources.ApplyResources(this.tbnAdd, "tbnAdd");
            this.tbnAdd.Name = "tbnAdd";
            this.tbnAdd.Click += new System.EventHandler(this.tbnAdd_Click);
            // 
            // tolOperation
            // 
            resources.ApplyResources(this.tolOperation, "tolOperation");
            this.tolOperation.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.tbnAdd,
            this.tbnEdit,
            this.tbnDelete,
            this.toolStripSeparator3,
            this.tbnUp,
            this.tbnDown});
            this.tolOperation.LayoutStyle = System.Windows.Forms.ToolStripLayoutStyle.HorizontalStackWithOverflow;
            this.tolOperation.Name = "tolOperation";
            this.tolOperation.ShowItemToolTips = false;
            // 
            // toolStripSeparator3
            // 
            resources.ApplyResources(this.toolStripSeparator3, "toolStripSeparator3");
            this.toolStripSeparator3.Name = "toolStripSeparator3";
            // 
            // tbnUp
            // 
            resources.ApplyResources(this.tbnUp, "tbnUp");
            this.tbnUp.Name = "tbnUp";
            this.tbnUp.Click += new System.EventHandler(this.tbnUp_Click);
            // 
            // tbnDown
            // 
            resources.ApplyResources(this.tbnDown, "tbnDown");
            this.tbnDown.Name = "tbnDown";
            this.tbnDown.Click += new System.EventHandler(this.tbnDown_Click);
            // 
            // FrmChannelVFOs
            // 
            resources.ApplyResources(this, "$this");
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.Controls.Add(this.dgvChannels);
            this.Controls.Add(this.tolOperation);
            this.Name = "FrmChannelVFOs";
            this.ShowIcon = false;
            this.Activated += new System.EventHandler(this.FrmChannelVFOs_Activated);
            this.FormClosed += new System.Windows.Forms.FormClosedEventHandler(this.FrmChannelVFOs_FormClosed);
            this.Load += new System.EventHandler(this.FrmChannelVFOs_Load);
            ((System.ComponentModel.ISupportInitialize)(this.dgvChannels)).EndInit();
            this.tolOperation.ResumeLayout(false);
            this.tolOperation.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

	}
}
