using System;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Windows.Forms;

public class FrmChannelAnalog : Form
{
	private int int_0;

	private GStructChannel gstruct3_0;

	private int int_1;

	private string string_0 = string.Empty;

	private bool bool_0;

	private bool bool_1;

	private IContainer icontainer_0;

	private Label label1;

	private TextBox txtChanName;

	private ComboBox cmbTxPower;

	private TextBox txtTxFreq;

	private Label label9;

	private Label label8;

	private TextBox txtRxFreq;

	private Label label7;

	private ComboBox cmbBandWidth;

	private Label label2;

	private ComboBox cmbFreqStep;

	private Label lblFreqStep;

	private ComboBox cmbRxToneDigit;

	private Label lblRxToneDigit;

	private ComboBox cmbTxToneDigit;

	private Label lblTxToneDigit;

	private ComboBox cmbRxTone;

	private Label lblRxTone;

	private ComboBox cmbTxTone;

	private Label lblTxTone;

	private ComboBox cmbRxToneType;

	private Label label23;

	private ComboBox cmbTxToneType;

	private Label label22;

	private Button btnOK;

	private Button btnCancel;

	private ComboBox cmbFreqReverse;

	private Label label3;

	private ComboBox cmbEncyptFlag;

	private Label lblBandDiffRxTx;

	private ComboBox cmbBusyNoTx;

	private Label label12;

	private ComboBox cmbPTTId;

	private Label label4;

	private CheckBox chkDtmfDecode;

	private ComboBox cmbAMChanFlag;

	private Label label5;

	[SpecialName]
	public GStructChannel getStructChannel()
	{
		return gstruct3_0;
	}

	public FrmChannelAnalog(int int_2, GStructChannel gstruct3_1, int int_3, string string_1, bool bool_2, bool bool_3)
	{
		InitializeComponent();
		int_0 = int_2;
		gstruct3_0 = gstruct3_1;
		int_1 = int_3;
		string_0 = string_1;
		bool_0 = bool_2;
		bool_1 = bool_3;
	}

	private void FrmChannelAnalog_Load(object sender, EventArgs e)
	{
		cmbTxPower.Items.Clear();
		cmbTxPower.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerLow"));
		cmbTxPower.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerMid"));
		cmbTxPower.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PowerHigh"));
		cmbTxToneType.Items.Clear();
		cmbTxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeNone"));
		cmbTxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudio"));
		cmbTxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigit"));
		cmbTxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigitR"));
		cmbRxToneType.Items.Clear();
		cmbRxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeNone"));
		cmbRxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudio"));
		cmbRxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigit"));
		cmbRxToneType.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_ToneTypeAudioDigitR"));
		cmbEncyptFlag.Items.Clear();
		cmbEncyptFlag.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"));
		for (int i = 0; i < 10; i++)
		{
			cmbEncyptFlag.Items.Add((i + 1).ToString());
		}
		cmbFreqReverse.Items.Clear();
		cmbFreqReverse.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"));
		cmbFreqReverse.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_On"));
		cmbBusyNoTx.Items.Clear();
		cmbBusyNoTx.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"));
		cmbBusyNoTx.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_On"));
		cmbAMChanFlag.Items.Clear();
		cmbAMChanFlag.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_Off"));
		cmbAMChanFlag.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_On"));
		cmbPTTId.Items.Clear();
		cmbPTTId.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PTTIDNone"));
		cmbPTTId.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PTTIDBOT"));
		cmbPTTId.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PTTIDEOT"));
		cmbPTTId.Items.Add(GClass0.resourceManager_0.GetString("FrmChannelAnalog_PTTIDBOTH"));
		string[] array = GClass0.string_0;
		foreach (string item in array)
		{
			cmbTxTone.Items.Add(item);
			cmbRxTone.Items.Add(item);
		}
		string[] string_ = GClass0.string_1;
		foreach (string item2 in string_)
		{
			cmbTxToneDigit.Items.Add(item2);
			cmbRxToneDigit.Items.Add(item2);
		}
		if (int_1 == 1)
		{
			cmbFreqStep.Items.Clear();
			cmbFreqStep.Items.Add(string.Empty);
			cmbFreqStep.Items.Add("8.33KHz");
		}
		if (int_1 == 0)
		{
			txtChanName.Text = string_0;
			txtChanName.Enabled = false;
		}
		else if (string.IsNullOrEmpty(gstruct3_0.sChanName))
		{
			txtChanName.Text = "CH-" + (int_0 + 1).ToString("000");
		}
		else
		{
			txtChanName.Text = gstruct3_0.sChanName;
		}
		cmbBandWidth.SelectedIndex = gstruct3_0.iBandWidth;
		txtRxFreq.Text = gstruct3_0.dRxFreq.ToString("F5");
		txtTxFreq.Text = gstruct3_0.dTxFreq.ToString("F5");
		cmbTxPower.SelectedIndex = gstruct3_0.iTxPower;
		cmbRxToneType.SelectedIndex = gstruct3_0.iRxToneType;
		if (cmbRxToneType.SelectedIndex == 1)
		{
			cmbRxTone.SelectedIndex = gstruct3_0.iRxTone;
			lblRxTone.Enabled = true;
			cmbRxTone.Enabled = true;
			lblRxToneDigit.Enabled = false;
			cmbRxToneDigit.Enabled = false;
		}
		else if (cmbRxToneType.SelectedIndex != 2 && cmbRxToneType.SelectedIndex != 3)
		{
			lblRxTone.Enabled = false;
			cmbRxTone.Enabled = false;
			lblRxToneDigit.Enabled = false;
			cmbRxToneDigit.Enabled = false;
		}
		else
		{
			cmbRxToneDigit.SelectedIndex = gstruct3_0.iRxTone;
			lblRxTone.Enabled = false;
			cmbRxTone.Enabled = false;
			lblRxToneDigit.Enabled = true;
			cmbRxToneDigit.Enabled = true;
		}
		cmbTxToneType.SelectedIndex = gstruct3_0.iTxToneType;
		if (cmbTxToneType.SelectedIndex == 1)
		{
			cmbTxTone.SelectedIndex = gstruct3_0.iTxTone;
			lblTxTone.Enabled = true;
			cmbTxTone.Enabled = true;
			lblTxToneDigit.Enabled = false;
			cmbTxToneDigit.Enabled = false;
		}
		else if (cmbTxToneType.SelectedIndex != 2 && cmbTxToneType.SelectedIndex != 3)
		{
			lblTxTone.Enabled = false;
			cmbTxTone.Enabled = false;
			lblTxToneDigit.Enabled = false;
			cmbTxToneDigit.Enabled = false;
		}
		else
		{
			cmbTxToneDigit.SelectedIndex = gstruct3_0.iTxTone;
			lblTxTone.Enabled = false;
			cmbTxTone.Enabled = false;
			lblTxToneDigit.Enabled = true;
			cmbTxToneDigit.Enabled = true;
		}
		cmbFreqReverse.SelectedIndex = gstruct3_0.iFreqReverse;
		if (int_1 == 0)
		{
			cmbFreqStep.SelectedIndex = gstruct3_0.iFreqStep;
		}
		else
		{
			cmbFreqStep.SelectedIndex = ((gstruct3_0.iFreqStep == GClass0.string_2.Length - 1) ? 1 : 0);
		}
		cmbEncyptFlag.SelectedIndex = gstruct3_0.iEncyptFlag;
		cmbBusyNoTx.SelectedIndex = gstruct3_0.iBusyNoTx;
		cmbPTTId.SelectedIndex = gstruct3_0.iPTTId;
		chkDtmfDecode.Checked = gstruct3_0.iDtmfDecode == 1;
		cmbAMChanFlag.SelectedIndex = gstruct3_0.AMChanFlag;
		if (int_1 == 0)
		{
			cmbFreqStep.Enabled = true;
		}
		else if (cmbAMChanFlag.SelectedIndex == 0)
		{
			lblFreqStep.Enabled = false;
			cmbFreqStep.Enabled = false;
		}
		else
		{
			lblFreqStep.Enabled = true;
			cmbFreqStep.Enabled = true;
		}
	}

	private void cmbRxToneType_SelectedIndexChanged(object sender, EventArgs e)
	{
		if (cmbRxToneType.SelectedIndex == 0)
		{
			lblRxTone.Enabled = false;
			cmbRxTone.Enabled = false;
			lblRxToneDigit.Enabled = false;
			cmbRxToneDigit.Enabled = false;
		}
		else if (cmbRxToneType.SelectedIndex == 1)
		{
			lblRxTone.Enabled = true;
			cmbRxTone.Enabled = true;
			lblRxToneDigit.Enabled = false;
			cmbRxToneDigit.Enabled = false;
		}
		else
		{
			lblRxTone.Enabled = false;
			cmbRxTone.Enabled = false;
			lblRxToneDigit.Enabled = true;
			cmbRxToneDigit.Enabled = true;
		}
	}

	private void cmbTxToneType_SelectedIndexChanged(object sender, EventArgs e)
	{
		if (cmbTxToneType.SelectedIndex == 0)
		{
			lblTxTone.Enabled = false;
			cmbTxTone.Enabled = false;
			lblTxToneDigit.Enabled = false;
			cmbTxToneDigit.Enabled = false;
		}
		else if (cmbTxToneType.SelectedIndex == 1)
		{
			lblTxTone.Enabled = true;
			cmbTxTone.Enabled = true;
			lblTxToneDigit.Enabled = false;
			cmbTxToneDigit.Enabled = false;
		}
		else
		{
			lblTxTone.Enabled = false;
			cmbTxTone.Enabled = false;
			lblTxToneDigit.Enabled = true;
			cmbTxToneDigit.Enabled = true;
		}
	}

	private void cmbAMChanFlag_SelectedIndexChanged(object sender, EventArgs e)
	{
		if (int_1 == 1)
		{
			if (cmbAMChanFlag.SelectedIndex == 0)
			{
				cmbFreqStep.SelectedIndex = 0;
				lblFreqStep.Enabled = false;
				cmbFreqStep.Enabled = false;
			}
			else
			{
				lblFreqStep.Enabled = true;
				cmbFreqStep.Enabled = true;
			}
		}
	}

	public bool isValidFreq()
	{
		uint ufreq = 0u;
		uint num3 = 0u;
		int num4 = 0;
		double result = 0.0;
		if (!string.IsNullOrEmpty(txtChanName.Text.Trim()) && GClass9.smethod_6(txtChanName.Text.Trim()))
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_ChanNameRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtChanName.Focus();
			return false;
		}
		if (string.IsNullOrEmpty(txtRxFreq.Text.Trim()))
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtRxFreq.Focus();
			return false;
		}
		if (!double.TryParse(txtRxFreq.Text.Trim(), out result))
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqIsNumber"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtRxFreq.Focus();
			return false;
		}
		ufreq = GClass4.dfreqToUint(result);
		if (!GClass4.isfreqAllow(ufreq, int_1, int_0))
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqRange"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtRxFreq.Focus();
			return false;
		}
		num4 = GClass4.dfreqToNum(result);
		int int_ = 0;
		if (int_1 == 0)
		{
			if (cmbFreqStep.SelectedIndex == GClass0.string_2.Length - 1 && num4 != 1)
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqStepUnmatch"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				txtRxFreq.Focus();
				return false;
			}
			if (cmbFreqStep.SelectedIndex == GClass0.string_2.Length - 1)
			{
				if (ufreq >= 108000000 && ufreq <= 135999900 && (long)(ufreq - 108000000) % (long)GClass0.int_31[GClass0.string_2.Length - 1] != 0L)
				{
					MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					txtRxFreq.Focus();
					return false;
				}
			}
			else if ((long)ufreq % (long)GClass0.int_31[cmbFreqStep.SelectedIndex] != 0L)
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				txtRxFreq.Focus();
				return false;
			}
		}
		else
		{
			if (cmbFreqStep.SelectedIndex == 1 && num4 != 1)
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqStepUnmatch"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				txtRxFreq.Focus();
				return false;
			}
			if (cmbFreqStep.SelectedIndex == 1)
			{
				if (ufreq >= 108000000 && ufreq <= 135999900 && (long)(ufreq - 108000000) % (long)GClass0.int_31[GClass0.string_2.Length - 1] != 0L)
				{
					MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxFreqRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					txtRxFreq.Focus();
					return false;
				}
			}
			else
			{
				uint num5 = (uint)method_3((int)ufreq, out int_);
				if (num5 != ufreq)
				{
					txtRxFreq.Text = ((double)num5 * 1E-06).ToString("F5");
				}
			}
		}
		if (string.IsNullOrEmpty(txtTxFreq.Text.Trim()))
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxFreqIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtTxFreq.Focus();
			return false;
		}
		if (!double.TryParse(txtTxFreq.Text.Trim(), out result))
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxFreqIsNumber"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtTxFreq.Focus();
			return false;
		}
		num3 = GClass4.dfreqToUint(result);
		if (int_1 == 0)
		{
			if (cmbFreqStep.SelectedIndex == GClass0.string_2.Length - 1)
			{
				if (num3 >= 108000000 && num3 <= 135999900 && (long)(num3 - 108000000) % (long)GClass0.int_31[GClass0.string_2.Length - 1] != 0L)
				{
					MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxFreqRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					txtTxFreq.Focus();
					return false;
				}
			}
			else if ((long)num3 % (long)GClass0.int_31[cmbFreqStep.SelectedIndex] != 0L)
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxFreqRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				txtTxFreq.Focus();
				return false;
			}
		}
		else if (cmbFreqStep.SelectedIndex == 1)
		{
			if (num3 >= 108000000 && num3 <= 135999900 && (long)(num3 - 108000000) % (long)GClass0.int_31[GClass0.string_2.Length - 1] != 0L)
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxFreqRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				txtTxFreq.Focus();
				return false;
			}
		}
		else
		{
			uint num6 = (uint)method_2((int)num3, int_, GClass4.freqToRangeBegin(num3));
			if (num6 != num3)
			{
				txtTxFreq.Text = ((double)num6 * 1E-06).ToString("F5");
			}
		}
		if (num4 == 1 && num3 != ufreq)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxFreqRegular2"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			txtTxFreq.Focus();
			return false;
		}
		if (cmbRxToneType.SelectedIndex == 1 && cmbRxTone.SelectedIndex == -1)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxCTCSSIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbRxTone.Focus();
			return false;
		}
		if (cmbRxToneType.SelectedIndex == 2 && cmbRxToneDigit.SelectedIndex == -1)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxDCSIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbRxToneDigit.Focus();
			return false;
		}
		if (cmbRxToneType.SelectedIndex == 3 && cmbRxToneDigit.SelectedIndex == -1)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_RxDCSReverseIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbRxToneDigit.Focus();
			return false;
		}
		if (cmbTxToneType.SelectedIndex == 1 && cmbTxTone.SelectedIndex == -1)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxCTCSSIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbTxTone.Focus();
			return false;
		}
		if (cmbTxToneType.SelectedIndex == 2 && cmbTxToneDigit.SelectedIndex == -1)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxDCSIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbTxToneDigit.Focus();
			return false;
		}
		if (cmbTxToneType.SelectedIndex == 3 && cmbTxToneDigit.SelectedIndex == -1)
		{
			MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmChannelAnalog_TxDCSReverseIsNotNull"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			cmbTxToneDigit.Focus();
			return false;
		}
		return true;
	}

	private void btnOK_Click(object sender, EventArgs e)
	{
		if (!isValidFreq())
		{
			return;
		}
		gstruct3_0.sChanName = txtChanName.Text.Trim();
		gstruct3_0.dRxFreq = double.Parse(txtRxFreq.Text.Trim());
		gstruct3_0.dTxFreq = double.Parse(txtTxFreq.Text.Trim());
		gstruct3_0.iTxPower = cmbTxPower.SelectedIndex;
		gstruct3_0.iRxToneType = cmbRxToneType.SelectedIndex;
		if (cmbRxToneType.SelectedIndex == 1)
		{
			gstruct3_0.iRxTone = cmbRxTone.SelectedIndex;
		}
		else if (cmbRxToneType.SelectedIndex != 2 && cmbRxToneType.SelectedIndex != 3)
		{
			gstruct3_0.iRxTone = 0;
		}
		else
		{
			gstruct3_0.iRxTone = cmbRxToneDigit.SelectedIndex;
		}
		gstruct3_0.iTxToneType = cmbTxToneType.SelectedIndex;
		if (cmbTxToneType.SelectedIndex == 1)
		{
			gstruct3_0.iTxTone = cmbTxTone.SelectedIndex;
		}
		else if (cmbTxToneType.SelectedIndex != 2 && cmbTxToneType.SelectedIndex != 3)
		{
			gstruct3_0.iTxTone = 0;
		}
		else
		{
			gstruct3_0.iTxTone = cmbTxToneDigit.SelectedIndex;
		}
		gstruct3_0.iBandWidth = cmbBandWidth.SelectedIndex;
		gstruct3_0.iFreqReverse = cmbFreqReverse.SelectedIndex;
		if (int_1 == 0)
		{
			gstruct3_0.iFreqStep = cmbFreqStep.SelectedIndex;
		}
		else if (cmbFreqStep.SelectedIndex == 1)
		{
			gstruct3_0.iFreqStep = GClass0.string_2.Length - 1;
		}
		else
		{
			uint num = GClass4.dfreqToUint(gstruct3_0.dRxFreq);
			if (num % 6250u == 0)
			{
				gstruct3_0.iFreqStep = 2;
			}
			else
			{
				gstruct3_0.iFreqStep = 0;
			}
		}
		gstruct3_0.iEncyptFlag = cmbEncyptFlag.SelectedIndex;
		gstruct3_0.iBusyNoTx = cmbBusyNoTx.SelectedIndex;
		gstruct3_0.iPTTId = cmbPTTId.SelectedIndex;
		gstruct3_0.iDtmfDecode = (chkDtmfDecode.Checked ? 1 : 0);
		gstruct3_0.AMChanFlag = cmbAMChanFlag.SelectedIndex;
		gstruct3_0.isChanlValid = true;
		base.DialogResult = DialogResult.OK;
	}

	private void btnCancel_Click(object sender, EventArgs e)
	{
		Close();
	}

	private int method_2(int int_2, int int_3, int int_4)
	{
		int num = 0;
		num = int_2 - int_4;
		return num / int_3 * int_3 + int_4;
	}

	private int method_3(int int_2, out int int_3)
	{
		if (int_2 % 6250 == 0)
		{
			int_3 = 6250;
			return int_2;
		}
		if (int_2 % 2500 == 0)
		{
			int_3 = 2500;
			return int_2;
		}
		int_3 = 2500;
		return method_2(int_2, 2500, GClass4.freqToRangeBegin((uint)int_2));
	}

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
		System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmChannelAnalog));
		this.label1 = new System.Windows.Forms.Label();
		this.txtChanName = new System.Windows.Forms.TextBox();
		this.cmbTxPower = new System.Windows.Forms.ComboBox();
		this.txtTxFreq = new System.Windows.Forms.TextBox();
		this.label9 = new System.Windows.Forms.Label();
		this.label8 = new System.Windows.Forms.Label();
		this.txtRxFreq = new System.Windows.Forms.TextBox();
		this.label7 = new System.Windows.Forms.Label();
		this.cmbBandWidth = new System.Windows.Forms.ComboBox();
		this.label2 = new System.Windows.Forms.Label();
		this.cmbFreqStep = new System.Windows.Forms.ComboBox();
		this.lblFreqStep = new System.Windows.Forms.Label();
		this.cmbRxToneDigit = new System.Windows.Forms.ComboBox();
		this.lblRxToneDigit = new System.Windows.Forms.Label();
		this.cmbTxToneDigit = new System.Windows.Forms.ComboBox();
		this.lblTxToneDigit = new System.Windows.Forms.Label();
		this.cmbRxTone = new System.Windows.Forms.ComboBox();
		this.lblRxTone = new System.Windows.Forms.Label();
		this.cmbTxTone = new System.Windows.Forms.ComboBox();
		this.lblTxTone = new System.Windows.Forms.Label();
		this.cmbRxToneType = new System.Windows.Forms.ComboBox();
		this.label23 = new System.Windows.Forms.Label();
		this.cmbTxToneType = new System.Windows.Forms.ComboBox();
		this.label22 = new System.Windows.Forms.Label();
		this.btnOK = new System.Windows.Forms.Button();
		this.btnCancel = new System.Windows.Forms.Button();
		this.cmbFreqReverse = new System.Windows.Forms.ComboBox();
		this.label3 = new System.Windows.Forms.Label();
		this.cmbEncyptFlag = new System.Windows.Forms.ComboBox();
		this.lblBandDiffRxTx = new System.Windows.Forms.Label();
		this.cmbBusyNoTx = new System.Windows.Forms.ComboBox();
		this.label12 = new System.Windows.Forms.Label();
		this.cmbPTTId = new System.Windows.Forms.ComboBox();
		this.label4 = new System.Windows.Forms.Label();
		this.chkDtmfDecode = new System.Windows.Forms.CheckBox();
		this.cmbAMChanFlag = new System.Windows.Forms.ComboBox();
		this.label5 = new System.Windows.Forms.Label();
		base.SuspendLayout();
		resources.ApplyResources(this.label1, "label1");
		this.label1.Name = "label1";
		resources.ApplyResources(this.txtChanName, "txtChanName");
		this.txtChanName.Name = "txtChanName";
		resources.ApplyResources(this.cmbTxPower, "cmbTxPower");
		this.cmbTxPower.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbTxPower.FormattingEnabled = true;
		this.cmbTxPower.Items.AddRange(new object[3]
		{
			resources.GetString("cmbTxPower.Items"),
			resources.GetString("cmbTxPower.Items1"),
			resources.GetString("cmbTxPower.Items2")
		});
		this.cmbTxPower.Name = "cmbTxPower";
		resources.ApplyResources(this.txtTxFreq, "txtTxFreq");
		this.txtTxFreq.Name = "txtTxFreq";
		resources.ApplyResources(this.label9, "label9");
		this.label9.Name = "label9";
		resources.ApplyResources(this.label8, "label8");
		this.label8.Name = "label8";
		resources.ApplyResources(this.txtRxFreq, "txtRxFreq");
		this.txtRxFreq.Name = "txtRxFreq";
		resources.ApplyResources(this.label7, "label7");
		this.label7.Name = "label7";
		resources.ApplyResources(this.cmbBandWidth, "cmbBandWidth");
		this.cmbBandWidth.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbBandWidth.FormattingEnabled = true;
		this.cmbBandWidth.Items.AddRange(new object[2]
		{
			resources.GetString("cmbBandWidth.Items"),
			resources.GetString("cmbBandWidth.Items1")
		});
		this.cmbBandWidth.Name = "cmbBandWidth";
		resources.ApplyResources(this.label2, "label2");
		this.label2.Name = "label2";
		resources.ApplyResources(this.cmbFreqStep, "cmbFreqStep");
		this.cmbFreqStep.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbFreqStep.FormattingEnabled = true;
		this.cmbFreqStep.Items.AddRange(new object[7]
		{
			resources.GetString("cmbFreqStep.Items"),
			resources.GetString("cmbFreqStep.Items1"),
			resources.GetString("cmbFreqStep.Items2"),
			resources.GetString("cmbFreqStep.Items3"),
			resources.GetString("cmbFreqStep.Items4"),
			resources.GetString("cmbFreqStep.Items5"),
			resources.GetString("cmbFreqStep.Items6")
		});
		this.cmbFreqStep.Name = "cmbFreqStep";
		resources.ApplyResources(this.lblFreqStep, "lblFreqStep");
		this.lblFreqStep.Name = "lblFreqStep";
		resources.ApplyResources(this.cmbRxToneDigit, "cmbRxToneDigit");
		this.cmbRxToneDigit.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbRxToneDigit.FormattingEnabled = true;
		this.cmbRxToneDigit.Name = "cmbRxToneDigit";
		resources.ApplyResources(this.lblRxToneDigit, "lblRxToneDigit");
		this.lblRxToneDigit.Name = "lblRxToneDigit";
		resources.ApplyResources(this.cmbTxToneDigit, "cmbTxToneDigit");
		this.cmbTxToneDigit.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbTxToneDigit.FormattingEnabled = true;
		this.cmbTxToneDigit.Name = "cmbTxToneDigit";
		resources.ApplyResources(this.lblTxToneDigit, "lblTxToneDigit");
		this.lblTxToneDigit.Name = "lblTxToneDigit";
		resources.ApplyResources(this.cmbRxTone, "cmbRxTone");
		this.cmbRxTone.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbRxTone.FormattingEnabled = true;
		this.cmbRxTone.Name = "cmbRxTone";
		resources.ApplyResources(this.lblRxTone, "lblRxTone");
		this.lblRxTone.Name = "lblRxTone";
		resources.ApplyResources(this.cmbTxTone, "cmbTxTone");
		this.cmbTxTone.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbTxTone.FormattingEnabled = true;
		this.cmbTxTone.Name = "cmbTxTone";
		resources.ApplyResources(this.lblTxTone, "lblTxTone");
		this.lblTxTone.Name = "lblTxTone";
		resources.ApplyResources(this.cmbRxToneType, "cmbRxToneType");
		this.cmbRxToneType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbRxToneType.FormattingEnabled = true;
		this.cmbRxToneType.Items.AddRange(new object[4]
		{
			resources.GetString("cmbRxToneType.Items"),
			resources.GetString("cmbRxToneType.Items1"),
			resources.GetString("cmbRxToneType.Items2"),
			resources.GetString("cmbRxToneType.Items3")
		});
		this.cmbRxToneType.Name = "cmbRxToneType";
		this.cmbRxToneType.SelectedIndexChanged += new System.EventHandler(cmbRxToneType_SelectedIndexChanged);
		resources.ApplyResources(this.label23, "label23");
		this.label23.Name = "label23";
		resources.ApplyResources(this.cmbTxToneType, "cmbTxToneType");
		this.cmbTxToneType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbTxToneType.FormattingEnabled = true;
		this.cmbTxToneType.Items.AddRange(new object[4]
		{
			resources.GetString("cmbTxToneType.Items"),
			resources.GetString("cmbTxToneType.Items1"),
			resources.GetString("cmbTxToneType.Items2"),
			resources.GetString("cmbTxToneType.Items3")
		});
		this.cmbTxToneType.Name = "cmbTxToneType";
		this.cmbTxToneType.SelectedIndexChanged += new System.EventHandler(cmbTxToneType_SelectedIndexChanged);
		resources.ApplyResources(this.label22, "label22");
		this.label22.Name = "label22";
		resources.ApplyResources(this.btnOK, "btnOK");
		this.btnOK.Name = "btnOK";
		this.btnOK.UseVisualStyleBackColor = true;
		this.btnOK.Click += new System.EventHandler(btnOK_Click);
		resources.ApplyResources(this.btnCancel, "btnCancel");
		this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
		this.btnCancel.Name = "btnCancel";
		this.btnCancel.UseVisualStyleBackColor = true;
		this.btnCancel.Click += new System.EventHandler(btnCancel_Click);
		resources.ApplyResources(this.cmbFreqReverse, "cmbFreqReverse");
		this.cmbFreqReverse.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbFreqReverse.FormattingEnabled = true;
		this.cmbFreqReverse.Items.AddRange(new object[2]
		{
			resources.GetString("cmbFreqReverse.Items"),
			resources.GetString("cmbFreqReverse.Items1")
		});
		this.cmbFreqReverse.Name = "cmbFreqReverse";
		resources.ApplyResources(this.label3, "label3");
		this.label3.Name = "label3";
		resources.ApplyResources(this.cmbEncyptFlag, "cmbEncyptFlag");
		this.cmbEncyptFlag.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbEncyptFlag.FormattingEnabled = true;
		this.cmbEncyptFlag.Items.AddRange(new object[11]
		{
			resources.GetString("cmbEncyptFlag.Items"),
			resources.GetString("cmbEncyptFlag.Items1"),
			resources.GetString("cmbEncyptFlag.Items2"),
			resources.GetString("cmbEncyptFlag.Items3"),
			resources.GetString("cmbEncyptFlag.Items4"),
			resources.GetString("cmbEncyptFlag.Items5"),
			resources.GetString("cmbEncyptFlag.Items6"),
			resources.GetString("cmbEncyptFlag.Items7"),
			resources.GetString("cmbEncyptFlag.Items8"),
			resources.GetString("cmbEncyptFlag.Items9"),
			resources.GetString("cmbEncyptFlag.Items10")
		});
		this.cmbEncyptFlag.Name = "cmbEncyptFlag";
		resources.ApplyResources(this.lblBandDiffRxTx, "lblBandDiffRxTx");
		this.lblBandDiffRxTx.Name = "lblBandDiffRxTx";
		resources.ApplyResources(this.cmbBusyNoTx, "cmbBusyNoTx");
		this.cmbBusyNoTx.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbBusyNoTx.FormattingEnabled = true;
		this.cmbBusyNoTx.Items.AddRange(new object[2]
		{
			resources.GetString("cmbBusyNoTx.Items"),
			resources.GetString("cmbBusyNoTx.Items1")
		});
		this.cmbBusyNoTx.Name = "cmbBusyNoTx";
		resources.ApplyResources(this.label12, "label12");
		this.label12.Name = "label12";
		resources.ApplyResources(this.cmbPTTId, "cmbPTTId");
		this.cmbPTTId.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbPTTId.FormattingEnabled = true;
		this.cmbPTTId.Items.AddRange(new object[4]
		{
			resources.GetString("cmbPTTId.Items"),
			resources.GetString("cmbPTTId.Items1"),
			resources.GetString("cmbPTTId.Items2"),
			resources.GetString("cmbPTTId.Items3")
		});
		this.cmbPTTId.Name = "cmbPTTId";
		resources.ApplyResources(this.label4, "label4");
		this.label4.Name = "label4";
		resources.ApplyResources(this.chkDtmfDecode, "chkDtmfDecode");
		this.chkDtmfDecode.Name = "chkDtmfDecode";
		this.chkDtmfDecode.UseVisualStyleBackColor = true;
		resources.ApplyResources(this.cmbAMChanFlag, "cmbAMChanFlag");
		this.cmbAMChanFlag.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
		this.cmbAMChanFlag.FormattingEnabled = true;
		this.cmbAMChanFlag.Items.AddRange(new object[2]
		{
			resources.GetString("cmbAMChanFlag.Items"),
			resources.GetString("cmbAMChanFlag.Items1")
		});
		this.cmbAMChanFlag.Name = "cmbAMChanFlag";
		this.cmbAMChanFlag.SelectedIndexChanged += new System.EventHandler(cmbAMChanFlag_SelectedIndexChanged);
		resources.ApplyResources(this.label5, "label5");
		this.label5.Name = "label5";
		base.AcceptButton = this.btnOK;
		resources.ApplyResources(this, "$this");
		base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		base.CancelButton = this.btnCancel;
		base.Controls.Add(this.cmbAMChanFlag);
		base.Controls.Add(this.label5);
		base.Controls.Add(this.cmbPTTId);
		base.Controls.Add(this.label4);
		base.Controls.Add(this.chkDtmfDecode);
		base.Controls.Add(this.cmbBusyNoTx);
		base.Controls.Add(this.label12);
		base.Controls.Add(this.cmbEncyptFlag);
		base.Controls.Add(this.lblBandDiffRxTx);
		base.Controls.Add(this.cmbFreqReverse);
		base.Controls.Add(this.label3);
		base.Controls.Add(this.btnCancel);
		base.Controls.Add(this.btnOK);
		base.Controls.Add(this.label1);
		base.Controls.Add(this.txtChanName);
		base.Controls.Add(this.cmbTxPower);
		base.Controls.Add(this.txtTxFreq);
		base.Controls.Add(this.label9);
		base.Controls.Add(this.label8);
		base.Controls.Add(this.txtRxFreq);
		base.Controls.Add(this.label7);
		base.Controls.Add(this.cmbBandWidth);
		base.Controls.Add(this.label2);
		base.Controls.Add(this.cmbFreqStep);
		base.Controls.Add(this.lblFreqStep);
		base.Controls.Add(this.cmbRxToneDigit);
		base.Controls.Add(this.lblRxToneDigit);
		base.Controls.Add(this.cmbTxToneDigit);
		base.Controls.Add(this.lblTxToneDigit);
		base.Controls.Add(this.cmbRxTone);
		base.Controls.Add(this.lblRxTone);
		base.Controls.Add(this.cmbTxTone);
		base.Controls.Add(this.lblTxTone);
		base.Controls.Add(this.cmbRxToneType);
		base.Controls.Add(this.label23);
		base.Controls.Add(this.cmbTxToneType);
		base.Controls.Add(this.label22);
		base.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
		base.MaximizeBox = false;
		base.MinimizeBox = false;
		base.Name = "FrmChannelAnalog";
		base.ShowIcon = false;
		base.Load += new System.EventHandler(FrmChannelAnalog_Load);
		base.ResumeLayout(false);
		base.PerformLayout();
	}
}
