using System;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;

public class FrmConnectionCOM : Form
{
	private IContainer icontainer_0;

	private Button btnConn;

	private ComboBox cmbCOM;

	private Label label36;

	private Button btnCancel;

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
		System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmConnectionCOM));
		this.btnConn = new System.Windows.Forms.Button();
		this.cmbCOM = new System.Windows.Forms.ComboBox();
		this.label36 = new System.Windows.Forms.Label();
		this.btnCancel = new System.Windows.Forms.Button();
		base.SuspendLayout();
		resources.ApplyResources(this.btnConn, "btnConn");
		this.btnConn.Name = "btnConn";
		this.btnConn.UseVisualStyleBackColor = true;
		this.btnConn.Click += new System.EventHandler(btnConn_Click);
		resources.ApplyResources(this.cmbCOM, "cmbCOM");
		this.cmbCOM.FormattingEnabled = true;
		this.cmbCOM.Name = "cmbCOM";
		resources.ApplyResources(this.label36, "label36");
		this.label36.Name = "label36";
		resources.ApplyResources(this.btnCancel, "btnCancel");
		this.btnCancel.Name = "btnCancel";
		this.btnCancel.UseVisualStyleBackColor = true;
		this.btnCancel.Click += new System.EventHandler(btnCancel_Click);
		resources.ApplyResources(this, "$this");
		base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		base.Controls.Add(this.btnCancel);
		base.Controls.Add(this.btnConn);
		base.Controls.Add(this.cmbCOM);
		base.Controls.Add(this.label36);
		base.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
		base.MaximizeBox = false;
		base.MinimizeBox = false;
		base.Name = "FrmConnectionCOM";
		base.ShowIcon = false;
		base.Load += new System.EventHandler(FrmConnectionCOM_Load);
		base.ResumeLayout(false);
		base.PerformLayout();
	}

	public FrmConnectionCOM()
	{
		InitializeComponent();
	}

	private void FrmConnectionCOM_Load(object sender, EventArgs e)
	{
		method_0();
		if (GClass0.isSerialPortConnected == 0)
		{
			if (!string.IsNullOrEmpty(GClass0.sSerialPort) && GClass0.sSerialPort.Substring(0, 3).Equals("COM"))
			{
				cmbCOM.Text = GClass0.sSerialPort;
			}
			btnConn.Text = GClass0.resourceManager_0.GetString("FrmConnectionCOM_Connet");
		}
		else if (GClass0.isSerialPortConnected == 1)
		{
			cmbCOM.Text = GClass0.sSerialPort;
			btnConn.Text = GClass0.resourceManager_0.GetString("FrmConnectionCOM_Disconnet");
		}
	}

	private void btnConn_Click(object sender, EventArgs e)
	{
		try
		{
			if (btnConn.Text.Equals(GClass0.resourceManager_0.GetString("FrmConnectionCOM_Connet")))
			{
				if (!string.IsNullOrEmpty(cmbCOM.Text.Trim()))
				{
					GClass10.smethod_0().serialPort_0.PortName = cmbCOM.Text.Trim().ToUpper();
					if (GClass10.smethod_0().serialPort_0.IsOpen)
					{
						MessageBox.Show(cmbCOM.Text.Trim().ToUpper() + GClass0.resourceManager_0.GetString("FrmConnectionCOM_IsOpen"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
						return;
					}
					GClass10.smethod_0().serialPort_0.Open();
					GClass0.isSerialPortConnected = 1;
					GClass5.smethod_0("SerialPort", cmbCOM.Text.Trim());
					GClass0.sSerialPort = cmbCOM.Text.Trim();
					btnConn.Text = GClass0.resourceManager_0.GetString("FrmConnectionCOM_Disconnet");
					Close();
				}
			}
			else
			{
				if (GClass10.smethod_0().serialPort_0.IsOpen)
				{
					GClass10.smethod_0().serialPort_0.Close();
				}
				GClass0.isSerialPortConnected = 0;
				GClass0.uint_0 = 0u;
				btnConn.Text = GClass0.resourceManager_0.GetString("FrmConnectionCOM_Connet");
			}
		}
		catch (Exception ex)
		{
			MessageBox.Show(GClass0.resourceManager_0.GetString("FrmMain_ErrInfo") + ex.Message, GClass0.resourceManager_0.GetString("DialogTitle_Error"), MessageBoxButtons.OK, MessageBoxIcon.Hand);
		}
	}

	private bool method_0()
	{
		cmbCOM.Items.Clear();
		try
		{
			RegistryKey registryKey = Registry.LocalMachine.OpenSubKey("Hardware\\DeviceMap\\SerialComm");
			string[] valueNames = registryKey.GetValueNames();
			for (int i = 0; i < valueNames.Length; i++)
			{
				cmbCOM.Items.Add((string)registryKey.GetValue(valueNames[i]));
			}
		}
		catch (Exception)
		{
			return false;
		}
		return true;
	}

	private void btnCancel_Click(object sender, EventArgs e)
	{
		Close();
	}
}
