using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Windows.Forms;

public class FrmScanLists : Form
{
	private int int_0;

	private Dictionary<int, string> dictionary_0;

	private static FrmScanLists frmScanLists_0;

	private IContainer icontainer_0;

	private DataGridView dgvChannels;

	private ToolStripSeparator toolStripSeparator3;

	private ToolStrip tolOperation;

	private ToolStripButton tbnAdd;

	private ToolStripButton tbnEdit;

	private ToolStripButton tbnDelete;

	private ToolStripButton tbnUp;

	private ToolStripButton tbnDown;

	private ToolStripButton tbnDefault;

	private DataGridViewTextBoxColumn clnNo;

	private DataGridViewTextBoxColumn clnChanName;

	private DataGridViewTextBoxColumn clnPriChannelScanEnable;

	private DataGridViewTextBoxColumn clnPriChannelIndex1;

	private DataGridViewTextBoxColumn clnPriChannel1;

	private DataGridViewTextBoxColumn clnPriChannelIndex2;

	private DataGridViewTextBoxColumn clnPriChannel2;

	private DataGridViewTextBoxColumn clnLists;

	private DataGridViewTextBoxColumn clnDefaultList;

	private DataGridViewTextBoxColumn clnListKey;

	[SpecialName]
	public int method_0()
	{
		return int_0;
	}

	[SpecialName]
	public void method_1(int int_1)
	{
		int_0 = int_1;
	}

	[SpecialName]
	public static FrmScanLists smethod_0()
	{
		if (frmScanLists_0 == null || frmScanLists_0.IsDisposed)
		{
			frmScanLists_0 = new FrmScanLists();
			frmScanLists_0.WindowState = FormWindowState.Normal;
		}
		return frmScanLists_0;
	}

	public static bool smethod_1()
	{
		if (frmScanLists_0 != null && !frmScanLists_0.IsDisposed)
		{
			return true;
		}
		return false;
	}

	private FrmScanLists()
	{
		InitializeComponent();
	}

	private void FrmScanLists_Load(object sender, EventArgs e)
	{
		int num2 = 0;
		dgvChannels.Rows.Add(2);
		foreach (DataGridViewRow item in (IEnumerable)dgvChannels.Rows)
		{
			item.Cells[0].Value = num2 + 1;
			item.Cells[1].Value = method_7(num2);
			item.Cells[2].Value = null;
			item.Cells[3].Value = null;
			item.Cells[4].Value = null;
			item.Cells[5].Value = null;
			item.Cells[6].Value = null;
			item.Cells[7].Value = null;
			item.Cells[8].Value = null;
			item.Cells["clnListKey"].Value = num2;
			num2++;
		}
	}

	public void method_2(List<GStructScan> list_0)
	{
		dgvChannels.Rows.Clear();
		dgvChannels.Rows.Add(2);
		try
		{
			int num = 0;
			foreach (GStructScan item in list_0)
			{
				method_5(num, item);
				num++;
			}
		}
		catch (Exception)
		{
		}
	}

	private void FrmScanLists_FormClosed(object sender, FormClosedEventArgs e)
	{
		List<GStructScan> list = new List<GStructScan>();
		for (int i = 0; i < 2; i++)
		{
			if (dgvChannels.Rows[i].Cells[2].Value != null)
			{
				list.Add(method_4(i));
			}
			else
			{
				list.Add(GClass4.smethod_15(i));
			}
		}
		FrmMain frmMain = (FrmMain)base.MdiParent;
		if (frmMain != null)
		{
			frmMain.setScanList(list, int_0);
		}
	}

	private void FrmScanLists_Activated(object sender, EventArgs e)
	{
		FrmMain frmMain = (FrmMain)base.MdiParent;
		dictionary_0 = frmMain.method_41();
	}

	private void tbnAdd_Click(object sender, EventArgs e)
	{
	}

	private void tbnEdit_Click(object sender, EventArgs e)
	{
		method_3();
	}

	private void tbnDelete_Click(object sender, EventArgs e)
	{
	}

	private void tbnUp_Click(object sender, EventArgs e)
	{
	}

	private void tbnDown_Click(object sender, EventArgs e)
	{
	}

	private void tbnDefault_Click(object sender, EventArgs e)
	{
		int index = dgvChannels.CurrentRow.Index;
		if (index < 0 || index >= dgvChannels.RowCount || dgvChannels.Rows[index].Cells[2].Value == null)
		{
			return;
		}
		int_0 = index;
		for (int i = 0; i < dgvChannels.Rows.Count; i++)
		{
			if (i == index)
			{
				dgvChannels.Rows[i].Cells["clnDefaultList"].Value = GClass0.resourceManager_0.GetString("FrmScanLists_Yes");
			}
			else
			{
				dgvChannels.Rows[i].Cells["clnDefaultList"].Value = GClass0.resourceManager_0.GetString("FrmScanLists_No");
			}
		}
	}

	private void dgvChannels_CellMouseDoubleClick(object sender, DataGridViewCellMouseEventArgs e)
	{
		method_3();
	}

	private void method_3()
	{
		int index = dgvChannels.CurrentRow.Index;
		if (index >= 0 && index < dgvChannels.RowCount)
		{
			int num2 = 0;
			GStructScan gstruct7_;
			if (dgvChannels.Rows[index].Cells[2].Value != null)
			{
				num2 = int.Parse(dgvChannels.Rows[index].Cells["clnListKey"].Value.ToString());
				gstruct7_ = method_4(index);
			}
			else
			{
				num2 = index;
				gstruct7_ = GClass4.smethod_15(index);
			}
			FrmScanList frmScanList = new FrmScanList(num2, gstruct7_, method_7(index), dictionary_0);
			if (frmScanList.ShowDialog() == DialogResult.OK)
			{
				method_5(index, frmScanList.method_0());
			}
		}
	}

	public GStructScan method_4(int int_1)
	{
		DataGridViewRow dataGridViewRow = dgvChannels.Rows[int_1];
		GStructScan result = default(GStructScan);
		result.string_0 = dataGridViewRow.Cells[1].Value.ToString();
		result.bool_0 = (dataGridViewRow.Cells[2].Value.ToString().Equals(GClass0.resourceManager_0.GetString("FrmScanLists_Yes")) ? true : false);
		if (result.bool_0)
		{
			result.int_0 = int.Parse(dataGridViewRow.Cells[3].Value.ToString());
			result.int_1 = int.Parse(dataGridViewRow.Cells[5].Value.ToString());
		}
		else
		{
			result.int_0 = -1;
			result.int_1 = -1;
		}
		result.list_0 = GClass4.smethod_42(dataGridViewRow.Cells[7].Value.ToString());
		return result;
	}

	public bool method_5(int int_1, GStructScan gstruct7_0)
	{
		DataGridViewRow dataGridViewRow = dgvChannels.Rows[int_1];
		dataGridViewRow.Cells[0].Value = int_1 + 1;
		if (gstruct7_0.list_0 != null && gstruct7_0.list_0.Count > 0)
		{
			dataGridViewRow.Cells[1].Value = method_7(int_1);
			dataGridViewRow.Cells[2].Value = (gstruct7_0.bool_0 ? GClass0.resourceManager_0.GetString("FrmScanLists_Yes") : GClass0.resourceManager_0.GetString("FrmScanLists_No"));
			if (gstruct7_0.bool_0)
			{
				dataGridViewRow.Cells[3].Value = gstruct7_0.int_0;
				if (dictionary_0.Keys.Contains(gstruct7_0.int_0))
				{
					dataGridViewRow.Cells[4].Value = dictionary_0[gstruct7_0.int_0];
				}
				else
				{
					dataGridViewRow.Cells[4].Value = null;
				}
				dataGridViewRow.Cells[5].Value = gstruct7_0.int_1;
				if (dictionary_0.Keys.Contains(gstruct7_0.int_1))
				{
					dataGridViewRow.Cells[6].Value = dictionary_0[gstruct7_0.int_1];
				}
				else
				{
					dataGridViewRow.Cells[6].Value = null;
				}
			}
			else
			{
				dataGridViewRow.Cells[3].Value = -1;
				dataGridViewRow.Cells[4].Value = null;
				dataGridViewRow.Cells[5].Value = -1;
				dataGridViewRow.Cells[6].Value = null;
			}
			dataGridViewRow.Cells[7].Value = GClass4.smethod_41(gstruct7_0.list_0);
			dataGridViewRow.Cells[8].Value = ((int_1 == int_0) ? GClass0.resourceManager_0.GetString("FrmScanLists_Yes") : GClass0.resourceManager_0.GetString("FrmScanLists_No"));
		}
		else
		{
			dataGridViewRow.Cells[1].Value = method_7(int_1);
			dataGridViewRow.Cells[2].Value = null;
			dataGridViewRow.Cells[3].Value = null;
			dataGridViewRow.Cells[4].Value = null;
			dataGridViewRow.Cells[5].Value = null;
			dataGridViewRow.Cells[6].Value = null;
			dataGridViewRow.Cells[7].Value = null;
			dataGridViewRow.Cells[8].Value = null;
		}
		dataGridViewRow.Cells["clnListKey"].Value = int_1;
		return true;
	}

	public void method_6()
	{
		FrmMain frmMain = (FrmMain)base.MdiParent;
		dictionary_0 = frmMain.method_41();
	}

	private string method_7(int int_1)
	{
		return GClass0.resourceManager_0.GetString("FrmScanLists_ListName") + (int_1 + 1);
	}

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
		System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmScanLists));
		System.Windows.Forms.DataGridViewCellStyle dataGridViewCellStyle = new System.Windows.Forms.DataGridViewCellStyle();
		this.dgvChannels = new System.Windows.Forms.DataGridView();
		this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
		this.tolOperation = new System.Windows.Forms.ToolStrip();
		this.tbnAdd = new System.Windows.Forms.ToolStripButton();
		this.tbnEdit = new System.Windows.Forms.ToolStripButton();
		this.tbnDelete = new System.Windows.Forms.ToolStripButton();
		this.tbnUp = new System.Windows.Forms.ToolStripButton();
		this.tbnDown = new System.Windows.Forms.ToolStripButton();
		this.tbnDefault = new System.Windows.Forms.ToolStripButton();
		this.clnNo = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnChanName = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnPriChannelScanEnable = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnPriChannelIndex1 = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnPriChannel1 = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnPriChannelIndex2 = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnPriChannel2 = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnLists = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnDefaultList = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnListKey = new System.Windows.Forms.DataGridViewTextBoxColumn();
		((System.ComponentModel.ISupportInitialize)this.dgvChannels).BeginInit();
		this.tolOperation.SuspendLayout();
		base.SuspendLayout();
		resources.ApplyResources(this.dgvChannels, "dgvChannels");
		this.dgvChannels.AllowUserToAddRows = false;
		this.dgvChannels.AllowUserToDeleteRows = false;
		this.dgvChannels.AllowUserToResizeColumns = false;
		this.dgvChannels.AllowUserToResizeRows = false;
		dataGridViewCellStyle.BackColor = System.Drawing.Color.Bisque;
		this.dgvChannels.AlternatingRowsDefaultCellStyle = dataGridViewCellStyle;
		this.dgvChannels.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
		this.dgvChannels.Columns.AddRange(this.clnNo, this.clnChanName, this.clnPriChannelScanEnable, this.clnPriChannelIndex1, this.clnPriChannel1, this.clnPriChannelIndex2, this.clnPriChannel2, this.clnLists, this.clnDefaultList, this.clnListKey);
		this.dgvChannels.MultiSelect = false;
		this.dgvChannels.Name = "dgvChannels";
		this.dgvChannels.ReadOnly = true;
		this.dgvChannels.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.DisableResizing;
		this.dgvChannels.RowTemplate.Height = 23;
		this.dgvChannels.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
		this.dgvChannels.CellMouseDoubleClick += new System.Windows.Forms.DataGridViewCellMouseEventHandler(dgvChannels_CellMouseDoubleClick);
		resources.ApplyResources(this.toolStripSeparator3, "toolStripSeparator3");
		this.toolStripSeparator3.Name = "toolStripSeparator3";
		resources.ApplyResources(this.tolOperation, "tolOperation");
		this.tolOperation.Items.AddRange(new System.Windows.Forms.ToolStripItem[7] { this.tbnAdd, this.tbnEdit, this.tbnDelete, this.toolStripSeparator3, this.tbnUp, this.tbnDown, this.tbnDefault });
		this.tolOperation.LayoutStyle = System.Windows.Forms.ToolStripLayoutStyle.HorizontalStackWithOverflow;
		this.tolOperation.Name = "tolOperation";
		this.tolOperation.ShowItemToolTips = false;
		resources.ApplyResources(this.tbnAdd, "tbnAdd");
		this.tbnAdd.Name = "tbnAdd";
		this.tbnAdd.Click += new System.EventHandler(tbnAdd_Click);
		resources.ApplyResources(this.tbnEdit, "tbnEdit");
		this.tbnEdit.Name = "tbnEdit";
		this.tbnEdit.Click += new System.EventHandler(tbnEdit_Click);
		resources.ApplyResources(this.tbnDelete, "tbnDelete");
		this.tbnDelete.Name = "tbnDelete";
		this.tbnDelete.Click += new System.EventHandler(tbnDelete_Click);
		resources.ApplyResources(this.tbnUp, "tbnUp");
		this.tbnUp.Name = "tbnUp";
		this.tbnUp.Click += new System.EventHandler(tbnUp_Click);
		resources.ApplyResources(this.tbnDown, "tbnDown");
		this.tbnDown.Name = "tbnDown";
		this.tbnDown.Click += new System.EventHandler(tbnDown_Click);
		resources.ApplyResources(this.tbnDefault, "tbnDefault");
		this.tbnDefault.Name = "tbnDefault";
		this.tbnDefault.Click += new System.EventHandler(tbnDefault_Click);
		resources.ApplyResources(this.clnNo, "clnNo");
		this.clnNo.Name = "clnNo";
		this.clnNo.ReadOnly = true;
		this.clnNo.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnChanName, "clnChanName");
		this.clnChanName.Name = "clnChanName";
		this.clnChanName.ReadOnly = true;
		this.clnChanName.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnPriChannelScanEnable, "clnPriChannelScanEnable");
		this.clnPriChannelScanEnable.Name = "clnPriChannelScanEnable";
		this.clnPriChannelScanEnable.ReadOnly = true;
		this.clnPriChannelScanEnable.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnPriChannelIndex1, "clnPriChannelIndex1");
		this.clnPriChannelIndex1.Name = "clnPriChannelIndex1";
		this.clnPriChannelIndex1.ReadOnly = true;
		resources.ApplyResources(this.clnPriChannel1, "clnPriChannel1");
		this.clnPriChannel1.Name = "clnPriChannel1";
		this.clnPriChannel1.ReadOnly = true;
		this.clnPriChannel1.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnPriChannelIndex2, "clnPriChannelIndex2");
		this.clnPriChannelIndex2.Name = "clnPriChannelIndex2";
		this.clnPriChannelIndex2.ReadOnly = true;
		resources.ApplyResources(this.clnPriChannel2, "clnPriChannel2");
		this.clnPriChannel2.Name = "clnPriChannel2";
		this.clnPriChannel2.ReadOnly = true;
		this.clnPriChannel2.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnLists, "clnLists");
		this.clnLists.Name = "clnLists";
		this.clnLists.ReadOnly = true;
		resources.ApplyResources(this.clnDefaultList, "clnDefaultList");
		this.clnDefaultList.Name = "clnDefaultList";
		this.clnDefaultList.ReadOnly = true;
		this.clnDefaultList.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnListKey, "clnListKey");
		this.clnListKey.Name = "clnListKey";
		this.clnListKey.ReadOnly = true;
		resources.ApplyResources(this, "$this");
		base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		base.Controls.Add(this.dgvChannels);
		base.Controls.Add(this.tolOperation);
		base.Name = "FrmScanLists";
		base.ShowIcon = false;
		base.Activated += new System.EventHandler(FrmScanLists_Activated);
		base.FormClosed += new System.Windows.Forms.FormClosedEventHandler(FrmScanLists_FormClosed);
		base.Load += new System.EventHandler(FrmScanLists_Load);
		((System.ComponentModel.ISupportInitialize)this.dgvChannels).EndInit();
		this.tolOperation.ResumeLayout(false);
		this.tolOperation.PerformLayout();
		base.ResumeLayout(false);
		base.PerformLayout();
	}
}
