using System;
using System.IO;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Text.RegularExpressions;

public static class GClass9
{
	private static byte[] byte_0 = new byte[8] { 19, 36, 87, 104, 144, 172, 189, 239 };

	public static bool smethod_0(string string_0)
	{
		Regex regex = new Regex("^[0-9]+$");
		return regex.Match(string_0).Success;
	}

	public static bool smethod_1(string string_0)
	{
		Regex regex = new Regex("^[a-zA-Z]+$");
		return regex.Match(string_0).Success;
	}

	public static bool smethod_2(string string_0)
	{
		Regex regex = new Regex("^[a-zA-Z0-9]+$");
		return regex.Match(string_0).Success;
	}

	public static bool smethod_3(string string_0)
	{
		Regex regex = new Regex("([^A-Fa-f0-9]|\\s+?)+");
		return regex.Match(string_0).Success;
	}

	public static bool smethod_4(string string_0)
	{
		Regex regex = new Regex("^[a-zA-Z0-9\\x2D\\x5F\\x20\\x28\\x29]+$");
		return regex.Match(string_0).Success;
	}

	public static bool smethod_5(string string_0)
	{
		Regex regex = new Regex("^[A-D0-9\\x2A\\x23]+$");
		return regex.Match(string_0).Success;
	}

	public static bool smethod_6(string string_0)
	{
		int num2 = 0;
		while (true)
		{
			if (num2 < string_0.Length)
			{
				string s = string_0.Substring(num2, 1);
				byte[] bytes = Encoding.GetEncoding("gb2312").GetBytes(s);
				if (bytes.Length == 2)
				{
					break;
				}
				num2++;
				continue;
			}
			return false;
		}
		return true;
	}

	public static string smethod_7(uint uint_0)
	{
		string text = string.Empty;
		byte[] bytes = BitConverter.GetBytes(uint_0);
		for (int num2 = bytes.Length - 1; num2 >= 0; num2--)
		{
			if (num2 != bytes.Length - 1)
			{
				text += ".";
			}
			text += bytes[num2];
		}
		return text;
	}

	public static uint smethod_8(string string_0)
	{
		string[] array = string_0.Split('.');
		byte[] array2 = new byte[4];
		for (int i = 0; i <= array.Length - 1; i++)
		{
			array2[i] = byte.Parse(array[i]);
		}
		return BitConverter.ToUInt32(array2.Reverse().ToArray(), 0);
	}

	public static string smethod_9(string string_0, string string_1)
	{
		try
		{
			byte[] bytes = Encoding.UTF8.GetBytes(string_1.Substring(0, 8));
			byte[] rgbIV = byte_0;
			byte[] bytes2 = Encoding.UTF8.GetBytes(string_0);
			DESCryptoServiceProvider dESCryptoServiceProvider = new DESCryptoServiceProvider();
			MemoryStream memoryStream = new MemoryStream();
			CryptoStream cryptoStream = new CryptoStream(memoryStream, dESCryptoServiceProvider.CreateEncryptor(bytes, rgbIV), CryptoStreamMode.Write);
			cryptoStream.Write(bytes2, 0, bytes2.Length);
			cryptoStream.FlushFinalBlock();
			return Convert.ToBase64String(memoryStream.ToArray());
		}
		catch
		{
			return string_0;
		}
	}

	public static string smethod_10(string string_0, string string_1)
	{
		try
		{
			byte[] bytes = Encoding.UTF8.GetBytes(string_1.Substring(0, 8));
			byte[] rgbIV = byte_0;
			byte[] array = Convert.FromBase64String(string_0);
			DESCryptoServiceProvider dESCryptoServiceProvider = new DESCryptoServiceProvider();
			MemoryStream memoryStream = new MemoryStream();
			CryptoStream cryptoStream = new CryptoStream(memoryStream, dESCryptoServiceProvider.CreateDecryptor(bytes, rgbIV), CryptoStreamMode.Write);
			cryptoStream.Write(array, 0, array.Length);
			cryptoStream.FlushFinalBlock();
			return Encoding.UTF8.GetString(memoryStream.ToArray());
		}
		catch
		{
			return string_0;
		}
	}

	public static bool smethod_11(ref byte[] byte_1)
	{
		byte[] array = new byte[16]
		{
			22, 108, 20, 230, 46, 145, 13, 64, 33, 53,
			213, 64, 19, 3, 233, 128
		};
		for (int i = 0; i < byte_1.Length; i++)
		{
			byte_1[i] ^= array[i % array.Length];
		}
		return true;
	}

	public static int smethod_12(DateTime dateTime_0)
	{
		double num = 0.0;
		try
		{
			DateTime dateTime = TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(1970, 1, 1));
			num = (dateTime_0 - dateTime).TotalSeconds;
		}
		catch (Exception)
		{
		}
		return (int)num;
	}

	public static DateTime smethod_13(double double_0)
	{
		return TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(1970, 1, 1)).AddSeconds(double_0);
	}

	public static ushort smethod_14(byte[] byte_1)
	{
		int[] array = new int[256]
		{
			0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161,
			41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786,
			21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076,
			62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637,
			42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842,
			5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616,
			63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241,
			10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403,
			23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188,
			64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749,
			11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395,
			36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696,
			65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193,
			45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419,
			20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044,
			58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270,
			46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411,
			5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840,
			59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326,
			17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435,
			22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156,
			60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254,
			2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427,
			40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265,
			61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310,
			20053, 24180, 11923, 16050, 3793, 7920
		};
		ushort num = 0;
		for (int i = 0; i < byte_1.Length; i++)
		{
			num = (ushort)((num << 8) ^ array[((num >> 8) ^ byte_1[i]) & 0xFF]);
		}
		return num;
	}

	public static byte[] smethod_15(byte[] byte_1, uint[] uint_0, uint[] uint_1)
	{
		byte[] array = new byte[uint_0.Length * 4];
		for (int i = 0; i < uint_0.Length; i++)
		{
			BitConverter.GetBytes(uint_0[i]).Reverse().ToArray()
				.CopyTo(array, i * 4);
		}
		byte[] array2 = new byte[uint_1.Length * 4];
		for (int j = 0; j < uint_1.Length; j++)
		{
			BitConverter.GetBytes(uint_1[j]).Reverse().ToArray()
				.CopyTo(array2, j * 4);
		}
		Rijndael rijndael = Rijndael.Create();
		try
		{
			using (MemoryStream memoryStream = new MemoryStream())
			{
				using (CryptoStream cryptoStream = new CryptoStream(memoryStream, rijndael.CreateEncryptor(array, array2), CryptoStreamMode.Write))
				{
					cryptoStream.Write(byte_1, 0, byte_1.Length);
					cryptoStream.FlushFinalBlock();
					return memoryStream.ToArray();
				}
			}
		}
		catch (Exception)
		{
			return null;
		}
	}

	public static byte[] smethod_16(byte[] byte_1, uint[] uint_0, uint[] uint_1)
	{
		byte[] array = new byte[uint_0.Length * 4];
		for (int i = 0; i < uint_0.Length; i++)
		{
			BitConverter.GetBytes(uint_0[i]).Reverse().ToArray()
				.CopyTo(array, i * 4);
		}
		byte[] array2 = new byte[uint_1.Length * 4];
		for (int j = 0; j < uint_1.Length; j++)
		{
			BitConverter.GetBytes(uint_1[j]).Reverse().ToArray()
				.CopyTo(array2, j * 4);
		}
		Rijndael rijndael = Rijndael.Create();
		try
		{
			using (MemoryStream stream = new MemoryStream(byte_1))
			{
				using (CryptoStream cryptoStream = new CryptoStream(stream, rijndael.CreateDecryptor(array, array2), CryptoStreamMode.Read))
				{
					using (MemoryStream memoryStream = new MemoryStream())
					{
						byte[] array4 = new byte[1024];
						int num = 0;
						while ((num = cryptoStream.Read(array4, 0, array4.Length)) > 0)
						{
							memoryStream.Write(array4, 0, num);
						}
						return memoryStream.ToArray();
					}
				}
			}
		}
		catch (Exception)
		{
			return null;
		}
	}
}
