using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Runtime.CompilerServices;
using System.Text;
using System.Windows.Forms;

public class FrmContactDTMF : Form
{
	private bool bool_0;

	private List<GStructContactDTMF> list_0;

	private static FrmContactDTMF frmContactDTMF_0;

	private IContainer icontainer_0;

	private DataGridView dgvContact;

	private DataGridViewTextBoxColumn clnNo;

	private DataGridViewTextBoxColumn clnName;

	private DataGridViewTextBoxColumn clnId;

	[SpecialName]
	public List<GStructContactDTMF> method_0()
	{
		return list_0;
	}

	[SpecialName]
	public void method_1(List<GStructContactDTMF> list_1)
	{
		list_0 = list_1;
	}

	[SpecialName]
	public static FrmContactDTMF smethod_0()
	{
		if (frmContactDTMF_0 == null || frmContactDTMF_0.IsDisposed)
		{
			frmContactDTMF_0 = new FrmContactDTMF();
			frmContactDTMF_0.WindowState = FormWindowState.Normal;
		}
		return frmContactDTMF_0;
	}

	public static bool smethod_1()
	{
		if (frmContactDTMF_0 != null && !frmContactDTMF_0.IsDisposed)
		{
			return true;
		}
		return false;
	}

	private FrmContactDTMF()
	{
		InitializeComponent();
	}

	private void FrmContactDTMF_Load(object sender, EventArgs e)
	{
		list_0 = new List<GStructContactDTMF>();
		dgvContact.Rows.Clear();
		dgvContact.Rows.Add(16);
		for (int i = 0; i < dgvContact.Rows.Count; i++)
		{
			dgvContact.Rows[i].Cells[0].Value = i + 1;
		}
	}

	public void method_2(List<GStructContactDTMF> list_1)
	{
		try
		{
			list_0.Clear();
			list_0.AddRange(list_1);
			for (int i = 0; i < dgvContact.Rows.Count; i++)
			{
				if (i < list_1.Count)
				{
					dgvContact.Rows[i].Cells[1].Value = list_1[i].string_0;
					dgvContact.Rows[i].Cells[2].Value = list_1[i].string_1;
				}
				else
				{
					dgvContact.Rows[i].Cells[1].Value = string.Empty;
					dgvContact.Rows[i].Cells[2].Value = string.Empty;
				}
			}
		}
		catch (Exception)
		{
		}
	}

	private void FrmContactDTMF_FormClosed(object sender, FormClosedEventArgs e)
	{
		FrmMain frmMain = (FrmMain)base.MdiParent;
		if (frmMain != null)
		{
			frmMain.setContactDTMF(list_0);
		}
	}

	private void dgvContact_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e)
	{
		if (e.ColumnIndex == 1)
		{
			bool_0 = true;
		}
	}

	private void dgvContact_CellEndEdit(object sender, DataGridViewCellEventArgs e)
	{
		if (e.ColumnIndex != 1 && e.ColumnIndex != 2)
		{
			return;
		}
		bool_0 = false;
		if (dgvContact.Rows[e.RowIndex].Cells[1].Value != null && dgvContact.Rows[e.RowIndex].Cells[2].Value != null)
		{
			string text = dgvContact.Rows[e.RowIndex].Cells[1].Value.ToString();
			string text2 = dgvContact.Rows[e.RowIndex].Cells[2].Value.ToString();
			if (!string.IsNullOrEmpty(text) && GClass9.smethod_6(text))
			{
				MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmContactDTMF_NameIsRegular"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				if (GClass0.bool_3)
				{
					GClass0.bool_4 = true;
				}
				return;
			}
			if (!string.IsNullOrEmpty(text2))
			{
				if (text2.Length != 3)
				{
					MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmContactDTMF_DTMFCodeLen"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					if (GClass0.bool_3)
					{
						GClass0.bool_4 = true;
					}
					return;
				}
				if (!GClass9.smethod_5(text2))
				{
					MessageBox.Show(this, GClass0.resourceManager_0.GetString("FrmContactDTMF_DTMFCodeLegality"), GClass0.resourceManager_0.GetString("DialogTitle_Warning"), MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					if (GClass0.bool_3)
					{
						GClass0.bool_4 = true;
					}
					return;
				}
			}
		}
		method_3();
	}

	private void dgvContact_Leave(object sender, EventArgs e)
	{
		if (bool_0)
		{
			dgvContact.EndEdit();
		}
		else
		{
			method_3();
		}
	}

	private void method_3()
	{
		list_0.Clear();
		for (int i = 0; i < dgvContact.Rows.Count; i++)
		{
			if (dgvContact.Rows[i].Cells[1].Value != null && dgvContact.Rows[i].Cells[2].Value != null && method_4(dgvContact.Rows[i].Cells[1].Value.ToString(), dgvContact.Rows[i].Cells[2].Value.ToString()))
			{
				list_0.Add(new GStructContactDTMF
				{
					string_0 = dgvContact.Rows[i].Cells[1].Value.ToString(),
					string_1 = dgvContact.Rows[i].Cells[2].Value.ToString()
				});
			}
		}
	}

	private bool method_4(string string_0, string string_1)
	{
		if (!string.IsNullOrEmpty(string_0) && !string.IsNullOrEmpty(string_1))
		{
			if (!GClass9.smethod_6(string_0) && GClass9.smethod_5(string_1) && string_1.Length == 3)
			{
				return true;
			}
			return false;
		}
		return false;
	}

	public bool method_5(string string_0)
	{
		int num2 = 0;
		while (true)
		{
			if (num2 < string_0.Length)
			{
				string text = string_0.Substring(num2, 1);
				if (!string.IsNullOrEmpty(text))
				{
					byte[] bytes = Encoding.GetEncoding("gb2312").GetBytes(text);
					if (bytes.Length != 2 && !GClass9.smethod_4(text))
					{
						break;
					}
					num2++;
					continue;
				}
				return false;
			}
			return true;
		}
		return false;
	}

	public int method_6(out List<GStructContactDTMF> list_1)
	{
		list_1 = new List<GStructContactDTMF>();
		int num = 0;
		for (int i = 0; i < dgvContact.Rows.Count; i++)
		{
			if (dgvContact.Rows[i].Cells[1].Value != null && dgvContact.Rows[i].Cells[2].Value != null && method_4(dgvContact.Rows[i].Cells[1].Value.ToString(), dgvContact.Rows[i].Cells[2].Value.ToString()))
			{
				list_1.Add(new GStructContactDTMF
				{
					string_0 = dgvContact.Rows[i].Cells[1].Value.ToString(),
					string_1 = dgvContact.Rows[i].Cells[2].Value.ToString()
				});
				num++;
			}
		}
		return num;
	}

	protected override void Dispose(bool disposing)
	{
		if (disposing && icontainer_0 != null)
		{
			icontainer_0.Dispose();
		}
		base.Dispose(disposing);
	}

	private void InitializeComponent()
	{
		System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmContactDTMF));
		System.Windows.Forms.DataGridViewCellStyle dataGridViewCellStyle = new System.Windows.Forms.DataGridViewCellStyle();
		this.dgvContact = new System.Windows.Forms.DataGridView();
		this.clnNo = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnName = new System.Windows.Forms.DataGridViewTextBoxColumn();
		this.clnId = new System.Windows.Forms.DataGridViewTextBoxColumn();
		((System.ComponentModel.ISupportInitialize)this.dgvContact).BeginInit();
		base.SuspendLayout();
		resources.ApplyResources(this.dgvContact, "dgvContact");
		this.dgvContact.AllowUserToAddRows = false;
		this.dgvContact.AllowUserToDeleteRows = false;
		this.dgvContact.AllowUserToResizeColumns = false;
		this.dgvContact.AllowUserToResizeRows = false;
		dataGridViewCellStyle.BackColor = System.Drawing.Color.Bisque;
		this.dgvContact.AlternatingRowsDefaultCellStyle = dataGridViewCellStyle;
		this.dgvContact.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
		this.dgvContact.Columns.AddRange(this.clnNo, this.clnName, this.clnId);
		this.dgvContact.MultiSelect = false;
		this.dgvContact.Name = "dgvContact";
		this.dgvContact.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.DisableResizing;
		this.dgvContact.RowTemplate.Height = 23;
		this.dgvContact.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
		this.dgvContact.CellBeginEdit += new System.Windows.Forms.DataGridViewCellCancelEventHandler(dgvContact_CellBeginEdit);
		this.dgvContact.CellEndEdit += new System.Windows.Forms.DataGridViewCellEventHandler(dgvContact_CellEndEdit);
		this.dgvContact.Leave += new System.EventHandler(dgvContact_Leave);
		resources.ApplyResources(this.clnNo, "clnNo");
		this.clnNo.Name = "clnNo";
		this.clnNo.ReadOnly = true;
		this.clnNo.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnName, "clnName");
		this.clnName.Name = "clnName";
		this.clnName.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this.clnId, "clnId");
		this.clnId.Name = "clnId";
		this.clnId.SortMode = System.Windows.Forms.DataGridViewColumnSortMode.NotSortable;
		resources.ApplyResources(this, "$this");
		base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		base.Controls.Add(this.dgvContact);
		base.Name = "FrmContactDTMF";
		base.ShowIcon = false;
		base.FormClosed += new System.Windows.Forms.FormClosedEventHandler(FrmContactDTMF_FormClosed);
		base.Load += new System.EventHandler(FrmContactDTMF_Load);
		((System.ComponentModel.ISupportInitialize)this.dgvContact).EndInit();
		base.ResumeLayout(false);
	}
}
