/* Copyright 2023 Dual Tachyon
 * https://github.com/DualTachyon
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef HARDWARE_DP32G030_PORTCON_H
#define HARDWARE_DP32G030_PORTCON_H

#if !defined(__ASSEMBLY__)
#include <stdint.h>
#endif

/* -------- PORTCON -------- */
#define PORTCON_BASE_ADDR                           0x400B0000U
#define PORTCON_BASE_SIZE                           0x00000800U

#define PORTCON_PORTA_SEL0_ADDR                     (PORTCON_BASE_ADDR + 0x0000U)
#define PORTCON_PORTA_SEL0                          (*(volatile uint32_t *)PORTCON_PORTA_SEL0_ADDR)
#define PORTCON_PORTA_SEL0_A0_SHIFT                 0
#define PORTCON_PORTA_SEL0_A0_WIDTH                 4
#define PORTCON_PORTA_SEL0_A0_MASK                  (((1U << PORTCON_PORTA_SEL0_A0_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A0_SHIFT)
#define PORTCON_PORTA_SEL0_A0_VALUE_GPIOA0          0U
#define PORTCON_PORTA_SEL0_A0_BITS_GPIOA0           (PORTCON_PORTA_SEL0_A0_VALUE_GPIOA0 << PORTCON_PORTA_SEL0_A0_SHIFT)
#define PORTCON_PORTA_SEL0_A0_VALUE_PWMP1_PLUS0     1U
#define PORTCON_PORTA_SEL0_A0_BITS_PWMP1_PLUS0      (PORTCON_PORTA_SEL0_A0_VALUE_PWMP1_PLUS0 << PORTCON_PORTA_SEL0_A0_SHIFT)
#define PORTCON_PORTA_SEL0_A0_VALUE_PWMP0_PLUS1     2U
#define PORTCON_PORTA_SEL0_A0_BITS_PWMP0_PLUS1      (PORTCON_PORTA_SEL0_A0_VALUE_PWMP0_PLUS1 << PORTCON_PORTA_SEL0_A0_SHIFT)
#define PORTCON_PORTA_SEL0_A0_VALUE_TM              3U
#define PORTCON_PORTA_SEL0_A0_BITS_TM               (PORTCON_PORTA_SEL0_A0_VALUE_TM << PORTCON_PORTA_SEL0_A0_SHIFT)
#define PORTCON_PORTA_SEL0_A0_VALUE_WAKEUP0         4U
#define PORTCON_PORTA_SEL0_A0_BITS_WAKEUP0          (PORTCON_PORTA_SEL0_A0_VALUE_WAKEUP0 << PORTCON_PORTA_SEL0_A0_SHIFT)

#define PORTCON_PORTA_SEL0_A1_SHIFT                 4
#define PORTCON_PORTA_SEL0_A1_WIDTH                 4
#define PORTCON_PORTA_SEL0_A1_MASK                  (((1U << PORTCON_PORTA_SEL0_A1_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A1_SHIFT)
#define PORTCON_PORTA_SEL0_A1_VALUE_GPIOA1          0U
#define PORTCON_PORTA_SEL0_A1_BITS_GPIOA1           (PORTCON_PORTA_SEL0_A1_VALUE_GPIOA1 << PORTCON_PORTA_SEL0_A1_SHIFT)
#define PORTCON_PORTA_SEL0_A1_VALUE_XTAL_XI         1U
#define PORTCON_PORTA_SEL0_A1_BITS_XTAL_XI          (PORTCON_PORTA_SEL0_A1_VALUE_XTAL_XI << PORTCON_PORTA_SEL0_A1_SHIFT)

#define PORTCON_PORTA_SEL0_A2_SHIFT                 8
#define PORTCON_PORTA_SEL0_A2_WIDTH                 4
#define PORTCON_PORTA_SEL0_A2_MASK                  (((1U << PORTCON_PORTA_SEL0_A2_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A2_SHIFT)
#define PORTCON_PORTA_SEL0_A2_VALUE_GPIOA2          0U
#define PORTCON_PORTA_SEL0_A2_BITS_GPIOA2           (PORTCON_PORTA_SEL0_A2_VALUE_GPIOA2 << PORTCON_PORTA_SEL0_A2_SHIFT)
#define PORTCON_PORTA_SEL0_A2_VALUE_XTAL_XO         1U
#define PORTCON_PORTA_SEL0_A2_BITS_XTAL_XO          (PORTCON_PORTA_SEL0_A2_VALUE_XTAL_XO << PORTCON_PORTA_SEL0_A2_SHIFT)

#define PORTCON_PORTA_SEL0_A3_SHIFT                 12
#define PORTCON_PORTA_SEL0_A3_WIDTH                 4
#define PORTCON_PORTA_SEL0_A3_MASK                  (((1U << PORTCON_PORTA_SEL0_A3_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A3_SHIFT)
#define PORTCON_PORTA_SEL0_A3_VALUE_GPIOA3          0U
#define PORTCON_PORTA_SEL0_A3_BITS_GPIOA3           (PORTCON_PORTA_SEL0_A3_VALUE_GPIOA3 << PORTCON_PORTA_SEL0_A3_SHIFT)
#define PORTCON_PORTA_SEL0_A3_VALUE_CMP0_VN         1U
#define PORTCON_PORTA_SEL0_A3_BITS_CMP0_VN          (PORTCON_PORTA_SEL0_A3_VALUE_CMP0_VN << PORTCON_PORTA_SEL0_A3_SHIFT)
#define PORTCON_PORTA_SEL0_A3_VALUE_XTAH_XI         2U
#define PORTCON_PORTA_SEL0_A3_BITS_XTAH_XI          (PORTCON_PORTA_SEL0_A3_VALUE_XTAH_XI << PORTCON_PORTA_SEL0_A3_SHIFT)

#define PORTCON_PORTA_SEL0_A4_SHIFT                 16
#define PORTCON_PORTA_SEL0_A4_WIDTH                 4
#define PORTCON_PORTA_SEL0_A4_MASK                  (((1U << PORTCON_PORTA_SEL0_A4_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A4_SHIFT)
#define PORTCON_PORTA_SEL0_A4_VALUE_GPIOA4          0U
#define PORTCON_PORTA_SEL0_A4_BITS_GPIOA4           (PORTCON_PORTA_SEL0_A4_VALUE_GPIOA4 << PORTCON_PORTA_SEL0_A4_SHIFT)
#define PORTCON_PORTA_SEL0_A4_VALUE_CMP0_VP         1U
#define PORTCON_PORTA_SEL0_A4_BITS_CMP0_VP          (PORTCON_PORTA_SEL0_A4_VALUE_CMP0_VP << PORTCON_PORTA_SEL0_A4_SHIFT)
#define PORTCON_PORTA_SEL0_A4_VALUE_XTAH_XO         2U
#define PORTCON_PORTA_SEL0_A4_BITS_XTAH_XO          (PORTCON_PORTA_SEL0_A4_VALUE_XTAH_XO << PORTCON_PORTA_SEL0_A4_SHIFT)

#define PORTCON_PORTA_SEL0_A5_SHIFT                 20
#define PORTCON_PORTA_SEL0_A5_WIDTH                 4
#define PORTCON_PORTA_SEL0_A5_MASK                  (((1U << PORTCON_PORTA_SEL0_A5_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_GPIOA5          0U
#define PORTCON_PORTA_SEL0_A5_BITS_GPIOA5           (PORTCON_PORTA_SEL0_A5_VALUE_GPIOA5 << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_UART1_CTS       1U
#define PORTCON_PORTA_SEL0_A5_BITS_UART1_CTS        (PORTCON_PORTA_SEL0_A5_VALUE_UART1_CTS << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_PWMP1_PLUS1     2U
#define PORTCON_PORTA_SEL0_A5_BITS_PWMP1_PLUS1      (PORTCON_PORTA_SEL0_A5_VALUE_PWMP1_PLUS1 << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_TIMERP1_IN0     3U
#define PORTCON_PORTA_SEL0_A5_BITS_TIMERP1_IN0      (PORTCON_PORTA_SEL0_A5_VALUE_TIMERP1_IN0 << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_TIMERP1_OUT_L   4U
#define PORTCON_PORTA_SEL0_A5_BITS_TIMERP1_OUT_L    (PORTCON_PORTA_SEL0_A5_VALUE_TIMERP1_OUT_L << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_WAKEUP1         5U
#define PORTCON_PORTA_SEL0_A5_BITS_WAKEUP1          (PORTCON_PORTA_SEL0_A5_VALUE_WAKEUP1 << PORTCON_PORTA_SEL0_A5_SHIFT)
#define PORTCON_PORTA_SEL0_A5_VALUE_SARADC_CH1      6U
#define PORTCON_PORTA_SEL0_A5_BITS_SARADC_CH1       (PORTCON_PORTA_SEL0_A5_VALUE_SARADC_CH1 << PORTCON_PORTA_SEL0_A5_SHIFT)

#define PORTCON_PORTA_SEL0_A6_SHIFT                 24
#define PORTCON_PORTA_SEL0_A6_WIDTH                 4
#define PORTCON_PORTA_SEL0_A6_MASK                  (((1U << PORTCON_PORTA_SEL0_A6_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A6_SHIFT)
#define PORTCON_PORTA_SEL0_A6_VALUE_GPIOA6          0U
#define PORTCON_PORTA_SEL0_A6_BITS_GPIOA6           (PORTCON_PORTA_SEL0_A6_VALUE_GPIOA6 << PORTCON_PORTA_SEL0_A6_SHIFT)
#define PORTCON_PORTA_SEL0_A6_VALUE_UART1_RTS       1U
#define PORTCON_PORTA_SEL0_A6_BITS_UART1_RTS        (PORTCON_PORTA_SEL0_A6_VALUE_UART1_RTS << PORTCON_PORTA_SEL0_A6_SHIFT)
#define PORTCON_PORTA_SEL0_A6_VALUE_TIMERP1_IN1     2U
#define PORTCON_PORTA_SEL0_A6_BITS_TIMERP1_IN1      (PORTCON_PORTA_SEL0_A6_VALUE_TIMERP1_IN1 << PORTCON_PORTA_SEL0_A6_SHIFT)
#define PORTCON_PORTA_SEL0_A6_VALUE_TIMERP1_OUT_H   3U
#define PORTCON_PORTA_SEL0_A6_BITS_TIMERP1_OUT_H    (PORTCON_PORTA_SEL0_A6_VALUE_TIMERP1_OUT_H << PORTCON_PORTA_SEL0_A6_SHIFT)
#define PORTCON_PORTA_SEL0_A6_VALUE_SARADC_CH1      4U
#define PORTCON_PORTA_SEL0_A6_BITS_SARADC_CH1       (PORTCON_PORTA_SEL0_A6_VALUE_SARADC_CH1 << PORTCON_PORTA_SEL0_A6_SHIFT)
#define PORTCON_PORTA_SEL0_A6_VALUE_OPA0_OUT        5U
#define PORTCON_PORTA_SEL0_A6_BITS_OPA0_OUT         (PORTCON_PORTA_SEL0_A6_VALUE_OPA0_OUT << PORTCON_PORTA_SEL0_A6_SHIFT)

#define PORTCON_PORTA_SEL0_A7_SHIFT                 28
#define PORTCON_PORTA_SEL0_A7_WIDTH                 4
#define PORTCON_PORTA_SEL0_A7_MASK                  (((1U << PORTCON_PORTA_SEL0_A7_WIDTH) - 1U) << PORTCON_PORTA_SEL0_A7_SHIFT)
#define PORTCON_PORTA_SEL0_A7_VALUE_GPIOA7          0U
#define PORTCON_PORTA_SEL0_A7_BITS_GPIOA7           (PORTCON_PORTA_SEL0_A7_VALUE_GPIOA7 << PORTCON_PORTA_SEL0_A7_SHIFT)
#define PORTCON_PORTA_SEL0_A7_VALUE_UART1_TX        1U
#define PORTCON_PORTA_SEL0_A7_BITS_UART1_TX         (PORTCON_PORTA_SEL0_A7_VALUE_UART1_TX << PORTCON_PORTA_SEL0_A7_SHIFT)
#define PORTCON_PORTA_SEL0_A7_VALUE_TIMERP0_IN0     2U
#define PORTCON_PORTA_SEL0_A7_BITS_TIMERP0_IN0      (PORTCON_PORTA_SEL0_A7_VALUE_TIMERP0_IN0 << PORTCON_PORTA_SEL0_A7_SHIFT)
#define PORTCON_PORTA_SEL0_A7_VALUE_TIMERP0_OUT_L   3U
#define PORTCON_PORTA_SEL0_A7_BITS_TIMERP0_OUT_L    (PORTCON_PORTA_SEL0_A7_VALUE_TIMERP0_OUT_L << PORTCON_PORTA_SEL0_A7_SHIFT)
#define PORTCON_PORTA_SEL0_A7_VALUE_SARADC_CH2      4U
#define PORTCON_PORTA_SEL0_A7_BITS_SARADC_CH2       (PORTCON_PORTA_SEL0_A7_VALUE_SARADC_CH2 << PORTCON_PORTA_SEL0_A7_SHIFT)
#define PORTCON_PORTA_SEL0_A7_VALUE_OPA0_VP         5U
#define PORTCON_PORTA_SEL0_A7_BITS_OPA0_VP          (PORTCON_PORTA_SEL0_A7_VALUE_OPA0_VP << PORTCON_PORTA_SEL0_A7_SHIFT)

#define PORTCON_PORTA_SEL1_ADDR                     (PORTCON_BASE_ADDR + 0x0004U)
#define PORTCON_PORTA_SEL1                          (*(volatile uint32_t *)PORTCON_PORTA_SEL1_ADDR)
#define PORTCON_PORTA_SEL1_A8_SHIFT                 0
#define PORTCON_PORTA_SEL1_A8_WIDTH                 4
#define PORTCON_PORTA_SEL1_A8_MASK                  (((1U << PORTCON_PORTA_SEL1_A8_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A8_SHIFT)
#define PORTCON_PORTA_SEL1_A8_VALUE_GPIOA8          0U
#define PORTCON_PORTA_SEL1_A8_BITS_GPIOA8           (PORTCON_PORTA_SEL1_A8_VALUE_GPIOA8 << PORTCON_PORTA_SEL1_A8_SHIFT)
#define PORTCON_PORTA_SEL1_A8_VALUE_UART1_RX        1U
#define PORTCON_PORTA_SEL1_A8_BITS_UART1_RX         (PORTCON_PORTA_SEL1_A8_VALUE_UART1_RX << PORTCON_PORTA_SEL1_A8_SHIFT)
#define PORTCON_PORTA_SEL1_A8_VALUE_TIMERP0_IN1     2U
#define PORTCON_PORTA_SEL1_A8_BITS_TIMERP0_IN1      (PORTCON_PORTA_SEL1_A8_VALUE_TIMERP0_IN1 << PORTCON_PORTA_SEL1_A8_SHIFT)
#define PORTCON_PORTA_SEL1_A8_VALUE_TIMERP0_OUT_H   3U
#define PORTCON_PORTA_SEL1_A8_BITS_TIMERP0_OUT_H    (PORTCON_PORTA_SEL1_A8_VALUE_TIMERP0_OUT_H << PORTCON_PORTA_SEL1_A8_SHIFT)
#define PORTCON_PORTA_SEL1_A8_VALUE_SARADC_CH3      4U
#define PORTCON_PORTA_SEL1_A8_BITS_SARADC_CH3       (PORTCON_PORTA_SEL1_A8_VALUE_SARADC_CH3 << PORTCON_PORTA_SEL1_A8_SHIFT)
#define PORTCON_PORTA_SEL1_A8_VALUE_OPA0_VN         5U
#define PORTCON_PORTA_SEL1_A8_BITS_OPA0_VN          (PORTCON_PORTA_SEL1_A8_VALUE_OPA0_VN << PORTCON_PORTA_SEL1_A8_SHIFT)

#define PORTCON_PORTA_SEL1_A9_SHIFT                 4
#define PORTCON_PORTA_SEL1_A9_WIDTH                 4
#define PORTCON_PORTA_SEL1_A9_MASK                  (((1U << PORTCON_PORTA_SEL1_A9_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_GPIOA9          0U
#define PORTCON_PORTA_SEL1_A9_BITS_GPIOA9           (PORTCON_PORTA_SEL1_A9_VALUE_GPIOA9 << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_SPI0_SSN        1U
#define PORTCON_PORTA_SEL1_A9_BITS_SPI0_SSN         (PORTCON_PORTA_SEL1_A9_VALUE_SPI0_SSN << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_TIMERP1_IN0     2U
#define PORTCON_PORTA_SEL1_A9_BITS_TIMERP1_IN0      (PORTCON_PORTA_SEL1_A9_VALUE_TIMERP1_IN0 << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_TIMERP1_OUT_L   3U
#define PORTCON_PORTA_SEL1_A9_BITS_TIMERP1_OUT_L    (PORTCON_PORTA_SEL1_A9_VALUE_TIMERP1_OUT_L << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_TM              4U
#define PORTCON_PORTA_SEL1_A9_BITS_TM               (PORTCON_PORTA_SEL1_A9_VALUE_TM << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_SARADC_CH4      5U
#define PORTCON_PORTA_SEL1_A9_BITS_SARADC_CH4       (PORTCON_PORTA_SEL1_A9_VALUE_SARADC_CH4 << PORTCON_PORTA_SEL1_A9_SHIFT)
#define PORTCON_PORTA_SEL1_A9_VALUE_CMP1_VN         6U
#define PORTCON_PORTA_SEL1_A9_BITS_CMP1_VN          (PORTCON_PORTA_SEL1_A9_VALUE_CMP1_VN << PORTCON_PORTA_SEL1_A9_SHIFT)

#define PORTCON_PORTA_SEL1_A10_SHIFT                8
#define PORTCON_PORTA_SEL1_A10_WIDTH                4
#define PORTCON_PORTA_SEL1_A10_MASK                 (((1U << PORTCON_PORTA_SEL1_A10_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A10_SHIFT)
#define PORTCON_PORTA_SEL1_A10_VALUE_GPIOA10        0U
#define PORTCON_PORTA_SEL1_A10_BITS_GPIOA10         (PORTCON_PORTA_SEL1_A10_VALUE_GPIOA10 << PORTCON_PORTA_SEL1_A10_SHIFT)
#define PORTCON_PORTA_SEL1_A10_VALUE_SPI0_CLK       1U
#define PORTCON_PORTA_SEL1_A10_BITS_SPI0_CLK        (PORTCON_PORTA_SEL1_A10_VALUE_SPI0_CLK << PORTCON_PORTA_SEL1_A10_SHIFT)
#define PORTCON_PORTA_SEL1_A10_VALUE_SARADC_CH5     2U
#define PORTCON_PORTA_SEL1_A10_BITS_SARADC_CH5      (PORTCON_PORTA_SEL1_A10_VALUE_SARADC_CH5 << PORTCON_PORTA_SEL1_A10_SHIFT)
#define PORTCON_PORTA_SEL1_A10_VALUE_CMP1_VP        3U
#define PORTCON_PORTA_SEL1_A10_BITS_CMP1_VP         (PORTCON_PORTA_SEL1_A10_VALUE_CMP1_VP << PORTCON_PORTA_SEL1_A10_SHIFT)

#define PORTCON_PORTA_SEL1_A11_SHIFT                12
#define PORTCON_PORTA_SEL1_A11_WIDTH                4
#define PORTCON_PORTA_SEL1_A11_MASK                 (((1U << PORTCON_PORTA_SEL1_A11_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_GPIOA11        0U
#define PORTCON_PORTA_SEL1_A11_BITS_GPIOA11         (PORTCON_PORTA_SEL1_A11_VALUE_GPIOA11 << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_SPI0_MISO      1U
#define PORTCON_PORTA_SEL1_A11_BITS_SPI0_MISO       (PORTCON_PORTA_SEL1_A11_VALUE_SPI0_MISO << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_PWMB0_CH0      2U
#define PORTCON_PORTA_SEL1_A11_BITS_PWMB0_CH0       (PORTCON_PORTA_SEL1_A11_VALUE_PWMB0_CH0 << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_PWMP0_BRAKE0   3U
#define PORTCON_PORTA_SEL1_A11_BITS_PWMP0_BRAKE0    (PORTCON_PORTA_SEL1_A11_VALUE_PWMP0_BRAKE0 << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_TIMERP1_IN1    4U
#define PORTCON_PORTA_SEL1_A11_BITS_TIMERP1_IN1     (PORTCON_PORTA_SEL1_A11_VALUE_TIMERP1_IN1 << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_TIMERP1_OUT_H  5U
#define PORTCON_PORTA_SEL1_A11_BITS_TIMERP1_OUT_H   (PORTCON_PORTA_SEL1_A11_VALUE_TIMERP1_OUT_H << PORTCON_PORTA_SEL1_A11_SHIFT)
#define PORTCON_PORTA_SEL1_A11_VALUE_SARADC_CH6     6U
#define PORTCON_PORTA_SEL1_A11_BITS_SARADC_CH6      (PORTCON_PORTA_SEL1_A11_VALUE_SARADC_CH6 << PORTCON_PORTA_SEL1_A11_SHIFT)

#define PORTCON_PORTA_SEL1_A12_SHIFT                16
#define PORTCON_PORTA_SEL1_A12_WIDTH                4
#define PORTCON_PORTA_SEL1_A12_MASK                 (((1U << PORTCON_PORTA_SEL1_A12_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_GPIOA12        0U
#define PORTCON_PORTA_SEL1_A12_BITS_GPIOA12         (PORTCON_PORTA_SEL1_A12_VALUE_GPIOA12 << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_SPI0_MOSI      1U
#define PORTCON_PORTA_SEL1_A12_BITS_SPI0_MOSI       (PORTCON_PORTA_SEL1_A12_VALUE_SPI0_MOSI << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_PWMB0_CH1      2U
#define PORTCON_PORTA_SEL1_A12_BITS_PWMB0_CH1       (PORTCON_PORTA_SEL1_A12_VALUE_PWMB0_CH1 << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_PWMP0_CH0N     3U
#define PORTCON_PORTA_SEL1_A12_BITS_PWMP0_CH0N      (PORTCON_PORTA_SEL1_A12_VALUE_PWMP0_CH0N << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_TIMERP0_IN0    4U
#define PORTCON_PORTA_SEL1_A12_BITS_TIMERP0_IN0     (PORTCON_PORTA_SEL1_A12_VALUE_TIMERP0_IN0 << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_TIMERP0_OUT_L  5U
#define PORTCON_PORTA_SEL1_A12_BITS_TIMERP0_OUT_L   (PORTCON_PORTA_SEL1_A12_VALUE_TIMERP0_OUT_L << PORTCON_PORTA_SEL1_A12_SHIFT)
#define PORTCON_PORTA_SEL1_A12_VALUE_SARADC_CH7     6U
#define PORTCON_PORTA_SEL1_A12_BITS_SARADC_CH7      (PORTCON_PORTA_SEL1_A12_VALUE_SARADC_CH7 << PORTCON_PORTA_SEL1_A12_SHIFT)

#define PORTCON_PORTA_SEL1_A13_SHIFT                20
#define PORTCON_PORTA_SEL1_A13_WIDTH                4
#define PORTCON_PORTA_SEL1_A13_MASK                 (((1U << PORTCON_PORTA_SEL1_A13_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A13_SHIFT)
#define PORTCON_PORTA_SEL1_A13_VALUE_GPIOA13        0U
#define PORTCON_PORTA_SEL1_A13_BITS_GPIOA13         (PORTCON_PORTA_SEL1_A13_VALUE_GPIOA13 << PORTCON_PORTA_SEL1_A13_SHIFT)
#define PORTCON_PORTA_SEL1_A13_VALUE_PWMB0_CH2      1U
#define PORTCON_PORTA_SEL1_A13_BITS_PWMB0_CH2       (PORTCON_PORTA_SEL1_A13_VALUE_PWMB0_CH2 << PORTCON_PORTA_SEL1_A13_SHIFT)
#define PORTCON_PORTA_SEL1_A13_VALUE_PWMP0_CH1N     2U
#define PORTCON_PORTA_SEL1_A13_BITS_PWMP0_CH1N      (PORTCON_PORTA_SEL1_A13_VALUE_PWMP0_CH1N << PORTCON_PORTA_SEL1_A13_SHIFT)
#define PORTCON_PORTA_SEL1_A13_VALUE_TIMERP0_IN1    3U
#define PORTCON_PORTA_SEL1_A13_BITS_TIMERP0_IN1     (PORTCON_PORTA_SEL1_A13_VALUE_TIMERP0_IN1 << PORTCON_PORTA_SEL1_A13_SHIFT)
#define PORTCON_PORTA_SEL1_A13_VALUE_TIMERP0_OUT_H  4U
#define PORTCON_PORTA_SEL1_A13_BITS_TIMERP0_OUT_H   (PORTCON_PORTA_SEL1_A13_VALUE_TIMERP0_OUT_H << PORTCON_PORTA_SEL1_A13_SHIFT)
#define PORTCON_PORTA_SEL1_A13_VALUE_SARADC_CH8     5U
#define PORTCON_PORTA_SEL1_A13_BITS_SARADC_CH8      (PORTCON_PORTA_SEL1_A13_VALUE_SARADC_CH8 << PORTCON_PORTA_SEL1_A13_SHIFT)

#define PORTCON_PORTA_SEL1_A14_SHIFT                24
#define PORTCON_PORTA_SEL1_A14_WIDTH                4
#define PORTCON_PORTA_SEL1_A14_MASK                 (((1U << PORTCON_PORTA_SEL1_A14_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A14_SHIFT)
#define PORTCON_PORTA_SEL1_A14_VALUE_GPIOA14        0U
#define PORTCON_PORTA_SEL1_A14_BITS_GPIOA14         (PORTCON_PORTA_SEL1_A14_VALUE_GPIOA14 << PORTCON_PORTA_SEL1_A14_SHIFT)
#define PORTCON_PORTA_SEL1_A14_VALUE_PWMB1_CH0      1U
#define PORTCON_PORTA_SEL1_A14_BITS_PWMB1_CH0       (PORTCON_PORTA_SEL1_A14_VALUE_PWMB1_CH0 << PORTCON_PORTA_SEL1_A14_SHIFT)
#define PORTCON_PORTA_SEL1_A14_VALUE_PWMP0_CH2N     2U
#define PORTCON_PORTA_SEL1_A14_BITS_PWMP0_CH2N      (PORTCON_PORTA_SEL1_A14_VALUE_PWMP0_CH2N << PORTCON_PORTA_SEL1_A14_SHIFT)
#define PORTCON_PORTA_SEL1_A14_VALUE_TIMERP1_IN0    3U
#define PORTCON_PORTA_SEL1_A14_BITS_TIMERP1_IN0     (PORTCON_PORTA_SEL1_A14_VALUE_TIMERP1_IN0 << PORTCON_PORTA_SEL1_A14_SHIFT)
#define PORTCON_PORTA_SEL1_A14_VALUE_TIMERP1_OUT_L  4U
#define PORTCON_PORTA_SEL1_A14_BITS_TIMERP1_OUT_L   (PORTCON_PORTA_SEL1_A14_VALUE_TIMERP1_OUT_L << PORTCON_PORTA_SEL1_A14_SHIFT)
#define PORTCON_PORTA_SEL1_A14_VALUE_SARADC_CH9     5U
#define PORTCON_PORTA_SEL1_A14_BITS_SARADC_CH9      (PORTCON_PORTA_SEL1_A14_VALUE_SARADC_CH9 << PORTCON_PORTA_SEL1_A14_SHIFT)

#define PORTCON_PORTA_SEL1_A15_SHIFT                28
#define PORTCON_PORTA_SEL1_A15_WIDTH                4
#define PORTCON_PORTA_SEL1_A15_MASK                 (((1U << PORTCON_PORTA_SEL1_A15_WIDTH) - 1U) << PORTCON_PORTA_SEL1_A15_SHIFT)
#define PORTCON_PORTA_SEL1_A15_VALUE_GPIOA15        0U
#define PORTCON_PORTA_SEL1_A15_BITS_GPIOA15         (PORTCON_PORTA_SEL1_A15_VALUE_GPIOA15 << PORTCON_PORTA_SEL1_A15_SHIFT)
#define PORTCON_PORTA_SEL1_A15_VALUE_PWMB1_CH1      1U
#define PORTCON_PORTA_SEL1_A15_BITS_PWMB1_CH1       (PORTCON_PORTA_SEL1_A15_VALUE_PWMB1_CH1 << PORTCON_PORTA_SEL1_A15_SHIFT)
#define PORTCON_PORTA_SEL1_A15_VALUE_PWMP0_CH0      2U
#define PORTCON_PORTA_SEL1_A15_BITS_PWMP0_CH0       (PORTCON_PORTA_SEL1_A15_VALUE_PWMP0_CH0 << PORTCON_PORTA_SEL1_A15_SHIFT)
#define PORTCON_PORTA_SEL1_A15_VALUE_TIMERP1_IN1    3U
#define PORTCON_PORTA_SEL1_A15_BITS_TIMERP1_IN1     (PORTCON_PORTA_SEL1_A15_VALUE_TIMERP1_IN1 << PORTCON_PORTA_SEL1_A15_SHIFT)
#define PORTCON_PORTA_SEL1_A15_VALUE_TIMERP1_OUT_H  4U
#define PORTCON_PORTA_SEL1_A15_BITS_TIMERP1_OUT_H   (PORTCON_PORTA_SEL1_A15_VALUE_TIMERP1_OUT_H << PORTCON_PORTA_SEL1_A15_SHIFT)

#define PORTCON_PORTB_SEL0_ADDR                     (PORTCON_BASE_ADDR + 0x0008U)
#define PORTCON_PORTB_SEL0                          (*(volatile uint32_t *)PORTCON_PORTB_SEL0_ADDR)
#define PORTCON_PORTB_SEL0_B0_SHIFT                 0
#define PORTCON_PORTB_SEL0_B0_WIDTH                 4
#define PORTCON_PORTB_SEL0_B0_MASK                  (((1U << PORTCON_PORTB_SEL0_B0_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B0_SHIFT)
#define PORTCON_PORTB_SEL0_B0_VALUE_GPIOB0          0U
#define PORTCON_PORTB_SEL0_B0_BITS_GPIOB0           (PORTCON_PORTB_SEL0_B0_VALUE_GPIOB0 << PORTCON_PORTB_SEL0_B0_SHIFT)
#define PORTCON_PORTB_SEL0_B0_VALUE_UART2_TX        1U
#define PORTCON_PORTB_SEL0_B0_BITS_UART2_TX         (PORTCON_PORTB_SEL0_B0_VALUE_UART2_TX << PORTCON_PORTB_SEL0_B0_SHIFT)
#define PORTCON_PORTB_SEL0_B0_VALUE_IIC0_SCL        2U
#define PORTCON_PORTB_SEL0_B0_BITS_IIC0_SCL         (PORTCON_PORTB_SEL0_B0_VALUE_IIC0_SCL << PORTCON_PORTB_SEL0_B0_SHIFT)
#define PORTCON_PORTB_SEL0_B0_VALUE_PWMB1_CH2       3U
#define PORTCON_PORTB_SEL0_B0_BITS_PWMB1_CH2        (PORTCON_PORTB_SEL0_B0_VALUE_PWMB1_CH2 << PORTCON_PORTB_SEL0_B0_SHIFT)
#define PORTCON_PORTB_SEL0_B0_VALUE_PWMP0_CH1       4U
#define PORTCON_PORTB_SEL0_B0_BITS_PWMP0_CH1        (PORTCON_PORTB_SEL0_B0_VALUE_PWMP0_CH1 << PORTCON_PORTB_SEL0_B0_SHIFT)

#define PORTCON_PORTB_SEL0_B1_SHIFT                 4
#define PORTCON_PORTB_SEL0_B1_WIDTH                 4
#define PORTCON_PORTB_SEL0_B1_MASK                  (((1U << PORTCON_PORTB_SEL0_B1_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B1_SHIFT)
#define PORTCON_PORTB_SEL0_B1_VALUE_GPIOB1          0U
#define PORTCON_PORTB_SEL0_B1_BITS_GPIOB1           (PORTCON_PORTB_SEL0_B1_VALUE_GPIOB1 << PORTCON_PORTB_SEL0_B1_SHIFT)
#define PORTCON_PORTB_SEL0_B1_VALUE_UART2_RX        1U
#define PORTCON_PORTB_SEL0_B1_BITS_UART2_RX         (PORTCON_PORTB_SEL0_B1_VALUE_UART2_RX << PORTCON_PORTB_SEL0_B1_SHIFT)
#define PORTCON_PORTB_SEL0_B1_VALUE_IIC0_SDA        2U
#define PORTCON_PORTB_SEL0_B1_BITS_IIC0_SDA         (PORTCON_PORTB_SEL0_B1_VALUE_IIC0_SDA << PORTCON_PORTB_SEL0_B1_SHIFT)
#define PORTCON_PORTB_SEL0_B1_VALUE_PWMP0_CH2       3U
#define PORTCON_PORTB_SEL0_B1_BITS_PWMP0_CH2        (PORTCON_PORTB_SEL0_B1_VALUE_PWMP0_CH2 << PORTCON_PORTB_SEL0_B1_SHIFT)

#define PORTCON_PORTB_SEL0_B2_SHIFT                 8
#define PORTCON_PORTB_SEL0_B2_WIDTH                 4
#define PORTCON_PORTB_SEL0_B2_MASK                  (((1U << PORTCON_PORTB_SEL0_B2_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B2_SHIFT)
#define PORTCON_PORTB_SEL0_B2_VALUE_GPIOB2          0U
#define PORTCON_PORTB_SEL0_B2_BITS_GPIOB2           (PORTCON_PORTB_SEL0_B2_VALUE_GPIOB2 << PORTCON_PORTB_SEL0_B2_SHIFT)
#define PORTCON_PORTB_SEL0_B2_VALUE_SPI1_SSN        1U
#define PORTCON_PORTB_SEL0_B2_BITS_SPI1_SSN         (PORTCON_PORTB_SEL0_B2_VALUE_SPI1_SSN << PORTCON_PORTB_SEL0_B2_SHIFT)
#define PORTCON_PORTB_SEL0_B2_VALUE_PWMP0_BRAKE1    2U
#define PORTCON_PORTB_SEL0_B2_BITS_PWMP0_BRAKE1     (PORTCON_PORTB_SEL0_B2_VALUE_PWMP0_BRAKE1 << PORTCON_PORTB_SEL0_B2_SHIFT)
#define PORTCON_PORTB_SEL0_B2_VALUE_TIMERP1_HALL0   3U
#define PORTCON_PORTB_SEL0_B2_BITS_TIMERP1_HALL0    (PORTCON_PORTB_SEL0_B2_VALUE_TIMERP1_HALL0 << PORTCON_PORTB_SEL0_B2_SHIFT)

#define PORTCON_PORTB_SEL0_B3_SHIFT                 12
#define PORTCON_PORTB_SEL0_B3_WIDTH                 4
#define PORTCON_PORTB_SEL0_B3_MASK                  (((1U << PORTCON_PORTB_SEL0_B3_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B3_SHIFT)
#define PORTCON_PORTB_SEL0_B3_VALUE_GPIOB3          0U
#define PORTCON_PORTB_SEL0_B3_BITS_GPIOB3           (PORTCON_PORTB_SEL0_B3_VALUE_GPIOB3 << PORTCON_PORTB_SEL0_B3_SHIFT)
#define PORTCON_PORTB_SEL0_B3_VALUE_SPI1_CLK        1U
#define PORTCON_PORTB_SEL0_B3_BITS_SPI1_CLK         (PORTCON_PORTB_SEL0_B3_VALUE_SPI1_CLK << PORTCON_PORTB_SEL0_B3_SHIFT)
#define PORTCON_PORTB_SEL0_B3_VALUE_IIC1_SDA        2U
#define PORTCON_PORTB_SEL0_B3_BITS_IIC1_SDA         (PORTCON_PORTB_SEL0_B3_VALUE_IIC1_SDA << PORTCON_PORTB_SEL0_B3_SHIFT)
#define PORTCON_PORTB_SEL0_B3_VALUE_PWMP0_CH0N      3U
#define PORTCON_PORTB_SEL0_B3_BITS_PWMP0_CH0N       (PORTCON_PORTB_SEL0_B3_VALUE_PWMP0_CH0N << PORTCON_PORTB_SEL0_B3_SHIFT)
#define PORTCON_PORTB_SEL0_B3_VALUE_TIMERP1_HALL1   4U
#define PORTCON_PORTB_SEL0_B3_BITS_TIMERP1_HALL1    (PORTCON_PORTB_SEL0_B3_VALUE_TIMERP1_HALL1 << PORTCON_PORTB_SEL0_B3_SHIFT)

#define PORTCON_PORTB_SEL0_B4_SHIFT                 16
#define PORTCON_PORTB_SEL0_B4_WIDTH                 4
#define PORTCON_PORTB_SEL0_B4_MASK                  (((1U << PORTCON_PORTB_SEL0_B4_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B4_SHIFT)
#define PORTCON_PORTB_SEL0_B4_VALUE_GPIOB4          0U
#define PORTCON_PORTB_SEL0_B4_BITS_GPIOB4           (PORTCON_PORTB_SEL0_B4_VALUE_GPIOB4 << PORTCON_PORTB_SEL0_B4_SHIFT)
#define PORTCON_PORTB_SEL0_B4_VALUE_SPI1_MISO       1U
#define PORTCON_PORTB_SEL0_B4_BITS_SPI1_MISO        (PORTCON_PORTB_SEL0_B4_VALUE_SPI1_MISO << PORTCON_PORTB_SEL0_B4_SHIFT)
#define PORTCON_PORTB_SEL0_B4_VALUE_IIC1_SCL        2U
#define PORTCON_PORTB_SEL0_B4_BITS_IIC1_SCL         (PORTCON_PORTB_SEL0_B4_VALUE_IIC1_SCL << PORTCON_PORTB_SEL0_B4_SHIFT)
#define PORTCON_PORTB_SEL0_B4_VALUE_PWMP1_CH0       3U
#define PORTCON_PORTB_SEL0_B4_BITS_PWMP1_CH0        (PORTCON_PORTB_SEL0_B4_VALUE_PWMP1_CH0 << PORTCON_PORTB_SEL0_B4_SHIFT)
#define PORTCON_PORTB_SEL0_B4_VALUE_PWMP0_CH1N      4U
#define PORTCON_PORTB_SEL0_B4_BITS_PWMP0_CH1N       (PORTCON_PORTB_SEL0_B4_VALUE_PWMP0_CH1N << PORTCON_PORTB_SEL0_B4_SHIFT)
#define PORTCON_PORTB_SEL0_B4_VALUE_TIMERP1_HALL2   5U
#define PORTCON_PORTB_SEL0_B4_BITS_TIMERP1_HALL2    (PORTCON_PORTB_SEL0_B4_VALUE_TIMERP1_HALL2 << PORTCON_PORTB_SEL0_B4_SHIFT)

#define PORTCON_PORTB_SEL0_B5_SHIFT                 20
#define PORTCON_PORTB_SEL0_B5_WIDTH                 4
#define PORTCON_PORTB_SEL0_B5_MASK                  (((1U << PORTCON_PORTB_SEL0_B5_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B5_SHIFT)
#define PORTCON_PORTB_SEL0_B5_VALUE_GPIOB5          0U
#define PORTCON_PORTB_SEL0_B5_BITS_GPIOB5           (PORTCON_PORTB_SEL0_B5_VALUE_GPIOB5 << PORTCON_PORTB_SEL0_B5_SHIFT)
#define PORTCON_PORTB_SEL0_B5_VALUE_SPI1_MOSI       1U
#define PORTCON_PORTB_SEL0_B5_BITS_SPI1_MOSI        (PORTCON_PORTB_SEL0_B5_VALUE_SPI1_MOSI << PORTCON_PORTB_SEL0_B5_SHIFT)
#define PORTCON_PORTB_SEL0_B5_VALUE_PWMP1_CH0N      2U
#define PORTCON_PORTB_SEL0_B5_BITS_PWMP1_CH0N       (PORTCON_PORTB_SEL0_B5_VALUE_PWMP1_CH0N << PORTCON_PORTB_SEL0_B5_SHIFT)
#define PORTCON_PORTB_SEL0_B5_VALUE_PWMP0_CH2N      3U
#define PORTCON_PORTB_SEL0_B5_BITS_PWMP0_CH2N       (PORTCON_PORTB_SEL0_B5_VALUE_PWMP0_CH2N << PORTCON_PORTB_SEL0_B5_SHIFT)
#define PORTCON_PORTB_SEL0_B5_VALUE_TIMERP0_IN0     4U
#define PORTCON_PORTB_SEL0_B5_BITS_TIMERP0_IN0      (PORTCON_PORTB_SEL0_B5_VALUE_TIMERP0_IN0 << PORTCON_PORTB_SEL0_B5_SHIFT)
#define PORTCON_PORTB_SEL0_B5_VALUE_TIMERP0_OUT_L   5U
#define PORTCON_PORTB_SEL0_B5_BITS_TIMERP0_OUT_L    (PORTCON_PORTB_SEL0_B5_VALUE_TIMERP0_OUT_L << PORTCON_PORTB_SEL0_B5_SHIFT)

#define PORTCON_PORTB_SEL0_B6_SHIFT                 24
#define PORTCON_PORTB_SEL0_B6_WIDTH                 4
#define PORTCON_PORTB_SEL0_B6_MASK                  (((1U << PORTCON_PORTB_SEL0_B6_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B6_SHIFT)
#define PORTCON_PORTB_SEL0_B6_VALUE_GPIOB6          0U
#define PORTCON_PORTB_SEL0_B6_BITS_GPIOB6           (PORTCON_PORTB_SEL0_B6_VALUE_GPIOB6 << PORTCON_PORTB_SEL0_B6_SHIFT)
#define PORTCON_PORTB_SEL0_B6_VALUE_PWMP0_CH0       1U
#define PORTCON_PORTB_SEL0_B6_BITS_PWMP0_CH0        (PORTCON_PORTB_SEL0_B6_VALUE_PWMP0_CH0 << PORTCON_PORTB_SEL0_B6_SHIFT)
#define PORTCON_PORTB_SEL0_B6_VALUE_TIMERP0_IN1     2U
#define PORTCON_PORTB_SEL0_B6_BITS_TIMERP0_IN1      (PORTCON_PORTB_SEL0_B6_VALUE_TIMERP0_IN1 << PORTCON_PORTB_SEL0_B6_SHIFT)
#define PORTCON_PORTB_SEL0_B6_VALUE_TIMERP0_OUT_H   3U
#define PORTCON_PORTB_SEL0_B6_BITS_TIMERP0_OUT_H    (PORTCON_PORTB_SEL0_B6_VALUE_TIMERP0_OUT_H << PORTCON_PORTB_SEL0_B6_SHIFT)

#define PORTCON_PORTB_SEL0_B7_SHIFT                 28
#define PORTCON_PORTB_SEL0_B7_WIDTH                 4
#define PORTCON_PORTB_SEL0_B7_MASK                  (((1U << PORTCON_PORTB_SEL0_B7_WIDTH) - 1U) << PORTCON_PORTB_SEL0_B7_SHIFT)
#define PORTCON_PORTB_SEL0_B7_VALUE_GPIOB7          0U
#define PORTCON_PORTB_SEL0_B7_BITS_GPIOB7           (PORTCON_PORTB_SEL0_B7_VALUE_GPIOB7 << PORTCON_PORTB_SEL0_B7_SHIFT)
#define PORTCON_PORTB_SEL0_B7_VALUE_SPI0_SSN        1U
#define PORTCON_PORTB_SEL0_B7_BITS_SPI0_SSN         (PORTCON_PORTB_SEL0_B7_VALUE_SPI0_SSN << PORTCON_PORTB_SEL0_B7_SHIFT)
#define PORTCON_PORTB_SEL0_B7_VALUE_UART0_TX        2U
#define PORTCON_PORTB_SEL0_B7_BITS_UART0_TX         (PORTCON_PORTB_SEL0_B7_VALUE_UART0_TX << PORTCON_PORTB_SEL0_B7_SHIFT)
#define PORTCON_PORTB_SEL0_B7_VALUE_IIC0_SCL        3U
#define PORTCON_PORTB_SEL0_B7_BITS_IIC0_SCL         (PORTCON_PORTB_SEL0_B7_VALUE_IIC0_SCL << PORTCON_PORTB_SEL0_B7_SHIFT)
#define PORTCON_PORTB_SEL0_B7_VALUE_PWMP1_BRAKE0    4U
#define PORTCON_PORTB_SEL0_B7_BITS_PWMP1_BRAKE0     (PORTCON_PORTB_SEL0_B7_VALUE_PWMP1_BRAKE0 << PORTCON_PORTB_SEL0_B7_SHIFT)
#define PORTCON_PORTB_SEL0_B7_VALUE_PWMP0_CH1       5U
#define PORTCON_PORTB_SEL0_B7_BITS_PWMP0_CH1        (PORTCON_PORTB_SEL0_B7_VALUE_PWMP0_CH1 << PORTCON_PORTB_SEL0_B7_SHIFT)

#define PORTCON_PORTB_SEL1_ADDR                     (PORTCON_BASE_ADDR + 0x000CU)
#define PORTCON_PORTB_SEL1                          (*(volatile uint32_t *)PORTCON_PORTB_SEL1_ADDR)
#define PORTCON_PORTB_SEL1_B8_SHIFT                 0
#define PORTCON_PORTB_SEL1_B8_WIDTH                 4
#define PORTCON_PORTB_SEL1_B8_MASK                  (((1U << PORTCON_PORTB_SEL1_B8_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_GPIOB8          0U
#define PORTCON_PORTB_SEL1_B8_BITS_GPIOB8           (PORTCON_PORTB_SEL1_B8_VALUE_GPIOB8 << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_SPI0_CLK        1U
#define PORTCON_PORTB_SEL1_B8_BITS_SPI0_CLK         (PORTCON_PORTB_SEL1_B8_VALUE_SPI0_CLK << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_UART0_RX        2U
#define PORTCON_PORTB_SEL1_B8_BITS_UART0_RX         (PORTCON_PORTB_SEL1_B8_VALUE_UART0_RX << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_IIC0_SDA        3U
#define PORTCON_PORTB_SEL1_B8_BITS_IIC0_SDA         (PORTCON_PORTB_SEL1_B8_VALUE_IIC0_SDA << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_PWMB0_CH0       4U
#define PORTCON_PORTB_SEL1_B8_BITS_PWMB0_CH0        (PORTCON_PORTB_SEL1_B8_VALUE_PWMB0_CH0 << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_PWMP1_BRAKE1    5U
#define PORTCON_PORTB_SEL1_B8_BITS_PWMP1_BRAKE1     (PORTCON_PORTB_SEL1_B8_VALUE_PWMP1_BRAKE1 << PORTCON_PORTB_SEL1_B8_SHIFT)
#define PORTCON_PORTB_SEL1_B8_VALUE_PWMP0_CH2       6U
#define PORTCON_PORTB_SEL1_B8_BITS_PWMP0_CH2        (PORTCON_PORTB_SEL1_B8_VALUE_PWMP0_CH2 << PORTCON_PORTB_SEL1_B8_SHIFT)

#define PORTCON_PORTB_SEL1_B9_SHIFT                 4
#define PORTCON_PORTB_SEL1_B9_WIDTH                 4
#define PORTCON_PORTB_SEL1_B9_MASK                  (((1U << PORTCON_PORTB_SEL1_B9_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_GPIOB9          0U
#define PORTCON_PORTB_SEL1_B9_BITS_GPIOB9           (PORTCON_PORTB_SEL1_B9_VALUE_GPIOB9 << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_SPI0_MISO       1U
#define PORTCON_PORTB_SEL1_B9_BITS_SPI0_MISO        (PORTCON_PORTB_SEL1_B9_VALUE_SPI0_MISO << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_UART0_CTS       2U
#define PORTCON_PORTB_SEL1_B9_BITS_UART0_CTS        (PORTCON_PORTB_SEL1_B9_VALUE_UART0_CTS << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_PWMB0_CH1       3U
#define PORTCON_PORTB_SEL1_B9_BITS_PWMB0_CH1        (PORTCON_PORTB_SEL1_B9_VALUE_PWMB0_CH1 << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_PWMP1_CH0       4U
#define PORTCON_PORTB_SEL1_B9_BITS_PWMP1_CH0        (PORTCON_PORTB_SEL1_B9_VALUE_PWMP1_CH0 << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_TIMERP1_IN1     5U
#define PORTCON_PORTB_SEL1_B9_BITS_TIMERP1_IN1      (PORTCON_PORTB_SEL1_B9_VALUE_TIMERP1_IN1 << PORTCON_PORTB_SEL1_B9_SHIFT)
#define PORTCON_PORTB_SEL1_B9_VALUE_TIMERP1_OUT_H   6U
#define PORTCON_PORTB_SEL1_B9_BITS_TIMERP1_OUT_H    (PORTCON_PORTB_SEL1_B9_VALUE_TIMERP1_OUT_H << PORTCON_PORTB_SEL1_B9_SHIFT)

#define PORTCON_PORTB_SEL1_B10_SHIFT                8
#define PORTCON_PORTB_SEL1_B10_WIDTH                4
#define PORTCON_PORTB_SEL1_B10_MASK                 (((1U << PORTCON_PORTB_SEL1_B10_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_GPIOB10        0U
#define PORTCON_PORTB_SEL1_B10_BITS_GPIOB10         (PORTCON_PORTB_SEL1_B10_VALUE_GPIOB10 << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_SPI0_MOSI      1U
#define PORTCON_PORTB_SEL1_B10_BITS_SPI0_MOSI       (PORTCON_PORTB_SEL1_B10_VALUE_SPI0_MOSI << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_UART0_RTS      2U
#define PORTCON_PORTB_SEL1_B10_BITS_UART0_RTS       (PORTCON_PORTB_SEL1_B10_VALUE_UART0_RTS << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_PWMB0_CH2      3U
#define PORTCON_PORTB_SEL1_B10_BITS_PWMB0_CH2       (PORTCON_PORTB_SEL1_B10_VALUE_PWMB0_CH2 << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_PWMP1_CH1      4U
#define PORTCON_PORTB_SEL1_B10_BITS_PWMP1_CH1       (PORTCON_PORTB_SEL1_B10_VALUE_PWMP1_CH1 << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_PWMP0_PLUS0    5U
#define PORTCON_PORTB_SEL1_B10_BITS_PWMP0_PLUS0     (PORTCON_PORTB_SEL1_B10_VALUE_PWMP0_PLUS0 << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_TIMERP1_IN0    6U
#define PORTCON_PORTB_SEL1_B10_BITS_TIMERP1_IN0     (PORTCON_PORTB_SEL1_B10_VALUE_TIMERP1_IN0 << PORTCON_PORTB_SEL1_B10_SHIFT)
#define PORTCON_PORTB_SEL1_B10_VALUE_TIMERP1_OUT_L  7U
#define PORTCON_PORTB_SEL1_B10_BITS_TIMERP1_OUT_L   (PORTCON_PORTB_SEL1_B10_VALUE_TIMERP1_OUT_L << PORTCON_PORTB_SEL1_B10_SHIFT)

#define PORTCON_PORTB_SEL1_B11_SHIFT                12
#define PORTCON_PORTB_SEL1_B11_WIDTH                4
#define PORTCON_PORTB_SEL1_B11_MASK                 (((1U << PORTCON_PORTB_SEL1_B11_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B11_SHIFT)
#define PORTCON_PORTB_SEL1_B11_VALUE_GPIOB11        0U
#define PORTCON_PORTB_SEL1_B11_BITS_GPIOB11         (PORTCON_PORTB_SEL1_B11_VALUE_GPIOB11 << PORTCON_PORTB_SEL1_B11_SHIFT)
#define PORTCON_PORTB_SEL1_B11_VALUE_SWDIO          1U
#define PORTCON_PORTB_SEL1_B11_BITS_SWDIO           (PORTCON_PORTB_SEL1_B11_VALUE_SWDIO << PORTCON_PORTB_SEL1_B11_SHIFT)
#define PORTCON_PORTB_SEL1_B11_VALUE_PWMP1_CH2      2U
#define PORTCON_PORTB_SEL1_B11_BITS_PWMP1_CH2       (PORTCON_PORTB_SEL1_B11_VALUE_PWMP1_CH2 << PORTCON_PORTB_SEL1_B11_SHIFT)
#define PORTCON_PORTB_SEL1_B11_VALUE_PWMP0_BRAKE2   3U
#define PORTCON_PORTB_SEL1_B11_BITS_PWMP0_BRAKE2    (PORTCON_PORTB_SEL1_B11_VALUE_PWMP0_BRAKE2 << PORTCON_PORTB_SEL1_B11_SHIFT)

#define PORTCON_PORTB_SEL1_B12_SHIFT                16
#define PORTCON_PORTB_SEL1_B12_WIDTH                4
#define PORTCON_PORTB_SEL1_B12_MASK                 (((1U << PORTCON_PORTB_SEL1_B12_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B12_SHIFT)
#define PORTCON_PORTB_SEL1_B12_VALUE_GPIOB12        0U
#define PORTCON_PORTB_SEL1_B12_BITS_GPIOB12         (PORTCON_PORTB_SEL1_B12_VALUE_GPIOB12 << PORTCON_PORTB_SEL1_B12_SHIFT)
#define PORTCON_PORTB_SEL1_B12_VALUE_UART1_TX       1U
#define PORTCON_PORTB_SEL1_B12_BITS_UART1_TX        (PORTCON_PORTB_SEL1_B12_VALUE_UART1_TX << PORTCON_PORTB_SEL1_B12_SHIFT)
#define PORTCON_PORTB_SEL1_B12_VALUE_IIC1_SCL       2U
#define PORTCON_PORTB_SEL1_B12_BITS_IIC1_SCL        (PORTCON_PORTB_SEL1_B12_VALUE_IIC1_SCL << PORTCON_PORTB_SEL1_B12_SHIFT)
#define PORTCON_PORTB_SEL1_B12_VALUE_PWMP1_CH0N     3U
#define PORTCON_PORTB_SEL1_B12_BITS_PWMP1_CH0N      (PORTCON_PORTB_SEL1_B12_VALUE_PWMP1_CH0N << PORTCON_PORTB_SEL1_B12_SHIFT)

#define PORTCON_PORTB_SEL1_B13_SHIFT                20
#define PORTCON_PORTB_SEL1_B13_WIDTH                4
#define PORTCON_PORTB_SEL1_B13_MASK                 (((1U << PORTCON_PORTB_SEL1_B13_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B13_SHIFT)
#define PORTCON_PORTB_SEL1_B13_VALUE_GPIOB13        0U
#define PORTCON_PORTB_SEL1_B13_BITS_GPIOB13         (PORTCON_PORTB_SEL1_B13_VALUE_GPIOB13 << PORTCON_PORTB_SEL1_B13_SHIFT)
#define PORTCON_PORTB_SEL1_B13_VALUE_UART1_RX       1U
#define PORTCON_PORTB_SEL1_B13_BITS_UART1_RX        (PORTCON_PORTB_SEL1_B13_VALUE_UART1_RX << PORTCON_PORTB_SEL1_B13_SHIFT)
#define PORTCON_PORTB_SEL1_B13_VALUE_IIC1_SDA       2U
#define PORTCON_PORTB_SEL1_B13_BITS_IIC1_SDA        (PORTCON_PORTB_SEL1_B13_VALUE_IIC1_SDA << PORTCON_PORTB_SEL1_B13_SHIFT)
#define PORTCON_PORTB_SEL1_B13_VALUE_PWMP1_CH1N     3U
#define PORTCON_PORTB_SEL1_B13_BITS_PWMP1_CH1N      (PORTCON_PORTB_SEL1_B13_VALUE_PWMP1_CH1N << PORTCON_PORTB_SEL1_B13_SHIFT)

#define PORTCON_PORTB_SEL1_B14_SHIFT                24
#define PORTCON_PORTB_SEL1_B14_WIDTH                4
#define PORTCON_PORTB_SEL1_B14_MASK                 (((1U << PORTCON_PORTB_SEL1_B14_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B14_SHIFT)
#define PORTCON_PORTB_SEL1_B14_VALUE_GPIOB14        0U
#define PORTCON_PORTB_SEL1_B14_BITS_GPIOB14         (PORTCON_PORTB_SEL1_B14_VALUE_GPIOB14 << PORTCON_PORTB_SEL1_B14_SHIFT)
#define PORTCON_PORTB_SEL1_B14_VALUE_SWCLK          1U
#define PORTCON_PORTB_SEL1_B14_BITS_SWCLK           (PORTCON_PORTB_SEL1_B14_VALUE_SWCLK << PORTCON_PORTB_SEL1_B14_SHIFT)
#define PORTCON_PORTB_SEL1_B14_VALUE_UART2_TX       2U
#define PORTCON_PORTB_SEL1_B14_BITS_UART2_TX        (PORTCON_PORTB_SEL1_B14_VALUE_UART2_TX << PORTCON_PORTB_SEL1_B14_SHIFT)
#define PORTCON_PORTB_SEL1_B14_VALUE_PWMP1_CH2N     3U
#define PORTCON_PORTB_SEL1_B14_BITS_PWMP1_CH2N      (PORTCON_PORTB_SEL1_B14_VALUE_PWMP1_CH2N << PORTCON_PORTB_SEL1_B14_SHIFT)

#define PORTCON_PORTB_SEL1_B15_SHIFT                28
#define PORTCON_PORTB_SEL1_B15_WIDTH                4
#define PORTCON_PORTB_SEL1_B15_MASK                 (((1U << PORTCON_PORTB_SEL1_B15_WIDTH) - 1U) << PORTCON_PORTB_SEL1_B15_SHIFT)
#define PORTCON_PORTB_SEL1_B15_VALUE_GPIOB15        0U
#define PORTCON_PORTB_SEL1_B15_BITS_GPIOB15         (PORTCON_PORTB_SEL1_B15_VALUE_GPIOB15 << PORTCON_PORTB_SEL1_B15_SHIFT)
#define PORTCON_PORTB_SEL1_B15_VALUE_SPI1_SSN       1U
#define PORTCON_PORTB_SEL1_B15_BITS_SPI1_SSN        (PORTCON_PORTB_SEL1_B15_VALUE_SPI1_SSN << PORTCON_PORTB_SEL1_B15_SHIFT)
#define PORTCON_PORTB_SEL1_B15_VALUE_UART2_RX       2U
#define PORTCON_PORTB_SEL1_B15_BITS_UART2_RX        (PORTCON_PORTB_SEL1_B15_VALUE_UART2_RX << PORTCON_PORTB_SEL1_B15_SHIFT)

#define PORTCON_PORTC_SEL0_ADDR                     (PORTCON_BASE_ADDR + 0x0010U)
#define PORTCON_PORTC_SEL0                          (*(volatile uint32_t *)PORTCON_PORTC_SEL0_ADDR)
#define PORTCON_PORTC_SEL0_C0_SHIFT                 0
#define PORTCON_PORTC_SEL0_C0_WIDTH                 4
#define PORTCON_PORTC_SEL0_C0_MASK                  (((1U << PORTCON_PORTC_SEL0_C0_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C0_SHIFT)
#define PORTCON_PORTC_SEL0_C0_VALUE_GPIOC0          0U
#define PORTCON_PORTC_SEL0_C0_BITS_GPIOC0           (PORTCON_PORTC_SEL0_C0_VALUE_GPIOC0 << PORTCON_PORTC_SEL0_C0_SHIFT)
#define PORTCON_PORTC_SEL0_C0_VALUE_SPI1_CLK        1U
#define PORTCON_PORTC_SEL0_C0_BITS_SPI1_CLK         (PORTCON_PORTC_SEL0_C0_VALUE_SPI1_CLK << PORTCON_PORTC_SEL0_C0_SHIFT)
#define PORTCON_PORTC_SEL0_C0_VALUE_UART2_CTS       2U
#define PORTCON_PORTC_SEL0_C0_BITS_UART2_CTS        (PORTCON_PORTC_SEL0_C0_VALUE_UART2_CTS << PORTCON_PORTC_SEL0_C0_SHIFT)
#define PORTCON_PORTC_SEL0_C0_VALUE_PWMB1_CH0       3U
#define PORTCON_PORTC_SEL0_C0_BITS_PWMB1_CH0        (PORTCON_PORTC_SEL0_C0_VALUE_PWMB1_CH0 << PORTCON_PORTC_SEL0_C0_SHIFT)

#define PORTCON_PORTC_SEL0_C1_SHIFT                 4
#define PORTCON_PORTC_SEL0_C1_WIDTH                 4
#define PORTCON_PORTC_SEL0_C1_MASK                  (((1U << PORTCON_PORTC_SEL0_C1_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C1_SHIFT)
#define PORTCON_PORTC_SEL0_C1_VALUE_GPIOC1          0U
#define PORTCON_PORTC_SEL0_C1_BITS_GPIOC1           (PORTCON_PORTC_SEL0_C1_VALUE_GPIOC1 << PORTCON_PORTC_SEL0_C1_SHIFT)
#define PORTCON_PORTC_SEL0_C1_VALUE_SPI1_MISO       1U
#define PORTCON_PORTC_SEL0_C1_BITS_SPI1_MISO        (PORTCON_PORTC_SEL0_C1_VALUE_SPI1_MISO << PORTCON_PORTC_SEL0_C1_SHIFT)
#define PORTCON_PORTC_SEL0_C1_VALUE_UART2_RTS       2U
#define PORTCON_PORTC_SEL0_C1_BITS_UART2_RTS        (PORTCON_PORTC_SEL0_C1_VALUE_UART2_RTS << PORTCON_PORTC_SEL0_C1_SHIFT)
#define PORTCON_PORTC_SEL0_C1_VALUE_PWMB1_CH1       3U
#define PORTCON_PORTC_SEL0_C1_BITS_PWMB1_CH1        (PORTCON_PORTC_SEL0_C1_VALUE_PWMB1_CH1 << PORTCON_PORTC_SEL0_C1_SHIFT)
#define PORTCON_PORTC_SEL0_C1_VALUE_TIMERP0_IN0     4U
#define PORTCON_PORTC_SEL0_C1_BITS_TIMERP0_IN0      (PORTCON_PORTC_SEL0_C1_VALUE_TIMERP0_IN0 << PORTCON_PORTC_SEL0_C1_SHIFT)
#define PORTCON_PORTC_SEL0_C1_VALUE_TIMERP0_OUT_L   5U
#define PORTCON_PORTC_SEL0_C1_BITS_TIMERP0_OUT_L    (PORTCON_PORTC_SEL0_C1_VALUE_TIMERP0_OUT_L << PORTCON_PORTC_SEL0_C1_SHIFT)

#define PORTCON_PORTC_SEL0_C2_SHIFT                 8
#define PORTCON_PORTC_SEL0_C2_WIDTH                 4
#define PORTCON_PORTC_SEL0_C2_MASK                  (((1U << PORTCON_PORTC_SEL0_C2_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C2_SHIFT)
#define PORTCON_PORTC_SEL0_C2_VALUE_GPIOC2          0U
#define PORTCON_PORTC_SEL0_C2_BITS_GPIOC2           (PORTCON_PORTC_SEL0_C2_VALUE_GPIOC2 << PORTCON_PORTC_SEL0_C2_SHIFT)
#define PORTCON_PORTC_SEL0_C2_VALUE_SPI1_MOSI       1U
#define PORTCON_PORTC_SEL0_C2_BITS_SPI1_MOSI        (PORTCON_PORTC_SEL0_C2_VALUE_SPI1_MOSI << PORTCON_PORTC_SEL0_C2_SHIFT)
#define PORTCON_PORTC_SEL0_C2_VALUE_PWMB1_CH2       2U
#define PORTCON_PORTC_SEL0_C2_BITS_PWMB1_CH2        (PORTCON_PORTC_SEL0_C2_VALUE_PWMB1_CH2 << PORTCON_PORTC_SEL0_C2_SHIFT)
#define PORTCON_PORTC_SEL0_C2_VALUE_PWMP1_BRAKE2    3U
#define PORTCON_PORTC_SEL0_C2_BITS_PWMP1_BRAKE2     (PORTCON_PORTC_SEL0_C2_VALUE_PWMP1_BRAKE2 << PORTCON_PORTC_SEL0_C2_SHIFT)
#define PORTCON_PORTC_SEL0_C2_VALUE_TIMERP0_IN1     4U
#define PORTCON_PORTC_SEL0_C2_BITS_TIMERP0_IN1      (PORTCON_PORTC_SEL0_C2_VALUE_TIMERP0_IN1 << PORTCON_PORTC_SEL0_C2_SHIFT)
#define PORTCON_PORTC_SEL0_C2_VALUE_TIMERP0_OUT_H   5U
#define PORTCON_PORTC_SEL0_C2_BITS_TIMERP0_OUT_H    (PORTCON_PORTC_SEL0_C2_VALUE_TIMERP0_OUT_H << PORTCON_PORTC_SEL0_C2_SHIFT)

#define PORTCON_PORTC_SEL0_C3_SHIFT                 12
#define PORTCON_PORTC_SEL0_C3_WIDTH                 4
#define PORTCON_PORTC_SEL0_C3_MASK                  (((1U << PORTCON_PORTC_SEL0_C3_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C3_SHIFT)
#define PORTCON_PORTC_SEL0_C3_VALUE_GPIOC3          0U
#define PORTCON_PORTC_SEL0_C3_BITS_GPIOC3           (PORTCON_PORTC_SEL0_C3_VALUE_GPIOC3 << PORTCON_PORTC_SEL0_C3_SHIFT)
#define PORTCON_PORTC_SEL0_C3_VALUE_UART0_TX        1U
#define PORTCON_PORTC_SEL0_C3_BITS_UART0_TX         (PORTCON_PORTC_SEL0_C3_VALUE_UART0_TX << PORTCON_PORTC_SEL0_C3_SHIFT)
#define PORTCON_PORTC_SEL0_C3_VALUE_IIC0_SCL        2U
#define PORTCON_PORTC_SEL0_C3_BITS_IIC0_SCL         (PORTCON_PORTC_SEL0_C3_VALUE_IIC0_SCL << PORTCON_PORTC_SEL0_C3_SHIFT)
#define PORTCON_PORTC_SEL0_C3_VALUE_PWMP1_CH1N      3U
#define PORTCON_PORTC_SEL0_C3_BITS_PWMP1_CH1N       (PORTCON_PORTC_SEL0_C3_VALUE_PWMP1_CH1N << PORTCON_PORTC_SEL0_C3_SHIFT)
#define PORTCON_PORTC_SEL0_C3_VALUE_TIMERP0_HALL0   4U
#define PORTCON_PORTC_SEL0_C3_BITS_TIMERP0_HALL0    (PORTCON_PORTC_SEL0_C3_VALUE_TIMERP0_HALL0 << PORTCON_PORTC_SEL0_C3_SHIFT)
#define PORTCON_PORTC_SEL0_C3_VALUE_CMP2_VN         5U
#define PORTCON_PORTC_SEL0_C3_BITS_CMP2_VN          (PORTCON_PORTC_SEL0_C3_VALUE_CMP2_VN << PORTCON_PORTC_SEL0_C3_SHIFT)

#define PORTCON_PORTC_SEL0_C4_SHIFT                 16
#define PORTCON_PORTC_SEL0_C4_WIDTH                 4
#define PORTCON_PORTC_SEL0_C4_MASK                  (((1U << PORTCON_PORTC_SEL0_C4_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C4_SHIFT)
#define PORTCON_PORTC_SEL0_C4_VALUE_GPIOC4          0U
#define PORTCON_PORTC_SEL0_C4_BITS_GPIOC4           (PORTCON_PORTC_SEL0_C4_VALUE_GPIOC4 << PORTCON_PORTC_SEL0_C4_SHIFT)
#define PORTCON_PORTC_SEL0_C4_VALUE_UART0_RX        1U
#define PORTCON_PORTC_SEL0_C4_BITS_UART0_RX         (PORTCON_PORTC_SEL0_C4_VALUE_UART0_RX << PORTCON_PORTC_SEL0_C4_SHIFT)
#define PORTCON_PORTC_SEL0_C4_VALUE_IIC0_SDA        2U
#define PORTCON_PORTC_SEL0_C4_BITS_IIC0_SDA         (PORTCON_PORTC_SEL0_C4_VALUE_IIC0_SDA << PORTCON_PORTC_SEL0_C4_SHIFT)
#define PORTCON_PORTC_SEL0_C4_VALUE_PWMP1_CH2N      3U
#define PORTCON_PORTC_SEL0_C4_BITS_PWMP1_CH2N       (PORTCON_PORTC_SEL0_C4_VALUE_PWMP1_CH2N << PORTCON_PORTC_SEL0_C4_SHIFT)
#define PORTCON_PORTC_SEL0_C4_VALUE_TIMERP0_HALL1   4U
#define PORTCON_PORTC_SEL0_C4_BITS_TIMERP0_HALL1    (PORTCON_PORTC_SEL0_C4_VALUE_TIMERP0_HALL1 << PORTCON_PORTC_SEL0_C4_SHIFT)
#define PORTCON_PORTC_SEL0_C4_VALUE_CMP2_VP         5U
#define PORTCON_PORTC_SEL0_C4_BITS_CMP2_VP          (PORTCON_PORTC_SEL0_C4_VALUE_CMP2_VP << PORTCON_PORTC_SEL0_C4_SHIFT)

#define PORTCON_PORTC_SEL0_C5_SHIFT                 20
#define PORTCON_PORTC_SEL0_C5_WIDTH                 4
#define PORTCON_PORTC_SEL0_C5_MASK                  (((1U << PORTCON_PORTC_SEL0_C5_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C5_SHIFT)
#define PORTCON_PORTC_SEL0_C5_VALUE_GPIOC5          0U
#define PORTCON_PORTC_SEL0_C5_BITS_GPIOC5           (PORTCON_PORTC_SEL0_C5_VALUE_GPIOC5 << PORTCON_PORTC_SEL0_C5_SHIFT)
#define PORTCON_PORTC_SEL0_C5_VALUE_TIMERP0_HALL2   1U
#define PORTCON_PORTC_SEL0_C5_BITS_TIMERP0_HALL2    (PORTCON_PORTC_SEL0_C5_VALUE_TIMERP0_HALL2 << PORTCON_PORTC_SEL0_C5_SHIFT)
#define PORTCON_PORTC_SEL0_C5_VALUE_TM              2U
#define PORTCON_PORTC_SEL0_C5_BITS_TM               (PORTCON_PORTC_SEL0_C5_VALUE_TM << PORTCON_PORTC_SEL0_C5_SHIFT)
#define PORTCON_PORTC_SEL0_C5_VALUE_OPA1_VP         3U
#define PORTCON_PORTC_SEL0_C5_BITS_OPA1_VP          (PORTCON_PORTC_SEL0_C5_VALUE_OPA1_VP << PORTCON_PORTC_SEL0_C5_SHIFT)

#define PORTCON_PORTC_SEL0_C6_SHIFT                 24
#define PORTCON_PORTC_SEL0_C6_WIDTH                 4
#define PORTCON_PORTC_SEL0_C6_MASK                  (((1U << PORTCON_PORTC_SEL0_C6_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C6_SHIFT)
#define PORTCON_PORTC_SEL0_C6_VALUE_GPIOC6          0U
#define PORTCON_PORTC_SEL0_C6_BITS_GPIOC6           (PORTCON_PORTC_SEL0_C6_VALUE_GPIOC6 << PORTCON_PORTC_SEL0_C6_SHIFT)
#define PORTCON_PORTC_SEL0_C6_VALUE_IIC1_SCL        1U
#define PORTCON_PORTC_SEL0_C6_BITS_IIC1_SCL         (PORTCON_PORTC_SEL0_C6_VALUE_IIC1_SCL << PORTCON_PORTC_SEL0_C6_SHIFT)
#define PORTCON_PORTC_SEL0_C6_VALUE_PWMP1_CH1       2U
#define PORTCON_PORTC_SEL0_C6_BITS_PWMP1_CH1        (PORTCON_PORTC_SEL0_C6_VALUE_PWMP1_CH1 << PORTCON_PORTC_SEL0_C6_SHIFT)
#define PORTCON_PORTC_SEL0_C6_VALUE_TIMERP1_IN1     3U
#define PORTCON_PORTC_SEL0_C6_BITS_TIMERP1_IN1      (PORTCON_PORTC_SEL0_C6_VALUE_TIMERP1_IN1 << PORTCON_PORTC_SEL0_C6_SHIFT)
#define PORTCON_PORTC_SEL0_C6_VALUE_TIMERP1_OUT_H   4U
#define PORTCON_PORTC_SEL0_C6_BITS_TIMERP1_OUT_H    (PORTCON_PORTC_SEL0_C6_VALUE_TIMERP1_OUT_H << PORTCON_PORTC_SEL0_C6_SHIFT)
#define PORTCON_PORTC_SEL0_C6_VALUE_OPA1_VN         5U
#define PORTCON_PORTC_SEL0_C6_BITS_OPA1_VN          (PORTCON_PORTC_SEL0_C6_VALUE_OPA1_VN << PORTCON_PORTC_SEL0_C6_SHIFT)

#define PORTCON_PORTC_SEL0_C7_SHIFT                 28
#define PORTCON_PORTC_SEL0_C7_WIDTH                 4
#define PORTCON_PORTC_SEL0_C7_MASK                  (((1U << PORTCON_PORTC_SEL0_C7_WIDTH) - 1U) << PORTCON_PORTC_SEL0_C7_SHIFT)
#define PORTCON_PORTC_SEL0_C7_VALUE_GPIOC7          0U
#define PORTCON_PORTC_SEL0_C7_BITS_GPIOC7           (PORTCON_PORTC_SEL0_C7_VALUE_GPIOC7 << PORTCON_PORTC_SEL0_C7_SHIFT)
#define PORTCON_PORTC_SEL0_C7_VALUE_IIC1_SDA        1U
#define PORTCON_PORTC_SEL0_C7_BITS_IIC1_SDA         (PORTCON_PORTC_SEL0_C7_VALUE_IIC1_SDA << PORTCON_PORTC_SEL0_C7_SHIFT)
#define PORTCON_PORTC_SEL0_C7_VALUE_PWMP1_CH2       2U
#define PORTCON_PORTC_SEL0_C7_BITS_PWMP1_CH2        (PORTCON_PORTC_SEL0_C7_VALUE_PWMP1_CH2 << PORTCON_PORTC_SEL0_C7_SHIFT)
#define PORTCON_PORTC_SEL0_C7_VALUE_TIMERP1_IN0     3U
#define PORTCON_PORTC_SEL0_C7_BITS_TIMERP1_IN0      (PORTCON_PORTC_SEL0_C7_VALUE_TIMERP1_IN0 << PORTCON_PORTC_SEL0_C7_SHIFT)
#define PORTCON_PORTC_SEL0_C7_VALUE_TIMERP1_OUT_L   4U
#define PORTCON_PORTC_SEL0_C7_BITS_TIMERP1_OUT_L    (PORTCON_PORTC_SEL0_C7_VALUE_TIMERP1_OUT_L << PORTCON_PORTC_SEL0_C7_SHIFT)
#define PORTCON_PORTC_SEL0_C7_VALUE_OPA1_OUT        5U
#define PORTCON_PORTC_SEL0_C7_BITS_OPA1_OUT         (PORTCON_PORTC_SEL0_C7_VALUE_OPA1_OUT << PORTCON_PORTC_SEL0_C7_SHIFT)

#define PORTCON_PORTA_IE_ADDR                       (PORTCON_BASE_ADDR + 0x0100U)
#define PORTCON_PORTA_IE                            (*(volatile uint32_t *)PORTCON_PORTA_IE_ADDR)
#define PORTCON_PORTA_IE_A0_SHIFT                   0
#define PORTCON_PORTA_IE_A0_WIDTH                   1
#define PORTCON_PORTA_IE_A0_MASK                    (((1U << PORTCON_PORTA_IE_A0_WIDTH) - 1U) << PORTCON_PORTA_IE_A0_SHIFT)
#define PORTCON_PORTA_IE_A0_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A0_BITS_DISABLE            (PORTCON_PORTA_IE_A0_VALUE_DISABLE << PORTCON_PORTA_IE_A0_SHIFT)
#define PORTCON_PORTA_IE_A0_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A0_BITS_ENABLE             (PORTCON_PORTA_IE_A0_VALUE_ENABLE << PORTCON_PORTA_IE_A0_SHIFT)

#define PORTCON_PORTA_IE_A1_SHIFT                   1
#define PORTCON_PORTA_IE_A1_WIDTH                   1
#define PORTCON_PORTA_IE_A1_MASK                    (((1U << PORTCON_PORTA_IE_A1_WIDTH) - 1U) << PORTCON_PORTA_IE_A1_SHIFT)
#define PORTCON_PORTA_IE_A1_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A1_BITS_DISABLE            (PORTCON_PORTA_IE_A1_VALUE_DISABLE << PORTCON_PORTA_IE_A1_SHIFT)
#define PORTCON_PORTA_IE_A1_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A1_BITS_ENABLE             (PORTCON_PORTA_IE_A1_VALUE_ENABLE << PORTCON_PORTA_IE_A1_SHIFT)

#define PORTCON_PORTA_IE_A2_SHIFT                   2
#define PORTCON_PORTA_IE_A2_WIDTH                   1
#define PORTCON_PORTA_IE_A2_MASK                    (((1U << PORTCON_PORTA_IE_A2_WIDTH) - 1U) << PORTCON_PORTA_IE_A2_SHIFT)
#define PORTCON_PORTA_IE_A2_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A2_BITS_DISABLE            (PORTCON_PORTA_IE_A2_VALUE_DISABLE << PORTCON_PORTA_IE_A2_SHIFT)
#define PORTCON_PORTA_IE_A2_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A2_BITS_ENABLE             (PORTCON_PORTA_IE_A2_VALUE_ENABLE << PORTCON_PORTA_IE_A2_SHIFT)

#define PORTCON_PORTA_IE_A3_SHIFT                   3
#define PORTCON_PORTA_IE_A3_WIDTH                   1
#define PORTCON_PORTA_IE_A3_MASK                    (((1U << PORTCON_PORTA_IE_A3_WIDTH) - 1U) << PORTCON_PORTA_IE_A3_SHIFT)
#define PORTCON_PORTA_IE_A3_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A3_BITS_DISABLE            (PORTCON_PORTA_IE_A3_VALUE_DISABLE << PORTCON_PORTA_IE_A3_SHIFT)
#define PORTCON_PORTA_IE_A3_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A3_BITS_ENABLE             (PORTCON_PORTA_IE_A3_VALUE_ENABLE << PORTCON_PORTA_IE_A3_SHIFT)

#define PORTCON_PORTA_IE_A4_SHIFT                   4
#define PORTCON_PORTA_IE_A4_WIDTH                   1
#define PORTCON_PORTA_IE_A4_MASK                    (((1U << PORTCON_PORTA_IE_A4_WIDTH) - 1U) << PORTCON_PORTA_IE_A4_SHIFT)
#define PORTCON_PORTA_IE_A4_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A4_BITS_DISABLE            (PORTCON_PORTA_IE_A4_VALUE_DISABLE << PORTCON_PORTA_IE_A4_SHIFT)
#define PORTCON_PORTA_IE_A4_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A4_BITS_ENABLE             (PORTCON_PORTA_IE_A4_VALUE_ENABLE << PORTCON_PORTA_IE_A4_SHIFT)

#define PORTCON_PORTA_IE_A5_SHIFT                   5
#define PORTCON_PORTA_IE_A5_WIDTH                   1
#define PORTCON_PORTA_IE_A5_MASK                    (((1U << PORTCON_PORTA_IE_A5_WIDTH) - 1U) << PORTCON_PORTA_IE_A5_SHIFT)
#define PORTCON_PORTA_IE_A5_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A5_BITS_DISABLE            (PORTCON_PORTA_IE_A5_VALUE_DISABLE << PORTCON_PORTA_IE_A5_SHIFT)
#define PORTCON_PORTA_IE_A5_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A5_BITS_ENABLE             (PORTCON_PORTA_IE_A5_VALUE_ENABLE << PORTCON_PORTA_IE_A5_SHIFT)

#define PORTCON_PORTA_IE_A6_SHIFT                   6
#define PORTCON_PORTA_IE_A6_WIDTH                   1
#define PORTCON_PORTA_IE_A6_MASK                    (((1U << PORTCON_PORTA_IE_A6_WIDTH) - 1U) << PORTCON_PORTA_IE_A6_SHIFT)
#define PORTCON_PORTA_IE_A6_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A6_BITS_DISABLE            (PORTCON_PORTA_IE_A6_VALUE_DISABLE << PORTCON_PORTA_IE_A6_SHIFT)
#define PORTCON_PORTA_IE_A6_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A6_BITS_ENABLE             (PORTCON_PORTA_IE_A6_VALUE_ENABLE << PORTCON_PORTA_IE_A6_SHIFT)

#define PORTCON_PORTA_IE_A7_SHIFT                   7
#define PORTCON_PORTA_IE_A7_WIDTH                   1
#define PORTCON_PORTA_IE_A7_MASK                    (((1U << PORTCON_PORTA_IE_A7_WIDTH) - 1U) << PORTCON_PORTA_IE_A7_SHIFT)
#define PORTCON_PORTA_IE_A7_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A7_BITS_DISABLE            (PORTCON_PORTA_IE_A7_VALUE_DISABLE << PORTCON_PORTA_IE_A7_SHIFT)
#define PORTCON_PORTA_IE_A7_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A7_BITS_ENABLE             (PORTCON_PORTA_IE_A7_VALUE_ENABLE << PORTCON_PORTA_IE_A7_SHIFT)

#define PORTCON_PORTA_IE_A8_SHIFT                   8
#define PORTCON_PORTA_IE_A8_WIDTH                   1
#define PORTCON_PORTA_IE_A8_MASK                    (((1U << PORTCON_PORTA_IE_A8_WIDTH) - 1U) << PORTCON_PORTA_IE_A8_SHIFT)
#define PORTCON_PORTA_IE_A8_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A8_BITS_DISABLE            (PORTCON_PORTA_IE_A8_VALUE_DISABLE << PORTCON_PORTA_IE_A8_SHIFT)
#define PORTCON_PORTA_IE_A8_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A8_BITS_ENABLE             (PORTCON_PORTA_IE_A8_VALUE_ENABLE << PORTCON_PORTA_IE_A8_SHIFT)

#define PORTCON_PORTA_IE_A9_SHIFT                   9
#define PORTCON_PORTA_IE_A9_WIDTH                   1
#define PORTCON_PORTA_IE_A9_MASK                    (((1U << PORTCON_PORTA_IE_A9_WIDTH) - 1U) << PORTCON_PORTA_IE_A9_SHIFT)
#define PORTCON_PORTA_IE_A9_VALUE_DISABLE           0U
#define PORTCON_PORTA_IE_A9_BITS_DISABLE            (PORTCON_PORTA_IE_A9_VALUE_DISABLE << PORTCON_PORTA_IE_A9_SHIFT)
#define PORTCON_PORTA_IE_A9_VALUE_ENABLE            1U
#define PORTCON_PORTA_IE_A9_BITS_ENABLE             (PORTCON_PORTA_IE_A9_VALUE_ENABLE << PORTCON_PORTA_IE_A9_SHIFT)

#define PORTCON_PORTA_IE_A10_SHIFT                  10
#define PORTCON_PORTA_IE_A10_WIDTH                  1
#define PORTCON_PORTA_IE_A10_MASK                   (((1U << PORTCON_PORTA_IE_A10_WIDTH) - 1U) << PORTCON_PORTA_IE_A10_SHIFT)
#define PORTCON_PORTA_IE_A10_VALUE_DISABLE          0U
#define PORTCON_PORTA_IE_A10_BITS_DISABLE           (PORTCON_PORTA_IE_A10_VALUE_DISABLE << PORTCON_PORTA_IE_A10_SHIFT)
#define PORTCON_PORTA_IE_A10_VALUE_ENABLE           1U
#define PORTCON_PORTA_IE_A10_BITS_ENABLE            (PORTCON_PORTA_IE_A10_VALUE_ENABLE << PORTCON_PORTA_IE_A10_SHIFT)

#define PORTCON_PORTA_IE_A11_SHIFT                  11
#define PORTCON_PORTA_IE_A11_WIDTH                  1
#define PORTCON_PORTA_IE_A11_MASK                   (((1U << PORTCON_PORTA_IE_A11_WIDTH) - 1U) << PORTCON_PORTA_IE_A11_SHIFT)
#define PORTCON_PORTA_IE_A11_VALUE_DISABLE          0U
#define PORTCON_PORTA_IE_A11_BITS_DISABLE           (PORTCON_PORTA_IE_A11_VALUE_DISABLE << PORTCON_PORTA_IE_A11_SHIFT)
#define PORTCON_PORTA_IE_A11_VALUE_ENABLE           1U
#define PORTCON_PORTA_IE_A11_BITS_ENABLE            (PORTCON_PORTA_IE_A11_VALUE_ENABLE << PORTCON_PORTA_IE_A11_SHIFT)

#define PORTCON_PORTA_IE_A12_SHIFT                  12
#define PORTCON_PORTA_IE_A12_WIDTH                  1
#define PORTCON_PORTA_IE_A12_MASK                   (((1U << PORTCON_PORTA_IE_A12_WIDTH) - 1U) << PORTCON_PORTA_IE_A12_SHIFT)
#define PORTCON_PORTA_IE_A12_VALUE_DISABLE          0U
#define PORTCON_PORTA_IE_A12_BITS_DISABLE           (PORTCON_PORTA_IE_A12_VALUE_DISABLE << PORTCON_PORTA_IE_A12_SHIFT)
#define PORTCON_PORTA_IE_A12_VALUE_ENABLE           1U
#define PORTCON_PORTA_IE_A12_BITS_ENABLE            (PORTCON_PORTA_IE_A12_VALUE_ENABLE << PORTCON_PORTA_IE_A12_SHIFT)

#define PORTCON_PORTA_IE_A13_SHIFT                  13
#define PORTCON_PORTA_IE_A13_WIDTH                  1
#define PORTCON_PORTA_IE_A13_MASK                   (((1U << PORTCON_PORTA_IE_A13_WIDTH) - 1U) << PORTCON_PORTA_IE_A13_SHIFT)
#define PORTCON_PORTA_IE_A13_VALUE_DISABLE          0U
#define PORTCON_PORTA_IE_A13_BITS_DISABLE           (PORTCON_PORTA_IE_A13_VALUE_DISABLE << PORTCON_PORTA_IE_A13_SHIFT)
#define PORTCON_PORTA_IE_A13_VALUE_ENABLE           1U
#define PORTCON_PORTA_IE_A13_BITS_ENABLE            (PORTCON_PORTA_IE_A13_VALUE_ENABLE << PORTCON_PORTA_IE_A13_SHIFT)

#define PORTCON_PORTA_IE_A14_SHIFT                  14
#define PORTCON_PORTA_IE_A14_WIDTH                  1
#define PORTCON_PORTA_IE_A14_MASK                   (((1U << PORTCON_PORTA_IE_A14_WIDTH) - 1U) << PORTCON_PORTA_IE_A14_SHIFT)
#define PORTCON_PORTA_IE_A14_VALUE_DISABLE          0U
#define PORTCON_PORTA_IE_A14_BITS_DISABLE           (PORTCON_PORTA_IE_A14_VALUE_DISABLE << PORTCON_PORTA_IE_A14_SHIFT)
#define PORTCON_PORTA_IE_A14_VALUE_ENABLE           1U
#define PORTCON_PORTA_IE_A14_BITS_ENABLE            (PORTCON_PORTA_IE_A14_VALUE_ENABLE << PORTCON_PORTA_IE_A14_SHIFT)

#define PORTCON_PORTA_IE_A15_SHIFT                  15
#define PORTCON_PORTA_IE_A15_WIDTH                  1
#define PORTCON_PORTA_IE_A15_MASK                   (((1U << PORTCON_PORTA_IE_A15_WIDTH) - 1U) << PORTCON_PORTA_IE_A15_SHIFT)
#define PORTCON_PORTA_IE_A15_VALUE_DISABLE          0U
#define PORTCON_PORTA_IE_A15_BITS_DISABLE           (PORTCON_PORTA_IE_A15_VALUE_DISABLE << PORTCON_PORTA_IE_A15_SHIFT)
#define PORTCON_PORTA_IE_A15_VALUE_ENABLE           1U
#define PORTCON_PORTA_IE_A15_BITS_ENABLE            (PORTCON_PORTA_IE_A15_VALUE_ENABLE << PORTCON_PORTA_IE_A15_SHIFT)

#define PORTCON_PORTB_IE_ADDR                       (PORTCON_BASE_ADDR + 0x0104U)
#define PORTCON_PORTB_IE                            (*(volatile uint32_t *)PORTCON_PORTB_IE_ADDR)
#define PORTCON_PORTB_IE_B0_SHIFT                   0
#define PORTCON_PORTB_IE_B0_WIDTH                   1
#define PORTCON_PORTB_IE_B0_MASK                    (((1U << PORTCON_PORTB_IE_B0_WIDTH) - 1U) << PORTCON_PORTB_IE_B0_SHIFT)
#define PORTCON_PORTB_IE_B0_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B0_BITS_DISABLE            (PORTCON_PORTB_IE_B0_VALUE_DISABLE << PORTCON_PORTB_IE_B0_SHIFT)
#define PORTCON_PORTB_IE_B0_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B0_BITS_ENABLE             (PORTCON_PORTB_IE_B0_VALUE_ENABLE << PORTCON_PORTB_IE_B0_SHIFT)

#define PORTCON_PORTB_IE_B1_SHIFT                   1
#define PORTCON_PORTB_IE_B1_WIDTH                   1
#define PORTCON_PORTB_IE_B1_MASK                    (((1U << PORTCON_PORTB_IE_B1_WIDTH) - 1U) << PORTCON_PORTB_IE_B1_SHIFT)
#define PORTCON_PORTB_IE_B1_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B1_BITS_DISABLE            (PORTCON_PORTB_IE_B1_VALUE_DISABLE << PORTCON_PORTB_IE_B1_SHIFT)
#define PORTCON_PORTB_IE_B1_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B1_BITS_ENABLE             (PORTCON_PORTB_IE_B1_VALUE_ENABLE << PORTCON_PORTB_IE_B1_SHIFT)

#define PORTCON_PORTB_IE_B2_SHIFT                   2
#define PORTCON_PORTB_IE_B2_WIDTH                   1
#define PORTCON_PORTB_IE_B2_MASK                    (((1U << PORTCON_PORTB_IE_B2_WIDTH) - 1U) << PORTCON_PORTB_IE_B2_SHIFT)
#define PORTCON_PORTB_IE_B2_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B2_BITS_DISABLE            (PORTCON_PORTB_IE_B2_VALUE_DISABLE << PORTCON_PORTB_IE_B2_SHIFT)
#define PORTCON_PORTB_IE_B2_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B2_BITS_ENABLE             (PORTCON_PORTB_IE_B2_VALUE_ENABLE << PORTCON_PORTB_IE_B2_SHIFT)

#define PORTCON_PORTB_IE_B3_SHIFT                   3
#define PORTCON_PORTB_IE_B3_WIDTH                   1
#define PORTCON_PORTB_IE_B3_MASK                    (((1U << PORTCON_PORTB_IE_B3_WIDTH) - 1U) << PORTCON_PORTB_IE_B3_SHIFT)
#define PORTCON_PORTB_IE_B3_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B3_BITS_DISABLE            (PORTCON_PORTB_IE_B3_VALUE_DISABLE << PORTCON_PORTB_IE_B3_SHIFT)
#define PORTCON_PORTB_IE_B3_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B3_BITS_ENABLE             (PORTCON_PORTB_IE_B3_VALUE_ENABLE << PORTCON_PORTB_IE_B3_SHIFT)

#define PORTCON_PORTB_IE_B4_SHIFT                   4
#define PORTCON_PORTB_IE_B4_WIDTH                   1
#define PORTCON_PORTB_IE_B4_MASK                    (((1U << PORTCON_PORTB_IE_B4_WIDTH) - 1U) << PORTCON_PORTB_IE_B4_SHIFT)
#define PORTCON_PORTB_IE_B4_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B4_BITS_DISABLE            (PORTCON_PORTB_IE_B4_VALUE_DISABLE << PORTCON_PORTB_IE_B4_SHIFT)
#define PORTCON_PORTB_IE_B4_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B4_BITS_ENABLE             (PORTCON_PORTB_IE_B4_VALUE_ENABLE << PORTCON_PORTB_IE_B4_SHIFT)

#define PORTCON_PORTB_IE_B5_SHIFT                   5
#define PORTCON_PORTB_IE_B5_WIDTH                   1
#define PORTCON_PORTB_IE_B5_MASK                    (((1U << PORTCON_PORTB_IE_B5_WIDTH) - 1U) << PORTCON_PORTB_IE_B5_SHIFT)
#define PORTCON_PORTB_IE_B5_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B5_BITS_DISABLE            (PORTCON_PORTB_IE_B5_VALUE_DISABLE << PORTCON_PORTB_IE_B5_SHIFT)
#define PORTCON_PORTB_IE_B5_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B5_BITS_ENABLE             (PORTCON_PORTB_IE_B5_VALUE_ENABLE << PORTCON_PORTB_IE_B5_SHIFT)

#define PORTCON_PORTB_IE_B6_SHIFT                   6
#define PORTCON_PORTB_IE_B6_WIDTH                   1
#define PORTCON_PORTB_IE_B6_MASK                    (((1U << PORTCON_PORTB_IE_B6_WIDTH) - 1U) << PORTCON_PORTB_IE_B6_SHIFT)
#define PORTCON_PORTB_IE_B6_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B6_BITS_DISABLE            (PORTCON_PORTB_IE_B6_VALUE_DISABLE << PORTCON_PORTB_IE_B6_SHIFT)
#define PORTCON_PORTB_IE_B6_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B6_BITS_ENABLE             (PORTCON_PORTB_IE_B6_VALUE_ENABLE << PORTCON_PORTB_IE_B6_SHIFT)

#define PORTCON_PORTB_IE_B7_SHIFT                   7
#define PORTCON_PORTB_IE_B7_WIDTH                   1
#define PORTCON_PORTB_IE_B7_MASK                    (((1U << PORTCON_PORTB_IE_B7_WIDTH) - 1U) << PORTCON_PORTB_IE_B7_SHIFT)
#define PORTCON_PORTB_IE_B7_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B7_BITS_DISABLE            (PORTCON_PORTB_IE_B7_VALUE_DISABLE << PORTCON_PORTB_IE_B7_SHIFT)
#define PORTCON_PORTB_IE_B7_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B7_BITS_ENABLE             (PORTCON_PORTB_IE_B7_VALUE_ENABLE << PORTCON_PORTB_IE_B7_SHIFT)

#define PORTCON_PORTB_IE_B8_SHIFT                   8
#define PORTCON_PORTB_IE_B8_WIDTH                   1
#define PORTCON_PORTB_IE_B8_MASK                    (((1U << PORTCON_PORTB_IE_B8_WIDTH) - 1U) << PORTCON_PORTB_IE_B8_SHIFT)
#define PORTCON_PORTB_IE_B8_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B8_BITS_DISABLE            (PORTCON_PORTB_IE_B8_VALUE_DISABLE << PORTCON_PORTB_IE_B8_SHIFT)
#define PORTCON_PORTB_IE_B8_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B8_BITS_ENABLE             (PORTCON_PORTB_IE_B8_VALUE_ENABLE << PORTCON_PORTB_IE_B8_SHIFT)

#define PORTCON_PORTB_IE_B9_SHIFT                   9
#define PORTCON_PORTB_IE_B9_WIDTH                   1
#define PORTCON_PORTB_IE_B9_MASK                    (((1U << PORTCON_PORTB_IE_B9_WIDTH) - 1U) << PORTCON_PORTB_IE_B9_SHIFT)
#define PORTCON_PORTB_IE_B9_VALUE_DISABLE           0U
#define PORTCON_PORTB_IE_B9_BITS_DISABLE            (PORTCON_PORTB_IE_B9_VALUE_DISABLE << PORTCON_PORTB_IE_B9_SHIFT)
#define PORTCON_PORTB_IE_B9_VALUE_ENABLE            1U
#define PORTCON_PORTB_IE_B9_BITS_ENABLE             (PORTCON_PORTB_IE_B9_VALUE_ENABLE << PORTCON_PORTB_IE_B9_SHIFT)

#define PORTCON_PORTB_IE_B10_SHIFT                  10
#define PORTCON_PORTB_IE_B10_WIDTH                  1
#define PORTCON_PORTB_IE_B10_MASK                   (((1U << PORTCON_PORTB_IE_B10_WIDTH) - 1U) << PORTCON_PORTB_IE_B10_SHIFT)
#define PORTCON_PORTB_IE_B10_VALUE_DISABLE          0U
#define PORTCON_PORTB_IE_B10_BITS_DISABLE           (PORTCON_PORTB_IE_B10_VALUE_DISABLE << PORTCON_PORTB_IE_B10_SHIFT)
#define PORTCON_PORTB_IE_B10_VALUE_ENABLE           1U
#define PORTCON_PORTB_IE_B10_BITS_ENABLE            (PORTCON_PORTB_IE_B10_VALUE_ENABLE << PORTCON_PORTB_IE_B10_SHIFT)

#define PORTCON_PORTB_IE_B11_SHIFT                  11
#define PORTCON_PORTB_IE_B11_WIDTH                  1
#define PORTCON_PORTB_IE_B11_MASK                   (((1U << PORTCON_PORTB_IE_B11_WIDTH) - 1U) << PORTCON_PORTB_IE_B11_SHIFT)
#define PORTCON_PORTB_IE_B11_VALUE_DISABLE          0U
#define PORTCON_PORTB_IE_B11_BITS_DISABLE           (PORTCON_PORTB_IE_B11_VALUE_DISABLE << PORTCON_PORTB_IE_B11_SHIFT)
#define PORTCON_PORTB_IE_B11_VALUE_ENABLE           1U
#define PORTCON_PORTB_IE_B11_BITS_ENABLE            (PORTCON_PORTB_IE_B11_VALUE_ENABLE << PORTCON_PORTB_IE_B11_SHIFT)

#define PORTCON_PORTB_IE_B12_SHIFT                  12
#define PORTCON_PORTB_IE_B12_WIDTH                  1
#define PORTCON_PORTB_IE_B12_MASK                   (((1U << PORTCON_PORTB_IE_B12_WIDTH) - 1U) << PORTCON_PORTB_IE_B12_SHIFT)
#define PORTCON_PORTB_IE_B12_VALUE_DISABLE          0U
#define PORTCON_PORTB_IE_B12_BITS_DISABLE           (PORTCON_PORTB_IE_B12_VALUE_DISABLE << PORTCON_PORTB_IE_B12_SHIFT)
#define PORTCON_PORTB_IE_B12_VALUE_ENABLE           1U
#define PORTCON_PORTB_IE_B12_BITS_ENABLE            (PORTCON_PORTB_IE_B12_VALUE_ENABLE << PORTCON_PORTB_IE_B12_SHIFT)

#define PORTCON_PORTB_IE_B13_SHIFT                  13
#define PORTCON_PORTB_IE_B13_WIDTH                  1
#define PORTCON_PORTB_IE_B13_MASK                   (((1U << PORTCON_PORTB_IE_B13_WIDTH) - 1U) << PORTCON_PORTB_IE_B13_SHIFT)
#define PORTCON_PORTB_IE_B13_VALUE_DISABLE          0U
#define PORTCON_PORTB_IE_B13_BITS_DISABLE           (PORTCON_PORTB_IE_B13_VALUE_DISABLE << PORTCON_PORTB_IE_B13_SHIFT)
#define PORTCON_PORTB_IE_B13_VALUE_ENABLE           1U
#define PORTCON_PORTB_IE_B13_BITS_ENABLE            (PORTCON_PORTB_IE_B13_VALUE_ENABLE << PORTCON_PORTB_IE_B13_SHIFT)

#define PORTCON_PORTB_IE_B14_SHIFT                  14
#define PORTCON_PORTB_IE_B14_WIDTH                  1
#define PORTCON_PORTB_IE_B14_MASK                   (((1U << PORTCON_PORTB_IE_B14_WIDTH) - 1U) << PORTCON_PORTB_IE_B14_SHIFT)
#define PORTCON_PORTB_IE_B14_VALUE_DISABLE          0U
#define PORTCON_PORTB_IE_B14_BITS_DISABLE           (PORTCON_PORTB_IE_B14_VALUE_DISABLE << PORTCON_PORTB_IE_B14_SHIFT)
#define PORTCON_PORTB_IE_B14_VALUE_ENABLE           1U
#define PORTCON_PORTB_IE_B14_BITS_ENABLE            (PORTCON_PORTB_IE_B14_VALUE_ENABLE << PORTCON_PORTB_IE_B14_SHIFT)

#define PORTCON_PORTB_IE_B15_SHIFT                  15
#define PORTCON_PORTB_IE_B15_WIDTH                  1
#define PORTCON_PORTB_IE_B15_MASK                   (((1U << PORTCON_PORTB_IE_B15_WIDTH) - 1U) << PORTCON_PORTB_IE_B15_SHIFT)
#define PORTCON_PORTB_IE_B15_VALUE_DISABLE          0U
#define PORTCON_PORTB_IE_B15_BITS_DISABLE           (PORTCON_PORTB_IE_B15_VALUE_DISABLE << PORTCON_PORTB_IE_B15_SHIFT)
#define PORTCON_PORTB_IE_B15_VALUE_ENABLE           1U
#define PORTCON_PORTB_IE_B15_BITS_ENABLE            (PORTCON_PORTB_IE_B15_VALUE_ENABLE << PORTCON_PORTB_IE_B15_SHIFT)

#define PORTCON_PORTC_IE_ADDR                       (PORTCON_BASE_ADDR + 0x0108U)
#define PORTCON_PORTC_IE                            (*(volatile uint32_t *)PORTCON_PORTC_IE_ADDR)
#define PORTCON_PORTC_IE_C0_SHIFT                   0
#define PORTCON_PORTC_IE_C0_WIDTH                   1
#define PORTCON_PORTC_IE_C0_MASK                    (((1U << PORTCON_PORTC_IE_C0_WIDTH) - 1U) << PORTCON_PORTC_IE_C0_SHIFT)
#define PORTCON_PORTC_IE_C0_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C0_BITS_DISABLE            (PORTCON_PORTC_IE_C0_VALUE_DISABLE << PORTCON_PORTC_IE_C0_SHIFT)
#define PORTCON_PORTC_IE_C0_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C0_BITS_ENABLE             (PORTCON_PORTC_IE_C0_VALUE_ENABLE << PORTCON_PORTC_IE_C0_SHIFT)

#define PORTCON_PORTC_IE_C1_SHIFT                   1
#define PORTCON_PORTC_IE_C1_WIDTH                   1
#define PORTCON_PORTC_IE_C1_MASK                    (((1U << PORTCON_PORTC_IE_C1_WIDTH) - 1U) << PORTCON_PORTC_IE_C1_SHIFT)
#define PORTCON_PORTC_IE_C1_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C1_BITS_DISABLE            (PORTCON_PORTC_IE_C1_VALUE_DISABLE << PORTCON_PORTC_IE_C1_SHIFT)
#define PORTCON_PORTC_IE_C1_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C1_BITS_ENABLE             (PORTCON_PORTC_IE_C1_VALUE_ENABLE << PORTCON_PORTC_IE_C1_SHIFT)

#define PORTCON_PORTC_IE_C2_SHIFT                   2
#define PORTCON_PORTC_IE_C2_WIDTH                   1
#define PORTCON_PORTC_IE_C2_MASK                    (((1U << PORTCON_PORTC_IE_C2_WIDTH) - 1U) << PORTCON_PORTC_IE_C2_SHIFT)
#define PORTCON_PORTC_IE_C2_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C2_BITS_DISABLE            (PORTCON_PORTC_IE_C2_VALUE_DISABLE << PORTCON_PORTC_IE_C2_SHIFT)
#define PORTCON_PORTC_IE_C2_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C2_BITS_ENABLE             (PORTCON_PORTC_IE_C2_VALUE_ENABLE << PORTCON_PORTC_IE_C2_SHIFT)

#define PORTCON_PORTC_IE_C3_SHIFT                   3
#define PORTCON_PORTC_IE_C3_WIDTH                   1
#define PORTCON_PORTC_IE_C3_MASK                    (((1U << PORTCON_PORTC_IE_C3_WIDTH) - 1U) << PORTCON_PORTC_IE_C3_SHIFT)
#define PORTCON_PORTC_IE_C3_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C3_BITS_DISABLE            (PORTCON_PORTC_IE_C3_VALUE_DISABLE << PORTCON_PORTC_IE_C3_SHIFT)
#define PORTCON_PORTC_IE_C3_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C3_BITS_ENABLE             (PORTCON_PORTC_IE_C3_VALUE_ENABLE << PORTCON_PORTC_IE_C3_SHIFT)

#define PORTCON_PORTC_IE_C4_SHIFT                   4
#define PORTCON_PORTC_IE_C4_WIDTH                   1
#define PORTCON_PORTC_IE_C4_MASK                    (((1U << PORTCON_PORTC_IE_C4_WIDTH) - 1U) << PORTCON_PORTC_IE_C4_SHIFT)
#define PORTCON_PORTC_IE_C4_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C4_BITS_DISABLE            (PORTCON_PORTC_IE_C4_VALUE_DISABLE << PORTCON_PORTC_IE_C4_SHIFT)
#define PORTCON_PORTC_IE_C4_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C4_BITS_ENABLE             (PORTCON_PORTC_IE_C4_VALUE_ENABLE << PORTCON_PORTC_IE_C4_SHIFT)

#define PORTCON_PORTC_IE_C5_SHIFT                   5
#define PORTCON_PORTC_IE_C5_WIDTH                   1
#define PORTCON_PORTC_IE_C5_MASK                    (((1U << PORTCON_PORTC_IE_C5_WIDTH) - 1U) << PORTCON_PORTC_IE_C5_SHIFT)
#define PORTCON_PORTC_IE_C5_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C5_BITS_DISABLE            (PORTCON_PORTC_IE_C5_VALUE_DISABLE << PORTCON_PORTC_IE_C5_SHIFT)
#define PORTCON_PORTC_IE_C5_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C5_BITS_ENABLE             (PORTCON_PORTC_IE_C5_VALUE_ENABLE << PORTCON_PORTC_IE_C5_SHIFT)

#define PORTCON_PORTC_IE_C6_SHIFT                   6
#define PORTCON_PORTC_IE_C6_WIDTH                   1
#define PORTCON_PORTC_IE_C6_MASK                    (((1U << PORTCON_PORTC_IE_C6_WIDTH) - 1U) << PORTCON_PORTC_IE_C6_SHIFT)
#define PORTCON_PORTC_IE_C6_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C6_BITS_DISABLE            (PORTCON_PORTC_IE_C6_VALUE_DISABLE << PORTCON_PORTC_IE_C6_SHIFT)
#define PORTCON_PORTC_IE_C6_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C6_BITS_ENABLE             (PORTCON_PORTC_IE_C6_VALUE_ENABLE << PORTCON_PORTC_IE_C6_SHIFT)

#define PORTCON_PORTC_IE_C7_SHIFT                   7
#define PORTCON_PORTC_IE_C7_WIDTH                   1
#define PORTCON_PORTC_IE_C7_MASK                    (((1U << PORTCON_PORTC_IE_C7_WIDTH) - 1U) << PORTCON_PORTC_IE_C7_SHIFT)
#define PORTCON_PORTC_IE_C7_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C7_BITS_DISABLE            (PORTCON_PORTC_IE_C7_VALUE_DISABLE << PORTCON_PORTC_IE_C7_SHIFT)
#define PORTCON_PORTC_IE_C7_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C7_BITS_ENABLE             (PORTCON_PORTC_IE_C7_VALUE_ENABLE << PORTCON_PORTC_IE_C7_SHIFT)

#define PORTCON_PORTC_IE_C8_SHIFT                   8
#define PORTCON_PORTC_IE_C8_WIDTH                   1
#define PORTCON_PORTC_IE_C8_MASK                    (((1U << PORTCON_PORTC_IE_C8_WIDTH) - 1U) << PORTCON_PORTC_IE_C8_SHIFT)
#define PORTCON_PORTC_IE_C8_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C8_BITS_DISABLE            (PORTCON_PORTC_IE_C8_VALUE_DISABLE << PORTCON_PORTC_IE_C8_SHIFT)
#define PORTCON_PORTC_IE_C8_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C8_BITS_ENABLE             (PORTCON_PORTC_IE_C8_VALUE_ENABLE << PORTCON_PORTC_IE_C8_SHIFT)

#define PORTCON_PORTC_IE_C9_SHIFT                   9
#define PORTCON_PORTC_IE_C9_WIDTH                   1
#define PORTCON_PORTC_IE_C9_MASK                    (((1U << PORTCON_PORTC_IE_C9_WIDTH) - 1U) << PORTCON_PORTC_IE_C9_SHIFT)
#define PORTCON_PORTC_IE_C9_VALUE_DISABLE           0U
#define PORTCON_PORTC_IE_C9_BITS_DISABLE            (PORTCON_PORTC_IE_C9_VALUE_DISABLE << PORTCON_PORTC_IE_C9_SHIFT)
#define PORTCON_PORTC_IE_C9_VALUE_ENABLE            1U
#define PORTCON_PORTC_IE_C9_BITS_ENABLE             (PORTCON_PORTC_IE_C9_VALUE_ENABLE << PORTCON_PORTC_IE_C9_SHIFT)

#define PORTCON_PORTC_IE_C10_SHIFT                  10
#define PORTCON_PORTC_IE_C10_WIDTH                  1
#define PORTCON_PORTC_IE_C10_MASK                   (((1U << PORTCON_PORTC_IE_C10_WIDTH) - 1U) << PORTCON_PORTC_IE_C10_SHIFT)
#define PORTCON_PORTC_IE_C10_VALUE_DISABLE          0U
#define PORTCON_PORTC_IE_C10_BITS_DISABLE           (PORTCON_PORTC_IE_C10_VALUE_DISABLE << PORTCON_PORTC_IE_C10_SHIFT)
#define PORTCON_PORTC_IE_C10_VALUE_ENABLE           1U
#define PORTCON_PORTC_IE_C10_BITS_ENABLE            (PORTCON_PORTC_IE_C10_VALUE_ENABLE << PORTCON_PORTC_IE_C10_SHIFT)

#define PORTCON_PORTC_IE_C11_SHIFT                  11
#define PORTCON_PORTC_IE_C11_WIDTH                  1
#define PORTCON_PORTC_IE_C11_MASK                   (((1U << PORTCON_PORTC_IE_C11_WIDTH) - 1U) << PORTCON_PORTC_IE_C11_SHIFT)
#define PORTCON_PORTC_IE_C11_VALUE_DISABLE          0U
#define PORTCON_PORTC_IE_C11_BITS_DISABLE           (PORTCON_PORTC_IE_C11_VALUE_DISABLE << PORTCON_PORTC_IE_C11_SHIFT)
#define PORTCON_PORTC_IE_C11_VALUE_ENABLE           1U
#define PORTCON_PORTC_IE_C11_BITS_ENABLE            (PORTCON_PORTC_IE_C11_VALUE_ENABLE << PORTCON_PORTC_IE_C11_SHIFT)

#define PORTCON_PORTC_IE_C12_SHIFT                  12
#define PORTCON_PORTC_IE_C12_WIDTH                  1
#define PORTCON_PORTC_IE_C12_MASK                   (((1U << PORTCON_PORTC_IE_C12_WIDTH) - 1U) << PORTCON_PORTC_IE_C12_SHIFT)
#define PORTCON_PORTC_IE_C12_VALUE_DISABLE          0U
#define PORTCON_PORTC_IE_C12_BITS_DISABLE           (PORTCON_PORTC_IE_C12_VALUE_DISABLE << PORTCON_PORTC_IE_C12_SHIFT)
#define PORTCON_PORTC_IE_C12_VALUE_ENABLE           1U
#define PORTCON_PORTC_IE_C12_BITS_ENABLE            (PORTCON_PORTC_IE_C12_VALUE_ENABLE << PORTCON_PORTC_IE_C12_SHIFT)

#define PORTCON_PORTC_IE_C13_SHIFT                  13
#define PORTCON_PORTC_IE_C13_WIDTH                  1
#define PORTCON_PORTC_IE_C13_MASK                   (((1U << PORTCON_PORTC_IE_C13_WIDTH) - 1U) << PORTCON_PORTC_IE_C13_SHIFT)
#define PORTCON_PORTC_IE_C13_VALUE_DISABLE          0U
#define PORTCON_PORTC_IE_C13_BITS_DISABLE           (PORTCON_PORTC_IE_C13_VALUE_DISABLE << PORTCON_PORTC_IE_C13_SHIFT)
#define PORTCON_PORTC_IE_C13_VALUE_ENABLE           1U
#define PORTCON_PORTC_IE_C13_BITS_ENABLE            (PORTCON_PORTC_IE_C13_VALUE_ENABLE << PORTCON_PORTC_IE_C13_SHIFT)

#define PORTCON_PORTC_IE_C14_SHIFT                  14
#define PORTCON_PORTC_IE_C14_WIDTH                  1
#define PORTCON_PORTC_IE_C14_MASK                   (((1U << PORTCON_PORTC_IE_C14_WIDTH) - 1U) << PORTCON_PORTC_IE_C14_SHIFT)
#define PORTCON_PORTC_IE_C14_VALUE_DISABLE          0U
#define PORTCON_PORTC_IE_C14_BITS_DISABLE           (PORTCON_PORTC_IE_C14_VALUE_DISABLE << PORTCON_PORTC_IE_C14_SHIFT)
#define PORTCON_PORTC_IE_C14_VALUE_ENABLE           1U
#define PORTCON_PORTC_IE_C14_BITS_ENABLE            (PORTCON_PORTC_IE_C14_VALUE_ENABLE << PORTCON_PORTC_IE_C14_SHIFT)

#define PORTCON_PORTC_IE_C15_SHIFT                  15
#define PORTCON_PORTC_IE_C15_WIDTH                  1
#define PORTCON_PORTC_IE_C15_MASK                   (((1U << PORTCON_PORTC_IE_C15_WIDTH) - 1U) << PORTCON_PORTC_IE_C15_SHIFT)
#define PORTCON_PORTC_IE_C15_VALUE_DISABLE          0U
#define PORTCON_PORTC_IE_C15_BITS_DISABLE           (PORTCON_PORTC_IE_C15_VALUE_DISABLE << PORTCON_PORTC_IE_C15_SHIFT)
#define PORTCON_PORTC_IE_C15_VALUE_ENABLE           1U
#define PORTCON_PORTC_IE_C15_BITS_ENABLE            (PORTCON_PORTC_IE_C15_VALUE_ENABLE << PORTCON_PORTC_IE_C15_SHIFT)

#define PORTCON_PORTA_PU_ADDR                       (PORTCON_BASE_ADDR + 0x0200U)
#define PORTCON_PORTA_PU                            (*(volatile uint32_t *)PORTCON_PORTA_PU_ADDR)
#define PORTCON_PORTA_PU_A0_SHIFT                   0
#define PORTCON_PORTA_PU_A0_WIDTH                   1
#define PORTCON_PORTA_PU_A0_MASK                    (((1U << PORTCON_PORTA_PU_A0_WIDTH) - 1U) << PORTCON_PORTA_PU_A0_SHIFT)
#define PORTCON_PORTA_PU_A0_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A0_BITS_DISABLE            (PORTCON_PORTA_PU_A0_VALUE_DISABLE << PORTCON_PORTA_PU_A0_SHIFT)
#define PORTCON_PORTA_PU_A0_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A0_BITS_ENABLE             (PORTCON_PORTA_PU_A0_VALUE_ENABLE << PORTCON_PORTA_PU_A0_SHIFT)

#define PORTCON_PORTA_PU_A1_SHIFT                   1
#define PORTCON_PORTA_PU_A1_WIDTH                   1
#define PORTCON_PORTA_PU_A1_MASK                    (((1U << PORTCON_PORTA_PU_A1_WIDTH) - 1U) << PORTCON_PORTA_PU_A1_SHIFT)
#define PORTCON_PORTA_PU_A1_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A1_BITS_DISABLE            (PORTCON_PORTA_PU_A1_VALUE_DISABLE << PORTCON_PORTA_PU_A1_SHIFT)
#define PORTCON_PORTA_PU_A1_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A1_BITS_ENABLE             (PORTCON_PORTA_PU_A1_VALUE_ENABLE << PORTCON_PORTA_PU_A1_SHIFT)

#define PORTCON_PORTA_PU_A2_SHIFT                   2
#define PORTCON_PORTA_PU_A2_WIDTH                   1
#define PORTCON_PORTA_PU_A2_MASK                    (((1U << PORTCON_PORTA_PU_A2_WIDTH) - 1U) << PORTCON_PORTA_PU_A2_SHIFT)
#define PORTCON_PORTA_PU_A2_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A2_BITS_DISABLE            (PORTCON_PORTA_PU_A2_VALUE_DISABLE << PORTCON_PORTA_PU_A2_SHIFT)
#define PORTCON_PORTA_PU_A2_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A2_BITS_ENABLE             (PORTCON_PORTA_PU_A2_VALUE_ENABLE << PORTCON_PORTA_PU_A2_SHIFT)

#define PORTCON_PORTA_PU_A3_SHIFT                   3
#define PORTCON_PORTA_PU_A3_WIDTH                   1
#define PORTCON_PORTA_PU_A3_MASK                    (((1U << PORTCON_PORTA_PU_A3_WIDTH) - 1U) << PORTCON_PORTA_PU_A3_SHIFT)
#define PORTCON_PORTA_PU_A3_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A3_BITS_DISABLE            (PORTCON_PORTA_PU_A3_VALUE_DISABLE << PORTCON_PORTA_PU_A3_SHIFT)
#define PORTCON_PORTA_PU_A3_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A3_BITS_ENABLE             (PORTCON_PORTA_PU_A3_VALUE_ENABLE << PORTCON_PORTA_PU_A3_SHIFT)

#define PORTCON_PORTA_PU_A4_SHIFT                   4
#define PORTCON_PORTA_PU_A4_WIDTH                   1
#define PORTCON_PORTA_PU_A4_MASK                    (((1U << PORTCON_PORTA_PU_A4_WIDTH) - 1U) << PORTCON_PORTA_PU_A4_SHIFT)
#define PORTCON_PORTA_PU_A4_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A4_BITS_DISABLE            (PORTCON_PORTA_PU_A4_VALUE_DISABLE << PORTCON_PORTA_PU_A4_SHIFT)
#define PORTCON_PORTA_PU_A4_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A4_BITS_ENABLE             (PORTCON_PORTA_PU_A4_VALUE_ENABLE << PORTCON_PORTA_PU_A4_SHIFT)

#define PORTCON_PORTA_PU_A5_SHIFT                   5
#define PORTCON_PORTA_PU_A5_WIDTH                   1
#define PORTCON_PORTA_PU_A5_MASK                    (((1U << PORTCON_PORTA_PU_A5_WIDTH) - 1U) << PORTCON_PORTA_PU_A5_SHIFT)
#define PORTCON_PORTA_PU_A5_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A5_BITS_DISABLE            (PORTCON_PORTA_PU_A5_VALUE_DISABLE << PORTCON_PORTA_PU_A5_SHIFT)
#define PORTCON_PORTA_PU_A5_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A5_BITS_ENABLE             (PORTCON_PORTA_PU_A5_VALUE_ENABLE << PORTCON_PORTA_PU_A5_SHIFT)

#define PORTCON_PORTA_PU_A6_SHIFT                   6
#define PORTCON_PORTA_PU_A6_WIDTH                   1
#define PORTCON_PORTA_PU_A6_MASK                    (((1U << PORTCON_PORTA_PU_A6_WIDTH) - 1U) << PORTCON_PORTA_PU_A6_SHIFT)
#define PORTCON_PORTA_PU_A6_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A6_BITS_DISABLE            (PORTCON_PORTA_PU_A6_VALUE_DISABLE << PORTCON_PORTA_PU_A6_SHIFT)
#define PORTCON_PORTA_PU_A6_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A6_BITS_ENABLE             (PORTCON_PORTA_PU_A6_VALUE_ENABLE << PORTCON_PORTA_PU_A6_SHIFT)

#define PORTCON_PORTA_PU_A7_SHIFT                   7
#define PORTCON_PORTA_PU_A7_WIDTH                   1
#define PORTCON_PORTA_PU_A7_MASK                    (((1U << PORTCON_PORTA_PU_A7_WIDTH) - 1U) << PORTCON_PORTA_PU_A7_SHIFT)
#define PORTCON_PORTA_PU_A7_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A7_BITS_DISABLE            (PORTCON_PORTA_PU_A7_VALUE_DISABLE << PORTCON_PORTA_PU_A7_SHIFT)
#define PORTCON_PORTA_PU_A7_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A7_BITS_ENABLE             (PORTCON_PORTA_PU_A7_VALUE_ENABLE << PORTCON_PORTA_PU_A7_SHIFT)

#define PORTCON_PORTA_PU_A8_SHIFT                   8
#define PORTCON_PORTA_PU_A8_WIDTH                   1
#define PORTCON_PORTA_PU_A8_MASK                    (((1U << PORTCON_PORTA_PU_A8_WIDTH) - 1U) << PORTCON_PORTA_PU_A8_SHIFT)
#define PORTCON_PORTA_PU_A8_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A8_BITS_DISABLE            (PORTCON_PORTA_PU_A8_VALUE_DISABLE << PORTCON_PORTA_PU_A8_SHIFT)
#define PORTCON_PORTA_PU_A8_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A8_BITS_ENABLE             (PORTCON_PORTA_PU_A8_VALUE_ENABLE << PORTCON_PORTA_PU_A8_SHIFT)

#define PORTCON_PORTA_PU_A9_SHIFT                   9
#define PORTCON_PORTA_PU_A9_WIDTH                   1
#define PORTCON_PORTA_PU_A9_MASK                    (((1U << PORTCON_PORTA_PU_A9_WIDTH) - 1U) << PORTCON_PORTA_PU_A9_SHIFT)
#define PORTCON_PORTA_PU_A9_VALUE_DISABLE           0U
#define PORTCON_PORTA_PU_A9_BITS_DISABLE            (PORTCON_PORTA_PU_A9_VALUE_DISABLE << PORTCON_PORTA_PU_A9_SHIFT)
#define PORTCON_PORTA_PU_A9_VALUE_ENABLE            1U
#define PORTCON_PORTA_PU_A9_BITS_ENABLE             (PORTCON_PORTA_PU_A9_VALUE_ENABLE << PORTCON_PORTA_PU_A9_SHIFT)

#define PORTCON_PORTA_PU_A10_SHIFT                  10
#define PORTCON_PORTA_PU_A10_WIDTH                  1
#define PORTCON_PORTA_PU_A10_MASK                   (((1U << PORTCON_PORTA_PU_A10_WIDTH) - 1U) << PORTCON_PORTA_PU_A10_SHIFT)
#define PORTCON_PORTA_PU_A10_VALUE_DISABLE          0U
#define PORTCON_PORTA_PU_A10_BITS_DISABLE           (PORTCON_PORTA_PU_A10_VALUE_DISABLE << PORTCON_PORTA_PU_A10_SHIFT)
#define PORTCON_PORTA_PU_A10_VALUE_ENABLE           1U
#define PORTCON_PORTA_PU_A10_BITS_ENABLE            (PORTCON_PORTA_PU_A10_VALUE_ENABLE << PORTCON_PORTA_PU_A10_SHIFT)

#define PORTCON_PORTA_PU_A11_SHIFT                  11
#define PORTCON_PORTA_PU_A11_WIDTH                  1
#define PORTCON_PORTA_PU_A11_MASK                   (((1U << PORTCON_PORTA_PU_A11_WIDTH) - 1U) << PORTCON_PORTA_PU_A11_SHIFT)
#define PORTCON_PORTA_PU_A11_VALUE_DISABLE          0U
#define PORTCON_PORTA_PU_A11_BITS_DISABLE           (PORTCON_PORTA_PU_A11_VALUE_DISABLE << PORTCON_PORTA_PU_A11_SHIFT)
#define PORTCON_PORTA_PU_A11_VALUE_ENABLE           1U
#define PORTCON_PORTA_PU_A11_BITS_ENABLE            (PORTCON_PORTA_PU_A11_VALUE_ENABLE << PORTCON_PORTA_PU_A11_SHIFT)

#define PORTCON_PORTA_PU_A12_SHIFT                  12
#define PORTCON_PORTA_PU_A12_WIDTH                  1
#define PORTCON_PORTA_PU_A12_MASK                   (((1U << PORTCON_PORTA_PU_A12_WIDTH) - 1U) << PORTCON_PORTA_PU_A12_SHIFT)
#define PORTCON_PORTA_PU_A12_VALUE_DISABLE          0U
#define PORTCON_PORTA_PU_A12_BITS_DISABLE           (PORTCON_PORTA_PU_A12_VALUE_DISABLE << PORTCON_PORTA_PU_A12_SHIFT)
#define PORTCON_PORTA_PU_A12_VALUE_ENABLE           1U
#define PORTCON_PORTA_PU_A12_BITS_ENABLE            (PORTCON_PORTA_PU_A12_VALUE_ENABLE << PORTCON_PORTA_PU_A12_SHIFT)

#define PORTCON_PORTA_PU_A13_SHIFT                  13
#define PORTCON_PORTA_PU_A13_WIDTH                  1
#define PORTCON_PORTA_PU_A13_MASK                   (((1U << PORTCON_PORTA_PU_A13_WIDTH) - 1U) << PORTCON_PORTA_PU_A13_SHIFT)
#define PORTCON_PORTA_PU_A13_VALUE_DISABLE          0U
#define PORTCON_PORTA_PU_A13_BITS_DISABLE           (PORTCON_PORTA_PU_A13_VALUE_DISABLE << PORTCON_PORTA_PU_A13_SHIFT)
#define PORTCON_PORTA_PU_A13_VALUE_ENABLE           1U
#define PORTCON_PORTA_PU_A13_BITS_ENABLE            (PORTCON_PORTA_PU_A13_VALUE_ENABLE << PORTCON_PORTA_PU_A13_SHIFT)

#define PORTCON_PORTA_PU_A14_SHIFT                  14
#define PORTCON_PORTA_PU_A14_WIDTH                  1
#define PORTCON_PORTA_PU_A14_MASK                   (((1U << PORTCON_PORTA_PU_A14_WIDTH) - 1U) << PORTCON_PORTA_PU_A14_SHIFT)
#define PORTCON_PORTA_PU_A14_VALUE_DISABLE          0U
#define PORTCON_PORTA_PU_A14_BITS_DISABLE           (PORTCON_PORTA_PU_A14_VALUE_DISABLE << PORTCON_PORTA_PU_A14_SHIFT)
#define PORTCON_PORTA_PU_A14_VALUE_ENABLE           1U
#define PORTCON_PORTA_PU_A14_BITS_ENABLE            (PORTCON_PORTA_PU_A14_VALUE_ENABLE << PORTCON_PORTA_PU_A14_SHIFT)

#define PORTCON_PORTA_PU_A15_SHIFT                  15
#define PORTCON_PORTA_PU_A15_WIDTH                  1
#define PORTCON_PORTA_PU_A15_MASK                   (((1U << PORTCON_PORTA_PU_A15_WIDTH) - 1U) << PORTCON_PORTA_PU_A15_SHIFT)
#define PORTCON_PORTA_PU_A15_VALUE_DISABLE          0U
#define PORTCON_PORTA_PU_A15_BITS_DISABLE           (PORTCON_PORTA_PU_A15_VALUE_DISABLE << PORTCON_PORTA_PU_A15_SHIFT)
#define PORTCON_PORTA_PU_A15_VALUE_ENABLE           1U
#define PORTCON_PORTA_PU_A15_BITS_ENABLE            (PORTCON_PORTA_PU_A15_VALUE_ENABLE << PORTCON_PORTA_PU_A15_SHIFT)

#define PORTCON_PORTB_PU_ADDR                       (PORTCON_BASE_ADDR + 0x0204U)
#define PORTCON_PORTB_PU                            (*(volatile uint32_t *)PORTCON_PORTB_PU_ADDR)
#define PORTCON_PORTB_PU_B0_SHIFT                   0
#define PORTCON_PORTB_PU_B0_WIDTH                   1
#define PORTCON_PORTB_PU_B0_MASK                    (((1U << PORTCON_PORTB_PU_B0_WIDTH) - 1U) << PORTCON_PORTB_PU_B0_SHIFT)
#define PORTCON_PORTB_PU_B0_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B0_BITS_DISABLE            (PORTCON_PORTB_PU_B0_VALUE_DISABLE << PORTCON_PORTB_PU_B0_SHIFT)
#define PORTCON_PORTB_PU_B0_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B0_BITS_ENABLE             (PORTCON_PORTB_PU_B0_VALUE_ENABLE << PORTCON_PORTB_PU_B0_SHIFT)

#define PORTCON_PORTB_PU_B1_SHIFT                   1
#define PORTCON_PORTB_PU_B1_WIDTH                   1
#define PORTCON_PORTB_PU_B1_MASK                    (((1U << PORTCON_PORTB_PU_B1_WIDTH) - 1U) << PORTCON_PORTB_PU_B1_SHIFT)
#define PORTCON_PORTB_PU_B1_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B1_BITS_DISABLE            (PORTCON_PORTB_PU_B1_VALUE_DISABLE << PORTCON_PORTB_PU_B1_SHIFT)
#define PORTCON_PORTB_PU_B1_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B1_BITS_ENABLE             (PORTCON_PORTB_PU_B1_VALUE_ENABLE << PORTCON_PORTB_PU_B1_SHIFT)

#define PORTCON_PORTB_PU_B2_SHIFT                   2
#define PORTCON_PORTB_PU_B2_WIDTH                   1
#define PORTCON_PORTB_PU_B2_MASK                    (((1U << PORTCON_PORTB_PU_B2_WIDTH) - 1U) << PORTCON_PORTB_PU_B2_SHIFT)
#define PORTCON_PORTB_PU_B2_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B2_BITS_DISABLE            (PORTCON_PORTB_PU_B2_VALUE_DISABLE << PORTCON_PORTB_PU_B2_SHIFT)
#define PORTCON_PORTB_PU_B2_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B2_BITS_ENABLE             (PORTCON_PORTB_PU_B2_VALUE_ENABLE << PORTCON_PORTB_PU_B2_SHIFT)

#define PORTCON_PORTB_PU_B3_SHIFT                   3
#define PORTCON_PORTB_PU_B3_WIDTH                   1
#define PORTCON_PORTB_PU_B3_MASK                    (((1U << PORTCON_PORTB_PU_B3_WIDTH) - 1U) << PORTCON_PORTB_PU_B3_SHIFT)
#define PORTCON_PORTB_PU_B3_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B3_BITS_DISABLE            (PORTCON_PORTB_PU_B3_VALUE_DISABLE << PORTCON_PORTB_PU_B3_SHIFT)
#define PORTCON_PORTB_PU_B3_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B3_BITS_ENABLE             (PORTCON_PORTB_PU_B3_VALUE_ENABLE << PORTCON_PORTB_PU_B3_SHIFT)

#define PORTCON_PORTB_PU_B4_SHIFT                   4
#define PORTCON_PORTB_PU_B4_WIDTH                   1
#define PORTCON_PORTB_PU_B4_MASK                    (((1U << PORTCON_PORTB_PU_B4_WIDTH) - 1U) << PORTCON_PORTB_PU_B4_SHIFT)
#define PORTCON_PORTB_PU_B4_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B4_BITS_DISABLE            (PORTCON_PORTB_PU_B4_VALUE_DISABLE << PORTCON_PORTB_PU_B4_SHIFT)
#define PORTCON_PORTB_PU_B4_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B4_BITS_ENABLE             (PORTCON_PORTB_PU_B4_VALUE_ENABLE << PORTCON_PORTB_PU_B4_SHIFT)

#define PORTCON_PORTB_PU_B5_SHIFT                   5
#define PORTCON_PORTB_PU_B5_WIDTH                   1
#define PORTCON_PORTB_PU_B5_MASK                    (((1U << PORTCON_PORTB_PU_B5_WIDTH) - 1U) << PORTCON_PORTB_PU_B5_SHIFT)
#define PORTCON_PORTB_PU_B5_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B5_BITS_DISABLE            (PORTCON_PORTB_PU_B5_VALUE_DISABLE << PORTCON_PORTB_PU_B5_SHIFT)
#define PORTCON_PORTB_PU_B5_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B5_BITS_ENABLE             (PORTCON_PORTB_PU_B5_VALUE_ENABLE << PORTCON_PORTB_PU_B5_SHIFT)

#define PORTCON_PORTB_PU_B6_SHIFT                   6
#define PORTCON_PORTB_PU_B6_WIDTH                   1
#define PORTCON_PORTB_PU_B6_MASK                    (((1U << PORTCON_PORTB_PU_B6_WIDTH) - 1U) << PORTCON_PORTB_PU_B6_SHIFT)
#define PORTCON_PORTB_PU_B6_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B6_BITS_DISABLE            (PORTCON_PORTB_PU_B6_VALUE_DISABLE << PORTCON_PORTB_PU_B6_SHIFT)
#define PORTCON_PORTB_PU_B6_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B6_BITS_ENABLE             (PORTCON_PORTB_PU_B6_VALUE_ENABLE << PORTCON_PORTB_PU_B6_SHIFT)

#define PORTCON_PORTB_PU_B7_SHIFT                   7
#define PORTCON_PORTB_PU_B7_WIDTH                   1
#define PORTCON_PORTB_PU_B7_MASK                    (((1U << PORTCON_PORTB_PU_B7_WIDTH) - 1U) << PORTCON_PORTB_PU_B7_SHIFT)
#define PORTCON_PORTB_PU_B7_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B7_BITS_DISABLE            (PORTCON_PORTB_PU_B7_VALUE_DISABLE << PORTCON_PORTB_PU_B7_SHIFT)
#define PORTCON_PORTB_PU_B7_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B7_BITS_ENABLE             (PORTCON_PORTB_PU_B7_VALUE_ENABLE << PORTCON_PORTB_PU_B7_SHIFT)

#define PORTCON_PORTB_PU_B8_SHIFT                   8
#define PORTCON_PORTB_PU_B8_WIDTH                   1
#define PORTCON_PORTB_PU_B8_MASK                    (((1U << PORTCON_PORTB_PU_B8_WIDTH) - 1U) << PORTCON_PORTB_PU_B8_SHIFT)
#define PORTCON_PORTB_PU_B8_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B8_BITS_DISABLE            (PORTCON_PORTB_PU_B8_VALUE_DISABLE << PORTCON_PORTB_PU_B8_SHIFT)
#define PORTCON_PORTB_PU_B8_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B8_BITS_ENABLE             (PORTCON_PORTB_PU_B8_VALUE_ENABLE << PORTCON_PORTB_PU_B8_SHIFT)

#define PORTCON_PORTB_PU_B9_SHIFT                   9
#define PORTCON_PORTB_PU_B9_WIDTH                   1
#define PORTCON_PORTB_PU_B9_MASK                    (((1U << PORTCON_PORTB_PU_B9_WIDTH) - 1U) << PORTCON_PORTB_PU_B9_SHIFT)
#define PORTCON_PORTB_PU_B9_VALUE_DISABLE           0U
#define PORTCON_PORTB_PU_B9_BITS_DISABLE            (PORTCON_PORTB_PU_B9_VALUE_DISABLE << PORTCON_PORTB_PU_B9_SHIFT)
#define PORTCON_PORTB_PU_B9_VALUE_ENABLE            1U
#define PORTCON_PORTB_PU_B9_BITS_ENABLE             (PORTCON_PORTB_PU_B9_VALUE_ENABLE << PORTCON_PORTB_PU_B9_SHIFT)

#define PORTCON_PORTB_PU_B10_SHIFT                  10
#define PORTCON_PORTB_PU_B10_WIDTH                  1
#define PORTCON_PORTB_PU_B10_MASK                   (((1U << PORTCON_PORTB_PU_B10_WIDTH) - 1U) << PORTCON_PORTB_PU_B10_SHIFT)
#define PORTCON_PORTB_PU_B10_VALUE_DISABLE          0U
#define PORTCON_PORTB_PU_B10_BITS_DISABLE           (PORTCON_PORTB_PU_B10_VALUE_DISABLE << PORTCON_PORTB_PU_B10_SHIFT)
#define PORTCON_PORTB_PU_B10_VALUE_ENABLE           1U
#define PORTCON_PORTB_PU_B10_BITS_ENABLE            (PORTCON_PORTB_PU_B10_VALUE_ENABLE << PORTCON_PORTB_PU_B10_SHIFT)

#define PORTCON_PORTB_PU_B11_SHIFT                  11
#define PORTCON_PORTB_PU_B11_WIDTH                  1
#define PORTCON_PORTB_PU_B11_MASK                   (((1U << PORTCON_PORTB_PU_B11_WIDTH) - 1U) << PORTCON_PORTB_PU_B11_SHIFT)
#define PORTCON_PORTB_PU_B11_VALUE_DISABLE          0U
#define PORTCON_PORTB_PU_B11_BITS_DISABLE           (PORTCON_PORTB_PU_B11_VALUE_DISABLE << PORTCON_PORTB_PU_B11_SHIFT)
#define PORTCON_PORTB_PU_B11_VALUE_ENABLE           1U
#define PORTCON_PORTB_PU_B11_BITS_ENABLE            (PORTCON_PORTB_PU_B11_VALUE_ENABLE << PORTCON_PORTB_PU_B11_SHIFT)

#define PORTCON_PORTB_PU_B12_SHIFT                  12
#define PORTCON_PORTB_PU_B12_WIDTH                  1
#define PORTCON_PORTB_PU_B12_MASK                   (((1U << PORTCON_PORTB_PU_B12_WIDTH) - 1U) << PORTCON_PORTB_PU_B12_SHIFT)
#define PORTCON_PORTB_PU_B12_VALUE_DISABLE          0U
#define PORTCON_PORTB_PU_B12_BITS_DISABLE           (PORTCON_PORTB_PU_B12_VALUE_DISABLE << PORTCON_PORTB_PU_B12_SHIFT)
#define PORTCON_PORTB_PU_B12_VALUE_ENABLE           1U
#define PORTCON_PORTB_PU_B12_BITS_ENABLE            (PORTCON_PORTB_PU_B12_VALUE_ENABLE << PORTCON_PORTB_PU_B12_SHIFT)

#define PORTCON_PORTB_PU_B13_SHIFT                  13
#define PORTCON_PORTB_PU_B13_WIDTH                  1
#define PORTCON_PORTB_PU_B13_MASK                   (((1U << PORTCON_PORTB_PU_B13_WIDTH) - 1U) << PORTCON_PORTB_PU_B13_SHIFT)
#define PORTCON_PORTB_PU_B13_VALUE_DISABLE          0U
#define PORTCON_PORTB_PU_B13_BITS_DISABLE           (PORTCON_PORTB_PU_B13_VALUE_DISABLE << PORTCON_PORTB_PU_B13_SHIFT)
#define PORTCON_PORTB_PU_B13_VALUE_ENABLE           1U
#define PORTCON_PORTB_PU_B13_BITS_ENABLE            (PORTCON_PORTB_PU_B13_VALUE_ENABLE << PORTCON_PORTB_PU_B13_SHIFT)

#define PORTCON_PORTB_PU_B14_SHIFT                  14
#define PORTCON_PORTB_PU_B14_WIDTH                  1
#define PORTCON_PORTB_PU_B14_MASK                   (((1U << PORTCON_PORTB_PU_B14_WIDTH) - 1U) << PORTCON_PORTB_PU_B14_SHIFT)
#define PORTCON_PORTB_PU_B14_VALUE_DISABLE          0U
#define PORTCON_PORTB_PU_B14_BITS_DISABLE           (PORTCON_PORTB_PU_B14_VALUE_DISABLE << PORTCON_PORTB_PU_B14_SHIFT)
#define PORTCON_PORTB_PU_B14_VALUE_ENABLE           1U
#define PORTCON_PORTB_PU_B14_BITS_ENABLE            (PORTCON_PORTB_PU_B14_VALUE_ENABLE << PORTCON_PORTB_PU_B14_SHIFT)

#define PORTCON_PORTB_PU_B15_SHIFT                  15
#define PORTCON_PORTB_PU_B15_WIDTH                  1
#define PORTCON_PORTB_PU_B15_MASK                   (((1U << PORTCON_PORTB_PU_B15_WIDTH) - 1U) << PORTCON_PORTB_PU_B15_SHIFT)
#define PORTCON_PORTB_PU_B15_VALUE_DISABLE          0U
#define PORTCON_PORTB_PU_B15_BITS_DISABLE           (PORTCON_PORTB_PU_B15_VALUE_DISABLE << PORTCON_PORTB_PU_B15_SHIFT)
#define PORTCON_PORTB_PU_B15_VALUE_ENABLE           1U
#define PORTCON_PORTB_PU_B15_BITS_ENABLE            (PORTCON_PORTB_PU_B15_VALUE_ENABLE << PORTCON_PORTB_PU_B15_SHIFT)

#define PORTCON_PORTC_PU_ADDR                       (PORTCON_BASE_ADDR + 0x0208U)
#define PORTCON_PORTC_PU                            (*(volatile uint32_t *)PORTCON_PORTC_PU_ADDR)
#define PORTCON_PORTC_PU_C0_SHIFT                   0
#define PORTCON_PORTC_PU_C0_WIDTH                   1
#define PORTCON_PORTC_PU_C0_MASK                    (((1U << PORTCON_PORTC_PU_C0_WIDTH) - 1U) << PORTCON_PORTC_PU_C0_SHIFT)
#define PORTCON_PORTC_PU_C0_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C0_BITS_DISABLE            (PORTCON_PORTC_PU_C0_VALUE_DISABLE << PORTCON_PORTC_PU_C0_SHIFT)
#define PORTCON_PORTC_PU_C0_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C0_BITS_ENABLE             (PORTCON_PORTC_PU_C0_VALUE_ENABLE << PORTCON_PORTC_PU_C0_SHIFT)

#define PORTCON_PORTC_PU_C1_SHIFT                   1
#define PORTCON_PORTC_PU_C1_WIDTH                   1
#define PORTCON_PORTC_PU_C1_MASK                    (((1U << PORTCON_PORTC_PU_C1_WIDTH) - 1U) << PORTCON_PORTC_PU_C1_SHIFT)
#define PORTCON_PORTC_PU_C1_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C1_BITS_DISABLE            (PORTCON_PORTC_PU_C1_VALUE_DISABLE << PORTCON_PORTC_PU_C1_SHIFT)
#define PORTCON_PORTC_PU_C1_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C1_BITS_ENABLE             (PORTCON_PORTC_PU_C1_VALUE_ENABLE << PORTCON_PORTC_PU_C1_SHIFT)

#define PORTCON_PORTC_PU_C2_SHIFT                   2
#define PORTCON_PORTC_PU_C2_WIDTH                   1
#define PORTCON_PORTC_PU_C2_MASK                    (((1U << PORTCON_PORTC_PU_C2_WIDTH) - 1U) << PORTCON_PORTC_PU_C2_SHIFT)
#define PORTCON_PORTC_PU_C2_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C2_BITS_DISABLE            (PORTCON_PORTC_PU_C2_VALUE_DISABLE << PORTCON_PORTC_PU_C2_SHIFT)
#define PORTCON_PORTC_PU_C2_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C2_BITS_ENABLE             (PORTCON_PORTC_PU_C2_VALUE_ENABLE << PORTCON_PORTC_PU_C2_SHIFT)

#define PORTCON_PORTC_PU_C3_SHIFT                   3
#define PORTCON_PORTC_PU_C3_WIDTH                   1
#define PORTCON_PORTC_PU_C3_MASK                    (((1U << PORTCON_PORTC_PU_C3_WIDTH) - 1U) << PORTCON_PORTC_PU_C3_SHIFT)
#define PORTCON_PORTC_PU_C3_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C3_BITS_DISABLE            (PORTCON_PORTC_PU_C3_VALUE_DISABLE << PORTCON_PORTC_PU_C3_SHIFT)
#define PORTCON_PORTC_PU_C3_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C3_BITS_ENABLE             (PORTCON_PORTC_PU_C3_VALUE_ENABLE << PORTCON_PORTC_PU_C3_SHIFT)

#define PORTCON_PORTC_PU_C4_SHIFT                   4
#define PORTCON_PORTC_PU_C4_WIDTH                   1
#define PORTCON_PORTC_PU_C4_MASK                    (((1U << PORTCON_PORTC_PU_C4_WIDTH) - 1U) << PORTCON_PORTC_PU_C4_SHIFT)
#define PORTCON_PORTC_PU_C4_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C4_BITS_DISABLE            (PORTCON_PORTC_PU_C4_VALUE_DISABLE << PORTCON_PORTC_PU_C4_SHIFT)
#define PORTCON_PORTC_PU_C4_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C4_BITS_ENABLE             (PORTCON_PORTC_PU_C4_VALUE_ENABLE << PORTCON_PORTC_PU_C4_SHIFT)

#define PORTCON_PORTC_PU_C5_SHIFT                   5
#define PORTCON_PORTC_PU_C5_WIDTH                   1
#define PORTCON_PORTC_PU_C5_MASK                    (((1U << PORTCON_PORTC_PU_C5_WIDTH) - 1U) << PORTCON_PORTC_PU_C5_SHIFT)
#define PORTCON_PORTC_PU_C5_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C5_BITS_DISABLE            (PORTCON_PORTC_PU_C5_VALUE_DISABLE << PORTCON_PORTC_PU_C5_SHIFT)
#define PORTCON_PORTC_PU_C5_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C5_BITS_ENABLE             (PORTCON_PORTC_PU_C5_VALUE_ENABLE << PORTCON_PORTC_PU_C5_SHIFT)

#define PORTCON_PORTC_PU_C6_SHIFT                   6
#define PORTCON_PORTC_PU_C6_WIDTH                   1
#define PORTCON_PORTC_PU_C6_MASK                    (((1U << PORTCON_PORTC_PU_C6_WIDTH) - 1U) << PORTCON_PORTC_PU_C6_SHIFT)
#define PORTCON_PORTC_PU_C6_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C6_BITS_DISABLE            (PORTCON_PORTC_PU_C6_VALUE_DISABLE << PORTCON_PORTC_PU_C6_SHIFT)
#define PORTCON_PORTC_PU_C6_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C6_BITS_ENABLE             (PORTCON_PORTC_PU_C6_VALUE_ENABLE << PORTCON_PORTC_PU_C6_SHIFT)

#define PORTCON_PORTC_PU_C7_SHIFT                   7
#define PORTCON_PORTC_PU_C7_WIDTH                   1
#define PORTCON_PORTC_PU_C7_MASK                    (((1U << PORTCON_PORTC_PU_C7_WIDTH) - 1U) << PORTCON_PORTC_PU_C7_SHIFT)
#define PORTCON_PORTC_PU_C7_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C7_BITS_DISABLE            (PORTCON_PORTC_PU_C7_VALUE_DISABLE << PORTCON_PORTC_PU_C7_SHIFT)
#define PORTCON_PORTC_PU_C7_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C7_BITS_ENABLE             (PORTCON_PORTC_PU_C7_VALUE_ENABLE << PORTCON_PORTC_PU_C7_SHIFT)

#define PORTCON_PORTC_PU_C8_SHIFT                   8
#define PORTCON_PORTC_PU_C8_WIDTH                   1
#define PORTCON_PORTC_PU_C8_MASK                    (((1U << PORTCON_PORTC_PU_C8_WIDTH) - 1U) << PORTCON_PORTC_PU_C8_SHIFT)
#define PORTCON_PORTC_PU_C8_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C8_BITS_DISABLE            (PORTCON_PORTC_PU_C8_VALUE_DISABLE << PORTCON_PORTC_PU_C8_SHIFT)
#define PORTCON_PORTC_PU_C8_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C8_BITS_ENABLE             (PORTCON_PORTC_PU_C8_VALUE_ENABLE << PORTCON_PORTC_PU_C8_SHIFT)

#define PORTCON_PORTC_PU_C9_SHIFT                   9
#define PORTCON_PORTC_PU_C9_WIDTH                   1
#define PORTCON_PORTC_PU_C9_MASK                    (((1U << PORTCON_PORTC_PU_C9_WIDTH) - 1U) << PORTCON_PORTC_PU_C9_SHIFT)
#define PORTCON_PORTC_PU_C9_VALUE_DISABLE           0U
#define PORTCON_PORTC_PU_C9_BITS_DISABLE            (PORTCON_PORTC_PU_C9_VALUE_DISABLE << PORTCON_PORTC_PU_C9_SHIFT)
#define PORTCON_PORTC_PU_C9_VALUE_ENABLE            1U
#define PORTCON_PORTC_PU_C9_BITS_ENABLE             (PORTCON_PORTC_PU_C9_VALUE_ENABLE << PORTCON_PORTC_PU_C9_SHIFT)

#define PORTCON_PORTC_PU_C10_SHIFT                  10
#define PORTCON_PORTC_PU_C10_WIDTH                  1
#define PORTCON_PORTC_PU_C10_MASK                   (((1U << PORTCON_PORTC_PU_C10_WIDTH) - 1U) << PORTCON_PORTC_PU_C10_SHIFT)
#define PORTCON_PORTC_PU_C10_VALUE_DISABLE          0U
#define PORTCON_PORTC_PU_C10_BITS_DISABLE           (PORTCON_PORTC_PU_C10_VALUE_DISABLE << PORTCON_PORTC_PU_C10_SHIFT)
#define PORTCON_PORTC_PU_C10_VALUE_ENABLE           1U
#define PORTCON_PORTC_PU_C10_BITS_ENABLE            (PORTCON_PORTC_PU_C10_VALUE_ENABLE << PORTCON_PORTC_PU_C10_SHIFT)

#define PORTCON_PORTC_PU_C11_SHIFT                  11
#define PORTCON_PORTC_PU_C11_WIDTH                  1
#define PORTCON_PORTC_PU_C11_MASK                   (((1U << PORTCON_PORTC_PU_C11_WIDTH) - 1U) << PORTCON_PORTC_PU_C11_SHIFT)
#define PORTCON_PORTC_PU_C11_VALUE_DISABLE          0U
#define PORTCON_PORTC_PU_C11_BITS_DISABLE           (PORTCON_PORTC_PU_C11_VALUE_DISABLE << PORTCON_PORTC_PU_C11_SHIFT)
#define PORTCON_PORTC_PU_C11_VALUE_ENABLE           1U
#define PORTCON_PORTC_PU_C11_BITS_ENABLE            (PORTCON_PORTC_PU_C11_VALUE_ENABLE << PORTCON_PORTC_PU_C11_SHIFT)

#define PORTCON_PORTC_PU_C12_SHIFT                  12
#define PORTCON_PORTC_PU_C12_WIDTH                  1
#define PORTCON_PORTC_PU_C12_MASK                   (((1U << PORTCON_PORTC_PU_C12_WIDTH) - 1U) << PORTCON_PORTC_PU_C12_SHIFT)
#define PORTCON_PORTC_PU_C12_VALUE_DISABLE          0U
#define PORTCON_PORTC_PU_C12_BITS_DISABLE           (PORTCON_PORTC_PU_C12_VALUE_DISABLE << PORTCON_PORTC_PU_C12_SHIFT)
#define PORTCON_PORTC_PU_C12_VALUE_ENABLE           1U
#define PORTCON_PORTC_PU_C12_BITS_ENABLE            (PORTCON_PORTC_PU_C12_VALUE_ENABLE << PORTCON_PORTC_PU_C12_SHIFT)

#define PORTCON_PORTC_PU_C13_SHIFT                  13
#define PORTCON_PORTC_PU_C13_WIDTH                  1
#define PORTCON_PORTC_PU_C13_MASK                   (((1U << PORTCON_PORTC_PU_C13_WIDTH) - 1U) << PORTCON_PORTC_PU_C13_SHIFT)
#define PORTCON_PORTC_PU_C13_VALUE_DISABLE          0U
#define PORTCON_PORTC_PU_C13_BITS_DISABLE           (PORTCON_PORTC_PU_C13_VALUE_DISABLE << PORTCON_PORTC_PU_C13_SHIFT)
#define PORTCON_PORTC_PU_C13_VALUE_ENABLE           1U
#define PORTCON_PORTC_PU_C13_BITS_ENABLE            (PORTCON_PORTC_PU_C13_VALUE_ENABLE << PORTCON_PORTC_PU_C13_SHIFT)

#define PORTCON_PORTC_PU_C14_SHIFT                  14
#define PORTCON_PORTC_PU_C14_WIDTH                  1
#define PORTCON_PORTC_PU_C14_MASK                   (((1U << PORTCON_PORTC_PU_C14_WIDTH) - 1U) << PORTCON_PORTC_PU_C14_SHIFT)
#define PORTCON_PORTC_PU_C14_VALUE_DISABLE          0U
#define PORTCON_PORTC_PU_C14_BITS_DISABLE           (PORTCON_PORTC_PU_C14_VALUE_DISABLE << PORTCON_PORTC_PU_C14_SHIFT)
#define PORTCON_PORTC_PU_C14_VALUE_ENABLE           1U
#define PORTCON_PORTC_PU_C14_BITS_ENABLE            (PORTCON_PORTC_PU_C14_VALUE_ENABLE << PORTCON_PORTC_PU_C14_SHIFT)

#define PORTCON_PORTC_PU_C15_SHIFT                  15
#define PORTCON_PORTC_PU_C15_WIDTH                  1
#define PORTCON_PORTC_PU_C15_MASK                   (((1U << PORTCON_PORTC_PU_C15_WIDTH) - 1U) << PORTCON_PORTC_PU_C15_SHIFT)
#define PORTCON_PORTC_PU_C15_VALUE_DISABLE          0U
#define PORTCON_PORTC_PU_C15_BITS_DISABLE           (PORTCON_PORTC_PU_C15_VALUE_DISABLE << PORTCON_PORTC_PU_C15_SHIFT)
#define PORTCON_PORTC_PU_C15_VALUE_ENABLE           1U
#define PORTCON_PORTC_PU_C15_BITS_ENABLE            (PORTCON_PORTC_PU_C15_VALUE_ENABLE << PORTCON_PORTC_PU_C15_SHIFT)

#define PORTCON_PORTA_PD_ADDR                       (PORTCON_BASE_ADDR + 0x0300U)
#define PORTCON_PORTA_PD                            (*(volatile uint32_t *)PORTCON_PORTA_PD_ADDR)
#define PORTCON_PORTA_PD_A0_SHIFT                   0
#define PORTCON_PORTA_PD_A0_WIDTH                   1
#define PORTCON_PORTA_PD_A0_MASK                    (((1U << PORTCON_PORTA_PD_A0_WIDTH) - 1U) << PORTCON_PORTA_PD_A0_SHIFT)
#define PORTCON_PORTA_PD_A0_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A0_BITS_DISABLE            (PORTCON_PORTA_PD_A0_VALUE_DISABLE << PORTCON_PORTA_PD_A0_SHIFT)
#define PORTCON_PORTA_PD_A0_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A0_BITS_ENABLE             (PORTCON_PORTA_PD_A0_VALUE_ENABLE << PORTCON_PORTA_PD_A0_SHIFT)

#define PORTCON_PORTA_PD_A1_SHIFT                   1
#define PORTCON_PORTA_PD_A1_WIDTH                   1
#define PORTCON_PORTA_PD_A1_MASK                    (((1U << PORTCON_PORTA_PD_A1_WIDTH) - 1U) << PORTCON_PORTA_PD_A1_SHIFT)
#define PORTCON_PORTA_PD_A1_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A1_BITS_DISABLE            (PORTCON_PORTA_PD_A1_VALUE_DISABLE << PORTCON_PORTA_PD_A1_SHIFT)
#define PORTCON_PORTA_PD_A1_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A1_BITS_ENABLE             (PORTCON_PORTA_PD_A1_VALUE_ENABLE << PORTCON_PORTA_PD_A1_SHIFT)

#define PORTCON_PORTA_PD_A2_SHIFT                   2
#define PORTCON_PORTA_PD_A2_WIDTH                   1
#define PORTCON_PORTA_PD_A2_MASK                    (((1U << PORTCON_PORTA_PD_A2_WIDTH) - 1U) << PORTCON_PORTA_PD_A2_SHIFT)
#define PORTCON_PORTA_PD_A2_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A2_BITS_DISABLE            (PORTCON_PORTA_PD_A2_VALUE_DISABLE << PORTCON_PORTA_PD_A2_SHIFT)
#define PORTCON_PORTA_PD_A2_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A2_BITS_ENABLE             (PORTCON_PORTA_PD_A2_VALUE_ENABLE << PORTCON_PORTA_PD_A2_SHIFT)

#define PORTCON_PORTA_PD_A3_SHIFT                   3
#define PORTCON_PORTA_PD_A3_WIDTH                   1
#define PORTCON_PORTA_PD_A3_MASK                    (((1U << PORTCON_PORTA_PD_A3_WIDTH) - 1U) << PORTCON_PORTA_PD_A3_SHIFT)
#define PORTCON_PORTA_PD_A3_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A3_BITS_DISABLE            (PORTCON_PORTA_PD_A3_VALUE_DISABLE << PORTCON_PORTA_PD_A3_SHIFT)
#define PORTCON_PORTA_PD_A3_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A3_BITS_ENABLE             (PORTCON_PORTA_PD_A3_VALUE_ENABLE << PORTCON_PORTA_PD_A3_SHIFT)

#define PORTCON_PORTA_PD_A4_SHIFT                   4
#define PORTCON_PORTA_PD_A4_WIDTH                   1
#define PORTCON_PORTA_PD_A4_MASK                    (((1U << PORTCON_PORTA_PD_A4_WIDTH) - 1U) << PORTCON_PORTA_PD_A4_SHIFT)
#define PORTCON_PORTA_PD_A4_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A4_BITS_DISABLE            (PORTCON_PORTA_PD_A4_VALUE_DISABLE << PORTCON_PORTA_PD_A4_SHIFT)
#define PORTCON_PORTA_PD_A4_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A4_BITS_ENABLE             (PORTCON_PORTA_PD_A4_VALUE_ENABLE << PORTCON_PORTA_PD_A4_SHIFT)

#define PORTCON_PORTA_PD_A5_SHIFT                   5
#define PORTCON_PORTA_PD_A5_WIDTH                   1
#define PORTCON_PORTA_PD_A5_MASK                    (((1U << PORTCON_PORTA_PD_A5_WIDTH) - 1U) << PORTCON_PORTA_PD_A5_SHIFT)
#define PORTCON_PORTA_PD_A5_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A5_BITS_DISABLE            (PORTCON_PORTA_PD_A5_VALUE_DISABLE << PORTCON_PORTA_PD_A5_SHIFT)
#define PORTCON_PORTA_PD_A5_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A5_BITS_ENABLE             (PORTCON_PORTA_PD_A5_VALUE_ENABLE << PORTCON_PORTA_PD_A5_SHIFT)

#define PORTCON_PORTA_PD_A6_SHIFT                   6
#define PORTCON_PORTA_PD_A6_WIDTH                   1
#define PORTCON_PORTA_PD_A6_MASK                    (((1U << PORTCON_PORTA_PD_A6_WIDTH) - 1U) << PORTCON_PORTA_PD_A6_SHIFT)
#define PORTCON_PORTA_PD_A6_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A6_BITS_DISABLE            (PORTCON_PORTA_PD_A6_VALUE_DISABLE << PORTCON_PORTA_PD_A6_SHIFT)
#define PORTCON_PORTA_PD_A6_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A6_BITS_ENABLE             (PORTCON_PORTA_PD_A6_VALUE_ENABLE << PORTCON_PORTA_PD_A6_SHIFT)

#define PORTCON_PORTA_PD_A7_SHIFT                   7
#define PORTCON_PORTA_PD_A7_WIDTH                   1
#define PORTCON_PORTA_PD_A7_MASK                    (((1U << PORTCON_PORTA_PD_A7_WIDTH) - 1U) << PORTCON_PORTA_PD_A7_SHIFT)
#define PORTCON_PORTA_PD_A7_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A7_BITS_DISABLE            (PORTCON_PORTA_PD_A7_VALUE_DISABLE << PORTCON_PORTA_PD_A7_SHIFT)
#define PORTCON_PORTA_PD_A7_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A7_BITS_ENABLE             (PORTCON_PORTA_PD_A7_VALUE_ENABLE << PORTCON_PORTA_PD_A7_SHIFT)

#define PORTCON_PORTA_PD_A8_SHIFT                   8
#define PORTCON_PORTA_PD_A8_WIDTH                   1
#define PORTCON_PORTA_PD_A8_MASK                    (((1U << PORTCON_PORTA_PD_A8_WIDTH) - 1U) << PORTCON_PORTA_PD_A8_SHIFT)
#define PORTCON_PORTA_PD_A8_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A8_BITS_DISABLE            (PORTCON_PORTA_PD_A8_VALUE_DISABLE << PORTCON_PORTA_PD_A8_SHIFT)
#define PORTCON_PORTA_PD_A8_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A8_BITS_ENABLE             (PORTCON_PORTA_PD_A8_VALUE_ENABLE << PORTCON_PORTA_PD_A8_SHIFT)

#define PORTCON_PORTA_PD_A9_SHIFT                   9
#define PORTCON_PORTA_PD_A9_WIDTH                   1
#define PORTCON_PORTA_PD_A9_MASK                    (((1U << PORTCON_PORTA_PD_A9_WIDTH) - 1U) << PORTCON_PORTA_PD_A9_SHIFT)
#define PORTCON_PORTA_PD_A9_VALUE_DISABLE           0U
#define PORTCON_PORTA_PD_A9_BITS_DISABLE            (PORTCON_PORTA_PD_A9_VALUE_DISABLE << PORTCON_PORTA_PD_A9_SHIFT)
#define PORTCON_PORTA_PD_A9_VALUE_ENABLE            1U
#define PORTCON_PORTA_PD_A9_BITS_ENABLE             (PORTCON_PORTA_PD_A9_VALUE_ENABLE << PORTCON_PORTA_PD_A9_SHIFT)

#define PORTCON_PORTA_PD_A10_SHIFT                  10
#define PORTCON_PORTA_PD_A10_WIDTH                  1
#define PORTCON_PORTA_PD_A10_MASK                   (((1U << PORTCON_PORTA_PD_A10_WIDTH) - 1U) << PORTCON_PORTA_PD_A10_SHIFT)
#define PORTCON_PORTA_PD_A10_VALUE_DISABLE          0U
#define PORTCON_PORTA_PD_A10_BITS_DISABLE           (PORTCON_PORTA_PD_A10_VALUE_DISABLE << PORTCON_PORTA_PD_A10_SHIFT)
#define PORTCON_PORTA_PD_A10_VALUE_ENABLE           1U
#define PORTCON_PORTA_PD_A10_BITS_ENABLE            (PORTCON_PORTA_PD_A10_VALUE_ENABLE << PORTCON_PORTA_PD_A10_SHIFT)

#define PORTCON_PORTA_PD_A11_SHIFT                  11
#define PORTCON_PORTA_PD_A11_WIDTH                  1
#define PORTCON_PORTA_PD_A11_MASK                   (((1U << PORTCON_PORTA_PD_A11_WIDTH) - 1U) << PORTCON_PORTA_PD_A11_SHIFT)
#define PORTCON_PORTA_PD_A11_VALUE_DISABLE          0U
#define PORTCON_PORTA_PD_A11_BITS_DISABLE           (PORTCON_PORTA_PD_A11_VALUE_DISABLE << PORTCON_PORTA_PD_A11_SHIFT)
#define PORTCON_PORTA_PD_A11_VALUE_ENABLE           1U
#define PORTCON_PORTA_PD_A11_BITS_ENABLE            (PORTCON_PORTA_PD_A11_VALUE_ENABLE << PORTCON_PORTA_PD_A11_SHIFT)

#define PORTCON_PORTA_PD_A12_SHIFT                  12
#define PORTCON_PORTA_PD_A12_WIDTH                  1
#define PORTCON_PORTA_PD_A12_MASK                   (((1U << PORTCON_PORTA_PD_A12_WIDTH) - 1U) << PORTCON_PORTA_PD_A12_SHIFT)
#define PORTCON_PORTA_PD_A12_VALUE_DISABLE          0U
#define PORTCON_PORTA_PD_A12_BITS_DISABLE           (PORTCON_PORTA_PD_A12_VALUE_DISABLE << PORTCON_PORTA_PD_A12_SHIFT)
#define PORTCON_PORTA_PD_A12_VALUE_ENABLE           1U
#define PORTCON_PORTA_PD_A12_BITS_ENABLE            (PORTCON_PORTA_PD_A12_VALUE_ENABLE << PORTCON_PORTA_PD_A12_SHIFT)

#define PORTCON_PORTA_PD_A13_SHIFT                  13
#define PORTCON_PORTA_PD_A13_WIDTH                  1
#define PORTCON_PORTA_PD_A13_MASK                   (((1U << PORTCON_PORTA_PD_A13_WIDTH) - 1U) << PORTCON_PORTA_PD_A13_SHIFT)
#define PORTCON_PORTA_PD_A13_VALUE_DISABLE          0U
#define PORTCON_PORTA_PD_A13_BITS_DISABLE           (PORTCON_PORTA_PD_A13_VALUE_DISABLE << PORTCON_PORTA_PD_A13_SHIFT)
#define PORTCON_PORTA_PD_A13_VALUE_ENABLE           1U
#define PORTCON_PORTA_PD_A13_BITS_ENABLE            (PORTCON_PORTA_PD_A13_VALUE_ENABLE << PORTCON_PORTA_PD_A13_SHIFT)

#define PORTCON_PORTA_PD_A14_SHIFT                  14
#define PORTCON_PORTA_PD_A14_WIDTH                  1
#define PORTCON_PORTA_PD_A14_MASK                   (((1U << PORTCON_PORTA_PD_A14_WIDTH) - 1U) << PORTCON_PORTA_PD_A14_SHIFT)
#define PORTCON_PORTA_PD_A14_VALUE_DISABLE          0U
#define PORTCON_PORTA_PD_A14_BITS_DISABLE           (PORTCON_PORTA_PD_A14_VALUE_DISABLE << PORTCON_PORTA_PD_A14_SHIFT)
#define PORTCON_PORTA_PD_A14_VALUE_ENABLE           1U
#define PORTCON_PORTA_PD_A14_BITS_ENABLE            (PORTCON_PORTA_PD_A14_VALUE_ENABLE << PORTCON_PORTA_PD_A14_SHIFT)

#define PORTCON_PORTA_PD_A15_SHIFT                  15
#define PORTCON_PORTA_PD_A15_WIDTH                  1
#define PORTCON_PORTA_PD_A15_MASK                   (((1U << PORTCON_PORTA_PD_A15_WIDTH) - 1U) << PORTCON_PORTA_PD_A15_SHIFT)
#define PORTCON_PORTA_PD_A15_VALUE_DISABLE          0U
#define PORTCON_PORTA_PD_A15_BITS_DISABLE           (PORTCON_PORTA_PD_A15_VALUE_DISABLE << PORTCON_PORTA_PD_A15_SHIFT)
#define PORTCON_PORTA_PD_A15_VALUE_ENABLE           1U
#define PORTCON_PORTA_PD_A15_BITS_ENABLE            (PORTCON_PORTA_PD_A15_VALUE_ENABLE << PORTCON_PORTA_PD_A15_SHIFT)

#define PORTCON_PORTB_PD_ADDR                       (PORTCON_BASE_ADDR + 0x0304U)
#define PORTCON_PORTB_PD                            (*(volatile uint32_t *)PORTCON_PORTB_PD_ADDR)
#define PORTCON_PORTB_PD_B0_SHIFT                   0
#define PORTCON_PORTB_PD_B0_WIDTH                   1
#define PORTCON_PORTB_PD_B0_MASK                    (((1U << PORTCON_PORTB_PD_B0_WIDTH) - 1U) << PORTCON_PORTB_PD_B0_SHIFT)
#define PORTCON_PORTB_PD_B0_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B0_BITS_DISABLE            (PORTCON_PORTB_PD_B0_VALUE_DISABLE << PORTCON_PORTB_PD_B0_SHIFT)
#define PORTCON_PORTB_PD_B0_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B0_BITS_ENABLE             (PORTCON_PORTB_PD_B0_VALUE_ENABLE << PORTCON_PORTB_PD_B0_SHIFT)

#define PORTCON_PORTB_PD_B1_SHIFT                   1
#define PORTCON_PORTB_PD_B1_WIDTH                   1
#define PORTCON_PORTB_PD_B1_MASK                    (((1U << PORTCON_PORTB_PD_B1_WIDTH) - 1U) << PORTCON_PORTB_PD_B1_SHIFT)
#define PORTCON_PORTB_PD_B1_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B1_BITS_DISABLE            (PORTCON_PORTB_PD_B1_VALUE_DISABLE << PORTCON_PORTB_PD_B1_SHIFT)
#define PORTCON_PORTB_PD_B1_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B1_BITS_ENABLE             (PORTCON_PORTB_PD_B1_VALUE_ENABLE << PORTCON_PORTB_PD_B1_SHIFT)

#define PORTCON_PORTB_PD_B2_SHIFT                   2
#define PORTCON_PORTB_PD_B2_WIDTH                   1
#define PORTCON_PORTB_PD_B2_MASK                    (((1U << PORTCON_PORTB_PD_B2_WIDTH) - 1U) << PORTCON_PORTB_PD_B2_SHIFT)
#define PORTCON_PORTB_PD_B2_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B2_BITS_DISABLE            (PORTCON_PORTB_PD_B2_VALUE_DISABLE << PORTCON_PORTB_PD_B2_SHIFT)
#define PORTCON_PORTB_PD_B2_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B2_BITS_ENABLE             (PORTCON_PORTB_PD_B2_VALUE_ENABLE << PORTCON_PORTB_PD_B2_SHIFT)

#define PORTCON_PORTB_PD_B3_SHIFT                   3
#define PORTCON_PORTB_PD_B3_WIDTH                   1
#define PORTCON_PORTB_PD_B3_MASK                    (((1U << PORTCON_PORTB_PD_B3_WIDTH) - 1U) << PORTCON_PORTB_PD_B3_SHIFT)
#define PORTCON_PORTB_PD_B3_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B3_BITS_DISABLE            (PORTCON_PORTB_PD_B3_VALUE_DISABLE << PORTCON_PORTB_PD_B3_SHIFT)
#define PORTCON_PORTB_PD_B3_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B3_BITS_ENABLE             (PORTCON_PORTB_PD_B3_VALUE_ENABLE << PORTCON_PORTB_PD_B3_SHIFT)

#define PORTCON_PORTB_PD_B4_SHIFT                   4
#define PORTCON_PORTB_PD_B4_WIDTH                   1
#define PORTCON_PORTB_PD_B4_MASK                    (((1U << PORTCON_PORTB_PD_B4_WIDTH) - 1U) << PORTCON_PORTB_PD_B4_SHIFT)
#define PORTCON_PORTB_PD_B4_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B4_BITS_DISABLE            (PORTCON_PORTB_PD_B4_VALUE_DISABLE << PORTCON_PORTB_PD_B4_SHIFT)
#define PORTCON_PORTB_PD_B4_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B4_BITS_ENABLE             (PORTCON_PORTB_PD_B4_VALUE_ENABLE << PORTCON_PORTB_PD_B4_SHIFT)

#define PORTCON_PORTB_PD_B5_SHIFT                   5
#define PORTCON_PORTB_PD_B5_WIDTH                   1
#define PORTCON_PORTB_PD_B5_MASK                    (((1U << PORTCON_PORTB_PD_B5_WIDTH) - 1U) << PORTCON_PORTB_PD_B5_SHIFT)
#define PORTCON_PORTB_PD_B5_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B5_BITS_DISABLE            (PORTCON_PORTB_PD_B5_VALUE_DISABLE << PORTCON_PORTB_PD_B5_SHIFT)
#define PORTCON_PORTB_PD_B5_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B5_BITS_ENABLE             (PORTCON_PORTB_PD_B5_VALUE_ENABLE << PORTCON_PORTB_PD_B5_SHIFT)

#define PORTCON_PORTB_PD_B6_SHIFT                   6
#define PORTCON_PORTB_PD_B6_WIDTH                   1
#define PORTCON_PORTB_PD_B6_MASK                    (((1U << PORTCON_PORTB_PD_B6_WIDTH) - 1U) << PORTCON_PORTB_PD_B6_SHIFT)
#define PORTCON_PORTB_PD_B6_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B6_BITS_DISABLE            (PORTCON_PORTB_PD_B6_VALUE_DISABLE << PORTCON_PORTB_PD_B6_SHIFT)
#define PORTCON_PORTB_PD_B6_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B6_BITS_ENABLE             (PORTCON_PORTB_PD_B6_VALUE_ENABLE << PORTCON_PORTB_PD_B6_SHIFT)

#define PORTCON_PORTB_PD_B7_SHIFT                   7
#define PORTCON_PORTB_PD_B7_WIDTH                   1
#define PORTCON_PORTB_PD_B7_MASK                    (((1U << PORTCON_PORTB_PD_B7_WIDTH) - 1U) << PORTCON_PORTB_PD_B7_SHIFT)
#define PORTCON_PORTB_PD_B7_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B7_BITS_DISABLE            (PORTCON_PORTB_PD_B7_VALUE_DISABLE << PORTCON_PORTB_PD_B7_SHIFT)
#define PORTCON_PORTB_PD_B7_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B7_BITS_ENABLE             (PORTCON_PORTB_PD_B7_VALUE_ENABLE << PORTCON_PORTB_PD_B7_SHIFT)

#define PORTCON_PORTB_PD_B8_SHIFT                   8
#define PORTCON_PORTB_PD_B8_WIDTH                   1
#define PORTCON_PORTB_PD_B8_MASK                    (((1U << PORTCON_PORTB_PD_B8_WIDTH) - 1U) << PORTCON_PORTB_PD_B8_SHIFT)
#define PORTCON_PORTB_PD_B8_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B8_BITS_DISABLE            (PORTCON_PORTB_PD_B8_VALUE_DISABLE << PORTCON_PORTB_PD_B8_SHIFT)
#define PORTCON_PORTB_PD_B8_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B8_BITS_ENABLE             (PORTCON_PORTB_PD_B8_VALUE_ENABLE << PORTCON_PORTB_PD_B8_SHIFT)

#define PORTCON_PORTB_PD_B9_SHIFT                   9
#define PORTCON_PORTB_PD_B9_WIDTH                   1
#define PORTCON_PORTB_PD_B9_MASK                    (((1U << PORTCON_PORTB_PD_B9_WIDTH) - 1U) << PORTCON_PORTB_PD_B9_SHIFT)
#define PORTCON_PORTB_PD_B9_VALUE_DISABLE           0U
#define PORTCON_PORTB_PD_B9_BITS_DISABLE            (PORTCON_PORTB_PD_B9_VALUE_DISABLE << PORTCON_PORTB_PD_B9_SHIFT)
#define PORTCON_PORTB_PD_B9_VALUE_ENABLE            1U
#define PORTCON_PORTB_PD_B9_BITS_ENABLE             (PORTCON_PORTB_PD_B9_VALUE_ENABLE << PORTCON_PORTB_PD_B9_SHIFT)

#define PORTCON_PORTB_PD_B10_SHIFT                  10
#define PORTCON_PORTB_PD_B10_WIDTH                  1
#define PORTCON_PORTB_PD_B10_MASK                   (((1U << PORTCON_PORTB_PD_B10_WIDTH) - 1U) << PORTCON_PORTB_PD_B10_SHIFT)
#define PORTCON_PORTB_PD_B10_VALUE_DISABLE          0U
#define PORTCON_PORTB_PD_B10_BITS_DISABLE           (PORTCON_PORTB_PD_B10_VALUE_DISABLE << PORTCON_PORTB_PD_B10_SHIFT)
#define PORTCON_PORTB_PD_B10_VALUE_ENABLE           1U
#define PORTCON_PORTB_PD_B10_BITS_ENABLE            (PORTCON_PORTB_PD_B10_VALUE_ENABLE << PORTCON_PORTB_PD_B10_SHIFT)

#define PORTCON_PORTB_PD_B11_SHIFT                  11
#define PORTCON_PORTB_PD_B11_WIDTH                  1
#define PORTCON_PORTB_PD_B11_MASK                   (((1U << PORTCON_PORTB_PD_B11_WIDTH) - 1U) << PORTCON_PORTB_PD_B11_SHIFT)
#define PORTCON_PORTB_PD_B11_VALUE_DISABLE          0U
#define PORTCON_PORTB_PD_B11_BITS_DISABLE           (PORTCON_PORTB_PD_B11_VALUE_DISABLE << PORTCON_PORTB_PD_B11_SHIFT)
#define PORTCON_PORTB_PD_B11_VALUE_ENABLE           1U
#define PORTCON_PORTB_PD_B11_BITS_ENABLE            (PORTCON_PORTB_PD_B11_VALUE_ENABLE << PORTCON_PORTB_PD_B11_SHIFT)

#define PORTCON_PORTB_PD_B12_SHIFT                  12
#define PORTCON_PORTB_PD_B12_WIDTH                  1
#define PORTCON_PORTB_PD_B12_MASK                   (((1U << PORTCON_PORTB_PD_B12_WIDTH) - 1U) << PORTCON_PORTB_PD_B12_SHIFT)
#define PORTCON_PORTB_PD_B12_VALUE_DISABLE          0U
#define PORTCON_PORTB_PD_B12_BITS_DISABLE           (PORTCON_PORTB_PD_B12_VALUE_DISABLE << PORTCON_PORTB_PD_B12_SHIFT)
#define PORTCON_PORTB_PD_B12_VALUE_ENABLE           1U
#define PORTCON_PORTB_PD_B12_BITS_ENABLE            (PORTCON_PORTB_PD_B12_VALUE_ENABLE << PORTCON_PORTB_PD_B12_SHIFT)

#define PORTCON_PORTB_PD_B13_SHIFT                  13
#define PORTCON_PORTB_PD_B13_WIDTH                  1
#define PORTCON_PORTB_PD_B13_MASK                   (((1U << PORTCON_PORTB_PD_B13_WIDTH) - 1U) << PORTCON_PORTB_PD_B13_SHIFT)
#define PORTCON_PORTB_PD_B13_VALUE_DISABLE          0U
#define PORTCON_PORTB_PD_B13_BITS_DISABLE           (PORTCON_PORTB_PD_B13_VALUE_DISABLE << PORTCON_PORTB_PD_B13_SHIFT)
#define PORTCON_PORTB_PD_B13_VALUE_ENABLE           1U
#define PORTCON_PORTB_PD_B13_BITS_ENABLE            (PORTCON_PORTB_PD_B13_VALUE_ENABLE << PORTCON_PORTB_PD_B13_SHIFT)

#define PORTCON_PORTB_PD_B14_SHIFT                  14
#define PORTCON_PORTB_PD_B14_WIDTH                  1
#define PORTCON_PORTB_PD_B14_MASK                   (((1U << PORTCON_PORTB_PD_B14_WIDTH) - 1U) << PORTCON_PORTB_PD_B14_SHIFT)
#define PORTCON_PORTB_PD_B14_VALUE_DISABLE          0U
#define PORTCON_PORTB_PD_B14_BITS_DISABLE           (PORTCON_PORTB_PD_B14_VALUE_DISABLE << PORTCON_PORTB_PD_B14_SHIFT)
#define PORTCON_PORTB_PD_B14_VALUE_ENABLE           1U
#define PORTCON_PORTB_PD_B14_BITS_ENABLE            (PORTCON_PORTB_PD_B14_VALUE_ENABLE << PORTCON_PORTB_PD_B14_SHIFT)

#define PORTCON_PORTB_PD_B15_SHIFT                  15
#define PORTCON_PORTB_PD_B15_WIDTH                  1
#define PORTCON_PORTB_PD_B15_MASK                   (((1U << PORTCON_PORTB_PD_B15_WIDTH) - 1U) << PORTCON_PORTB_PD_B15_SHIFT)
#define PORTCON_PORTB_PD_B15_VALUE_DISABLE          0U
#define PORTCON_PORTB_PD_B15_BITS_DISABLE           (PORTCON_PORTB_PD_B15_VALUE_DISABLE << PORTCON_PORTB_PD_B15_SHIFT)
#define PORTCON_PORTB_PD_B15_VALUE_ENABLE           1U
#define PORTCON_PORTB_PD_B15_BITS_ENABLE            (PORTCON_PORTB_PD_B15_VALUE_ENABLE << PORTCON_PORTB_PD_B15_SHIFT)

#define PORTCON_PORTC_PD_ADDR                       (PORTCON_BASE_ADDR + 0x0308U)
#define PORTCON_PORTC_PD                            (*(volatile uint32_t *)PORTCON_PORTC_PD_ADDR)
#define PORTCON_PORTC_PD_C0_SHIFT                   0
#define PORTCON_PORTC_PD_C0_WIDTH                   1
#define PORTCON_PORTC_PD_C0_MASK                    (((1U << PORTCON_PORTC_PD_C0_WIDTH) - 1U) << PORTCON_PORTC_PD_C0_SHIFT)
#define PORTCON_PORTC_PD_C0_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C0_BITS_DISABLE            (PORTCON_PORTC_PD_C0_VALUE_DISABLE << PORTCON_PORTC_PD_C0_SHIFT)
#define PORTCON_PORTC_PD_C0_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C0_BITS_ENABLE             (PORTCON_PORTC_PD_C0_VALUE_ENABLE << PORTCON_PORTC_PD_C0_SHIFT)

#define PORTCON_PORTC_PD_C1_SHIFT                   1
#define PORTCON_PORTC_PD_C1_WIDTH                   1
#define PORTCON_PORTC_PD_C1_MASK                    (((1U << PORTCON_PORTC_PD_C1_WIDTH) - 1U) << PORTCON_PORTC_PD_C1_SHIFT)
#define PORTCON_PORTC_PD_C1_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C1_BITS_DISABLE            (PORTCON_PORTC_PD_C1_VALUE_DISABLE << PORTCON_PORTC_PD_C1_SHIFT)
#define PORTCON_PORTC_PD_C1_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C1_BITS_ENABLE             (PORTCON_PORTC_PD_C1_VALUE_ENABLE << PORTCON_PORTC_PD_C1_SHIFT)

#define PORTCON_PORTC_PD_C2_SHIFT                   2
#define PORTCON_PORTC_PD_C2_WIDTH                   1
#define PORTCON_PORTC_PD_C2_MASK                    (((1U << PORTCON_PORTC_PD_C2_WIDTH) - 1U) << PORTCON_PORTC_PD_C2_SHIFT)
#define PORTCON_PORTC_PD_C2_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C2_BITS_DISABLE            (PORTCON_PORTC_PD_C2_VALUE_DISABLE << PORTCON_PORTC_PD_C2_SHIFT)
#define PORTCON_PORTC_PD_C2_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C2_BITS_ENABLE             (PORTCON_PORTC_PD_C2_VALUE_ENABLE << PORTCON_PORTC_PD_C2_SHIFT)

#define PORTCON_PORTC_PD_C3_SHIFT                   3
#define PORTCON_PORTC_PD_C3_WIDTH                   1
#define PORTCON_PORTC_PD_C3_MASK                    (((1U << PORTCON_PORTC_PD_C3_WIDTH) - 1U) << PORTCON_PORTC_PD_C3_SHIFT)
#define PORTCON_PORTC_PD_C3_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C3_BITS_DISABLE            (PORTCON_PORTC_PD_C3_VALUE_DISABLE << PORTCON_PORTC_PD_C3_SHIFT)
#define PORTCON_PORTC_PD_C3_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C3_BITS_ENABLE             (PORTCON_PORTC_PD_C3_VALUE_ENABLE << PORTCON_PORTC_PD_C3_SHIFT)

#define PORTCON_PORTC_PD_C4_SHIFT                   4
#define PORTCON_PORTC_PD_C4_WIDTH                   1
#define PORTCON_PORTC_PD_C4_MASK                    (((1U << PORTCON_PORTC_PD_C4_WIDTH) - 1U) << PORTCON_PORTC_PD_C4_SHIFT)
#define PORTCON_PORTC_PD_C4_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C4_BITS_DISABLE            (PORTCON_PORTC_PD_C4_VALUE_DISABLE << PORTCON_PORTC_PD_C4_SHIFT)
#define PORTCON_PORTC_PD_C4_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C4_BITS_ENABLE             (PORTCON_PORTC_PD_C4_VALUE_ENABLE << PORTCON_PORTC_PD_C4_SHIFT)

#define PORTCON_PORTC_PD_C5_SHIFT                   5
#define PORTCON_PORTC_PD_C5_WIDTH                   1
#define PORTCON_PORTC_PD_C5_MASK                    (((1U << PORTCON_PORTC_PD_C5_WIDTH) - 1U) << PORTCON_PORTC_PD_C5_SHIFT)
#define PORTCON_PORTC_PD_C5_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C5_BITS_DISABLE            (PORTCON_PORTC_PD_C5_VALUE_DISABLE << PORTCON_PORTC_PD_C5_SHIFT)
#define PORTCON_PORTC_PD_C5_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C5_BITS_ENABLE             (PORTCON_PORTC_PD_C5_VALUE_ENABLE << PORTCON_PORTC_PD_C5_SHIFT)

#define PORTCON_PORTC_PD_C6_SHIFT                   6
#define PORTCON_PORTC_PD_C6_WIDTH                   1
#define PORTCON_PORTC_PD_C6_MASK                    (((1U << PORTCON_PORTC_PD_C6_WIDTH) - 1U) << PORTCON_PORTC_PD_C6_SHIFT)
#define PORTCON_PORTC_PD_C6_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C6_BITS_DISABLE            (PORTCON_PORTC_PD_C6_VALUE_DISABLE << PORTCON_PORTC_PD_C6_SHIFT)
#define PORTCON_PORTC_PD_C6_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C6_BITS_ENABLE             (PORTCON_PORTC_PD_C6_VALUE_ENABLE << PORTCON_PORTC_PD_C6_SHIFT)

#define PORTCON_PORTC_PD_C7_SHIFT                   7
#define PORTCON_PORTC_PD_C7_WIDTH                   1
#define PORTCON_PORTC_PD_C7_MASK                    (((1U << PORTCON_PORTC_PD_C7_WIDTH) - 1U) << PORTCON_PORTC_PD_C7_SHIFT)
#define PORTCON_PORTC_PD_C7_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C7_BITS_DISABLE            (PORTCON_PORTC_PD_C7_VALUE_DISABLE << PORTCON_PORTC_PD_C7_SHIFT)
#define PORTCON_PORTC_PD_C7_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C7_BITS_ENABLE             (PORTCON_PORTC_PD_C7_VALUE_ENABLE << PORTCON_PORTC_PD_C7_SHIFT)

#define PORTCON_PORTC_PD_C8_SHIFT                   8
#define PORTCON_PORTC_PD_C8_WIDTH                   1
#define PORTCON_PORTC_PD_C8_MASK                    (((1U << PORTCON_PORTC_PD_C8_WIDTH) - 1U) << PORTCON_PORTC_PD_C8_SHIFT)
#define PORTCON_PORTC_PD_C8_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C8_BITS_DISABLE            (PORTCON_PORTC_PD_C8_VALUE_DISABLE << PORTCON_PORTC_PD_C8_SHIFT)
#define PORTCON_PORTC_PD_C8_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C8_BITS_ENABLE             (PORTCON_PORTC_PD_C8_VALUE_ENABLE << PORTCON_PORTC_PD_C8_SHIFT)

#define PORTCON_PORTC_PD_C9_SHIFT                   9
#define PORTCON_PORTC_PD_C9_WIDTH                   1
#define PORTCON_PORTC_PD_C9_MASK                    (((1U << PORTCON_PORTC_PD_C9_WIDTH) - 1U) << PORTCON_PORTC_PD_C9_SHIFT)
#define PORTCON_PORTC_PD_C9_VALUE_DISABLE           0U
#define PORTCON_PORTC_PD_C9_BITS_DISABLE            (PORTCON_PORTC_PD_C9_VALUE_DISABLE << PORTCON_PORTC_PD_C9_SHIFT)
#define PORTCON_PORTC_PD_C9_VALUE_ENABLE            1U
#define PORTCON_PORTC_PD_C9_BITS_ENABLE             (PORTCON_PORTC_PD_C9_VALUE_ENABLE << PORTCON_PORTC_PD_C9_SHIFT)

#define PORTCON_PORTC_PD_C10_SHIFT                  10
#define PORTCON_PORTC_PD_C10_WIDTH                  1
#define PORTCON_PORTC_PD_C10_MASK                   (((1U << PORTCON_PORTC_PD_C10_WIDTH) - 1U) << PORTCON_PORTC_PD_C10_SHIFT)
#define PORTCON_PORTC_PD_C10_VALUE_DISABLE          0U
#define PORTCON_PORTC_PD_C10_BITS_DISABLE           (PORTCON_PORTC_PD_C10_VALUE_DISABLE << PORTCON_PORTC_PD_C10_SHIFT)
#define PORTCON_PORTC_PD_C10_VALUE_ENABLE           1U
#define PORTCON_PORTC_PD_C10_BITS_ENABLE            (PORTCON_PORTC_PD_C10_VALUE_ENABLE << PORTCON_PORTC_PD_C10_SHIFT)

#define PORTCON_PORTC_PD_C11_SHIFT                  11
#define PORTCON_PORTC_PD_C11_WIDTH                  1
#define PORTCON_PORTC_PD_C11_MASK                   (((1U << PORTCON_PORTC_PD_C11_WIDTH) - 1U) << PORTCON_PORTC_PD_C11_SHIFT)
#define PORTCON_PORTC_PD_C11_VALUE_DISABLE          0U
#define PORTCON_PORTC_PD_C11_BITS_DISABLE           (PORTCON_PORTC_PD_C11_VALUE_DISABLE << PORTCON_PORTC_PD_C11_SHIFT)
#define PORTCON_PORTC_PD_C11_VALUE_ENABLE           1U
#define PORTCON_PORTC_PD_C11_BITS_ENABLE            (PORTCON_PORTC_PD_C11_VALUE_ENABLE << PORTCON_PORTC_PD_C11_SHIFT)

#define PORTCON_PORTC_PD_C12_SHIFT                  12
#define PORTCON_PORTC_PD_C12_WIDTH                  1
#define PORTCON_PORTC_PD_C12_MASK                   (((1U << PORTCON_PORTC_PD_C12_WIDTH) - 1U) << PORTCON_PORTC_PD_C12_SHIFT)
#define PORTCON_PORTC_PD_C12_VALUE_DISABLE          0U
#define PORTCON_PORTC_PD_C12_BITS_DISABLE           (PORTCON_PORTC_PD_C12_VALUE_DISABLE << PORTCON_PORTC_PD_C12_SHIFT)
#define PORTCON_PORTC_PD_C12_VALUE_ENABLE           1U
#define PORTCON_PORTC_PD_C12_BITS_ENABLE            (PORTCON_PORTC_PD_C12_VALUE_ENABLE << PORTCON_PORTC_PD_C12_SHIFT)

#define PORTCON_PORTC_PD_C13_SHIFT                  13
#define PORTCON_PORTC_PD_C13_WIDTH                  1
#define PORTCON_PORTC_PD_C13_MASK                   (((1U << PORTCON_PORTC_PD_C13_WIDTH) - 1U) << PORTCON_PORTC_PD_C13_SHIFT)
#define PORTCON_PORTC_PD_C13_VALUE_DISABLE          0U
#define PORTCON_PORTC_PD_C13_BITS_DISABLE           (PORTCON_PORTC_PD_C13_VALUE_DISABLE << PORTCON_PORTC_PD_C13_SHIFT)
#define PORTCON_PORTC_PD_C13_VALUE_ENABLE           1U
#define PORTCON_PORTC_PD_C13_BITS_ENABLE            (PORTCON_PORTC_PD_C13_VALUE_ENABLE << PORTCON_PORTC_PD_C13_SHIFT)

#define PORTCON_PORTC_PD_C14_SHIFT                  14
#define PORTCON_PORTC_PD_C14_WIDTH                  1
#define PORTCON_PORTC_PD_C14_MASK                   (((1U << PORTCON_PORTC_PD_C14_WIDTH) - 1U) << PORTCON_PORTC_PD_C14_SHIFT)
#define PORTCON_PORTC_PD_C14_VALUE_DISABLE          0U
#define PORTCON_PORTC_PD_C14_BITS_DISABLE           (PORTCON_PORTC_PD_C14_VALUE_DISABLE << PORTCON_PORTC_PD_C14_SHIFT)
#define PORTCON_PORTC_PD_C14_VALUE_ENABLE           1U
#define PORTCON_PORTC_PD_C14_BITS_ENABLE            (PORTCON_PORTC_PD_C14_VALUE_ENABLE << PORTCON_PORTC_PD_C14_SHIFT)

#define PORTCON_PORTC_PD_C15_SHIFT                  15
#define PORTCON_PORTC_PD_C15_WIDTH                  1
#define PORTCON_PORTC_PD_C15_MASK                   (((1U << PORTCON_PORTC_PD_C15_WIDTH) - 1U) << PORTCON_PORTC_PD_C15_SHIFT)
#define PORTCON_PORTC_PD_C15_VALUE_DISABLE          0U
#define PORTCON_PORTC_PD_C15_BITS_DISABLE           (PORTCON_PORTC_PD_C15_VALUE_DISABLE << PORTCON_PORTC_PD_C15_SHIFT)
#define PORTCON_PORTC_PD_C15_VALUE_ENABLE           1U
#define PORTCON_PORTC_PD_C15_BITS_ENABLE            (PORTCON_PORTC_PD_C15_VALUE_ENABLE << PORTCON_PORTC_PD_C15_SHIFT)

#define PORTCON_PORTA_OD_ADDR                       (PORTCON_BASE_ADDR + 0x0400U)
#define PORTCON_PORTA_OD                            (*(volatile uint32_t *)PORTCON_PORTA_OD_ADDR)
#define PORTCON_PORTA_OD_A0_SHIFT                   0
#define PORTCON_PORTA_OD_A0_WIDTH                   1
#define PORTCON_PORTA_OD_A0_MASK                    (((1U << PORTCON_PORTA_OD_A0_WIDTH) - 1U) << PORTCON_PORTA_OD_A0_SHIFT)
#define PORTCON_PORTA_OD_A0_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A0_BITS_DISABLE            (PORTCON_PORTA_OD_A0_VALUE_DISABLE << PORTCON_PORTA_OD_A0_SHIFT)
#define PORTCON_PORTA_OD_A0_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A0_BITS_ENABLE             (PORTCON_PORTA_OD_A0_VALUE_ENABLE << PORTCON_PORTA_OD_A0_SHIFT)

#define PORTCON_PORTA_OD_A1_SHIFT                   1
#define PORTCON_PORTA_OD_A1_WIDTH                   1
#define PORTCON_PORTA_OD_A1_MASK                    (((1U << PORTCON_PORTA_OD_A1_WIDTH) - 1U) << PORTCON_PORTA_OD_A1_SHIFT)
#define PORTCON_PORTA_OD_A1_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A1_BITS_DISABLE            (PORTCON_PORTA_OD_A1_VALUE_DISABLE << PORTCON_PORTA_OD_A1_SHIFT)
#define PORTCON_PORTA_OD_A1_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A1_BITS_ENABLE             (PORTCON_PORTA_OD_A1_VALUE_ENABLE << PORTCON_PORTA_OD_A1_SHIFT)

#define PORTCON_PORTA_OD_A2_SHIFT                   2
#define PORTCON_PORTA_OD_A2_WIDTH                   1
#define PORTCON_PORTA_OD_A2_MASK                    (((1U << PORTCON_PORTA_OD_A2_WIDTH) - 1U) << PORTCON_PORTA_OD_A2_SHIFT)
#define PORTCON_PORTA_OD_A2_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A2_BITS_DISABLE            (PORTCON_PORTA_OD_A2_VALUE_DISABLE << PORTCON_PORTA_OD_A2_SHIFT)
#define PORTCON_PORTA_OD_A2_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A2_BITS_ENABLE             (PORTCON_PORTA_OD_A2_VALUE_ENABLE << PORTCON_PORTA_OD_A2_SHIFT)

#define PORTCON_PORTA_OD_A3_SHIFT                   3
#define PORTCON_PORTA_OD_A3_WIDTH                   1
#define PORTCON_PORTA_OD_A3_MASK                    (((1U << PORTCON_PORTA_OD_A3_WIDTH) - 1U) << PORTCON_PORTA_OD_A3_SHIFT)
#define PORTCON_PORTA_OD_A3_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A3_BITS_DISABLE            (PORTCON_PORTA_OD_A3_VALUE_DISABLE << PORTCON_PORTA_OD_A3_SHIFT)
#define PORTCON_PORTA_OD_A3_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A3_BITS_ENABLE             (PORTCON_PORTA_OD_A3_VALUE_ENABLE << PORTCON_PORTA_OD_A3_SHIFT)

#define PORTCON_PORTA_OD_A4_SHIFT                   4
#define PORTCON_PORTA_OD_A4_WIDTH                   1
#define PORTCON_PORTA_OD_A4_MASK                    (((1U << PORTCON_PORTA_OD_A4_WIDTH) - 1U) << PORTCON_PORTA_OD_A4_SHIFT)
#define PORTCON_PORTA_OD_A4_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A4_BITS_DISABLE            (PORTCON_PORTA_OD_A4_VALUE_DISABLE << PORTCON_PORTA_OD_A4_SHIFT)
#define PORTCON_PORTA_OD_A4_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A4_BITS_ENABLE             (PORTCON_PORTA_OD_A4_VALUE_ENABLE << PORTCON_PORTA_OD_A4_SHIFT)

#define PORTCON_PORTA_OD_A5_SHIFT                   5
#define PORTCON_PORTA_OD_A5_WIDTH                   1
#define PORTCON_PORTA_OD_A5_MASK                    (((1U << PORTCON_PORTA_OD_A5_WIDTH) - 1U) << PORTCON_PORTA_OD_A5_SHIFT)
#define PORTCON_PORTA_OD_A5_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A5_BITS_DISABLE            (PORTCON_PORTA_OD_A5_VALUE_DISABLE << PORTCON_PORTA_OD_A5_SHIFT)
#define PORTCON_PORTA_OD_A5_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A5_BITS_ENABLE             (PORTCON_PORTA_OD_A5_VALUE_ENABLE << PORTCON_PORTA_OD_A5_SHIFT)

#define PORTCON_PORTA_OD_A6_SHIFT                   6
#define PORTCON_PORTA_OD_A6_WIDTH                   1
#define PORTCON_PORTA_OD_A6_MASK                    (((1U << PORTCON_PORTA_OD_A6_WIDTH) - 1U) << PORTCON_PORTA_OD_A6_SHIFT)
#define PORTCON_PORTA_OD_A6_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A6_BITS_DISABLE            (PORTCON_PORTA_OD_A6_VALUE_DISABLE << PORTCON_PORTA_OD_A6_SHIFT)
#define PORTCON_PORTA_OD_A6_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A6_BITS_ENABLE             (PORTCON_PORTA_OD_A6_VALUE_ENABLE << PORTCON_PORTA_OD_A6_SHIFT)

#define PORTCON_PORTA_OD_A7_SHIFT                   7
#define PORTCON_PORTA_OD_A7_WIDTH                   1
#define PORTCON_PORTA_OD_A7_MASK                    (((1U << PORTCON_PORTA_OD_A7_WIDTH) - 1U) << PORTCON_PORTA_OD_A7_SHIFT)
#define PORTCON_PORTA_OD_A7_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A7_BITS_DISABLE            (PORTCON_PORTA_OD_A7_VALUE_DISABLE << PORTCON_PORTA_OD_A7_SHIFT)
#define PORTCON_PORTA_OD_A7_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A7_BITS_ENABLE             (PORTCON_PORTA_OD_A7_VALUE_ENABLE << PORTCON_PORTA_OD_A7_SHIFT)

#define PORTCON_PORTA_OD_A8_SHIFT                   8
#define PORTCON_PORTA_OD_A8_WIDTH                   1
#define PORTCON_PORTA_OD_A8_MASK                    (((1U << PORTCON_PORTA_OD_A8_WIDTH) - 1U) << PORTCON_PORTA_OD_A8_SHIFT)
#define PORTCON_PORTA_OD_A8_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A8_BITS_DISABLE            (PORTCON_PORTA_OD_A8_VALUE_DISABLE << PORTCON_PORTA_OD_A8_SHIFT)
#define PORTCON_PORTA_OD_A8_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A8_BITS_ENABLE             (PORTCON_PORTA_OD_A8_VALUE_ENABLE << PORTCON_PORTA_OD_A8_SHIFT)

#define PORTCON_PORTA_OD_A9_SHIFT                   9
#define PORTCON_PORTA_OD_A9_WIDTH                   1
#define PORTCON_PORTA_OD_A9_MASK                    (((1U << PORTCON_PORTA_OD_A9_WIDTH) - 1U) << PORTCON_PORTA_OD_A9_SHIFT)
#define PORTCON_PORTA_OD_A9_VALUE_DISABLE           0U
#define PORTCON_PORTA_OD_A9_BITS_DISABLE            (PORTCON_PORTA_OD_A9_VALUE_DISABLE << PORTCON_PORTA_OD_A9_SHIFT)
#define PORTCON_PORTA_OD_A9_VALUE_ENABLE            1U
#define PORTCON_PORTA_OD_A9_BITS_ENABLE             (PORTCON_PORTA_OD_A9_VALUE_ENABLE << PORTCON_PORTA_OD_A9_SHIFT)

#define PORTCON_PORTA_OD_A10_SHIFT                  10
#define PORTCON_PORTA_OD_A10_WIDTH                  1
#define PORTCON_PORTA_OD_A10_MASK                   (((1U << PORTCON_PORTA_OD_A10_WIDTH) - 1U) << PORTCON_PORTA_OD_A10_SHIFT)
#define PORTCON_PORTA_OD_A10_VALUE_DISABLE          0U
#define PORTCON_PORTA_OD_A10_BITS_DISABLE           (PORTCON_PORTA_OD_A10_VALUE_DISABLE << PORTCON_PORTA_OD_A10_SHIFT)
#define PORTCON_PORTA_OD_A10_VALUE_ENABLE           1U
#define PORTCON_PORTA_OD_A10_BITS_ENABLE            (PORTCON_PORTA_OD_A10_VALUE_ENABLE << PORTCON_PORTA_OD_A10_SHIFT)

#define PORTCON_PORTA_OD_A11_SHIFT                  11
#define PORTCON_PORTA_OD_A11_WIDTH                  1
#define PORTCON_PORTA_OD_A11_MASK                   (((1U << PORTCON_PORTA_OD_A11_WIDTH) - 1U) << PORTCON_PORTA_OD_A11_SHIFT)
#define PORTCON_PORTA_OD_A11_VALUE_DISABLE          0U
#define PORTCON_PORTA_OD_A11_BITS_DISABLE           (PORTCON_PORTA_OD_A11_VALUE_DISABLE << PORTCON_PORTA_OD_A11_SHIFT)
#define PORTCON_PORTA_OD_A11_VALUE_ENABLE           1U
#define PORTCON_PORTA_OD_A11_BITS_ENABLE            (PORTCON_PORTA_OD_A11_VALUE_ENABLE << PORTCON_PORTA_OD_A11_SHIFT)

#define PORTCON_PORTA_OD_A12_SHIFT                  12
#define PORTCON_PORTA_OD_A12_WIDTH                  1
#define PORTCON_PORTA_OD_A12_MASK                   (((1U << PORTCON_PORTA_OD_A12_WIDTH) - 1U) << PORTCON_PORTA_OD_A12_SHIFT)
#define PORTCON_PORTA_OD_A12_VALUE_DISABLE          0U
#define PORTCON_PORTA_OD_A12_BITS_DISABLE           (PORTCON_PORTA_OD_A12_VALUE_DISABLE << PORTCON_PORTA_OD_A12_SHIFT)
#define PORTCON_PORTA_OD_A12_VALUE_ENABLE           1U
#define PORTCON_PORTA_OD_A12_BITS_ENABLE            (PORTCON_PORTA_OD_A12_VALUE_ENABLE << PORTCON_PORTA_OD_A12_SHIFT)

#define PORTCON_PORTA_OD_A13_SHIFT                  13
#define PORTCON_PORTA_OD_A13_WIDTH                  1
#define PORTCON_PORTA_OD_A13_MASK                   (((1U << PORTCON_PORTA_OD_A13_WIDTH) - 1U) << PORTCON_PORTA_OD_A13_SHIFT)
#define PORTCON_PORTA_OD_A13_VALUE_DISABLE          0U
#define PORTCON_PORTA_OD_A13_BITS_DISABLE           (PORTCON_PORTA_OD_A13_VALUE_DISABLE << PORTCON_PORTA_OD_A13_SHIFT)
#define PORTCON_PORTA_OD_A13_VALUE_ENABLE           1U
#define PORTCON_PORTA_OD_A13_BITS_ENABLE            (PORTCON_PORTA_OD_A13_VALUE_ENABLE << PORTCON_PORTA_OD_A13_SHIFT)

#define PORTCON_PORTA_OD_A14_SHIFT                  14
#define PORTCON_PORTA_OD_A14_WIDTH                  1
#define PORTCON_PORTA_OD_A14_MASK                   (((1U << PORTCON_PORTA_OD_A14_WIDTH) - 1U) << PORTCON_PORTA_OD_A14_SHIFT)
#define PORTCON_PORTA_OD_A14_VALUE_DISABLE          0U
#define PORTCON_PORTA_OD_A14_BITS_DISABLE           (PORTCON_PORTA_OD_A14_VALUE_DISABLE << PORTCON_PORTA_OD_A14_SHIFT)
#define PORTCON_PORTA_OD_A14_VALUE_ENABLE           1U
#define PORTCON_PORTA_OD_A14_BITS_ENABLE            (PORTCON_PORTA_OD_A14_VALUE_ENABLE << PORTCON_PORTA_OD_A14_SHIFT)

#define PORTCON_PORTA_OD_A15_SHIFT                  15
#define PORTCON_PORTA_OD_A15_WIDTH                  1
#define PORTCON_PORTA_OD_A15_MASK                   (((1U << PORTCON_PORTA_OD_A15_WIDTH) - 1U) << PORTCON_PORTA_OD_A15_SHIFT)
#define PORTCON_PORTA_OD_A15_VALUE_DISABLE          0U
#define PORTCON_PORTA_OD_A15_BITS_DISABLE           (PORTCON_PORTA_OD_A15_VALUE_DISABLE << PORTCON_PORTA_OD_A15_SHIFT)
#define PORTCON_PORTA_OD_A15_VALUE_ENABLE           1U
#define PORTCON_PORTA_OD_A15_BITS_ENABLE            (PORTCON_PORTA_OD_A15_VALUE_ENABLE << PORTCON_PORTA_OD_A15_SHIFT)

#define PORTCON_PORTB_OD_ADDR                       (PORTCON_BASE_ADDR + 0x0404U)
#define PORTCON_PORTB_OD                            (*(volatile uint32_t *)PORTCON_PORTB_OD_ADDR)
#define PORTCON_PORTB_OD_B0_SHIFT                   0
#define PORTCON_PORTB_OD_B0_WIDTH                   1
#define PORTCON_PORTB_OD_B0_MASK                    (((1U << PORTCON_PORTB_OD_B0_WIDTH) - 1U) << PORTCON_PORTB_OD_B0_SHIFT)
#define PORTCON_PORTB_OD_B0_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B0_BITS_DISABLE            (PORTCON_PORTB_OD_B0_VALUE_DISABLE << PORTCON_PORTB_OD_B0_SHIFT)
#define PORTCON_PORTB_OD_B0_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B0_BITS_ENABLE             (PORTCON_PORTB_OD_B0_VALUE_ENABLE << PORTCON_PORTB_OD_B0_SHIFT)

#define PORTCON_PORTB_OD_B1_SHIFT                   1
#define PORTCON_PORTB_OD_B1_WIDTH                   1
#define PORTCON_PORTB_OD_B1_MASK                    (((1U << PORTCON_PORTB_OD_B1_WIDTH) - 1U) << PORTCON_PORTB_OD_B1_SHIFT)
#define PORTCON_PORTB_OD_B1_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B1_BITS_DISABLE            (PORTCON_PORTB_OD_B1_VALUE_DISABLE << PORTCON_PORTB_OD_B1_SHIFT)
#define PORTCON_PORTB_OD_B1_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B1_BITS_ENABLE             (PORTCON_PORTB_OD_B1_VALUE_ENABLE << PORTCON_PORTB_OD_B1_SHIFT)

#define PORTCON_PORTB_OD_B2_SHIFT                   2
#define PORTCON_PORTB_OD_B2_WIDTH                   1
#define PORTCON_PORTB_OD_B2_MASK                    (((1U << PORTCON_PORTB_OD_B2_WIDTH) - 1U) << PORTCON_PORTB_OD_B2_SHIFT)
#define PORTCON_PORTB_OD_B2_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B2_BITS_DISABLE            (PORTCON_PORTB_OD_B2_VALUE_DISABLE << PORTCON_PORTB_OD_B2_SHIFT)
#define PORTCON_PORTB_OD_B2_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B2_BITS_ENABLE             (PORTCON_PORTB_OD_B2_VALUE_ENABLE << PORTCON_PORTB_OD_B2_SHIFT)

#define PORTCON_PORTB_OD_B3_SHIFT                   3
#define PORTCON_PORTB_OD_B3_WIDTH                   1
#define PORTCON_PORTB_OD_B3_MASK                    (((1U << PORTCON_PORTB_OD_B3_WIDTH) - 1U) << PORTCON_PORTB_OD_B3_SHIFT)
#define PORTCON_PORTB_OD_B3_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B3_BITS_DISABLE            (PORTCON_PORTB_OD_B3_VALUE_DISABLE << PORTCON_PORTB_OD_B3_SHIFT)
#define PORTCON_PORTB_OD_B3_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B3_BITS_ENABLE             (PORTCON_PORTB_OD_B3_VALUE_ENABLE << PORTCON_PORTB_OD_B3_SHIFT)

#define PORTCON_PORTB_OD_B4_SHIFT                   4
#define PORTCON_PORTB_OD_B4_WIDTH                   1
#define PORTCON_PORTB_OD_B4_MASK                    (((1U << PORTCON_PORTB_OD_B4_WIDTH) - 1U) << PORTCON_PORTB_OD_B4_SHIFT)
#define PORTCON_PORTB_OD_B4_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B4_BITS_DISABLE            (PORTCON_PORTB_OD_B4_VALUE_DISABLE << PORTCON_PORTB_OD_B4_SHIFT)
#define PORTCON_PORTB_OD_B4_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B4_BITS_ENABLE             (PORTCON_PORTB_OD_B4_VALUE_ENABLE << PORTCON_PORTB_OD_B4_SHIFT)

#define PORTCON_PORTB_OD_B5_SHIFT                   5
#define PORTCON_PORTB_OD_B5_WIDTH                   1
#define PORTCON_PORTB_OD_B5_MASK                    (((1U << PORTCON_PORTB_OD_B5_WIDTH) - 1U) << PORTCON_PORTB_OD_B5_SHIFT)
#define PORTCON_PORTB_OD_B5_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B5_BITS_DISABLE            (PORTCON_PORTB_OD_B5_VALUE_DISABLE << PORTCON_PORTB_OD_B5_SHIFT)
#define PORTCON_PORTB_OD_B5_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B5_BITS_ENABLE             (PORTCON_PORTB_OD_B5_VALUE_ENABLE << PORTCON_PORTB_OD_B5_SHIFT)

#define PORTCON_PORTB_OD_B6_SHIFT                   6
#define PORTCON_PORTB_OD_B6_WIDTH                   1
#define PORTCON_PORTB_OD_B6_MASK                    (((1U << PORTCON_PORTB_OD_B6_WIDTH) - 1U) << PORTCON_PORTB_OD_B6_SHIFT)
#define PORTCON_PORTB_OD_B6_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B6_BITS_DISABLE            (PORTCON_PORTB_OD_B6_VALUE_DISABLE << PORTCON_PORTB_OD_B6_SHIFT)
#define PORTCON_PORTB_OD_B6_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B6_BITS_ENABLE             (PORTCON_PORTB_OD_B6_VALUE_ENABLE << PORTCON_PORTB_OD_B6_SHIFT)

#define PORTCON_PORTB_OD_B7_SHIFT                   7
#define PORTCON_PORTB_OD_B7_WIDTH                   1
#define PORTCON_PORTB_OD_B7_MASK                    (((1U << PORTCON_PORTB_OD_B7_WIDTH) - 1U) << PORTCON_PORTB_OD_B7_SHIFT)
#define PORTCON_PORTB_OD_B7_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B7_BITS_DISABLE            (PORTCON_PORTB_OD_B7_VALUE_DISABLE << PORTCON_PORTB_OD_B7_SHIFT)
#define PORTCON_PORTB_OD_B7_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B7_BITS_ENABLE             (PORTCON_PORTB_OD_B7_VALUE_ENABLE << PORTCON_PORTB_OD_B7_SHIFT)

#define PORTCON_PORTB_OD_B8_SHIFT                   8
#define PORTCON_PORTB_OD_B8_WIDTH                   1
#define PORTCON_PORTB_OD_B8_MASK                    (((1U << PORTCON_PORTB_OD_B8_WIDTH) - 1U) << PORTCON_PORTB_OD_B8_SHIFT)
#define PORTCON_PORTB_OD_B8_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B8_BITS_DISABLE            (PORTCON_PORTB_OD_B8_VALUE_DISABLE << PORTCON_PORTB_OD_B8_SHIFT)
#define PORTCON_PORTB_OD_B8_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B8_BITS_ENABLE             (PORTCON_PORTB_OD_B8_VALUE_ENABLE << PORTCON_PORTB_OD_B8_SHIFT)

#define PORTCON_PORTB_OD_B9_SHIFT                   9
#define PORTCON_PORTB_OD_B9_WIDTH                   1
#define PORTCON_PORTB_OD_B9_MASK                    (((1U << PORTCON_PORTB_OD_B9_WIDTH) - 1U) << PORTCON_PORTB_OD_B9_SHIFT)
#define PORTCON_PORTB_OD_B9_VALUE_DISABLE           0U
#define PORTCON_PORTB_OD_B9_BITS_DISABLE            (PORTCON_PORTB_OD_B9_VALUE_DISABLE << PORTCON_PORTB_OD_B9_SHIFT)
#define PORTCON_PORTB_OD_B9_VALUE_ENABLE            1U
#define PORTCON_PORTB_OD_B9_BITS_ENABLE             (PORTCON_PORTB_OD_B9_VALUE_ENABLE << PORTCON_PORTB_OD_B9_SHIFT)

#define PORTCON_PORTB_OD_B10_SHIFT                  10
#define PORTCON_PORTB_OD_B10_WIDTH                  1
#define PORTCON_PORTB_OD_B10_MASK                   (((1U << PORTCON_PORTB_OD_B10_WIDTH) - 1U) << PORTCON_PORTB_OD_B10_SHIFT)
#define PORTCON_PORTB_OD_B10_VALUE_DISABLE          0U
#define PORTCON_PORTB_OD_B10_BITS_DISABLE           (PORTCON_PORTB_OD_B10_VALUE_DISABLE << PORTCON_PORTB_OD_B10_SHIFT)
#define PORTCON_PORTB_OD_B10_VALUE_ENABLE           1U
#define PORTCON_PORTB_OD_B10_BITS_ENABLE            (PORTCON_PORTB_OD_B10_VALUE_ENABLE << PORTCON_PORTB_OD_B10_SHIFT)

#define PORTCON_PORTB_OD_B11_SHIFT                  11
#define PORTCON_PORTB_OD_B11_WIDTH                  1
#define PORTCON_PORTB_OD_B11_MASK                   (((1U << PORTCON_PORTB_OD_B11_WIDTH) - 1U) << PORTCON_PORTB_OD_B11_SHIFT)
#define PORTCON_PORTB_OD_B11_VALUE_DISABLE          0U
#define PORTCON_PORTB_OD_B11_BITS_DISABLE           (PORTCON_PORTB_OD_B11_VALUE_DISABLE << PORTCON_PORTB_OD_B11_SHIFT)
#define PORTCON_PORTB_OD_B11_VALUE_ENABLE           1U
#define PORTCON_PORTB_OD_B11_BITS_ENABLE            (PORTCON_PORTB_OD_B11_VALUE_ENABLE << PORTCON_PORTB_OD_B11_SHIFT)

#define PORTCON_PORTB_OD_B12_SHIFT                  12
#define PORTCON_PORTB_OD_B12_WIDTH                  1
#define PORTCON_PORTB_OD_B12_MASK                   (((1U << PORTCON_PORTB_OD_B12_WIDTH) - 1U) << PORTCON_PORTB_OD_B12_SHIFT)
#define PORTCON_PORTB_OD_B12_VALUE_DISABLE          0U
#define PORTCON_PORTB_OD_B12_BITS_DISABLE           (PORTCON_PORTB_OD_B12_VALUE_DISABLE << PORTCON_PORTB_OD_B12_SHIFT)
#define PORTCON_PORTB_OD_B12_VALUE_ENABLE           1U
#define PORTCON_PORTB_OD_B12_BITS_ENABLE            (PORTCON_PORTB_OD_B12_VALUE_ENABLE << PORTCON_PORTB_OD_B12_SHIFT)

#define PORTCON_PORTB_OD_B13_SHIFT                  13
#define PORTCON_PORTB_OD_B13_WIDTH                  1
#define PORTCON_PORTB_OD_B13_MASK                   (((1U << PORTCON_PORTB_OD_B13_WIDTH) - 1U) << PORTCON_PORTB_OD_B13_SHIFT)
#define PORTCON_PORTB_OD_B13_VALUE_DISABLE          0U
#define PORTCON_PORTB_OD_B13_BITS_DISABLE           (PORTCON_PORTB_OD_B13_VALUE_DISABLE << PORTCON_PORTB_OD_B13_SHIFT)
#define PORTCON_PORTB_OD_B13_VALUE_ENABLE           1U
#define PORTCON_PORTB_OD_B13_BITS_ENABLE            (PORTCON_PORTB_OD_B13_VALUE_ENABLE << PORTCON_PORTB_OD_B13_SHIFT)

#define PORTCON_PORTB_OD_B14_SHIFT                  14
#define PORTCON_PORTB_OD_B14_WIDTH                  1
#define PORTCON_PORTB_OD_B14_MASK                   (((1U << PORTCON_PORTB_OD_B14_WIDTH) - 1U) << PORTCON_PORTB_OD_B14_SHIFT)
#define PORTCON_PORTB_OD_B14_VALUE_DISABLE          0U
#define PORTCON_PORTB_OD_B14_BITS_DISABLE           (PORTCON_PORTB_OD_B14_VALUE_DISABLE << PORTCON_PORTB_OD_B14_SHIFT)
#define PORTCON_PORTB_OD_B14_VALUE_ENABLE           1U
#define PORTCON_PORTB_OD_B14_BITS_ENABLE            (PORTCON_PORTB_OD_B14_VALUE_ENABLE << PORTCON_PORTB_OD_B14_SHIFT)

#define PORTCON_PORTB_OD_B15_SHIFT                  15
#define PORTCON_PORTB_OD_B15_WIDTH                  1
#define PORTCON_PORTB_OD_B15_MASK                   (((1U << PORTCON_PORTB_OD_B15_WIDTH) - 1U) << PORTCON_PORTB_OD_B15_SHIFT)
#define PORTCON_PORTB_OD_B15_VALUE_DISABLE          0U
#define PORTCON_PORTB_OD_B15_BITS_DISABLE           (PORTCON_PORTB_OD_B15_VALUE_DISABLE << PORTCON_PORTB_OD_B15_SHIFT)
#define PORTCON_PORTB_OD_B15_VALUE_ENABLE           1U
#define PORTCON_PORTB_OD_B15_BITS_ENABLE            (PORTCON_PORTB_OD_B15_VALUE_ENABLE << PORTCON_PORTB_OD_B15_SHIFT)

#define PORTCON_PORTC_OD_ADDR                       (PORTCON_BASE_ADDR + 0x0408U)
#define PORTCON_PORTC_OD                            (*(volatile uint32_t *)PORTCON_PORTC_OD_ADDR)
#define PORTCON_PORTC_OD_C0_SHIFT                   0
#define PORTCON_PORTC_OD_C0_WIDTH                   1
#define PORTCON_PORTC_OD_C0_MASK                    (((1U << PORTCON_PORTC_OD_C0_WIDTH) - 1U) << PORTCON_PORTC_OD_C0_SHIFT)
#define PORTCON_PORTC_OD_C0_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C0_BITS_DISABLE            (PORTCON_PORTC_OD_C0_VALUE_DISABLE << PORTCON_PORTC_OD_C0_SHIFT)
#define PORTCON_PORTC_OD_C0_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C0_BITS_ENABLE             (PORTCON_PORTC_OD_C0_VALUE_ENABLE << PORTCON_PORTC_OD_C0_SHIFT)

#define PORTCON_PORTC_OD_C1_SHIFT                   1
#define PORTCON_PORTC_OD_C1_WIDTH                   1
#define PORTCON_PORTC_OD_C1_MASK                    (((1U << PORTCON_PORTC_OD_C1_WIDTH) - 1U) << PORTCON_PORTC_OD_C1_SHIFT)
#define PORTCON_PORTC_OD_C1_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C1_BITS_DISABLE            (PORTCON_PORTC_OD_C1_VALUE_DISABLE << PORTCON_PORTC_OD_C1_SHIFT)
#define PORTCON_PORTC_OD_C1_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C1_BITS_ENABLE             (PORTCON_PORTC_OD_C1_VALUE_ENABLE << PORTCON_PORTC_OD_C1_SHIFT)

#define PORTCON_PORTC_OD_C2_SHIFT                   2
#define PORTCON_PORTC_OD_C2_WIDTH                   1
#define PORTCON_PORTC_OD_C2_MASK                    (((1U << PORTCON_PORTC_OD_C2_WIDTH) - 1U) << PORTCON_PORTC_OD_C2_SHIFT)
#define PORTCON_PORTC_OD_C2_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C2_BITS_DISABLE            (PORTCON_PORTC_OD_C2_VALUE_DISABLE << PORTCON_PORTC_OD_C2_SHIFT)
#define PORTCON_PORTC_OD_C2_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C2_BITS_ENABLE             (PORTCON_PORTC_OD_C2_VALUE_ENABLE << PORTCON_PORTC_OD_C2_SHIFT)

#define PORTCON_PORTC_OD_C3_SHIFT                   3
#define PORTCON_PORTC_OD_C3_WIDTH                   1
#define PORTCON_PORTC_OD_C3_MASK                    (((1U << PORTCON_PORTC_OD_C3_WIDTH) - 1U) << PORTCON_PORTC_OD_C3_SHIFT)
#define PORTCON_PORTC_OD_C3_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C3_BITS_DISABLE            (PORTCON_PORTC_OD_C3_VALUE_DISABLE << PORTCON_PORTC_OD_C3_SHIFT)
#define PORTCON_PORTC_OD_C3_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C3_BITS_ENABLE             (PORTCON_PORTC_OD_C3_VALUE_ENABLE << PORTCON_PORTC_OD_C3_SHIFT)

#define PORTCON_PORTC_OD_C4_SHIFT                   4
#define PORTCON_PORTC_OD_C4_WIDTH                   1
#define PORTCON_PORTC_OD_C4_MASK                    (((1U << PORTCON_PORTC_OD_C4_WIDTH) - 1U) << PORTCON_PORTC_OD_C4_SHIFT)
#define PORTCON_PORTC_OD_C4_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C4_BITS_DISABLE            (PORTCON_PORTC_OD_C4_VALUE_DISABLE << PORTCON_PORTC_OD_C4_SHIFT)
#define PORTCON_PORTC_OD_C4_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C4_BITS_ENABLE             (PORTCON_PORTC_OD_C4_VALUE_ENABLE << PORTCON_PORTC_OD_C4_SHIFT)

#define PORTCON_PORTC_OD_C5_SHIFT                   5
#define PORTCON_PORTC_OD_C5_WIDTH                   1
#define PORTCON_PORTC_OD_C5_MASK                    (((1U << PORTCON_PORTC_OD_C5_WIDTH) - 1U) << PORTCON_PORTC_OD_C5_SHIFT)
#define PORTCON_PORTC_OD_C5_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C5_BITS_DISABLE            (PORTCON_PORTC_OD_C5_VALUE_DISABLE << PORTCON_PORTC_OD_C5_SHIFT)
#define PORTCON_PORTC_OD_C5_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C5_BITS_ENABLE             (PORTCON_PORTC_OD_C5_VALUE_ENABLE << PORTCON_PORTC_OD_C5_SHIFT)

#define PORTCON_PORTC_OD_C6_SHIFT                   6
#define PORTCON_PORTC_OD_C6_WIDTH                   1
#define PORTCON_PORTC_OD_C6_MASK                    (((1U << PORTCON_PORTC_OD_C6_WIDTH) - 1U) << PORTCON_PORTC_OD_C6_SHIFT)
#define PORTCON_PORTC_OD_C6_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C6_BITS_DISABLE            (PORTCON_PORTC_OD_C6_VALUE_DISABLE << PORTCON_PORTC_OD_C6_SHIFT)
#define PORTCON_PORTC_OD_C6_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C6_BITS_ENABLE             (PORTCON_PORTC_OD_C6_VALUE_ENABLE << PORTCON_PORTC_OD_C6_SHIFT)

#define PORTCON_PORTC_OD_C7_SHIFT                   7
#define PORTCON_PORTC_OD_C7_WIDTH                   1
#define PORTCON_PORTC_OD_C7_MASK                    (((1U << PORTCON_PORTC_OD_C7_WIDTH) - 1U) << PORTCON_PORTC_OD_C7_SHIFT)
#define PORTCON_PORTC_OD_C7_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C7_BITS_DISABLE            (PORTCON_PORTC_OD_C7_VALUE_DISABLE << PORTCON_PORTC_OD_C7_SHIFT)
#define PORTCON_PORTC_OD_C7_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C7_BITS_ENABLE             (PORTCON_PORTC_OD_C7_VALUE_ENABLE << PORTCON_PORTC_OD_C7_SHIFT)

#define PORTCON_PORTC_OD_C8_SHIFT                   8
#define PORTCON_PORTC_OD_C8_WIDTH                   1
#define PORTCON_PORTC_OD_C8_MASK                    (((1U << PORTCON_PORTC_OD_C8_WIDTH) - 1U) << PORTCON_PORTC_OD_C8_SHIFT)
#define PORTCON_PORTC_OD_C8_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C8_BITS_DISABLE            (PORTCON_PORTC_OD_C8_VALUE_DISABLE << PORTCON_PORTC_OD_C8_SHIFT)
#define PORTCON_PORTC_OD_C8_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C8_BITS_ENABLE             (PORTCON_PORTC_OD_C8_VALUE_ENABLE << PORTCON_PORTC_OD_C8_SHIFT)

#define PORTCON_PORTC_OD_C9_SHIFT                   9
#define PORTCON_PORTC_OD_C9_WIDTH                   1
#define PORTCON_PORTC_OD_C9_MASK                    (((1U << PORTCON_PORTC_OD_C9_WIDTH) - 1U) << PORTCON_PORTC_OD_C9_SHIFT)
#define PORTCON_PORTC_OD_C9_VALUE_DISABLE           0U
#define PORTCON_PORTC_OD_C9_BITS_DISABLE            (PORTCON_PORTC_OD_C9_VALUE_DISABLE << PORTCON_PORTC_OD_C9_SHIFT)
#define PORTCON_PORTC_OD_C9_VALUE_ENABLE            1U
#define PORTCON_PORTC_OD_C9_BITS_ENABLE             (PORTCON_PORTC_OD_C9_VALUE_ENABLE << PORTCON_PORTC_OD_C9_SHIFT)

#define PORTCON_PORTC_OD_C10_SHIFT                  10
#define PORTCON_PORTC_OD_C10_WIDTH                  1
#define PORTCON_PORTC_OD_C10_MASK                   (((1U << PORTCON_PORTC_OD_C10_WIDTH) - 1U) << PORTCON_PORTC_OD_C10_SHIFT)
#define PORTCON_PORTC_OD_C10_VALUE_DISABLE          0U
#define PORTCON_PORTC_OD_C10_BITS_DISABLE           (PORTCON_PORTC_OD_C10_VALUE_DISABLE << PORTCON_PORTC_OD_C10_SHIFT)
#define PORTCON_PORTC_OD_C10_VALUE_ENABLE           1U
#define PORTCON_PORTC_OD_C10_BITS_ENABLE            (PORTCON_PORTC_OD_C10_VALUE_ENABLE << PORTCON_PORTC_OD_C10_SHIFT)

#define PORTCON_PORTC_OD_C11_SHIFT                  11
#define PORTCON_PORTC_OD_C11_WIDTH                  1
#define PORTCON_PORTC_OD_C11_MASK                   (((1U << PORTCON_PORTC_OD_C11_WIDTH) - 1U) << PORTCON_PORTC_OD_C11_SHIFT)
#define PORTCON_PORTC_OD_C11_VALUE_DISABLE          0U
#define PORTCON_PORTC_OD_C11_BITS_DISABLE           (PORTCON_PORTC_OD_C11_VALUE_DISABLE << PORTCON_PORTC_OD_C11_SHIFT)
#define PORTCON_PORTC_OD_C11_VALUE_ENABLE           1U
#define PORTCON_PORTC_OD_C11_BITS_ENABLE            (PORTCON_PORTC_OD_C11_VALUE_ENABLE << PORTCON_PORTC_OD_C11_SHIFT)

#define PORTCON_PORTC_OD_C12_SHIFT                  12
#define PORTCON_PORTC_OD_C12_WIDTH                  1
#define PORTCON_PORTC_OD_C12_MASK                   (((1U << PORTCON_PORTC_OD_C12_WIDTH) - 1U) << PORTCON_PORTC_OD_C12_SHIFT)
#define PORTCON_PORTC_OD_C12_VALUE_DISABLE          0U
#define PORTCON_PORTC_OD_C12_BITS_DISABLE           (PORTCON_PORTC_OD_C12_VALUE_DISABLE << PORTCON_PORTC_OD_C12_SHIFT)
#define PORTCON_PORTC_OD_C12_VALUE_ENABLE           1U
#define PORTCON_PORTC_OD_C12_BITS_ENABLE            (PORTCON_PORTC_OD_C12_VALUE_ENABLE << PORTCON_PORTC_OD_C12_SHIFT)

#define PORTCON_PORTC_OD_C13_SHIFT                  13
#define PORTCON_PORTC_OD_C13_WIDTH                  1
#define PORTCON_PORTC_OD_C13_MASK                   (((1U << PORTCON_PORTC_OD_C13_WIDTH) - 1U) << PORTCON_PORTC_OD_C13_SHIFT)
#define PORTCON_PORTC_OD_C13_VALUE_DISABLE          0U
#define PORTCON_PORTC_OD_C13_BITS_DISABLE           (PORTCON_PORTC_OD_C13_VALUE_DISABLE << PORTCON_PORTC_OD_C13_SHIFT)
#define PORTCON_PORTC_OD_C13_VALUE_ENABLE           1U
#define PORTCON_PORTC_OD_C13_BITS_ENABLE            (PORTCON_PORTC_OD_C13_VALUE_ENABLE << PORTCON_PORTC_OD_C13_SHIFT)

#define PORTCON_PORTC_OD_C14_SHIFT                  14
#define PORTCON_PORTC_OD_C14_WIDTH                  1
#define PORTCON_PORTC_OD_C14_MASK                   (((1U << PORTCON_PORTC_OD_C14_WIDTH) - 1U) << PORTCON_PORTC_OD_C14_SHIFT)
#define PORTCON_PORTC_OD_C14_VALUE_DISABLE          0U
#define PORTCON_PORTC_OD_C14_BITS_DISABLE           (PORTCON_PORTC_OD_C14_VALUE_DISABLE << PORTCON_PORTC_OD_C14_SHIFT)
#define PORTCON_PORTC_OD_C14_VALUE_ENABLE           1U
#define PORTCON_PORTC_OD_C14_BITS_ENABLE            (PORTCON_PORTC_OD_C14_VALUE_ENABLE << PORTCON_PORTC_OD_C14_SHIFT)

#define PORTCON_PORTC_OD_C15_SHIFT                  15
#define PORTCON_PORTC_OD_C15_WIDTH                  1
#define PORTCON_PORTC_OD_C15_MASK                   (((1U << PORTCON_PORTC_OD_C15_WIDTH) - 1U) << PORTCON_PORTC_OD_C15_SHIFT)
#define PORTCON_PORTC_OD_C15_VALUE_DISABLE          0U
#define PORTCON_PORTC_OD_C15_BITS_DISABLE           (PORTCON_PORTC_OD_C15_VALUE_DISABLE << PORTCON_PORTC_OD_C15_SHIFT)
#define PORTCON_PORTC_OD_C15_VALUE_ENABLE           1U
#define PORTCON_PORTC_OD_C15_BITS_ENABLE            (PORTCON_PORTC_OD_C15_VALUE_ENABLE << PORTCON_PORTC_OD_C15_SHIFT)


#endif

